/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.newtypes;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.newtypes.JSType;
import com.google.javascript.jscomp.newtypes.PersistentMap;
import java.util.Collection;

public class TypeEnv {
    private final PersistentMap<String, JSType> typeMap;

    public TypeEnv() {
        this.typeMap = PersistentMap.create();
    }

    private TypeEnv(PersistentMap<String, JSType> typeMap) {
        this.typeMap = typeMap;
    }

    public JSType getType(String n) {
        Preconditions.checkArgument((!n.contains(".") ? 1 : 0) != 0);
        return (JSType)this.typeMap.get(n);
    }

    public TypeEnv putType(String n, JSType t) {
        Preconditions.checkArgument((!n.contains(".") ? 1 : 0) != 0);
        Preconditions.checkArgument((t != null ? 1 : 0) != 0);
        return new TypeEnv(this.typeMap.with(n, t));
    }

    public TypeEnv split() {
        return this;
    }

    public static TypeEnv join(TypeEnv e1, TypeEnv e2) {
        return TypeEnv.join((Collection<TypeEnv>)ImmutableSet.of((Object)e1, (Object)e2));
    }

    public static TypeEnv join(Collection<TypeEnv> envs) {
        Preconditions.checkArgument((!envs.isEmpty() ? 1 : 0) != 0);
        TypeEnv firstEnv = envs.iterator().next();
        if (envs.size() == 1) {
            return firstEnv;
        }
        PersistentMap<String, JSType> newMap = firstEnv.typeMap;
        ImmutableSet.Builder keys = ImmutableSet.builder();
        for (TypeEnv env : envs) {
            keys.addAll(env.typeMap.keySet());
        }
        for (String n : keys.build()) {
            JSType joinedType = null;
            for (TypeEnv env : envs) {
                JSType otherType = env.getType(n);
                Preconditions.checkNotNull((Object)otherType, (String)"%s is missing from an env", (Object[])new Object[]{n});
                if (joinedType == null) {
                    joinedType = otherType;
                    continue;
                }
                if (joinedType.equals(otherType)) continue;
                joinedType = JSType.join(joinedType, otherType);
            }
            newMap = newMap.with(n, joinedType);
        }
        return new TypeEnv(newMap);
    }

    public String toString() {
        Objects.ToStringHelper helper = Objects.toStringHelper(this.getClass());
        for (String key : this.typeMap.keySet()) {
            helper.add(key, (Object)this.getType(key));
        }
        return helper.toString();
    }
}

