/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.parsing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.google.javascript.jscomp.parsing.Config;
import com.google.javascript.jscomp.parsing.JsDocInfoParser;
import com.google.javascript.jscomp.parsing.JsDocTokenStream;
import com.google.javascript.jscomp.parsing.NewTypeSafeDispatcher;
import com.google.javascript.jscomp.parsing.parser.IdentifierToken;
import com.google.javascript.jscomp.parsing.parser.LiteralToken;
import com.google.javascript.jscomp.parsing.parser.Token;
import com.google.javascript.jscomp.parsing.parser.TokenType;
import com.google.javascript.jscomp.parsing.parser.trees.ArrayLiteralExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ArrayPatternTree;
import com.google.javascript.jscomp.parsing.parser.trees.AssignmentRestElementTree;
import com.google.javascript.jscomp.parsing.parser.trees.BinaryOperatorTree;
import com.google.javascript.jscomp.parsing.parser.trees.BlockTree;
import com.google.javascript.jscomp.parsing.parser.trees.BreakStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.CallExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.CaseClauseTree;
import com.google.javascript.jscomp.parsing.parser.trees.CatchTree;
import com.google.javascript.jscomp.parsing.parser.trees.ClassDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.CommaExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.Comment;
import com.google.javascript.jscomp.parsing.parser.trees.ComprehensionForTree;
import com.google.javascript.jscomp.parsing.parser.trees.ComprehensionIfTree;
import com.google.javascript.jscomp.parsing.parser.trees.ComprehensionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ComputedPropertyDefinitionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ComputedPropertyMethodTree;
import com.google.javascript.jscomp.parsing.parser.trees.ConditionalExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ContinueStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.DebuggerStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.DefaultClauseTree;
import com.google.javascript.jscomp.parsing.parser.trees.DefaultParameterTree;
import com.google.javascript.jscomp.parsing.parser.trees.DoWhileStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.EmptyStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.ExportDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.ExportSpecifierTree;
import com.google.javascript.jscomp.parsing.parser.trees.ExpressionStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.FinallyTree;
import com.google.javascript.jscomp.parsing.parser.trees.ForInStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.ForOfStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.ForStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.FormalParameterListTree;
import com.google.javascript.jscomp.parsing.parser.trees.FunctionDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.GetAccessorTree;
import com.google.javascript.jscomp.parsing.parser.trees.IdentifierExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.IfStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.ImportDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.ImportSpecifierTree;
import com.google.javascript.jscomp.parsing.parser.trees.LabelledStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.LiteralExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.MemberExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.MemberLookupExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.MissingPrimaryExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ModuleImportTree;
import com.google.javascript.jscomp.parsing.parser.trees.NewExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.NullTree;
import com.google.javascript.jscomp.parsing.parser.trees.ObjectLiteralExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ObjectPatternFieldTree;
import com.google.javascript.jscomp.parsing.parser.trees.ObjectPatternTree;
import com.google.javascript.jscomp.parsing.parser.trees.ParenExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ParseTree;
import com.google.javascript.jscomp.parsing.parser.trees.ParseTreeType;
import com.google.javascript.jscomp.parsing.parser.trees.PostfixExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ProgramTree;
import com.google.javascript.jscomp.parsing.parser.trees.PropertyNameAssignmentTree;
import com.google.javascript.jscomp.parsing.parser.trees.RestParameterTree;
import com.google.javascript.jscomp.parsing.parser.trees.ReturnStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.SetAccessorTree;
import com.google.javascript.jscomp.parsing.parser.trees.SpreadExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.SuperExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.SwitchStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.TemplateLiteralExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.TemplateLiteralPortionTree;
import com.google.javascript.jscomp.parsing.parser.trees.TemplateSubstitutionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ThisExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ThrowStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.TryStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.UnaryExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.VariableDeclarationListTree;
import com.google.javascript.jscomp.parsing.parser.trees.VariableDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.VariableStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.WhileStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.WithStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.YieldExpressionTree;
import com.google.javascript.jscomp.parsing.parser.util.SourcePosition;
import com.google.javascript.jscomp.parsing.parser.util.SourceRange;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.TokenStream;
import com.google.javascript.rhino.jstype.StaticSourceFile;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

class NewIRFactory {
    static final String GETTER_ERROR_MESSAGE = "getters are not supported in older versions of JavaScript. If you are targeting newer versions of JavaScript, set the appropriate language_in option.";
    static final String SETTER_ERROR_MESSAGE = "setters are not supported in older versions of JavaScript. If you are targeting newer versions of JavaScript, set the appropriate language_in option.";
    static final String SUSPICIOUS_COMMENT_WARNING = "Non-JSDoc comment has annotations. Did you mean to start it with '/**'?";
    static final String MISPLACED_TYPE_ANNOTATION = "Type annotations are not allowed here. Are you missing parentheses?";
    static final String INVALID_ES3_PROP_NAME = "Keywords and reserved words are not allowed as unquoted property names in older versions of JavaScript. If you are targeting newer versions of JavaScript, set the appropriate language_in option.";
    static final String INVALID_ES5_STRICT_OCTAL = "Octal integer literals are not supported in Ecmascript 5 strict mode.";
    static final String INVALID_NUMBER_LITERAL = "Invalid number literal.";
    static final String STRING_CONTINUATION_WARNING = "String continuations are not supported in this language mode.";
    static final String BINARY_NUMBER_LITERAL_WARNING = "Binary integer literals are not supported in this language mode.";
    static final String OCTAL_NUMBER_LITERAL_WARNING = "Octal integer literals are not supported in this language mode.";
    static final String OCTAL_STRING_LITERAL_WARNING = "Octal literals in strings are not supported in this language mode.";
    static final String DUPLICATE_PARAMETER = "Duplicate parameter name \"%s\"";
    static final String DUPLICATE_LABEL = "Duplicate label \"%s\"";
    static final String UNLABELED_BREAK = "unlabelled break must be inside loop or switch";
    static final String UNEXPECTED_CONTINUE = "continue must be inside loop";
    static final String UNEXPECTED_LABLED_CONTINUE = "continue can only use labeles of iteration statements";
    static final String UNDEFINED_LABEL = "undefined label \"%s\"";
    private final String sourceString;
    private final List<Integer> newlines;
    private final StaticSourceFile sourceFile;
    private final String sourceName;
    private final Config config;
    private final ErrorReporter errorReporter;
    private final TransformDispatcher transformDispatcher;
    private static final ImmutableSet<String> ALLOWED_DIRECTIVES = ImmutableSet.of((Object)"use strict");
    private static final ImmutableSet<String> ES5_RESERVED_KEYWORDS = ImmutableSet.of((Object)"class", (Object)"const", (Object)"enum", (Object)"export", (Object)"extends", (Object)"import", (Object[])new String[]{"super"});
    private static final ImmutableSet<String> ES5_STRICT_RESERVED_KEYWORDS = ImmutableSet.of((Object)"class", (Object)"const", (Object)"enum", (Object)"export", (Object)"extends", (Object)"import", (Object[])new String[]{"super", "implements", "interface", "let", "package", "private", "protected", "public", "static", "yield"});
    private final Set<String> reservedKeywords;
    private final Set<Comment> parsedComments = Sets.newHashSet();
    Node rootNodeJsDocHolder = new Node(132);
    Node.FileLevelJsDocBuilder fileLevelJsDocBuilder = this.rootNodeJsDocHolder.getJsDocBuilderForNode();
    JSDocInfo fileOverviewInfo = null;
    private final Node templateNode;
    private final UnmodifiableIterator<Comment> nextCommentIter;
    private Comment currentComment;
    private boolean currentFileIsExterns = false;

    private NewIRFactory(String sourceString, StaticSourceFile sourceFile, Config config, ErrorReporter errorReporter, ImmutableList<Comment> comments) {
        this.sourceString = sourceString;
        this.nextCommentIter = comments.iterator();
        this.currentComment = this.nextCommentIter.hasNext() ? (Comment)this.nextCommentIter.next() : null;
        this.newlines = Lists.newArrayList();
        this.sourceFile = sourceFile;
        int charNo = 0;
        while ((charNo = sourceString.indexOf(10, charNo)) != -1) {
            this.newlines.add(charNo);
            ++charNo;
        }
        this.sourceName = sourceFile == null ? null : sourceFile.getName();
        this.config = config;
        this.errorReporter = errorReporter;
        this.transformDispatcher = new TransformDispatcher();
        this.templateNode = this.createTemplateNode();
        switch (config.languageMode) {
            case ECMASCRIPT3: {
                this.reservedKeywords = null;
                break;
            }
            case ECMASCRIPT5: {
                this.reservedKeywords = ES5_RESERVED_KEYWORDS;
                break;
            }
            case ECMASCRIPT5_STRICT: {
                this.reservedKeywords = ES5_STRICT_RESERVED_KEYWORDS;
                break;
            }
            case ECMASCRIPT6: {
                this.reservedKeywords = ES5_RESERVED_KEYWORDS;
                break;
            }
            case ECMASCRIPT6_STRICT: {
                this.reservedKeywords = ES5_STRICT_RESERVED_KEYWORDS;
                break;
            }
            default: {
                throw new IllegalStateException("unknown language mode");
            }
        }
    }

    private Node createTemplateNode() {
        Node templateNode = new Node(132);
        templateNode.setStaticSourceFile(this.sourceFile);
        return templateNode;
    }

    public static Node transformTree(ProgramTree tree, StaticSourceFile sourceFile, String sourceString, Config config, ErrorReporter errorReporter) {
        NewIRFactory irFactory = new NewIRFactory(sourceString, sourceFile, config, errorReporter, tree.sourceComments);
        Node n = irFactory.justTransform(tree);
        irFactory.setSourceInfo(n, tree);
        if (tree.sourceComments != null) {
            for (Comment comment : tree.sourceComments) {
                if (comment.type == Comment.Type.JSDOC && !irFactory.parsedComments.contains(comment)) {
                    irFactory.handlePossibleFileOverviewJsDoc(comment);
                    continue;
                }
                if (comment.type != Comment.Type.BLOCK) continue;
                irFactory.handleBlockComment(comment);
            }
        }
        irFactory.setFileOverviewJsDoc(n);
        irFactory.validateAll(n);
        return n;
    }

    private void validateAll(Node n) {
        this.validate(n);
        for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
            this.validateAll(c);
        }
    }

    private void validate(Node n) {
        this.validateTypeAnnotations(n);
        this.validateParameters(n);
        this.validateBreakContinue(n);
        this.validateLabel(n);
    }

    private void validateBreakContinue(Node n) {
        block8: {
            block9: {
                if (!n.isBreak() && !n.isContinue()) break block8;
                Node labelName = n.getFirstChild();
                if (labelName == null) break block9;
                Node parent = n.getParent();
                while (!parent.isLabel() || !NewIRFactory.labelsMatch(parent, labelName)) {
                    if (parent.isFunction() || parent.isScript()) {
                        this.errorReporter.error(String.format(UNDEFINED_LABEL, labelName.getString()), this.sourceName, n.getLineno(), n.getCharno());
                        break;
                    }
                    parent = parent.getParent();
                }
                if (!parent.isLabel() || !NewIRFactory.labelsMatch(parent, labelName) || !n.isContinue() || NewIRFactory.isContinueTarget(parent.getLastChild())) break block8;
                this.errorReporter.error(UNEXPECTED_LABLED_CONTINUE, this.sourceName, n.getLineno(), n.getCharno());
                break block8;
            }
            if (n.isContinue()) {
                Node parent = n.getParent();
                while (!NewIRFactory.isContinueTarget(parent)) {
                    if (parent.isFunction() || parent.isScript()) {
                        this.errorReporter.error(UNEXPECTED_CONTINUE, this.sourceName, n.getLineno(), n.getCharno());
                        break;
                    }
                    parent = parent.getParent();
                }
            } else {
                Node parent = n.getParent();
                while (!NewIRFactory.isBreakTarget(parent)) {
                    if (parent.isFunction() || parent.isScript()) {
                        this.errorReporter.error(UNLABELED_BREAK, this.sourceName, n.getLineno(), n.getCharno());
                        break;
                    }
                    parent = parent.getParent();
                }
            }
        }
    }

    private static boolean isBreakTarget(Node n) {
        switch (n.getType()) {
            case 110: 
            case 113: 
            case 114: 
            case 115: {
                return true;
            }
        }
        return false;
    }

    private static boolean isContinueTarget(Node n) {
        switch (n.getType()) {
            case 113: 
            case 114: 
            case 115: {
                return true;
            }
        }
        return false;
    }

    private static boolean labelsMatch(Node label, Node labelName) {
        return label.getFirstChild().getString().equals(labelName.getString());
    }

    private void validateParameters(Node n) {
        if (n.isParamList()) {
            for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
                if (!c.isName()) continue;
                for (Node sibling = c.getNext(); sibling != null; sibling = sibling.getNext()) {
                    if (!sibling.isName() || !c.getString().equals(sibling.getString())) continue;
                    this.errorReporter.warning(String.format(DUPLICATE_PARAMETER, c.getString()), this.sourceName, n.getLineno(), n.getCharno());
                }
            }
        }
    }

    private void validateTypeAnnotations(Node n) {
        JSDocInfo info = n.getJSDocInfo();
        if (info != null && info.hasType()) {
            boolean valid = false;
            switch (n.getType()) {
                case 155: {
                    valid = true;
                    break;
                }
                case 118: 
                case 149: 
                case 162: {
                    valid = true;
                    break;
                }
                case 105: {
                    valid = this.isFunctionDeclaration(n);
                    break;
                }
                case 38: {
                    Node parent = n.getParent();
                    switch (parent.getType()) {
                        case 83: 
                        case 105: 
                        case 118: 
                        case 120: 
                        case 147: 
                        case 148: 
                        case 149: 
                        case 154: 
                        case 162: {
                            valid = true;
                        }
                    }
                    break;
                }
                case 147: 
                case 148: 
                case 154: {
                    valid = true;
                    break;
                }
                case 86: {
                    valid = n.getParent().isExprResult() && (n.getFirstChild().isGetProp() || n.getFirstChild().isGetElem());
                    break;
                }
                case 33: {
                    valid = n.getParent().isExprResult() && n.isQualifiedName();
                    break;
                }
                case 37: {
                    valid = info.isDefine();
                }
            }
            if (!valid) {
                this.errorReporter.warning(MISPLACED_TYPE_ANNOTATION, this.sourceName, n.getLineno(), n.getCharno());
            }
        }
    }

    private void validateLabel(Node n) {
        if (n.isLabel()) {
            Node labelName = n.getFirstChild();
            for (Node parent = n.getParent(); parent != null && !parent.isFunction(); parent = parent.getParent()) {
                if (!parent.isLabel() || !NewIRFactory.labelsMatch(parent, labelName)) continue;
                this.errorReporter.error(String.format(DUPLICATE_LABEL, labelName.getString()), this.sourceName, n.getLineno(), n.getCharno());
                break;
            }
        }
    }

    private void setFileOverviewJsDoc(Node irNode) {
        JSDocInfo rootNodeJsDoc = this.rootNodeJsDocHolder.getJSDocInfo();
        if (rootNodeJsDoc != null) {
            irNode.setJSDocInfo(rootNodeJsDoc);
            rootNodeJsDoc.setAssociatedNode(irNode);
        }
        if (this.fileOverviewInfo != null) {
            if (irNode.getJSDocInfo() != null && irNode.getJSDocInfo().getLicense() != null) {
                this.fileOverviewInfo.setLicense(irNode.getJSDocInfo().getLicense());
            }
            irNode.setJSDocInfo(this.fileOverviewInfo);
            this.fileOverviewInfo.setAssociatedNode(irNode);
        }
    }

    private Node transformBlock(ParseTree node) {
        Node irNode = this.transform(node);
        if (!irNode.isBlock()) {
            if (irNode.isEmpty()) {
                irNode.setType(125);
            } else {
                Node newBlock = this.newNode(125, irNode);
                this.setSourceInfo(newBlock, irNode);
                irNode = newBlock;
            }
            irNode.setIsAddedBlock(true);
        }
        return irNode;
    }

    private void handleBlockComment(Comment comment) {
        Pattern p = Pattern.compile("(/|(\n[ \t]*))\\*[ \t]*@[a-zA-Z]+[ \t\n{]");
        if (p.matcher(comment.value).find()) {
            this.errorReporter.warning(SUSPICIOUS_COMMENT_WARNING, this.sourceName, NewIRFactory.lineno(comment.location.start), NewIRFactory.charno(comment.location.start));
        }
    }

    private boolean handlePossibleFileOverviewJsDoc(JsDocInfoParser jsDocParser) {
        if (jsDocParser.getFileOverviewJSDocInfo() != this.fileOverviewInfo) {
            this.fileOverviewInfo = jsDocParser.getFileOverviewJSDocInfo();
            if (this.fileOverviewInfo.isExterns()) {
                this.currentFileIsExterns = true;
            }
            return true;
        }
        return false;
    }

    private void handlePossibleFileOverviewJsDoc(Comment comment) {
        JsDocInfoParser jsDocParser = this.createJsDocInfoParser(comment);
        this.parsedComments.add(comment);
        this.handlePossibleFileOverviewJsDoc(jsDocParser);
    }

    private Comment getJsDoc(SourceRange location) {
        Comment closestPreviousComment = null;
        while (this.currentComment != null && this.currentComment.location.end.offset <= location.start.offset) {
            if (this.currentComment.type == Comment.Type.JSDOC) {
                closestPreviousComment = this.currentComment;
            }
            if (this.nextCommentIter.hasNext()) {
                this.currentComment = (Comment)this.nextCommentIter.next();
                continue;
            }
            this.currentComment = null;
        }
        return closestPreviousComment;
    }

    private Comment getJsDoc(ParseTree tree) {
        return this.getJsDoc(tree.location);
    }

    private Comment getJsDoc(Token token) {
        return this.getJsDoc(token.location);
    }

    private JSDocInfo handleJsDoc(Comment comment) {
        if (comment != null) {
            JsDocInfoParser jsDocParser = this.createJsDocInfoParser(comment);
            this.parsedComments.add(comment);
            if (!this.handlePossibleFileOverviewJsDoc(jsDocParser)) {
                return jsDocParser.retrieveAndResetParsedJSDocInfo();
            }
        }
        return null;
    }

    private JSDocInfo handleJsDoc(ParseTree node) {
        if (!this.shouldAttachJSDocHere(node)) {
            return null;
        }
        return this.handleJsDoc(this.getJsDoc(node));
    }

    private boolean shouldAttachJSDocHere(ParseTree tree) {
        switch (tree.type) {
            case EXPRESSION_STATEMENT: {
                return false;
            }
            case LABELLED_STATEMENT: {
                return false;
            }
            case CALL_EXPRESSION: 
            case CONDITIONAL_EXPRESSION: 
            case BINARY_OPERATOR: 
            case MEMBER_EXPRESSION: 
            case MEMBER_LOOKUP_EXPRESSION: 
            case POSTFIX_EXPRESSION: {
                ParseTree nearest = NewIRFactory.findNearestNode(tree);
                return nearest.type != ParseTreeType.PAREN_EXPRESSION;
            }
        }
        return true;
    }

    private static ParseTree findNearestNode(ParseTree tree) {
        block9: while (true) {
            switch (tree.type) {
                case EXPRESSION_STATEMENT: {
                    tree = tree.asExpressionStatement().expression;
                    continue block9;
                }
                case CALL_EXPRESSION: {
                    tree = tree.asCallExpression().operand;
                    continue block9;
                }
                case BINARY_OPERATOR: {
                    tree = tree.asBinaryOperator().left;
                    continue block9;
                }
                case CONDITIONAL_EXPRESSION: {
                    tree = tree.asConditionalExpression().condition;
                    continue block9;
                }
                case MEMBER_EXPRESSION: {
                    tree = tree.asMemberExpression().operand;
                    continue block9;
                }
                case MEMBER_LOOKUP_EXPRESSION: {
                    tree = tree.asMemberLookupExpression().operand;
                    continue block9;
                }
                case POSTFIX_EXPRESSION: {
                    tree = tree.asPostfixExpression().operand;
                    continue block9;
                }
            }
            break;
        }
        return tree;
    }

    private JSDocInfo handleJsDoc(Token token) {
        return this.handleJsDoc(this.getJsDoc(token));
    }

    private boolean isFunctionDeclaration(Node n) {
        return n.isFunction() && NewIRFactory.isStmtContainer(n.getParent());
    }

    private static boolean isStmtContainer(Node n) {
        return n.isBlock() || n.isScript();
    }

    private Node transform(ParseTree tree) {
        JSDocInfo info = this.handleJsDoc(tree);
        Node node = this.justTransform(tree);
        if (info != null) {
            node = this.maybeInjectCastNode(tree, info, node);
            NewIRFactory.attachJSDoc(info, node);
        }
        this.setSourceInfo(node, tree);
        return node;
    }

    private static void attachJSDoc(JSDocInfo info, Node n) {
        info.setAssociatedNode(n);
        n.setJSDocInfo(info);
    }

    private Node maybeInjectCastNode(ParseTree node, JSDocInfo info, Node irNode) {
        if (node.type == ParseTreeType.PAREN_EXPRESSION && info.hasType()) {
            irNode = this.newNode(155, irNode);
        }
        return irNode;
    }

    private Node transformNodeWithInlineJsDoc(ParseTree node, boolean optionalInline) {
        JSDocInfo info = this.handleInlineJsDoc(node, optionalInline);
        Node irNode = this.justTransform(node);
        if (info != null) {
            irNode.setJSDocInfo(info);
        }
        this.setSourceInfo(irNode, node);
        return irNode;
    }

    private JSDocInfo handleInlineJsDoc(ParseTree node, boolean optional) {
        return this.handleInlineJsDoc(node.location, optional);
    }

    private JSDocInfo handleInlineJsDoc(Token token, boolean optional) {
        return this.handleInlineJsDoc(token.location, optional);
    }

    private JSDocInfo handleInlineJsDoc(SourceRange location, boolean optional) {
        Comment comment = this.getJsDoc(location);
        if (!(comment == null || optional && comment.value.contains("@"))) {
            return this.parseInlineTypeDoc(comment);
        }
        return this.handleJsDoc(comment);
    }

    private Node transformNumberAsString(LiteralToken token) {
        double value = this.normalizeNumber(token);
        Node irNode = this.newStringNode(NewIRFactory.getStringValue(value));
        JSDocInfo jsDocInfo = this.handleJsDoc(token);
        if (jsDocInfo != null) {
            irNode.setJSDocInfo(jsDocInfo);
        }
        this.setSourceInfo(irNode, token);
        return irNode;
    }

    private static String getStringValue(double value) {
        long longValue = (long)value;
        if ((double)longValue == value) {
            return Long.toString(longValue);
        }
        return Double.toString(value);
    }

    private static int lineno(ParseTree node) {
        return NewIRFactory.lineno(node.location.start);
    }

    private static int charno(ParseTree node) {
        return NewIRFactory.charno(node.location.start);
    }

    private static int lineno(SourcePosition location) {
        return location.line + 1;
    }

    private static int charno(SourcePosition location) {
        return location.column;
    }

    private void setSourceInfo(Node node, Node ref) {
        node.setLineno(ref.getLineno());
        node.setCharno(ref.getCharno());
        this.maybeSetLengthFrom(node, ref);
    }

    private void setSourceInfo(Node irNode, ParseTree node) {
        if (irNode.getLineno() == -1) {
            this.setSourceInfo(irNode, node.location.start, node.location.end);
        }
    }

    private void setSourceInfo(Node irNode, Token token) {
        this.setSourceInfo(irNode, token.location.start, token.location.end);
    }

    private void setSourceInfo(Node node, SourcePosition start, SourcePosition end) {
        if (node.getLineno() == -1) {
            int lineno = NewIRFactory.lineno(start);
            node.setLineno(lineno);
            int charno = NewIRFactory.charno(start);
            node.setCharno(charno);
            this.maybeSetLength(node, start, end);
        }
    }

    private JsDocInfoParser createJsDocInfoParser(Comment node) {
        String comment = node.value;
        int lineno = NewIRFactory.lineno(node.location.start);
        int charno = NewIRFactory.charno(node.location.start);
        int position = node.location.start.offset;
        int numOpeningChars = 3;
        JsDocInfoParser jsdocParser = new JsDocInfoParser(new JsDocTokenStream(comment.substring(numOpeningChars), lineno, charno + numOpeningChars), comment, position, null, this.sourceFile, this.config, this.errorReporter);
        jsdocParser.setFileLevelJsDocBuilder(this.fileLevelJsDocBuilder);
        jsdocParser.setFileOverviewJSDocInfo(this.fileOverviewInfo);
        jsdocParser.parse();
        return jsdocParser;
    }

    private JSDocInfo parseInlineTypeDoc(Comment node) {
        String comment = node.value;
        int lineno = NewIRFactory.lineno(node.location.start);
        int charno = NewIRFactory.charno(node.location.start);
        int numOpeningChars = 3;
        JsDocInfoParser parser = new JsDocInfoParser(new JsDocTokenStream(comment.substring(numOpeningChars), lineno, charno + numOpeningChars), comment, node.location.start.offset, null, this.sourceFile, this.config, this.errorReporter);
        return parser.parseInlineTypeDoc();
    }

    private void maybeSetLength(Node node, SourcePosition start, SourcePosition end) {
        if (this.config.isIdeMode) {
            node.setLength(end.offset - start.offset);
        }
    }

    private void maybeSetLengthFrom(Node node, Node ref) {
        if (this.config.isIdeMode) {
            node.setLength(ref.getLength());
        }
    }

    private void maybeSetLength(Node node, int length) {
        if (this.config.isIdeMode) {
            node.setLength(length);
        }
    }

    private Node justTransform(ParseTree node) {
        return (Node)this.transformDispatcher.process(node);
    }

    private String normalizeRegex(LiteralToken token) {
        String value = token.value;
        int lastSlash = value.lastIndexOf(47);
        return value.substring(1, lastSlash);
    }

    private String normalizeString(LiteralToken token, boolean templateLiteral) {
        String value = token.value;
        if (templateLiteral) {
            value = value.replaceAll("(?<!\\\\)\r(\n)?", "\n");
        }
        int start = templateLiteral ? 0 : 1;
        int cur = value.indexOf(92);
        if (cur == -1) {
            return templateLiteral ? value : value.substring(1, value.length() - 1);
        }
        StringBuilder result = new StringBuilder();
        while (cur != -1) {
            if (cur - start > 0) {
                result.append(value, start, cur);
            }
            char c = value.charAt(++cur);
            switch (c) {
                case '\"': 
                case '\'': 
                case '\\': {
                    result.append(c);
                    break;
                }
                case 'b': {
                    result.append('\b');
                    break;
                }
                case 'f': {
                    result.append('\f');
                    break;
                }
                case 'n': {
                    result.append('\n');
                    break;
                }
                case 'r': {
                    result.append('\r');
                    break;
                }
                case 't': {
                    result.append('\t');
                    break;
                }
                case 'v': {
                    result.append('\u000b');
                    break;
                }
                case '\n': {
                    if (this.isEs5OrBetterMode()) break;
                    this.errorReporter.warning(STRING_CONTINUATION_WARNING, this.sourceName, NewIRFactory.lineno(token.location.start), NewIRFactory.charno(token.location.start));
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    char next1 = value.charAt(cur + 1);
                    if (this.inStrictContext() && (c != '0' || NewIRFactory.isOctalDigit(next1))) {
                        this.errorReporter.warning(OCTAL_STRING_LITERAL_WARNING, this.sourceName, NewIRFactory.lineno(token.location.start), NewIRFactory.charno(token.location.start));
                    }
                    if (!NewIRFactory.isOctalDigit(next1)) {
                        result.append((char)NewIRFactory.octaldigit(c));
                        break;
                    }
                    char next2 = value.charAt(cur + 2);
                    if (!NewIRFactory.isOctalDigit(next2)) {
                        result.append((char)(8 * NewIRFactory.octaldigit(c) + NewIRFactory.octaldigit(next1)));
                        ++cur;
                        break;
                    }
                    result.append((char)(64 * NewIRFactory.octaldigit(c) + 8 * NewIRFactory.octaldigit(next1) + NewIRFactory.octaldigit(next2)));
                    cur += 2;
                    break;
                }
                case 'x': {
                    result.append((char)(NewIRFactory.hexdigit(value.charAt(cur + 1)) * 16 + NewIRFactory.hexdigit(value.charAt(cur + 2))));
                    cur += 2;
                    break;
                }
                case 'u': {
                    String hexDigits;
                    int escapeEnd;
                    if (value.charAt(cur + 1) != '{') {
                        escapeEnd = cur + 5;
                        hexDigits = value.substring(cur + 1, escapeEnd);
                    } else {
                        escapeEnd = cur + 2;
                        while (Character.digit(value.charAt(escapeEnd), 16) >= 0) {
                            ++escapeEnd;
                        }
                        hexDigits = value.substring(cur + 2, escapeEnd);
                        ++escapeEnd;
                    }
                    result.append(Character.toChars(Integer.parseInt(hexDigits, 16)));
                    cur = escapeEnd - 1;
                    break;
                }
                default: {
                    result.append(c);
                }
            }
            start = cur + 1;
            cur = value.indexOf(92, start);
        }
        result.append(value, start, templateLiteral ? value.length() : value.length() - 1);
        return result.toString();
    }

    boolean isEs6Mode() {
        return this.config.languageMode == Config.LanguageMode.ECMASCRIPT6 || this.config.languageMode == Config.LanguageMode.ECMASCRIPT6_STRICT;
    }

    boolean isEs5OrBetterMode() {
        return this.config.languageMode != Config.LanguageMode.ECMASCRIPT3;
    }

    private boolean inStrictContext() {
        return this.config.languageMode == Config.LanguageMode.ECMASCRIPT5_STRICT || this.config.languageMode == Config.LanguageMode.ECMASCRIPT6_STRICT;
    }

    double normalizeNumber(LiteralToken token) {
        String value = token.value;
        SourceRange location = token.location;
        int length = value.length();
        Preconditions.checkState((length > 0 ? 1 : 0) != 0);
        Preconditions.checkState((value.charAt(0) != '-' && value.charAt(0) != '+' ? 1 : 0) != 0);
        if (value.charAt(0) == '.') {
            return Double.valueOf('0' + value);
        }
        if (value.charAt(0) == '0' && length > 1) {
            switch (value.charAt(1)) {
                case '.': 
                case 'E': 
                case 'e': {
                    return Double.valueOf(value);
                }
                case 'B': 
                case 'b': {
                    if (!this.isEs6Mode()) {
                        this.errorReporter.warning(BINARY_NUMBER_LITERAL_WARNING, this.sourceName, NewIRFactory.lineno(token.location.start), NewIRFactory.charno(token.location.start));
                    }
                    long v = 0L;
                    int c = 1;
                    while (++c < length) {
                        v = v * 2L + (long)NewIRFactory.binarydigit(value.charAt(c));
                    }
                    return v;
                }
                case 'O': 
                case 'o': {
                    if (!this.isEs6Mode()) {
                        this.errorReporter.warning(OCTAL_NUMBER_LITERAL_WARNING, this.sourceName, NewIRFactory.lineno(token.location.start), NewIRFactory.charno(token.location.start));
                    }
                    long v = 0L;
                    int c = 1;
                    while (++c < length) {
                        v = v * 8L + (long)NewIRFactory.octaldigit(value.charAt(c));
                    }
                    return v;
                }
                case 'X': 
                case 'x': {
                    long v = 0L;
                    int c = 1;
                    while (++c < length) {
                        v = v * 16L + (long)NewIRFactory.hexdigit(value.charAt(c));
                    }
                    return v;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    this.errorReporter.warning(INVALID_ES5_STRICT_OCTAL, this.sourceName, NewIRFactory.lineno(location.start), NewIRFactory.charno(location.start));
                    if (!this.inStrictContext()) {
                        long v = 0L;
                        int c = 0;
                        while (++c < length) {
                            v = v * 8L + (long)NewIRFactory.octaldigit(value.charAt(c));
                        }
                        return v;
                    }
                    return Double.valueOf(value);
                }
            }
            this.errorReporter.error(INVALID_NUMBER_LITERAL, this.sourceName, NewIRFactory.lineno(location.start), NewIRFactory.charno(location.start));
            return 0.0;
        }
        return Double.valueOf(value);
    }

    private static int binarydigit(char c) {
        if (c >= '0' && c <= '1') {
            return c - 48;
        }
        throw new IllegalStateException("unexpected: " + c);
    }

    private static boolean isOctalDigit(char c) {
        return c >= '0' && c <= '7';
    }

    private static int octaldigit(char c) {
        if (NewIRFactory.isOctalDigit(c)) {
            return c - 48;
        }
        throw new IllegalStateException("unexpected: " + c);
    }

    private static int hexdigit(char c) {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': 
            case 'a': {
                return 10;
            }
            case 'B': 
            case 'b': {
                return 11;
            }
            case 'C': 
            case 'c': {
                return 12;
            }
            case 'D': 
            case 'd': {
                return 13;
            }
            case 'E': 
            case 'e': {
                return 14;
            }
            case 'F': 
            case 'f': {
                return 15;
            }
        }
        throw new IllegalStateException("unexpected: " + c);
    }

    private static int transformBooleanTokenType(TokenType token) {
        switch (token) {
            case TRUE: {
                return 44;
            }
            case FALSE: {
                return 43;
            }
        }
        throw new IllegalStateException(String.valueOf((Object)token));
    }

    private static int transformPostfixTokenType(TokenType token) {
        switch (token) {
            case PLUS_PLUS: {
                return 102;
            }
            case MINUS_MINUS: {
                return 103;
            }
        }
        throw new IllegalStateException(String.valueOf((Object)token));
    }

    private static int transformUniaryTokenType(TokenType token) {
        switch (token) {
            case BANG: {
                return 26;
            }
            case TILDE: {
                return 27;
            }
            case PLUS: {
                return 28;
            }
            case MINUS: {
                return 29;
            }
            case DELETE: {
                return 31;
            }
            case TYPEOF: {
                return 32;
            }
            case PLUS_PLUS: {
                return 102;
            }
            case MINUS_MINUS: {
                return 103;
            }
            case VOID: {
                return 122;
            }
        }
        throw new IllegalStateException(String.valueOf((Object)token));
    }

    private static int transformBinaryTokenType(TokenType token) {
        switch (token) {
            case BAR: {
                return 9;
            }
            case CARET: {
                return 10;
            }
            case AMPERSAND: {
                return 11;
            }
            case EQUAL_EQUAL: {
                return 12;
            }
            case NOT_EQUAL: {
                return 13;
            }
            case OPEN_ANGLE: {
                return 14;
            }
            case LESS_EQUAL: {
                return 15;
            }
            case CLOSE_ANGLE: {
                return 16;
            }
            case GREATER_EQUAL: {
                return 17;
            }
            case LEFT_SHIFT: {
                return 18;
            }
            case RIGHT_SHIFT: {
                return 19;
            }
            case UNSIGNED_RIGHT_SHIFT: {
                return 20;
            }
            case PLUS: {
                return 21;
            }
            case MINUS: {
                return 22;
            }
            case STAR: {
                return 23;
            }
            case SLASH: {
                return 24;
            }
            case PERCENT: {
                return 25;
            }
            case EQUAL_EQUAL_EQUAL: {
                return 45;
            }
            case NOT_EQUAL_EQUAL: {
                return 46;
            }
            case IN: {
                return 51;
            }
            case INSTANCEOF: {
                return 52;
            }
            case COMMA: {
                return 85;
            }
            case EQUAL: {
                return 86;
            }
            case BAR_EQUAL: {
                return 87;
            }
            case CARET_EQUAL: {
                return 88;
            }
            case AMPERSAND_EQUAL: {
                return 89;
            }
            case LEFT_SHIFT_EQUAL: {
                return 90;
            }
            case RIGHT_SHIFT_EQUAL: {
                return 91;
            }
            case UNSIGNED_RIGHT_SHIFT_EQUAL: {
                return 92;
            }
            case PLUS_EQUAL: {
                return 93;
            }
            case MINUS_EQUAL: {
                return 94;
            }
            case STAR_EQUAL: {
                return 95;
            }
            case SLASH_EQUAL: {
                return 96;
            }
            case PERCENT_EQUAL: {
                return 97;
            }
            case OR: {
                return 100;
            }
            case AND: {
                return 101;
            }
        }
        throw new IllegalStateException(String.valueOf((Object)token));
    }

    private Node newNode(int type) {
        return new Node(type).clonePropsFrom(this.templateNode);
    }

    private Node newNode(int type, Node child1) {
        return new Node(type, child1).clonePropsFrom(this.templateNode);
    }

    private Node newNode(int type, Node child1, Node child2) {
        return new Node(type, child1, child2).clonePropsFrom(this.templateNode);
    }

    private Node newNode(int type, Node child1, Node child2, Node child3) {
        return new Node(type, child1, child2, child3).clonePropsFrom(this.templateNode);
    }

    private Node newStringNode(String value) {
        return IR.string(value).clonePropsFrom(this.templateNode);
    }

    private Node newStringNode(int type, String value) {
        return Node.newString(type, value).clonePropsFrom(this.templateNode);
    }

    private Node newNumberNode(Double value) {
        return IR.number(value).clonePropsFrom(this.templateNode);
    }

    private class TransformDispatcher
    extends NewTypeSafeDispatcher<Node> {
        private TransformDispatcher() {
        }

        private Node processObjectLitKeyAsString(Token token) {
            Node ret;
            if (token == null) {
                return this.createMissingExpressionNode();
            }
            if (token.type == TokenType.IDENTIFIER) {
                ret = this.processName(token.asIdentifier(), true);
            } else if (token.type == TokenType.NUMBER) {
                ret = NewIRFactory.this.transformNumberAsString(token.asLiteral());
                ret.putBooleanProp(36, true);
            } else {
                ret = this.processString(token.asLiteral());
                ret.putBooleanProp(36, true);
            }
            Preconditions.checkState((boolean)ret.isString());
            return ret;
        }

        @Override
        Node processComprehension(ComprehensionTree tree) {
            int type;
            this.maybeWarnEs6Feature(tree, "array/generator comprehensions");
            switch (tree.type) {
                case ARRAY: {
                    type = 175;
                    break;
                }
                case GENERATOR: {
                    type = 176;
                    break;
                }
                default: {
                    throw new IllegalStateException("unreachable");
                }
            }
            Node node = NewIRFactory.this.newNode(type);
            for (ParseTree child : tree.children) {
                node.addChildToBack(NewIRFactory.this.transform(child));
            }
            node.addChildToBack(NewIRFactory.this.transform(tree.tailExpression));
            return node;
        }

        @Override
        Node processComprehensionFor(ComprehensionForTree tree) {
            return NewIRFactory.this.newNode(163, NewIRFactory.this.transform(tree.initializer), NewIRFactory.this.transform(tree.collection));
        }

        @Override
        Node processComprehensionIf(ComprehensionIfTree tree) {
            return NewIRFactory.this.newNode(108, NewIRFactory.this.transform(tree.expression));
        }

        @Override
        Node processArrayLiteral(ArrayLiteralExpressionTree tree) {
            Node node = NewIRFactory.this.newNode(63);
            for (ParseTree child : tree.elements) {
                Node c = NewIRFactory.this.transform(child);
                node.addChildToBack(c);
            }
            return node;
        }

        @Override
        Node processArrayPattern(ArrayPatternTree tree) {
            this.maybeWarnEs6Feature(tree, "destructuring");
            Node node = NewIRFactory.this.newNode(156);
            for (ParseTree child : tree.elements) {
                node.addChildToBack(NewIRFactory.this.transform(child));
            }
            return node;
        }

        @Override
        Node processObjectPattern(ObjectPatternTree tree) {
            this.maybeWarnEs6Feature(tree, "destructuring");
            Node node = NewIRFactory.this.newNode(157);
            for (ParseTree child : tree.fields) {
                node.addChildToBack(NewIRFactory.this.transform(child));
            }
            return node;
        }

        @Override
        Node processObjectPatternField(ObjectPatternFieldTree tree) {
            Node node = this.processObjectLitKeyAsString(tree.identifier);
            node.setType(154);
            if (tree.element != null) {
                node.addChildToBack(NewIRFactory.this.transform(tree.element));
            }
            return node;
        }

        @Override
        Node processAssignmentRestElement(AssignmentRestElementTree tree) {
            return NewIRFactory.this.newStringNode(172, tree.identifier.value);
        }

        @Override
        Node processAstRoot(ProgramTree rootNode) {
            Node node = NewIRFactory.this.newNode(132);
            for (ParseTree child : rootNode.sourceElements) {
                node.addChildToBack(NewIRFactory.this.transform(child));
            }
            this.parseDirectives(node);
            return node;
        }

        private void parseDirectives(Node node) {
            Set directives = null;
            while (this.isDirective(node.getFirstChild())) {
                String directive = node.removeFirstChild().getFirstChild().getString();
                if (directives == null) {
                    directives = Sets.newHashSet((Object[])new String[]{directive});
                    continue;
                }
                directives.add(directive);
            }
            if (directives != null) {
                node.setDirectives(directives);
            }
        }

        private boolean isDirective(Node n) {
            if (n == null) {
                return false;
            }
            int nType = n.getType();
            return nType == 130 && n.getFirstChild().isString() && ALLOWED_DIRECTIVES.contains((Object)n.getFirstChild().getString());
        }

        @Override
        Node processBlock(BlockTree blockNode) {
            Node node = NewIRFactory.this.newNode(125);
            for (ParseTree child : blockNode.statements) {
                node.addChildToBack(NewIRFactory.this.transform(child));
            }
            return node;
        }

        @Override
        Node processBreakStatement(BreakStatementTree statementNode) {
            Node node = NewIRFactory.this.newNode(116);
            if (statementNode.getLabel() != null) {
                Node labelName = this.transformLabelName(statementNode.name);
                node.addChildToBack(labelName);
            }
            return node;
        }

        Node transformLabelName(IdentifierToken token) {
            Node label = NewIRFactory.this.newStringNode(153, token.value);
            NewIRFactory.this.setSourceInfo(label, token);
            return label;
        }

        @Override
        Node processConditionalExpression(ConditionalExpressionTree exprNode) {
            return NewIRFactory.this.newNode(98, NewIRFactory.this.transform(exprNode.condition), NewIRFactory.this.transform(exprNode.left), NewIRFactory.this.transform(exprNode.right));
        }

        @Override
        Node processContinueStatement(ContinueStatementTree statementNode) {
            Node node = NewIRFactory.this.newNode(117);
            if (statementNode.getLabel() != null) {
                Node labelName = this.transformLabelName(statementNode.name);
                node.addChildToBack(labelName);
            }
            return node;
        }

        @Override
        Node processDoLoop(DoWhileStatementTree loopNode) {
            return NewIRFactory.this.newNode(114, NewIRFactory.this.transformBlock(loopNode.body), NewIRFactory.this.transform(loopNode.condition));
        }

        @Override
        Node processElementGet(MemberLookupExpressionTree getNode) {
            return NewIRFactory.this.newNode(35, NewIRFactory.this.transform(getNode.operand), NewIRFactory.this.transform(getNode.memberExpression));
        }

        @Override
        Node processEmptyStatement(EmptyStatementTree exprNode) {
            return NewIRFactory.this.newNode(124);
        }

        @Override
        Node processExpressionStatement(ExpressionStatementTree statementNode) {
            Node node = NewIRFactory.this.newNode(130);
            node.addChildToBack(NewIRFactory.this.transform(statementNode.expression));
            return node;
        }

        @Override
        Node processForInLoop(ForInStatementTree loopNode) {
            return NewIRFactory.this.newNode(115, NewIRFactory.this.transform(loopNode.initializer), NewIRFactory.this.transform(loopNode.collection), NewIRFactory.this.transformBlock(loopNode.body));
        }

        @Override
        Node processForOf(ForOfStatementTree loopNode) {
            return NewIRFactory.this.newNode(163, NewIRFactory.this.transform(loopNode.initializer), NewIRFactory.this.transform(loopNode.collection), NewIRFactory.this.transformBlock(loopNode.body));
        }

        @Override
        Node processForLoop(ForStatementTree loopNode) {
            Node node = NewIRFactory.this.newNode(115, this.transformOrEmpty(loopNode.initializer, (ParseTree)loopNode), this.transformOrEmpty(loopNode.condition, (ParseTree)loopNode), this.transformOrEmpty(loopNode.increment, (ParseTree)loopNode));
            node.addChildToBack(NewIRFactory.this.transformBlock(loopNode.body));
            return node;
        }

        Node transformOrEmpty(ParseTree tree, ParseTree parent) {
            if (tree == null) {
                Node n = NewIRFactory.this.newNode(124);
                NewIRFactory.this.setSourceInfo(n, parent);
                return n;
            }
            return NewIRFactory.this.transform(tree);
        }

        Node transformOrEmpty(IdentifierToken token, ParseTree parent) {
            if (token == null) {
                Node n = NewIRFactory.this.newNode(124);
                NewIRFactory.this.setSourceInfo(n, parent);
                return n;
            }
            return this.processName(token);
        }

        @Override
        Node processFunctionCall(CallExpressionTree callNode) {
            Node node = NewIRFactory.this.newNode(37, NewIRFactory.this.transform(callNode.operand));
            for (ParseTree child : callNode.arguments.arguments) {
                node.addChildToBack(NewIRFactory.this.transform(child));
            }
            return node;
        }

        @Override
        Node processFunction(FunctionDeclarationTree functionTree) {
            Node result;
            Node newName;
            IdentifierToken name;
            boolean isDeclaration = functionTree.kind == FunctionDeclarationTree.Kind.DECLARATION;
            boolean isMember = functionTree.kind == FunctionDeclarationTree.Kind.MEMBER;
            boolean isArrow = functionTree.kind == FunctionDeclarationTree.Kind.ARROW;
            boolean isGenerator = functionTree.isGenerator;
            if (!NewIRFactory.this.isEs6Mode()) {
                if (isGenerator) {
                    this.maybeWarnEs6Feature(functionTree, "generators");
                }
                if (isMember) {
                    this.maybeWarnEs6Feature(functionTree, "member declarations");
                }
                if (isArrow) {
                    this.maybeWarnEs6Feature(functionTree, "short function syntax");
                }
            }
            if ((name = functionTree.name) != null) {
                newName = this.processNameWithInlineJSDoc(name);
            } else {
                if (isDeclaration || isMember) {
                    NewIRFactory.this.errorReporter.error("unnamed function statement", NewIRFactory.this.sourceName, NewIRFactory.lineno(functionTree), NewIRFactory.charno(functionTree));
                    newName = this.createMissingNameNode();
                } else {
                    newName = NewIRFactory.this.newStringNode(38, "");
                }
                newName.setLineno(NewIRFactory.lineno(functionTree));
                newName.setCharno(NewIRFactory.charno(functionTree));
                NewIRFactory.this.maybeSetLength(newName, 0);
            }
            Node node = NewIRFactory.this.newNode(105);
            if (!isMember) {
                node.addChildToBack(newName);
            } else {
                Node emptyName = NewIRFactory.this.newStringNode(38, "");
                emptyName.setLineno(NewIRFactory.lineno(functionTree));
                emptyName.setCharno(NewIRFactory.charno(functionTree));
                NewIRFactory.this.maybeSetLength(emptyName, 0);
                node.addChildToBack(emptyName);
            }
            node.addChildToBack(NewIRFactory.this.transform(functionTree.formalParameterList));
            Node bodyNode = NewIRFactory.this.transform(functionTree.functionBody);
            if (!isArrow && !bodyNode.isBlock()) {
                Preconditions.checkState((boolean)((NewIRFactory)NewIRFactory.this).config.isIdeMode);
                bodyNode = IR.block();
            }
            this.parseDirectives(bodyNode);
            node.addChildToBack(bodyNode);
            if (functionTree.kind == FunctionDeclarationTree.Kind.MEMBER) {
                NewIRFactory.this.setSourceInfo(node, functionTree);
                Node member = NewIRFactory.this.newStringNode(160, name.value);
                member.addChildToBack(node);
                member.setStaticMember(functionTree.isStatic);
                result = member;
            } else {
                result = node;
            }
            result.setIsGeneratorFunction(isGenerator);
            result.setIsArrowFunction(isArrow);
            return result;
        }

        @Override
        Node processFormalParameterList(FormalParameterListTree tree) {
            Node params = NewIRFactory.this.newNode(83);
            for (ParseTree param : tree.parameters) {
                Node paramNode = NewIRFactory.this.transformNodeWithInlineJsDoc(param, false);
                Preconditions.checkState((paramNode.isName() || paramNode.isRest() || paramNode.isArrayPattern() || paramNode.isObjectPattern() || paramNode.isDefaultValue() ? 1 : 0) != 0);
                params.addChildToBack(paramNode);
            }
            return params;
        }

        @Override
        Node processDefaultParameter(DefaultParameterTree tree) {
            this.maybeWarnEs6Feature(tree, "default parameters");
            return NewIRFactory.this.newNode(179, NewIRFactory.this.transform(tree.lhs), NewIRFactory.this.transform(tree.defaultValue));
        }

        @Override
        Node processRestParameter(RestParameterTree tree) {
            this.maybeWarnEs6Feature(tree, "rest parameters");
            return NewIRFactory.this.newStringNode(172, tree.identifier.value);
        }

        @Override
        Node processSpreadExpression(SpreadExpressionTree tree) {
            this.maybeWarnEs6Feature(tree, "spread expression");
            return NewIRFactory.this.newNode(173, NewIRFactory.this.transform(tree.expression));
        }

        @Override
        Node processIfStatement(IfStatementTree statementNode) {
            Node node = NewIRFactory.this.newNode(108);
            node.addChildToBack(NewIRFactory.this.transform(statementNode.condition));
            node.addChildToBack(NewIRFactory.this.transformBlock(statementNode.ifClause));
            if (statementNode.elseClause != null) {
                node.addChildToBack(NewIRFactory.this.transformBlock(statementNode.elseClause));
            }
            return node;
        }

        @Override
        Node processBinaryExpression(BinaryOperatorTree exprNode) {
            Node target;
            Node n = NewIRFactory.this.newNode(NewIRFactory.transformBinaryTokenType(exprNode.operator.type), NewIRFactory.this.transform(exprNode.left), NewIRFactory.this.transform(exprNode.right));
            if (this.isAssignmentOp(n) && !this.validAssignmentTarget(target = n.getFirstChild())) {
                NewIRFactory.this.errorReporter.error("invalid assignment target: " + target, NewIRFactory.this.sourceName, target.getLineno(), 0);
            }
            return n;
        }

        boolean isAssignmentOp(Node n) {
            switch (n.getType()) {
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: {
                    return true;
                }
            }
            return false;
        }

        @Override
        Node processDebuggerStatement(DebuggerStatementTree node) {
            return NewIRFactory.this.newNode(152);
        }

        @Override
        Node processThisExpression(ThisExpressionTree node) {
            return NewIRFactory.this.newNode(42);
        }

        @Override
        Node processLabeledStatement(LabelledStatementTree labelTree) {
            return NewIRFactory.this.newNode(126, this.transformLabelName(labelTree.name), NewIRFactory.this.transform(labelTree.statement));
        }

        @Override
        Node processName(IdentifierExpressionTree nameNode) {
            return this.processName(nameNode, false);
        }

        Node processName(IdentifierExpressionTree nameNode, boolean asString) {
            return this.processName(nameNode.identifierToken, asString);
        }

        Node processName(IdentifierToken identifierToken) {
            return this.processName(identifierToken, false);
        }

        Node processName(IdentifierToken identifierToken, boolean asString) {
            Node node;
            if (asString) {
                node = NewIRFactory.this.newStringNode(40, identifierToken.value);
            } else {
                JSDocInfo info = NewIRFactory.this.handleJsDoc(identifierToken);
                if (this.isReservedKeyword(identifierToken.toString())) {
                    NewIRFactory.this.errorReporter.error("identifier is a reserved word", NewIRFactory.this.sourceName, NewIRFactory.lineno(identifierToken.location.start), NewIRFactory.charno(identifierToken.location.start));
                }
                node = NewIRFactory.this.newStringNode(38, identifierToken.value);
                if (info != null) {
                    NewIRFactory.attachJSDoc(info, node);
                }
            }
            NewIRFactory.this.setSourceInfo(node, identifierToken);
            return node;
        }

        Node processString(LiteralToken token) {
            Preconditions.checkArgument((token.type == TokenType.STRING ? 1 : 0) != 0);
            Node node = NewIRFactory.this.newStringNode(40, NewIRFactory.this.normalizeString(token, false));
            NewIRFactory.this.setSourceInfo(node, token);
            return node;
        }

        Node processTemplateLiteralToken(LiteralToken token) {
            Preconditions.checkArgument((token.type == TokenType.NO_SUBSTITUTION_TEMPLATE || token.type == TokenType.TEMPLATE_HEAD || token.type == TokenType.TEMPLATE_MIDDLE || token.type == TokenType.TEMPLATE_TAIL ? 1 : 0) != 0);
            Node node = NewIRFactory.this.newStringNode(NewIRFactory.this.normalizeString(token, true));
            node.putProp(71, token.value);
            NewIRFactory.this.setSourceInfo(node, token);
            return node;
        }

        Node processNameWithInlineJSDoc(IdentifierToken identifierToken) {
            JSDocInfo info = NewIRFactory.this.handleInlineJsDoc(identifierToken, true);
            if (this.isReservedKeyword(identifierToken.toString())) {
                NewIRFactory.this.errorReporter.error("identifier is a reserved word", NewIRFactory.this.sourceName, NewIRFactory.lineno(identifierToken.location.start), NewIRFactory.charno(identifierToken.location.start));
            }
            Node node = NewIRFactory.this.newStringNode(38, identifierToken.toString());
            if (info != null) {
                NewIRFactory.attachJSDoc(info, node);
            }
            NewIRFactory.this.setSourceInfo(node, identifierToken);
            return node;
        }

        private boolean isAllowedProp(String identifier) {
            if (((NewIRFactory)NewIRFactory.this).config.languageMode == Config.LanguageMode.ECMASCRIPT3) {
                return !TokenStream.isKeyword(identifier);
            }
            return true;
        }

        private boolean isReservedKeyword(String identifier) {
            if (((NewIRFactory)NewIRFactory.this).config.languageMode == Config.LanguageMode.ECMASCRIPT3) {
                return TokenStream.isKeyword(identifier);
            }
            return NewIRFactory.this.reservedKeywords != null && NewIRFactory.this.reservedKeywords.contains(identifier);
        }

        @Override
        Node processNewExpression(NewExpressionTree exprNode) {
            Node node = NewIRFactory.this.newNode(30, NewIRFactory.this.transform(exprNode.operand));
            if (exprNode.arguments != null) {
                for (ParseTree arg : exprNode.arguments.arguments) {
                    node.addChildToBack(NewIRFactory.this.transform(arg));
                }
            }
            return node;
        }

        @Override
        Node processNumberLiteral(LiteralExpressionTree literalNode) {
            double value = NewIRFactory.this.normalizeNumber(literalNode.literalToken.asLiteral());
            return NewIRFactory.this.newNumberNode(value);
        }

        @Override
        Node processObjectLiteral(ObjectLiteralExpressionTree objTree) {
            Node node = NewIRFactory.this.newNode(64);
            boolean maybeWarn = false;
            for (ParseTree el : objTree.propertyNameAndValues) {
                Node key;
                if (((NewIRFactory)NewIRFactory.this).config.languageMode == Config.LanguageMode.ECMASCRIPT3) {
                    if (el.type == ParseTreeType.GET_ACCESSOR) {
                        this.reportGetter(el);
                        continue;
                    }
                    if (el.type == ParseTreeType.SET_ACCESSOR) {
                        this.reportSetter(el);
                        continue;
                    }
                }
                if (!((key = NewIRFactory.this.transform(el)).isComputedProp() || key.isQuotedString() || NewIRFactory.this.currentFileIsExterns || this.isAllowedProp(key.getString()))) {
                    NewIRFactory.this.errorReporter.warning(NewIRFactory.INVALID_ES3_PROP_NAME, NewIRFactory.this.sourceName, key.getLineno(), key.getCharno());
                }
                if (key.getFirstChild() == null) {
                    maybeWarn = true;
                }
                node.addChildToBack(key);
            }
            if (maybeWarn) {
                this.maybeWarnEs6Feature(objTree, "extended object literals");
            }
            return node;
        }

        @Override
        Node processComputedPropertyDefinition(ComputedPropertyDefinitionTree tree) {
            this.maybeWarnEs6Feature(tree, "computed property");
            return NewIRFactory.this.newNode(174, NewIRFactory.this.transform(tree.property), NewIRFactory.this.transform(tree.value));
        }

        @Override
        Node processComputedPropertyMethod(ComputedPropertyMethodTree tree) {
            this.maybeWarnEs6Feature(tree, "computed property");
            Node n = NewIRFactory.this.newNode(174, NewIRFactory.this.transform(tree.property), NewIRFactory.this.transform(tree.method));
            n.putBooleanProp(72, true);
            return n;
        }

        @Override
        Node processGetAccessor(GetAccessorTree tree) {
            Node key = this.processObjectLitKeyAsString(tree.propertyName);
            key.setType(147);
            Node body = NewIRFactory.this.transform(tree.body);
            Node dummyName = IR.name("");
            NewIRFactory.this.setSourceInfo(dummyName, tree.body);
            Node paramList = IR.paramList();
            NewIRFactory.this.setSourceInfo(paramList, tree.body);
            Node value = IR.function(dummyName, paramList, body);
            NewIRFactory.this.setSourceInfo(value, tree.body);
            key.addChildToFront(value);
            key.setStaticMember(tree.isStatic);
            return key;
        }

        @Override
        Node processSetAccessor(SetAccessorTree tree) {
            Node key = this.processObjectLitKeyAsString(tree.propertyName);
            key.setType(148);
            Node body = NewIRFactory.this.transform(tree.body);
            Node dummyName = IR.name("");
            NewIRFactory.this.setSourceInfo(dummyName, tree.propertyName);
            Node paramList = IR.paramList(this.safeProcessName(tree.parameter));
            NewIRFactory.this.setSourceInfo(paramList, tree.parameter);
            Node value = IR.function(dummyName, paramList, body);
            NewIRFactory.this.setSourceInfo(value, tree.body);
            key.addChildToFront(value);
            key.setStaticMember(tree.isStatic);
            return key;
        }

        @Override
        Node processPropertyNameAssignment(PropertyNameAssignmentTree tree) {
            Node key = this.processObjectLitKeyAsString(tree.name);
            key.setType(154);
            if (tree.value != null) {
                key.addChildToFront(NewIRFactory.this.transform(tree.value));
            }
            return key;
        }

        private Node safeProcessName(IdentifierToken identifierToken) {
            if (identifierToken == null) {
                return this.createMissingExpressionNode();
            }
            return this.processName(identifierToken);
        }

        @Override
        Node processParenthesizedExpression(ParenExpressionTree exprNode) {
            return NewIRFactory.this.transform(exprNode.expression);
        }

        @Override
        Node processPropertyGet(MemberExpressionTree getNode) {
            Node leftChild = NewIRFactory.this.transform(getNode.operand);
            IdentifierToken nodeProp = getNode.memberName;
            Node rightChild = this.processObjectLitKeyAsString(nodeProp);
            if (!(rightChild.isQuotedString() || NewIRFactory.this.currentFileIsExterns || this.isAllowedProp(rightChild.getString()))) {
                NewIRFactory.this.errorReporter.warning(NewIRFactory.INVALID_ES3_PROP_NAME, NewIRFactory.this.sourceName, rightChild.getLineno(), rightChild.getCharno());
            }
            return NewIRFactory.this.newNode(33, leftChild, rightChild);
        }

        @Override
        Node processRegExpLiteral(LiteralExpressionTree literalTree) {
            LiteralToken token = literalTree.literalToken.asLiteral();
            Node literalStringNode = NewIRFactory.this.newStringNode(NewIRFactory.this.normalizeRegex(token));
            NewIRFactory.this.setSourceInfo(literalStringNode, token);
            Node node = NewIRFactory.this.newNode(47, literalStringNode);
            String rawRegex = token.value;
            int lastSlash = rawRegex.lastIndexOf(47);
            String flags = "";
            if (lastSlash < rawRegex.length()) {
                flags = rawRegex.substring(lastSlash + 1);
            }
            this.validateRegExpFlags(literalTree, flags);
            if (!flags.isEmpty()) {
                Node flagsNode = NewIRFactory.this.newStringNode(flags);
                NewIRFactory.this.setSourceInfo(flagsNode, token);
                node.addChildToBack(flagsNode);
            }
            return node;
        }

        private void validateRegExpFlags(LiteralExpressionTree tree, String flags) {
            Iterator i$ = Lists.charactersOf((String)flags).iterator();
            block4: while (i$.hasNext()) {
                char flag = ((Character)i$.next()).charValue();
                switch (flag) {
                    case 'g': 
                    case 'i': 
                    case 'm': {
                        continue block4;
                    }
                    case 'u': 
                    case 'y': {
                        this.maybeWarnEs6Feature(tree, "new RegExp flag '" + flag + "'");
                        continue block4;
                    }
                }
                NewIRFactory.this.errorReporter.error("Invalid RegExp flag '" + flag + "'", NewIRFactory.this.sourceName, NewIRFactory.lineno(tree), NewIRFactory.charno(tree));
            }
        }

        @Override
        Node processReturnStatement(ReturnStatementTree statementNode) {
            Node node = NewIRFactory.this.newNode(4);
            if (statementNode.expression != null) {
                node.addChildToBack(NewIRFactory.this.transform(statementNode.expression));
            }
            return node;
        }

        @Override
        Node processStringLiteral(LiteralExpressionTree literalTree) {
            LiteralToken token = literalTree.literalToken.asLiteral();
            Node n = this.processString(token);
            String value = n.getString();
            if (value.indexOf(11) != -1) {
                int start = token.location.start.offset;
                int end = token.location.end.offset;
                if (start < NewIRFactory.this.sourceString.length() && NewIRFactory.this.sourceString.substring(start, Math.min(NewIRFactory.this.sourceString.length(), end)).contains("\\v")) {
                    n.putBooleanProp(54, true);
                }
            }
            return n;
        }

        @Override
        Node processTemplateLiteral(TemplateLiteralExpressionTree tree) {
            this.maybeWarnEs6Feature(tree, "template literals");
            Node node = tree.operand == null ? NewIRFactory.this.newNode(177) : NewIRFactory.this.newNode(177, NewIRFactory.this.transform(tree.operand));
            for (ParseTree child : tree.elements) {
                node.addChildToBack(NewIRFactory.this.transform(child));
            }
            return node;
        }

        @Override
        Node processTemplateLiteralPortion(TemplateLiteralPortionTree tree) {
            return this.processTemplateLiteralToken(tree.value.asLiteral());
        }

        @Override
        Node processTemplateSubstitution(TemplateSubstitutionTree tree) {
            return NewIRFactory.this.newNode(178, NewIRFactory.this.transform(tree.expression));
        }

        @Override
        Node processSwitchCase(CaseClauseTree caseNode) {
            ParseTree expr = caseNode.expression;
            Node node = NewIRFactory.this.newNode(111, NewIRFactory.this.transform(expr));
            Node block = NewIRFactory.this.newNode(125);
            block.putBooleanProp(38, true);
            NewIRFactory.this.setSourceInfo(block, caseNode);
            if (caseNode.statements != null) {
                for (ParseTree child : caseNode.statements) {
                    block.addChildToBack(NewIRFactory.this.transform(child));
                }
            }
            node.addChildToBack(block);
            return node;
        }

        @Override
        Node processSwitchDefault(DefaultClauseTree caseNode) {
            Node node = NewIRFactory.this.newNode(112);
            Node block = NewIRFactory.this.newNode(125);
            block.putBooleanProp(38, true);
            NewIRFactory.this.setSourceInfo(block, caseNode);
            if (caseNode.statements != null) {
                for (ParseTree child : caseNode.statements) {
                    block.addChildToBack(NewIRFactory.this.transform(child));
                }
            }
            node.addChildToBack(block);
            return node;
        }

        @Override
        Node processSwitchStatement(SwitchStatementTree statementNode) {
            Node node = NewIRFactory.this.newNode(110, NewIRFactory.this.transform(statementNode.expression));
            for (ParseTree child : statementNode.caseClauses) {
                node.addChildToBack(NewIRFactory.this.transform(child));
            }
            return node;
        }

        @Override
        Node processThrowStatement(ThrowStatementTree statementNode) {
            return NewIRFactory.this.newNode(49, NewIRFactory.this.transform(statementNode.value));
        }

        @Override
        Node processTryStatement(TryStatementTree statementNode) {
            Node node = NewIRFactory.this.newNode(77, NewIRFactory.this.transformBlock(statementNode.body));
            Node block = NewIRFactory.this.newNode(125);
            boolean lineSet = false;
            ParseTree cc = statementNode.catchBlock;
            if (cc != null) {
                NewIRFactory.this.setSourceInfo(block, cc);
                lineSet = true;
                block.addChildToBack(NewIRFactory.this.transform(cc));
            }
            node.addChildToBack(block);
            ParseTree finallyBlock = statementNode.finallyBlock;
            if (finallyBlock != null) {
                node.addChildToBack(NewIRFactory.this.transformBlock(finallyBlock));
            }
            if (!lineSet && finallyBlock != null) {
                NewIRFactory.this.setSourceInfo(block, finallyBlock);
            }
            return node;
        }

        @Override
        Node processCatchClause(CatchTree clauseNode) {
            IdentifierToken catchVar = clauseNode.exceptionName;
            Node node = NewIRFactory.this.newNode(120, this.processName(catchVar));
            node.addChildToBack(NewIRFactory.this.transformBlock(clauseNode.catchBody));
            return node;
        }

        @Override
        Node processFinally(FinallyTree finallyNode) {
            return NewIRFactory.this.transformBlock(finallyNode.block);
        }

        @Override
        Node processUnaryExpression(UnaryExpressionTree exprNode) {
            int type = NewIRFactory.transformUniaryTokenType(exprNode.operator.type);
            Node operand = NewIRFactory.this.transform(exprNode.operand);
            if (type == 29 && operand.isNumber()) {
                operand.setDouble(-operand.getDouble());
                return operand;
            }
            if (!(type != 31 || operand.isGetProp() || operand.isGetElem() || operand.isName())) {
                String msg = "Invalid delete operand. Only properties can be deleted.";
                NewIRFactory.this.errorReporter.error(msg, NewIRFactory.this.sourceName, operand.getLineno(), 0);
            } else if (!(type != 102 && type != 103 || this.validAssignmentTarget(operand))) {
                String msg = type == 102 ? "invalid increment target" : "invalid decrement target";
                NewIRFactory.this.errorReporter.error(msg, NewIRFactory.this.sourceName, operand.getLineno(), 0);
            }
            return NewIRFactory.this.newNode(type, operand);
        }

        @Override
        Node processPostfixExpression(PostfixExpressionTree exprNode) {
            int type = NewIRFactory.transformPostfixTokenType(exprNode.operator.type);
            Node operand = NewIRFactory.this.transform(exprNode.operand);
            if (!this.validAssignmentTarget(operand)) {
                String msg = type == 102 ? "invalid increment target" : "invalid decrement target";
                NewIRFactory.this.errorReporter.error(msg, NewIRFactory.this.sourceName, operand.getLineno(), 0);
            }
            Node node = NewIRFactory.this.newNode(type, operand);
            node.putBooleanProp(32, true);
            return node;
        }

        private boolean validAssignmentTarget(Node target) {
            switch (target.getType()) {
                case 33: 
                case 35: 
                case 38: 
                case 155: 
                case 156: 
                case 157: {
                    return true;
                }
            }
            return false;
        }

        @Override
        Node processVariableStatement(VariableStatementTree stmt) {
            return NewIRFactory.this.justTransform(stmt.declarations);
        }

        @Override
        Node processVariableDeclarationList(VariableDeclarationListTree decl) {
            int declType;
            switch (decl.declarationType) {
                case CONST: {
                    if (!((NewIRFactory)NewIRFactory.this).config.acceptConstKeyword) {
                        this.maybeWarnEs6Feature(decl, "const declarations");
                    }
                    if (NewIRFactory.this.isEs6Mode()) {
                        declType = 149;
                        break;
                    }
                    declType = 118;
                    break;
                }
                case LET: {
                    this.maybeWarnEs6Feature(decl, "let declarations");
                    declType = 162;
                    break;
                }
                case VAR: {
                    declType = 118;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            Node node = NewIRFactory.this.newNode(declType);
            for (VariableDeclarationTree child : decl.declarations) {
                node.addChildToBack(NewIRFactory.this.transformNodeWithInlineJsDoc(child, true));
            }
            return node;
        }

        @Override
        Node processVariableDeclaration(VariableDeclarationTree decl) {
            Node node = NewIRFactory.this.transformNodeWithInlineJsDoc(decl.lvalue, true);
            if (decl.initializer != null) {
                Node initalizer = NewIRFactory.this.transform(decl.initializer);
                node.addChildToBack(initalizer);
            }
            return node;
        }

        @Override
        Node processWhileLoop(WhileStatementTree stmt) {
            return NewIRFactory.this.newNode(113, NewIRFactory.this.transform(stmt.condition), NewIRFactory.this.transformBlock(stmt.body));
        }

        @Override
        Node processWithStatement(WithStatementTree stmt) {
            return NewIRFactory.this.newNode(119, NewIRFactory.this.transform(stmt.expression), NewIRFactory.this.transformBlock(stmt.body));
        }

        @Override
        Node processMissingExpression(MissingPrimaryExpressionTree tree) {
            return this.createMissingExpressionNode();
        }

        private Node createMissingNameNode() {
            return NewIRFactory.this.newStringNode(38, "__missing_name__");
        }

        private Node createMissingExpressionNode() {
            return NewIRFactory.this.newStringNode(38, "__missing_expression__");
        }

        @Override
        Node processIllegalToken(ParseTree node) {
            NewIRFactory.this.errorReporter.error("Unsupported syntax: " + (Object)((Object)node.type), NewIRFactory.this.sourceName, NewIRFactory.lineno(node), 0);
            return NewIRFactory.this.newNode(124);
        }

        void reportDestructuringAssign(ParseTree node) {
            NewIRFactory.this.errorReporter.error("destructuring assignment forbidden", NewIRFactory.this.sourceName, NewIRFactory.lineno(node), 0);
        }

        void reportGetter(ParseTree node) {
            NewIRFactory.this.errorReporter.error(NewIRFactory.GETTER_ERROR_MESSAGE, NewIRFactory.this.sourceName, NewIRFactory.lineno(node), 0);
        }

        void reportSetter(ParseTree node) {
            NewIRFactory.this.errorReporter.error(NewIRFactory.SETTER_ERROR_MESSAGE, NewIRFactory.this.sourceName, NewIRFactory.lineno(node), 0);
        }

        @Override
        Node processBooleanLiteral(LiteralExpressionTree literal) {
            return NewIRFactory.this.newNode(NewIRFactory.transformBooleanTokenType(literal.literalToken.type));
        }

        @Override
        Node processNullLiteral(LiteralExpressionTree literal) {
            return NewIRFactory.this.newNode(41);
        }

        @Override
        Node processNull(NullTree literal) {
            return NewIRFactory.this.newNode(124);
        }

        @Override
        Node processCommaExpression(CommaExpressionTree tree) {
            Node root = NewIRFactory.this.newNode(85);
            SourcePosition start = ((ParseTree)tree.expressions.get((int)0)).location.start;
            SourcePosition end = ((ParseTree)tree.expressions.get((int)1)).location.end;
            NewIRFactory.this.setSourceInfo(root, start, end);
            for (ParseTree expr : tree.expressions) {
                int count = root.getChildCount();
                if (count < 2) {
                    root.addChildrenToBack(NewIRFactory.this.transform(expr));
                    continue;
                }
                end = expr.location.end;
                root = NewIRFactory.this.newNode(85, root, NewIRFactory.this.transform(expr));
                NewIRFactory.this.setSourceInfo(root, start, end);
            }
            return root;
        }

        @Override
        Node processClassDeclaration(ClassDeclarationTree tree) {
            this.maybeWarnEs6Feature(tree, "class");
            Node name = this.transformOrEmpty(tree.name, (ParseTree)tree);
            Node superClass = this.transformOrEmpty(tree.superClass, (ParseTree)tree);
            Node body = NewIRFactory.this.newNode(159);
            NewIRFactory.this.setSourceInfo(body, tree);
            for (ParseTree child : tree.elements) {
                body.addChildToBack(NewIRFactory.this.transform(child));
            }
            return NewIRFactory.this.newNode(158, name, superClass, body);
        }

        @Override
        Node processSuper(SuperExpressionTree tree) {
            this.maybeWarnEs6Feature(tree, "super");
            return NewIRFactory.this.newNode(161);
        }

        @Override
        Node processYield(YieldExpressionTree tree) {
            Node yield = new Node(164);
            if (tree.expression != null) {
                yield.addChildToBack(NewIRFactory.this.transform(tree.expression));
            }
            yield.setYieldFor(tree.isYieldFor);
            return yield;
        }

        @Override
        Node processExportDecl(ExportDeclarationTree tree) {
            this.maybeWarnEs6Feature(tree, "modules");
            Node decls = null;
            if (tree.isExportAll) {
                Preconditions.checkState((tree.declaration == null && tree.exportSpecifierList == null ? 1 : 0) != 0);
            } else if (tree.declaration != null) {
                Preconditions.checkState((tree.exportSpecifierList == null ? 1 : 0) != 0);
                decls = NewIRFactory.this.transform(tree.declaration);
            } else {
                decls = this.transformList(169, tree.exportSpecifierList);
            }
            if (decls == null) {
                decls = NewIRFactory.this.newNode(124);
            }
            Node export = NewIRFactory.this.newNode(168, decls);
            if (tree.from != null) {
                Node from = this.processString(tree.from);
                export.addChildToBack(from);
            }
            export.putBooleanProp(63, tree.isExportAll);
            export.putBooleanProp(62, tree.isDefault);
            return export;
        }

        @Override
        Node processExportSpec(ExportSpecifierTree tree) {
            Node importSpec = NewIRFactory.this.newNode(170, this.processName(tree.importedName));
            if (tree.destinationName != null) {
                importSpec.addChildToBack(this.processName(tree.destinationName));
            }
            return importSpec;
        }

        @Override
        Node processImportDecl(ImportDeclarationTree tree) {
            this.maybeWarnEs6Feature(tree, "modules");
            Node export = NewIRFactory.this.newNode(165, this.transformOrEmpty(tree.defaultBindingIndentifier, (ParseTree)tree), this.transformListOrEmpty(166, tree.importSpecifierList), this.processString(tree.moduleSpecifier));
            return export;
        }

        @Override
        Node processImportSpec(ImportSpecifierTree tree) {
            Node importSpec = NewIRFactory.this.newNode(167, this.processName(tree.importedName));
            if (tree.destinationName != null) {
                importSpec.addChildToBack(this.processName(tree.destinationName));
            }
            return importSpec;
        }

        @Override
        Node processModuleImport(ModuleImportTree tree) {
            this.maybeWarnEs6Feature(tree, "modules");
            Node module = NewIRFactory.this.newNode(171, this.processName(tree.name), this.processString(tree.from));
            return module;
        }

        private Node transformList(int type, ImmutableList<ParseTree> list) {
            Node n = NewIRFactory.this.newNode(type);
            for (ParseTree tree : list) {
                n.addChildToBack(NewIRFactory.this.transform(tree));
            }
            return n;
        }

        private Node transformListOrEmpty(int type, ImmutableList<ParseTree> list) {
            if (list != null) {
                return this.transformList(type, list);
            }
            return NewIRFactory.this.newNode(124);
        }

        void maybeWarnEs6Feature(ParseTree node, String feature) {
            if (!NewIRFactory.this.isEs6Mode()) {
                NewIRFactory.this.errorReporter.warning("this language feature is only supported in es6 mode: " + feature, NewIRFactory.this.sourceName, NewIRFactory.lineno(node), NewIRFactory.charno(node));
            }
        }

        @Override
        Node unsupportedLanguageFeature(ParseTree node, String feature) {
            NewIRFactory.this.errorReporter.error("unsupported language feature: " + feature, NewIRFactory.this.sourceName, NewIRFactory.lineno(node), NewIRFactory.charno(node));
            return this.createMissingExpressionNode();
        }
    }
}

