/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.parsing;

import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.parsing.Config;
import com.google.javascript.jscomp.parsing.ParserRunner;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.SimpleErrorReporter;
import com.google.javascript.rhino.jstype.StaticSourceFile;
import java.util.HashSet;

public final class TypeTransformationParser {
    private String typeTransformationString;
    private Node typeTransformationAst;
    private StaticSourceFile sourceFile;
    private ErrorReporter errorReporter;
    private int templateLineno;
    private int templateCharno;
    private static final CharMatcher TYPEVAR_FIRSTLETTER_MATCHER = CharMatcher.JAVA_LETTER.or(CharMatcher.is((char)'_')).or(CharMatcher.is((char)'$'));
    private static final CharMatcher TYPEVAR_MATCHER = CharMatcher.JAVA_LETTER_OR_DIGIT.or(CharMatcher.is((char)'_')).or(CharMatcher.is((char)'$'));
    private static final ImmutableList<Keywords> TYPE_CONSTRUCTORS = ImmutableList.of((Object)((Object)Keywords.TYPE), (Object)((Object)Keywords.UNION));
    private static final ImmutableList<Keywords> OPERATIONS = ImmutableList.of((Object)((Object)Keywords.COND), (Object)((Object)Keywords.MAPUNION));
    private static final ImmutableList<Keywords> BOOLEAN_PREDICATES = ImmutableList.of((Object)((Object)Keywords.EQTYPE), (Object)((Object)Keywords.SUBTYPE));
    private static final int TYPE_MIN_PARAM_COUNT = 1;
    private static final int TYPE_MAX_PARAM_COUNT = 1;
    private static final int UNION_MIN_PARAM_COUNT = 2;
    private static final int COND_PARAM_COUNT = 3;
    private static final int BOOLPRED_PARAM_COUNT = 2;
    private static final int MAPUNION_PARAM_COUNT = 2;

    public TypeTransformationParser(String typeTransformationString, StaticSourceFile sourceFile, ErrorReporter errorReporter, int templateLineno, int templateCharno) {
        this.typeTransformationString = typeTransformationString;
        this.sourceFile = sourceFile;
        this.errorReporter = errorReporter;
        this.templateLineno = templateLineno;
        this.templateCharno = templateCharno;
    }

    public Node getTypeTransformationAst() {
        return this.typeTransformationAst;
    }

    private void addNewWarning(String messageId, Node nodeWarning) {
        this.addNewWarning(messageId, "", nodeWarning);
    }

    private void addNewWarning(String messageId, String messageArg, Node nodeWarning) {
        this.errorReporter.warning("Bad type annotation. " + SimpleErrorReporter.getMessage1(messageId, messageArg), this.sourceFile.getName(), this.templateLineno, this.templateCharno);
    }

    private boolean isKeyword(String s, Keywords keyword) {
        return s.equals(keyword.name);
    }

    private boolean belongsTo(String s, ImmutableList<Keywords> set) {
        for (Keywords keyword : set) {
            if (!s.equals(keyword.name)) continue;
            return true;
        }
        return false;
    }

    private boolean validTypeTransformationName(String name) {
        return !name.isEmpty() && TYPEVAR_FIRSTLETTER_MATCHER.matches(name.charAt(0)) && TYPEVAR_MATCHER.matchesAllOf((CharSequence)name);
    }

    public boolean parseTypeTransformation() {
        Config config = new Config(new HashSet<String>(), new HashSet<String>(), true, Config.LanguageMode.ECMASCRIPT6, false);
        ParserRunner.ParseResult result = ParserRunner.parse(this.sourceFile, this.typeTransformationString, config, this.errorReporter);
        Node ast = result.ast;
        if (!ast.isScript() || !ast.getFirstChild().isExprResult()) {
            this.addNewWarning("msg.jsdoc.typetransformation.invalid.expression", "type transformation", ast);
            return false;
        }
        Node expr = ast.getFirstChild().getFirstChild();
        if (!this.validTypeTransformationExpression(expr)) {
            return false;
        }
        this.typeTransformationAst = expr;
        return true;
    }

    private boolean validTTLTypeVar(Node expression) {
        if (!expression.isName()) {
            this.addNewWarning("msg.jsdoc.typetransformation.invalid.typevar", expression);
            return false;
        }
        if (!this.validTypeTransformationName(expression.getString())) {
            this.addNewWarning("msg.jsdoc.typetransformation.invalid.typevar", expression);
            return false;
        }
        return true;
    }

    private boolean validTTLBasicTypeExpression(Node expression) {
        if (!expression.isName() && !expression.isCall()) {
            this.addNewWarning("msg.jsdoc.typetransformation.invalid.expression", "basic type", expression);
            return false;
        }
        if (expression.isName()) {
            return this.validTTLTypeVar(expression);
        }
        String keyword = expression.getFirstChild().getString();
        if (!this.isKeyword(keyword, Keywords.TYPE)) {
            this.addNewWarning("msg.jsdoc.typetransformation.invalid.expression", "basic type", expression);
            return false;
        }
        if (expression.getChildCount() < 2) {
            this.addNewWarning("msg.jsdoc.typetransformation.missing.param", "type operation", expression);
            return false;
        }
        if (expression.getChildCount() > 2) {
            this.addNewWarning("msg.jsdoc.typetransformation.extra.param", "type operation", expression);
            return false;
        }
        if (!expression.getChildAtIndex(1).isString()) {
            this.addNewWarning("msg.jsdoc.typetransformation.invalid", "type name", expression);
            return false;
        }
        return true;
    }

    private boolean validTTLUnionTypeExpression(Node expression) {
        if (!expression.isName() && !expression.isCall()) {
            this.addNewWarning("msg.jsdoc.typetransformation.invalid.expression", "union type", expression);
            return false;
        }
        if (expression.isName()) {
            return this.validTTLTypeVar(expression);
        }
        String keyword = expression.getFirstChild().getString();
        if (!this.isKeyword(keyword, Keywords.UNION)) {
            this.addNewWarning("msg.jsdoc.typetransformation.invalid.expression", "union type", expression);
            return false;
        }
        if (expression.getChildCount() < 3) {
            this.addNewWarning("msg.jsdoc.typetransformation.missing.param", "union type", expression);
            return false;
        }
        for (Node param : expression.children()) {
            if (param.equals(expression.getFirstChild()) || this.validTTLTypeExpression(param)) continue;
            this.addNewWarning("msg.jsdoc.typetransformation.invalid.inside", "union type", expression);
            return false;
        }
        return true;
    }

    private boolean validTTLTypeExpression(Node expression) {
        if (!expression.isName() && !expression.isCall()) {
            this.addNewWarning("msg.jsdoc.typetransformation.invalid.expression", "type", expression);
            return false;
        }
        if (expression.isName()) {
            return this.validTTLTypeVar(expression);
        }
        Node operation = expression.getFirstChild();
        String keyword = operation.getString();
        if (!this.belongsTo(keyword, TYPE_CONSTRUCTORS)) {
            this.addNewWarning("msg.jsdoc.typetransformation.invalid.expression", "type", operation);
            return false;
        }
        if (this.isKeyword(keyword, Keywords.TYPE)) {
            return this.validTTLBasicTypeExpression(expression);
        }
        if (this.isKeyword(keyword, Keywords.UNION)) {
            return this.validTTLUnionTypeExpression(expression);
        }
        throw new IllegalStateException("Invalid type expression");
    }

    private boolean validTTLBooleanTypeExpression(Node expression) {
        if (!expression.isCall()) {
            this.addNewWarning("msg.jsdoc.typetransformation.invalid.expression", "boolean", expression);
            return false;
        }
        String predicate = expression.getFirstChild().getString();
        if (!this.belongsTo(predicate, BOOLEAN_PREDICATES)) {
            this.addNewWarning("msg.jsdoc.typetransformation.invalid", "boolean predicate", expression);
            return false;
        }
        if (expression.getChildCount() < 3) {
            this.addNewWarning("msg.jsdoc.typetransformation.missing.param", "boolean predicate", expression);
            return false;
        }
        if (expression.getChildCount() > 3) {
            this.addNewWarning("msg.jsdoc.typetransformation.extra.param", "boolean predicate", expression);
            return false;
        }
        if (!this.validTypeTransformationExpression(expression.getChildAtIndex(1)) || !this.validTypeTransformationExpression(expression.getChildAtIndex(2))) {
            this.addNewWarning("msg.jsdoc.typetransformation.invalid.inside", "boolean", expression);
            return false;
        }
        return true;
    }

    private boolean validTTLCondionalExpression(Node expression) {
        if (expression.getChildCount() < 4) {
            this.addNewWarning("msg.jsdoc.typetransformation.missing.param", "conditional", expression);
            return false;
        }
        if (expression.getChildCount() > 4) {
            this.addNewWarning("msg.jsdoc.typetransformation.extra.param", "conditional", expression);
            return false;
        }
        if (!this.validTTLBooleanTypeExpression(expression.getChildAtIndex(1))) {
            this.addNewWarning("msg.jsdoc.typetransformation.invalid.inside", "conditional", expression);
            return false;
        }
        if (!this.validTypeTransformationExpression(expression.getChildAtIndex(2))) {
            this.addNewWarning("msg.jsdoc.typetransformation.invalid.inside", "conditional", expression);
            return false;
        }
        if (!this.validTypeTransformationExpression(expression.getChildAtIndex(3))) {
            this.addNewWarning("msg.jsdoc.typetransformation.invalid.inside", "conditional", expression);
            return false;
        }
        return true;
    }

    private boolean validTTLMapunionExpression(Node expression) {
        if (expression.getChildCount() < 3) {
            this.addNewWarning("msg.jsdoc.typetransformation.missing.param", "mapunion", expression);
            return false;
        }
        if (expression.getChildCount() > 3) {
            this.addNewWarning("msg.jsdoc.typetransformation.extra.param", "mapunion", expression);
            return false;
        }
        if (!this.validTTLUnionTypeExpression(expression.getChildAtIndex(1))) {
            this.addNewWarning("msg.jsdoc.typetransformation.invalid.inside", "mapunion", expression.getChildAtIndex(1));
            return false;
        }
        if (!expression.getChildAtIndex(2).isFunction()) {
            this.addNewWarning("msg.jsdoc.typetransformation.invalid", "map function", expression.getChildAtIndex(2));
            return false;
        }
        Node mapFunction = expression.getChildAtIndex(2);
        if (!mapFunction.getChildAtIndex(1).hasChildren()) {
            this.addNewWarning("msg.jsdoc.typetransformation.missing.param", "map function", mapFunction.getChildAtIndex(1));
            return false;
        }
        if (!mapFunction.getChildAtIndex(1).hasOneChild()) {
            this.addNewWarning("msg.jsdoc.typetransformation.extra.param", "map function", mapFunction.getChildAtIndex(1));
            return false;
        }
        Node mapFunctionParam = mapFunction.getChildAtIndex(1).getFirstChild();
        if (!this.validTTLTypeVar(mapFunctionParam)) {
            this.addNewWarning("msg.jsdoc.typetransformation.invalid.inside", "map function", mapFunctionParam);
            return false;
        }
        Node mapFunctionBody = mapFunction.getChildAtIndex(2);
        if (!this.validTypeTransformationExpression(mapFunctionBody)) {
            this.addNewWarning("msg.jsdoc.typetransformation.invalid.inside", "map function body", mapFunctionBody);
            return false;
        }
        return true;
    }

    private boolean validTypeTransformationExpression(Node expression) {
        if (!expression.isName() && !expression.isCall()) {
            this.addNewWarning("msg.jsdoc.typetransformation.invalid.expression", "type transformation", expression);
            return false;
        }
        if (expression.isName()) {
            return this.validTTLTypeVar(expression);
        }
        Node operation = expression.getFirstChild();
        String keyword = operation.getString();
        if (!this.belongsTo(keyword, TYPE_CONSTRUCTORS) && !this.belongsTo(keyword, OPERATIONS)) {
            this.addNewWarning("msg.jsdoc.typetransformation.invalid.expression", "type transformation", operation);
            return false;
        }
        if (this.belongsTo(keyword, TYPE_CONSTRUCTORS)) {
            return this.validTTLTypeExpression(expression);
        }
        if (this.isKeyword(keyword, Keywords.COND)) {
            return this.validTTLCondionalExpression(expression);
        }
        if (this.isKeyword(keyword, Keywords.MAPUNION)) {
            return this.validTTLMapunionExpression(expression);
        }
        throw new IllegalStateException("Invalid type transformation expression");
    }

    public static enum Keywords {
        TYPE("type"),
        UNION("union"),
        COND("cond"),
        MAPUNION("mapunion"),
        EQTYPE("eq"),
        SUBTYPE("sub");

        public final String name;

        private Keywords(String name) {
            this.name = name;
        }
    }
}

