/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ConformanceConfig;
import com.google.javascript.jscomp.ConformanceRules;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.Requirement;
import com.google.javascript.rhino.Node;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;

public final class CheckConformance
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    static final DiagnosticType CONFORMANCE_VIOLATION = DiagnosticType.warning("JSC_CONFORMANCE_VIOLATION", "Violation: {0}");
    static final DiagnosticType CONFORMANCE_POSSIBLE_VIOLATION = DiagnosticType.warning("JSC_CONFORMANCE_POSSIBLE_VIOLATION", "Possible violation: {0}");
    static final DiagnosticType INVALID_REQUIREMENT_SPEC = DiagnosticType.error("JSC_INVALID_REQUIREMENT_SPEC", "Invalid requirement. Reason: {0}\nRequirement spec:\n{1}");
    private final AbstractCompiler compiler;
    private final ImmutableList<Rule> rules;

    CheckConformance(AbstractCompiler compiler, ImmutableList<ConformanceConfig> configs) {
        this.compiler = compiler;
        this.rules = CheckConformance.initRules(compiler, configs);
    }

    @Override
    public void process(Node externs, Node root) {
        if (!this.rules.isEmpty()) {
            NodeTraversal.traverse(this.compiler, root, this);
        }
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        for (Rule rule : this.rules) {
            rule.check(t, n);
        }
    }

    private static ImmutableList<Rule> initRules(AbstractCompiler compiler, ImmutableList<ConformanceConfig> configs) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ConformanceConfig config : configs) {
            for (Requirement requirement : config.getRequirementList()) {
                Rule rule = CheckConformance.initRule(compiler, requirement);
                if (rule == null) continue;
                builder.add((Object)rule);
            }
        }
        return builder.build();
    }

    private static Rule initRule(AbstractCompiler compiler, Requirement requirement) {
        try {
            switch (requirement.getType()) {
                case CUSTOM: {
                    return new ConformanceRules.CustomRuleProxy(compiler, requirement);
                }
                case BANNED_CODE_PATTERN: {
                    return new ConformanceRules.BannedCodePattern(compiler, requirement);
                }
                case BANNED_DEPENDENCY: {
                    return new ConformanceRules.BannedDependency(compiler, requirement);
                }
                case BANNED_NAME: {
                    return new ConformanceRules.BannedName(compiler, requirement);
                }
                case BANNED_PROPERTY: 
                case BANNED_PROPERTY_READ: 
                case BANNED_PROPERTY_WRITE: 
                case BANNED_PROPERTY_CALL: {
                    return new ConformanceRules.BannedProperty(compiler, requirement);
                }
                case RESTRICTED_NAME_CALL: {
                    return new ConformanceRules.RestrictedNameCall(compiler, requirement);
                }
                case RESTRICTED_METHOD_CALL: {
                    return new ConformanceRules.RestrictedMethodCall(compiler, requirement);
                }
            }
            CheckConformance.reportInvalidRequirement(compiler, requirement, "unknown requirement type");
            return null;
        }
        catch (InvalidRequirementSpec e) {
            CheckConformance.reportInvalidRequirement(compiler, requirement, e.getMessage());
            return null;
        }
    }

    private static void reportInvalidRequirement(AbstractCompiler compiler, Requirement requirement, String reason) {
        compiler.report(JSError.make(INVALID_REQUIREMENT_SPEC, reason, TextFormat.printToString((MessageOrBuilder)requirement)));
    }

    public static class InvalidRequirementSpec
    extends Exception {
        InvalidRequirementSpec(String message) {
            super(message);
        }
    }

    public static interface Rule {
        public void check(NodeTraversal var1, Node var2);
    }
}

