/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

class ClosureRewriteClass
extends NodeTraversal.AbstractPostOrderCallback
implements HotSwapCompilerPass {
    static final DiagnosticType GOOG_CLASS_TARGET_INVALID = DiagnosticType.error("JSC_GOOG_CLASS_TARGET_INVALID", "Unsupported class definition expression.");
    static final DiagnosticType GOOG_CLASS_SUPER_CLASS_NOT_VALID = DiagnosticType.error("JSC_GOOG_CLASS_SUPER_CLASS_NOT_VALID", "The super class must be null or a valid name reference");
    static final DiagnosticType GOOG_CLASS_DESCRIPTOR_NOT_VALID = DiagnosticType.error("JSC_GOOG_CLASS_DESCRIPTOR_NOT_VALID", "The class descriptor must be an object literal");
    static final DiagnosticType GOOG_CLASS_CONSTRUCTOR_MISSING = DiagnosticType.error("JSC_GOOG_CLASS_CONSTRUCTOR_MISSING", "The constructor expression is missing for the class descriptor");
    static final DiagnosticType GOOG_CLASS_CONSTRUCTOR_ON_INTERFACE = DiagnosticType.error("JSC_GOOG_CLASS_CONSTRUCTOR_ON_INTERFACE", "Should not have a constructor expression for an interface");
    static final DiagnosticType GOOG_CLASS_STATICS_NOT_VALID = DiagnosticType.error("JSC_GOOG_CLASS_STATICS_NOT_VALID", "The class statics descriptor must be an object or function literal");
    static final DiagnosticType GOOG_CLASS_UNEXPECTED_PARAMS = DiagnosticType.error("JSC_GOOG_CLASS_UNEXPECTED_PARAMS", "The class definition has too many arguments.");
    static final DiagnosticType GOOG_CLASS_NG_INJECT_ON_CLASS = DiagnosticType.warning("JSC_GOOG_CLASS_NG_INJECT_ON_CLASS", "@ngInject should be declared on the constructor, not on the class.");
    private final AbstractCompiler compiler;
    static final String VIRTUAL_FILE = "<ClosureRewriteClass.java>";

    public ClosureRewriteClass(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        this.hotSwapScript(root, null);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        NodeTraversal.traverse(this.compiler, scriptRoot, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (n.isCall() && ClosureRewriteClass.isGoogDefineClass(n) && !this.validateUsage(n)) {
            this.compiler.report(JSError.make(n, GOOG_CLASS_TARGET_INVALID, new String[0]));
        }
        this.maybeRewriteClassDefinition(n);
    }

    private boolean validateUsage(Node n) {
        Node parent = n.getParent();
        switch (parent.getType()) {
            case 38: {
                return true;
            }
            case 86: {
                return n == parent.getLastChild() && parent.getParent().isExprResult();
            }
            case 154: {
                return this.isContainedInGoogDefineClass(parent);
            }
        }
        return false;
    }

    private boolean isContainedInGoogDefineClass(Node n) {
        while (n != null) {
            if ((n = n.getParent()).isCall()) {
                if (!ClosureRewriteClass.isGoogDefineClass(n)) continue;
                return true;
            }
            if (n.isObjectLit() || n.isStringKey()) continue;
            break;
        }
        return false;
    }

    private void maybeRewriteClassDefinition(Node n) {
        if (n.isVar()) {
            Node target = n.getFirstChild();
            Node value = target.getFirstChild();
            this.maybeRewriteClassDefinition(n, target, value);
        } else if (NodeUtil.isExprAssign(n)) {
            Node assign = n.getFirstChild();
            Node target = assign.getFirstChild();
            Node value = assign.getLastChild();
            this.maybeRewriteClassDefinition(n, target, value);
        }
    }

    private void maybeRewriteClassDefinition(Node n, Node target, Node value) {
        if (ClosureRewriteClass.isGoogDefineClass(value)) {
            ClassDefinition def;
            if (!target.isQualifiedName()) {
                this.compiler.report(JSError.make(n, GOOG_CLASS_TARGET_INVALID, new String[0]));
            }
            if ((def = this.extractClassDefinition(target, value)) != null) {
                value.detachFromParent();
                target.detachFromParent();
                this.rewriteGoogDefineClass(n, def);
            }
        }
    }

    private ClassDefinition extractClassDefinition(Node targetName, Node callNode) {
        Node description;
        JSDocInfo classInfo = NodeUtil.getBestJSDocInfo(targetName);
        Node superClass = NodeUtil.getArgumentForCallOrNew(callNode, 0);
        if (superClass == null || !superClass.isNull() && !superClass.isQualifiedName()) {
            this.compiler.report(JSError.make(callNode, GOOG_CLASS_SUPER_CLASS_NOT_VALID, new String[0]));
            return null;
        }
        if (NodeUtil.isNullOrUndefined(superClass) || superClass.matchesQualifiedName("Object")) {
            superClass = null;
        }
        if ((description = NodeUtil.getArgumentForCallOrNew(callNode, 1)) == null || !description.isObjectLit() || !ClosureRewriteClass.validateObjLit(description)) {
            this.compiler.report(JSError.make(callNode, GOOG_CLASS_DESCRIPTOR_NOT_VALID, new String[0]));
            return null;
        }
        int paramCount = callNode.getChildCount() - 1;
        if (paramCount > 2) {
            this.compiler.report(JSError.make(callNode, GOOG_CLASS_UNEXPECTED_PARAMS, new String[0]));
            return null;
        }
        Node constructor = ClosureRewriteClass.extractProperty(description, "constructor");
        if (classInfo != null && classInfo.isInterface()) {
            if (constructor != null) {
                this.compiler.report(JSError.make(description, GOOG_CLASS_CONSTRUCTOR_ON_INTERFACE, new String[0]));
                return null;
            }
        } else if (constructor == null) {
            this.compiler.report(JSError.make(description, GOOG_CLASS_CONSTRUCTOR_MISSING, new String[0]));
            return null;
        }
        if (constructor == null) {
            constructor = IR.function(IR.name("").srcref(callNode), IR.paramList().srcref(callNode), IR.block().srcref(callNode));
            constructor.srcref(callNode);
        }
        JSDocInfo info = NodeUtil.getBestJSDocInfo(constructor);
        Node classModifier = null;
        Node statics = null;
        Node staticsProp = ClosureRewriteClass.extractProperty(description, "statics");
        if (staticsProp != null) {
            if (staticsProp.isObjectLit() && ClosureRewriteClass.validateObjLit(staticsProp)) {
                statics = staticsProp;
            } else if (staticsProp.isFunction()) {
                classModifier = staticsProp;
            } else {
                this.compiler.report(JSError.make(staticsProp, GOOG_CLASS_STATICS_NOT_VALID, new String[0]));
                return null;
            }
        }
        if (statics == null) {
            statics = IR.objectlit(new Node[0]);
        }
        ClosureRewriteClass.maybeDetach(constructor.getParent());
        ClosureRewriteClass.maybeDetach(statics.getParent());
        if (classModifier != null) {
            ClosureRewriteClass.maybeDetach(classModifier.getParent());
        }
        ClassDefinition def = new ClassDefinition(targetName, classInfo, ClosureRewriteClass.maybeDetach(superClass), new MemberDefinition(info, null, ClosureRewriteClass.maybeDetach(constructor)), ClosureRewriteClass.objectLitToList(ClosureRewriteClass.maybeDetach(statics)), ClosureRewriteClass.objectLitToList(description), ClosureRewriteClass.maybeDetach(classModifier));
        return def;
    }

    private static Node maybeDetach(Node node) {
        if (node != null && node.getParent() != null) {
            node.detachFromParent();
        }
        return node;
    }

    private static boolean validateObjLit(Node objlit) {
        for (Node key : objlit.children()) {
            if (key.isStringKey() && !key.isQuotedString()) continue;
            return false;
        }
        return true;
    }

    private static Node extractProperty(Node objlit, String keyName) {
        for (Node keyNode : objlit.children()) {
            if (!keyNode.getString().equals(keyName)) continue;
            return keyNode.isStringKey() ? keyNode.getFirstChild() : null;
        }
        return null;
    }

    private static List<MemberDefinition> objectLitToList(Node objlit) {
        ArrayList result = Lists.newArrayList();
        for (Node keyNode : objlit.children()) {
            result.add(new MemberDefinition(NodeUtil.getBestJSDocInfo(keyNode), keyNode, keyNode.removeFirstChild()));
        }
        objlit.detachChildren();
        return result;
    }

    private void rewriteGoogDefineClass(Node exprRoot, final ClassDefinition cls) {
        JSDocInfo mergedClassInfo;
        Node block = IR.block();
        cls.constructor.value.setJSDocInfo(null);
        if (exprRoot.isVar()) {
            Node var = IR.var(cls.name.cloneTree(), cls.constructor.value).srcref(exprRoot);
            mergedClassInfo = this.mergeJsDocFor(cls, var);
            var.setJSDocInfo(mergedClassInfo);
            block.addChildToBack(var);
        } else {
            Node assign = IR.assign(cls.name.cloneTree(), cls.constructor.value).srcref(exprRoot).setJSDocInfo(cls.constructor.info);
            mergedClassInfo = this.mergeJsDocFor(cls, assign);
            assign.setJSDocInfo(mergedClassInfo);
            Node expr = IR.exprResult(assign).srcref(exprRoot);
            block.addChildToBack(expr);
        }
        if (cls.superClass != null) {
            block.addChildToBack(ClosureRewriteClass.fixupSrcref(IR.exprResult(IR.call(NodeUtil.newQName(this.compiler, "goog.inherits").srcrefTree(cls.superClass), cls.name.cloneTree(), cls.superClass.cloneTree()).srcref(cls.superClass))));
        }
        for (MemberDefinition def : cls.staticProps) {
            def.value.setJSDocInfo(null);
            block.addChildToBack(ClosureRewriteClass.fixupSrcref(IR.exprResult(ClosureRewriteClass.fixupSrcref(IR.assign(IR.getprop(cls.name.cloneTree(), IR.string(def.name.getString()).srcref(def.name)).srcref(def.name), def.value)).setJSDocInfo(def.info))));
            this.maybeRewriteClassDefinition(block.getLastChild());
        }
        for (MemberDefinition def : cls.props) {
            def.value.setJSDocInfo(null);
            block.addChildToBack(ClosureRewriteClass.fixupSrcref(IR.exprResult(ClosureRewriteClass.fixupSrcref(IR.assign(IR.getprop(ClosureRewriteClass.fixupSrcref(IR.getprop(cls.name.cloneTree(), IR.string("prototype").srcref(def.name))), IR.string(def.name.getString()).srcref(def.name)).srcref(def.name), def.value)).setJSDocInfo(def.info))));
            this.maybeRewriteClassDefinition(block.getLastChild());
        }
        if (cls.classModifier != null) {
            Node argList = cls.classModifier.getFirstChild().getNext();
            Node arg = argList.getFirstChild();
            final String argName = arg.getString();
            NodeTraversal.traverse(this.compiler, cls.classModifier.getLastChild(), new NodeTraversal.AbstractPostOrderCallback(){

                @Override
                public void visit(NodeTraversal t, Node n, Node parent) {
                    if (n.isName() && n.getString().equals(argName)) {
                        parent.replaceChild(n, cls.name.cloneTree());
                    }
                }
            });
            block.addChildToBack(IR.exprResult(ClosureRewriteClass.fixupFreeCall(IR.call(cls.classModifier, cls.name.cloneTree()).srcref(cls.classModifier))).srcref(cls.classModifier));
        }
        Node parent = exprRoot.getParent();
        Node stmts = block.removeChildren();
        parent.addChildrenAfter(stmts, exprRoot);
        parent.removeChild(exprRoot);
        this.compiler.reportCodeChange();
    }

    private static Node fixupSrcref(Node node) {
        node.srcref(node.getFirstChild());
        return node;
    }

    private static Node fixupFreeCall(Node call) {
        Preconditions.checkState((boolean)call.isCall());
        call.putBooleanProp(50, true);
        return call;
    }

    private static boolean isGoogDefineClass(Node value) {
        if (value != null && value.isCall()) {
            return value.getFirstChild().matchesQualifiedName("goog.defineClass");
        }
        return false;
    }

    private JSDocInfo mergeJsDocFor(ClassDefinition cls, Node associatedNode) {
        boolean isInterface;
        JSDocInfo.Visibility visibility;
        JSDocInfo classInfo = cls.classInfo != null ? cls.classInfo : new JSDocInfo(true);
        JSDocInfo ctorInfo = cls.constructor.info != null ? cls.constructor.info : new JSDocInfo(true);
        Node superNode = cls.superClass;
        JSDocInfoBuilder mergedInfo = cls.constructor.info != null ? JSDocInfoBuilder.copyFrom(ctorInfo) : new JSDocInfoBuilder(true);
        String blockDescription = Joiner.on((String)"\n").skipNulls().join((Object)classInfo.getBlockDescription(), (Object)ctorInfo.getBlockDescription(), new Object[0]);
        if (!blockDescription.isEmpty()) {
            mergedInfo.recordBlockDescription(blockDescription);
        }
        HashSet suppressions = Sets.newHashSet();
        suppressions.addAll(classInfo.getSuppressions());
        suppressions.addAll(ctorInfo.getSuppressions());
        if (!suppressions.isEmpty()) {
            mergedInfo.recordSuppressions(suppressions);
        }
        if (classInfo.isDeprecated()) {
            mergedInfo.recordDeprecated();
        }
        String deprecationReason = null;
        if (classInfo.getDeprecationReason() != null) {
            deprecationReason = classInfo.getDeprecationReason();
            mergedInfo.recordDeprecationReason(deprecationReason);
        }
        if ((visibility = classInfo.getVisibility()) != null && visibility != JSDocInfo.Visibility.INHERITED) {
            mergedInfo.recordVisibility(classInfo.getVisibility());
        }
        if (classInfo.isConstant()) {
            mergedInfo.recordConstancy();
        }
        if (classInfo.isExport()) {
            mergedInfo.recordExport();
        }
        if (classInfo.isNgInject()) {
            this.compiler.report(JSError.make(associatedNode, GOOG_CLASS_NG_INJECT_ON_CLASS, new String[0]));
            mergedInfo.recordNgInject(true);
        }
        boolean bl = isInterface = classInfo.isInterface() || ctorInfo.isInterface();
        if (isInterface) {
            mergedInfo.recordInterface();
            ImmutableList extendedInterfaces = null;
            if (classInfo.getExtendedInterfacesCount() > 0) {
                extendedInterfaces = classInfo.getExtendedInterfaces();
            } else if (ctorInfo.getExtendedInterfacesCount() == 0 && superNode != null) {
                extendedInterfaces = ImmutableList.of((Object)new JSTypeExpression(new Node(306, IR.string(superNode.getQualifiedName())), VIRTUAL_FILE));
            }
            if (extendedInterfaces != null) {
                for (JSTypeExpression extend : extendedInterfaces) {
                    mergedInfo.recordExtendedInterface(extend);
                }
            }
        } else {
            mergedInfo.recordConstructor();
            if (classInfo.makesUnrestricted() || ctorInfo.makesUnrestricted()) {
                mergedInfo.recordUnrestricted();
            } else if (classInfo.makesDicts() || ctorInfo.makesDicts()) {
                mergedInfo.recordDict();
            } else {
                mergedInfo.recordStruct();
            }
            if (superNode != null) {
                JSTypeExpression baseType = new JSTypeExpression(new Node(306, IR.string(superNode.getQualifiedName())), VIRTUAL_FILE);
                mergedInfo.recordBaseType(baseType);
            }
            List<JSTypeExpression> interfaces = classInfo.getImplementedInterfaces();
            for (JSTypeExpression implemented : interfaces) {
                mergedInfo.recordImplementedInterface(implemented);
            }
        }
        ArrayList<String> templateNames = new ArrayList<String>();
        templateNames.addAll((Collection<String>)classInfo.getTemplateTypeNames());
        templateNames.addAll((Collection<String>)ctorInfo.getTemplateTypeNames());
        for (String typeName : templateNames) {
            mergedInfo.recordTemplateTypeName(typeName);
        }
        return mergedInfo.build(associatedNode);
    }

    private static final class ClassDefinition {
        final Node name;
        final JSDocInfo classInfo;
        final Node superClass;
        final MemberDefinition constructor;
        final List<MemberDefinition> staticProps;
        final List<MemberDefinition> props;
        final Node classModifier;

        ClassDefinition(Node name, JSDocInfo classInfo, Node superClass, MemberDefinition constructor, List<MemberDefinition> staticProps, List<MemberDefinition> props, Node classModifier) {
            this.name = name;
            this.classInfo = classInfo;
            this.superClass = superClass;
            this.constructor = constructor;
            this.staticProps = staticProps;
            this.props = props;
            this.classModifier = classModifier;
        }
    }

    private static class MemberDefinition {
        final JSDocInfo info;
        final Node name;
        final Node value;

        MemberDefinition(JSDocInfo info, Node name, Node value) {
            this.info = info;
            this.name = name;
            this.value = value;
        }
    }
}

