/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.fuzzing;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.fuzzing.AbstractFuzzer;
import com.google.javascript.jscomp.fuzzing.BlockFuzzer;
import com.google.javascript.jscomp.fuzzing.ExpressionFuzzer;
import com.google.javascript.jscomp.fuzzing.FuzzingContext;
import com.google.javascript.jscomp.fuzzing.Scope;
import com.google.javascript.jscomp.fuzzing.Type;
import com.google.javascript.rhino.Node;
import java.util.EnumSet;
import java.util.Set;

class WhileFuzzer
extends AbstractFuzzer {
    WhileFuzzer(FuzzingContext context) {
        super(context);
    }

    @Override
    protected boolean isEnough(int budget) {
        return budget >= 3;
    }

    @Override
    protected Node generate(int budget, Set<Type> types) {
        AbstractFuzzer[] fuzzers = new AbstractFuzzer[]{new ExpressionFuzzer(this.context), new BlockFuzzer(this.context)};
        Scope scope = this.context.scopeManager.localScope();
        ++scope.loopNesting;
        Node[] components = this.distribute(budget - 1, fuzzers);
        --scope.loopNesting;
        return new Node(113, components);
    }

    @Override
    protected String getConfigName() {
        return "while";
    }

    @Override
    protected Node fuzz(AbstractFuzzer fuzzer, int budget) {
        if (fuzzer instanceof ExpressionFuzzer) {
            ImmutableSet types = Sets.immutableEnumSet((Iterable)Sets.difference(fuzzer.supportedTypes(), EnumSet.of(Type.UNDEFINED)));
            return fuzzer.generate(budget, (Set<Type>)types);
        }
        return fuzzer.generate(budget);
    }
}

