/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.refactoring;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodePrinter;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.parsing.JsDocInfoParser;
import com.google.javascript.refactoring.CodeReplacement;
import com.google.javascript.refactoring.Match;
import com.google.javascript.refactoring.Matchers;
import com.google.javascript.refactoring.NodeMetadata;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SuggestedFix {
    private final SetMultimap<String, CodeReplacement> replacements;

    private SuggestedFix(SetMultimap<String, CodeReplacement> replacements) {
        this.replacements = replacements;
    }

    public SetMultimap<String, CodeReplacement> getReplacements() {
        return this.replacements;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.replacements.asMap().entrySet()) {
            sb.append("Replacements for file: " + (String)entry.getKey() + "\n");
            Joiner.on((String)"\n").appendTo(sb, (Iterable)entry.getValue());
        }
        return sb.toString();
    }

    public static final class Builder {
        private final ImmutableSetMultimap.Builder<String, CodeReplacement> replacements = ImmutableSetMultimap.builder();

        public Builder insertBefore(Node nodeToInsertBefore, Node n, AbstractCompiler compiler) {
            return this.insertBefore(nodeToInsertBefore, this.generateCode(compiler, n));
        }

        public Builder insertBefore(Node nodeToInsertBefore, String content) {
            JSDocInfo jsDoc;
            int startPosition = nodeToInsertBefore.getSourceOffset();
            JSDocInfo jSDocInfo = jsDoc = nodeToInsertBefore.isExprResult() ? nodeToInsertBefore.getFirstChild().getJSDocInfo() : nodeToInsertBefore.getJSDocInfo();
            if (jsDoc != null) {
                startPosition = jsDoc.getOriginalCommentPosition();
            }
            this.replacements.put((Object)nodeToInsertBefore.getSourceFileName(), (Object)new CodeReplacement(startPosition, 0, content));
            return this;
        }

        public Builder delete(Node n) {
            JSDocInfo jsDoc;
            int startPosition = n.getSourceOffset();
            int length = n.getLength();
            JSDocInfo jSDocInfo = jsDoc = n.isExprResult() ? n.getFirstChild().getJSDocInfo() : n.getJSDocInfo();
            if (jsDoc != null) {
                length = n.getLength() + (startPosition - jsDoc.getOriginalCommentPosition());
                startPosition = jsDoc.getOriginalCommentPosition();
            }
            this.replacements.put((Object)n.getSourceFileName(), (Object)new CodeReplacement(startPosition, length, ""));
            return this;
        }

        public Builder rename(Node n, String name) {
            return this.rename(n, name, false);
        }

        public Builder rename(Node n, String name, boolean replaceEntireName) {
            Node nodeToRename = null;
            if (n.isCall()) {
                Node child;
                nodeToRename = child = n.getFirstChild();
                if (!replaceEntireName && child.isGetProp()) {
                    nodeToRename = child.getLastChild();
                }
            } else if (n.isGetProp()) {
                nodeToRename = n.getLastChild();
                if (replaceEntireName) {
                    while (nodeToRename.getParent().isGetProp()) {
                        nodeToRename = nodeToRename.getParent();
                    }
                }
            } else if (n.isStringKey()) {
                nodeToRename = n;
            } else {
                throw new UnsupportedOperationException("Rename is not implemented for node type: " + n.getType());
            }
            this.replacements.put((Object)nodeToRename.getSourceFileName(), (Object)new CodeReplacement(nodeToRename.getSourceOffset(), nodeToRename.getLength(), name));
            return this;
        }

        public Builder replace(Node original, Node newNode, AbstractCompiler compiler) {
            this.replacements.put((Object)original.getSourceFileName(), (Object)new CodeReplacement(original.getSourceOffset(), original.getLength(), this.generateCode(compiler, newNode)));
            return this;
        }

        public Builder addCast(Node n, AbstractCompiler compiler, String type) {
            this.replacements.put((Object)n.getSourceFileName(), (Object)new CodeReplacement(n.getSourceOffset(), n.getLength(), "/** @type {" + type + "} */ (" + this.generateCode(compiler, n) + ")"));
            return this;
        }

        public Builder removeCast(Node n, AbstractCompiler compiler) {
            Preconditions.checkArgument((boolean)n.isCast());
            JSDocInfo jsDoc = n.getJSDocInfo();
            Node child = n.getFirstChild();
            this.replacements.put((Object)n.getSourceFileName(), (Object)new CodeReplacement(jsDoc.getOriginalCommentPosition(), n.getSourceOffset() + n.getLength() - jsDoc.getOriginalCommentPosition(), this.generateCode(compiler, child)));
            return this;
        }

        public Builder addOrReplaceJsDoc(Node n, String newJsDoc) {
            int startPosition = n.getSourceOffset();
            int length = 0;
            JSDocInfo jsDoc = NodeUtil.getBestJSDocInfo(n);
            if (jsDoc != null) {
                startPosition = jsDoc.getOriginalCommentPosition();
                length = n.getSourceOffset() - jsDoc.getOriginalCommentPosition();
            }
            this.replacements.put((Object)n.getSourceFileName(), (Object)new CodeReplacement(startPosition, length, newJsDoc));
            return this;
        }

        public Builder changeJsDocType(Node n, AbstractCompiler compiler, String type) {
            JSDocInfo info = NodeUtil.getBestJSDocInfo(n);
            Preconditions.checkNotNull((Object)info, (String)"Node %s does not have JS Doc associated with it.", (Object[])new Object[]{n});
            Node typeNode = JsDocInfoParser.parseTypeString(type);
            Preconditions.checkNotNull((Object)typeNode, (String)"Invalid type: %s", (Object[])new Object[]{type});
            JSTypeExpression typeExpr = new JSTypeExpression(typeNode, "jsflume");
            JSType newJsType = typeExpr.evaluate(null, compiler.getTypeRegistry());
            if (newJsType == null) {
                throw new RuntimeException("JS Compiler does not recognize type: " + type);
            }
            String originalComment = info.getOriginalCommentString();
            int originalPosition = info.getOriginalCommentPosition();
            Pattern typeDocPattern = Pattern.compile("@(type|private|protected|public|const|return) *\\{?[^\\s}]+\\}?");
            Matcher m = typeDocPattern.matcher(originalComment);
            while (m.find()) {
                this.replacements.put((Object)n.getSourceFileName(), (Object)new CodeReplacement(originalPosition + m.start(), m.end() - m.start(), "@" + m.group(1) + " {" + type + "}"));
            }
            return this;
        }

        public Builder insertArguments(Node n, int position, String ... args) {
            int startPosition;
            int i;
            Preconditions.checkArgument((boolean)n.isCall(), (Object)"insertArguments is only applicable to function call nodes.");
            Node argument = n.getFirstChild().getNext();
            for (i = 0; argument != null && i < position; argument = argument.getNext(), ++i) {
            }
            if (argument == null) {
                Preconditions.checkArgument((position == i ? 1 : 0) != 0, (Object)"The specified position must be less than the number of arguments.");
                startPosition = n.getSourceOffset() + n.getLength() - 1;
            } else {
                startPosition = argument.getSourceOffset();
            }
            String newContent = Joiner.on((String)", ").join((Object[])args);
            if (argument != null) {
                newContent = newContent + ", ";
            } else if (i > 0) {
                newContent = ", " + newContent;
            }
            this.replacements.put((Object)n.getSourceFileName(), (Object)new CodeReplacement(startPosition, 0, newContent));
            return this;
        }

        public Builder addGoogRequire(Match m, String namespace) {
            Node script;
            Node node = m.getNode();
            NodeMetadata metadata = m.getMetadata();
            Node existingNode = this.findGoogRequireNode(m.getNode(), metadata, namespace);
            if (existingNode != null) {
                return this;
            }
            Node googRequireNode = IR.exprResult(IR.call(IR.getprop(IR.name("goog"), IR.string("require")), IR.string(namespace)));
            for (script = node.getParent(); script != null && !script.isScript(); script = script.getParent()) {
            }
            if (script == null) {
                return this;
            }
            Node lastGoogProvideNode = null;
            Node lastGoogRequireNode = null;
            Node nodeToInsertBefore = null;
            for (Node child = script.getFirstChild(); child != null; child = child.getNext()) {
                if (!child.isExprResult() || !child.getFirstChild().isCall()) continue;
                Node grandchild = child.getFirstChild();
                if (Matchers.functionCall("goog.provide").matches(grandchild, metadata)) {
                    lastGoogProvideNode = grandchild;
                    continue;
                }
                if (!Matchers.functionCall("goog.require").matches(grandchild, metadata)) continue;
                lastGoogRequireNode = grandchild;
                if (!grandchild.getLastChild().isString() || namespace.compareTo(grandchild.getLastChild().getString()) >= 0) continue;
                nodeToInsertBefore = child;
                break;
            }
            if (nodeToInsertBefore == null) {
                if (lastGoogProvideNode != null || lastGoogRequireNode != null) {
                    Node nodeToInsertAfter = lastGoogRequireNode != null ? lastGoogRequireNode : lastGoogProvideNode;
                    int startPosition = nodeToInsertAfter.getSourceOffset() + nodeToInsertAfter.getLength() + 2;
                    this.replacements.put((Object)nodeToInsertAfter.getSourceFileName(), (Object)new CodeReplacement(startPosition, 0, this.generateCode(m.getMetadata().getCompiler(), googRequireNode)));
                    return this;
                }
                if (script.getFirstChild() != null) {
                    nodeToInsertBefore = script.getFirstChild();
                } else {
                    this.replacements.put((Object)script.getSourceFileName(), (Object)new CodeReplacement(0, 0, this.generateCode(m.getMetadata().getCompiler(), googRequireNode)));
                    return this;
                }
            }
            return this.insertBefore(nodeToInsertBefore, googRequireNode, m.getMetadata().getCompiler());
        }

        public Builder removeGoogRequire(Match m, String namespace) {
            Node googRequireNode = this.findGoogRequireNode(m.getNode(), m.getMetadata(), namespace);
            if (googRequireNode != null) {
                return this.delete(googRequireNode);
            }
            return this;
        }

        private Node findGoogRequireNode(Node n, NodeMetadata metadata, String namespace) {
            Node script;
            for (script = n.getParent(); script != null && !script.isScript(); script = script.getParent()) {
            }
            if (script != null) {
                for (Node child = script.getFirstChild(); child != null; child = child.getNext()) {
                    if (!child.isExprResult() || !child.getFirstChild().isCall()) continue;
                    Node grandchild = child.getFirstChild();
                    if (!Matchers.functionCall("goog.require").matches(child.getFirstChild(), metadata) || !grandchild.getLastChild().isString() || !namespace.equals(grandchild.getLastChild().getString())) continue;
                    return child;
                }
            }
            return null;
        }

        public String generateCode(AbstractCompiler compiler, Node node) {
            CompilerOptions compilerOptions = new CompilerOptions();
            compilerOptions.setPreferSingleQuotes(true);
            compilerOptions.setLineLengthThreshold(80);
            return new CodePrinter.Builder(node).setCompilerOptions(compilerOptions).setTypeRegistry(compiler.getTypeRegistry()).setPrettyPrint(true).setLineBreak(true).setOutputTypes(true).build();
        }

        public SuggestedFix build() {
            return new SuggestedFix((SetMultimap)this.replacements.build());
        }
    }
}

