/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.Es6ToEs3Converter;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;

public class Es6ConvertSuper
implements NodeTraversal.Callback,
HotSwapCompilerPass {
    static final DiagnosticType NO_SUPERTYPE = DiagnosticType.error("JSC_NO_SUPERTYPE", "The super keyword may only appear in classes with an extends clause.");
    private final AbstractCompiler compiler;

    public Es6ConvertSuper(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    private void checkClassSuperReferences(Node classNode) {
        Node className = classNode.getFirstChild();
        Node superClassName = className.getNext();
        if (NodeUtil.referencesSuper(classNode) && superClassName.isEmpty()) {
            this.compiler.report(JSError.make(classNode, NO_SUPERTYPE, new String[0]));
        }
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        if (n.isClass()) {
            boolean hasConstructor = false;
            for (Node member = n.getLastChild().getFirstChild(); member != null; member = member.getNext()) {
                if (member.isGetterDef() || member.isSetterDef() || member.getBooleanProp(73) || member.getBooleanProp(74)) {
                    this.compiler.report(JSError.make(member, Es6ToEs3Converter.CANNOT_CONVERT, "getters or setters in class definitions"));
                    return false;
                }
                if (!member.isMemberDef() || !member.getString().equals("constructor")) continue;
                hasConstructor = true;
            }
            if (!hasConstructor) {
                this.addSyntheticConstructor(n);
            }
            this.checkClassSuperReferences(n);
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (n.isSuper()) {
            this.visitSuper(n, parent);
        }
    }

    private void addSyntheticConstructor(Node classNode) {
        Node memberDef;
        Node superClass = classNode.getFirstChild().getNext();
        Node classMembers = classNode.getLastChild();
        if (superClass.isEmpty()) {
            memberDef = IR.memberDef("constructor", IR.function(IR.name(""), IR.paramList(), IR.block()));
        } else {
            Node paramList = IR.paramList(IR.rest("args"));
            Node body = IR.block(IR.exprResult(IR.call(IR.superNode(), IR.spread(IR.name("args")))));
            Node constructor = IR.function(IR.name(""), paramList, body);
            memberDef = IR.memberDef("constructor", constructor);
        }
        memberDef.useSourceInfoIfMissingFromForTree(classNode);
        classMembers.addChildToFront(memberDef);
    }

    private void visitSuper(Node node, Node parent) {
        Node enclosing = parent;
        Node potentialCallee = node;
        if (!parent.isCall()) {
            enclosing = parent.getParent();
            potentialCallee = parent;
        }
        if (!enclosing.isCall() || enclosing.getFirstChild() != potentialCallee) {
            this.compiler.report(JSError.make(node, Es6ToEs3Converter.CANNOT_CONVERT_YET, "Only calls to super or to a method of super are supported."));
            return;
        }
        Node clazz = NodeUtil.getEnclosingClass(node);
        if (clazz == null) {
            this.compiler.report(JSError.make(node, NO_SUPERTYPE, new String[0]));
            return;
        }
        if (NodeUtil.getClassNameNode(clazz) == null) {
            return;
        }
        Node enclosingMemberDef = NodeUtil.getEnclosingClassMember(node);
        if (enclosingMemberDef.isStaticMember()) {
            Node superName = clazz.getFirstChild().getNext();
            if (!superName.isQualifiedName()) {
                return;
            }
            potentialCallee.detachFromParent();
            if (potentialCallee == node) {
                potentialCallee = IR.getprop(superName.cloneTree(), IR.string(enclosingMemberDef.getString()));
                enclosing.putBooleanProp(50, false);
            } else {
                potentialCallee.replaceChild(node, superName.cloneTree());
            }
            Node callTarget = IR.getprop(potentialCallee, IR.string("call"));
            enclosing.addChildToFront(callTarget);
            enclosing.addChildAfter(IR.thisNode(), callTarget);
            enclosing.useSourceInfoIfMissingFromForTree(enclosing);
            this.compiler.reportCodeChange();
            return;
        }
        Node callName = enclosing.removeFirstChild();
        String methodName = callName.isSuper() ? enclosingMemberDef.getString() : callName.getLastChild().getString();
        Node baseCall = this.baseCall(clazz, methodName, enclosing.removeChildren()).useSourceInfoIfMissingFromForTree(enclosing);
        enclosing.getParent().replaceChild(enclosing, baseCall);
        this.compiler.reportCodeChange();
    }

    private Node baseCall(Node clazz, String methodName, Node arguments) {
        boolean useUnique = NodeUtil.isStatement(clazz) && !NodeUtil.isInFunction(clazz);
        String uniqueClassString = useUnique ? Es6ToEs3Converter.getUniqueClassName(NodeUtil.getClassName(clazz)) : NodeUtil.getClassName(clazz);
        Node uniqueClassName = NodeUtil.newQName(this.compiler, uniqueClassString);
        Node base = IR.getprop(uniqueClassName, IR.string("base"));
        Node call = IR.call(base, IR.thisNode(), IR.string(methodName));
        if (arguments != null) {
            call.addChildrenToBack(arguments);
        }
        return call;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        NodeTraversal.traverse(this.compiler, scriptRoot, this);
    }
}

