/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NewTypeInference;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.RhinoErrorReporter;
import com.google.javascript.jscomp.TypeCheck;
import com.google.javascript.jscomp.TypeValidator;
import com.google.javascript.jscomp.newtypes.DeclaredFunctionType;
import com.google.javascript.jscomp.newtypes.DeclaredTypeRegistry;
import com.google.javascript.jscomp.newtypes.EnumType;
import com.google.javascript.jscomp.newtypes.FunctionType;
import com.google.javascript.jscomp.newtypes.FunctionTypeBuilder;
import com.google.javascript.jscomp.newtypes.JSType;
import com.google.javascript.jscomp.newtypes.JSTypeCreatorFromJSDoc;
import com.google.javascript.jscomp.newtypes.JSTypes;
import com.google.javascript.jscomp.newtypes.Namespace;
import com.google.javascript.jscomp.newtypes.NamespaceLit;
import com.google.javascript.jscomp.newtypes.NominalType;
import com.google.javascript.jscomp.newtypes.QualifiedName;
import com.google.javascript.jscomp.newtypes.Typedef;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

class GlobalTypeInfo
implements CompilerPass {
    static final DiagnosticType DUPLICATE_JSDOC = DiagnosticType.warning("JSC_DUPLICATE_JSDOC", "Found two JsDoc comments for variable: {0}.\n");
    static final DiagnosticType REDECLARED_PROPERTY = DiagnosticType.warning("JSC_REDECLARED_PROPERTY", "Found two declarations for property {0} of type {1}.\n");
    static final DiagnosticType INVALID_PROP_OVERRIDE = DiagnosticType.warning("JSC_INVALID_PROP_OVERRIDE", "Invalid redeclaration of property {0}.\ninherited type  : {1}\noverriding type : {2}\n");
    static final DiagnosticType EXTENDS_NOT_ON_CTOR_OR_INTERF = DiagnosticType.warning("JSC_EXTENDS_NOT_ON_CTOR_OR_INTERF", "@extends used without @constructor or @interface for {0}.\n");
    static final DiagnosticType EXTENDS_NON_OBJECT = DiagnosticType.warning("JSC_EXTENDS_NON_OBJECT", "{0} extends non-object type {1}.\n");
    static final DiagnosticType CTOR_IN_DIFFERENT_SCOPE = DiagnosticType.warning("JSC_CTOR_IN_DIFFERENT_SCOPE", "Modifying the prototype is only allowed if the constructor is in the same scope\n");
    static final DiagnosticType UNRECOGNIZED_TYPE_NAME = DiagnosticType.warning("JSC_UNRECOGNIZED_TYPE_NAME", "Type annotation references non-existent type {0}.");
    static final DiagnosticType INHERITANCE_CYCLE = DiagnosticType.warning("JSC_INHERITANCE_CYCLE", "Cycle detected in inheritance chain of type {0}");
    static final DiagnosticType DICT_IMPLEMENTS_INTERF = DiagnosticType.warning("JSC_DICT_IMPLEMENTS_INTERF", "Class {0} is a dict. Dicts can't implement interfaces.");
    static final DiagnosticType STRUCTDICT_WITHOUT_CTOR = DiagnosticType.warning("JSC_STRUCTDICT_WITHOUT_CTOR", "{0} used without @constructor.");
    static final DiagnosticType EXPECTED_CONSTRUCTOR = DiagnosticType.warning("JSC_EXPECTED_CONSTRUCTOR", "Expected constructor name but found {0}.");
    static final DiagnosticType EXPECTED_INTERFACE = DiagnosticType.warning("JSC_EXPECTED_INTERFACE", "Expected interface name but found {0}.");
    static final DiagnosticType INEXISTENT_PARAM = DiagnosticType.warning("JSC_INEXISTENT_PARAM", "parameter {0} does not appear in {1}''s parameter list");
    static final DiagnosticType IMPLEMENTS_WITHOUT_CONSTRUCTOR = DiagnosticType.warning("JSC_IMPLEMENTS_WITHOUT_CONSTRUCTOR", "@implements used without @constructor or @interface for {0}");
    static final DiagnosticType CONST_WITHOUT_INITIALIZER = DiagnosticType.warning("JSC_CONST_WITHOUT_INITIALIZER", "Constants must be initialized when they are defined.");
    static final DiagnosticType COULD_NOT_INFER_CONST_TYPE = DiagnosticType.warning("JSC_COULD_NOT_INFER_CONST_TYPE", "All constants must be typed. The compiler could not infer the type of this constant. Please use an explicit type annotation.");
    static final DiagnosticType MISPLACED_CONST_ANNOTATION = DiagnosticType.warning("JSC_MISPLACED_CONST_ANNOTATION", "This property cannot be @const. The @const annotation is only allowed for properties of namespaces, prototype properties, static properties of constructors, and properties of the form this.prop declared inside constructors.");
    static final DiagnosticType CANNOT_OVERRIDE_FINAL_METHOD = DiagnosticType.warning("JSC_CANNOT_OVERRIDE_FINAL_METHOD", "Final method {0} cannot be overriden.");
    static final DiagnosticType CANNOT_INIT_TYPEDEF = DiagnosticType.warning("JSC_CANNOT_INIT_TYPEDEF", "A typedef variable represents a type name; it cannot be assigned a value.");
    static final DiagnosticType ANONYMOUS_NOMINAL_TYPE = DiagnosticType.warning("JSC_ANONYMOUS_NOMINAL_TYPE", "Must specify a name when defining a class or interface.");
    static final DiagnosticType MALFORMED_ENUM = DiagnosticType.warning("JSC_MALFORMED_ENUM", "An enum must be initialized to a non-empty object literal.");
    static final DiagnosticType DUPLICATE_PROP_IN_ENUM = DiagnosticType.warning("JSC_DUPLICATE_PROP_IN_ENUM", "Property {0} appears twice in the enum declaration.");
    static final DiagnosticType UNDECLARED_NAMESPACE = DiagnosticType.warning("JSC_UNDECLARED_NAMESPACE", "Undeclared reference to {0}.");
    static final DiagnosticType LENDS_ON_BAD_TYPE = DiagnosticType.warning("JSC_LENDS_ON_BAD_TYPE", "May only lend properties to namespaces, constructors and their prototypes. Found {0}.");
    static final DiagnosticGroup ALL_DIAGNOSTICS = new DiagnosticGroup(ANONYMOUS_NOMINAL_TYPE, CANNOT_INIT_TYPEDEF, CANNOT_OVERRIDE_FINAL_METHOD, CONST_WITHOUT_INITIALIZER, COULD_NOT_INFER_CONST_TYPE, CTOR_IN_DIFFERENT_SCOPE, DICT_IMPLEMENTS_INTERF, DUPLICATE_JSDOC, DUPLICATE_PROP_IN_ENUM, EXPECTED_CONSTRUCTOR, EXPECTED_INTERFACE, EXTENDS_NON_OBJECT, EXTENDS_NOT_ON_CTOR_OR_INTERF, REDECLARED_PROPERTY, IMPLEMENTS_WITHOUT_CONSTRUCTOR, INEXISTENT_PARAM, INHERITANCE_CYCLE, INVALID_PROP_OVERRIDE, LENDS_ON_BAD_TYPE, MALFORMED_ENUM, MISPLACED_CONST_ANNOTATION, STRUCTDICT_WITHOUT_CTOR, UNDECLARED_NAMESPACE, UNRECOGNIZED_TYPE_NAME, RhinoErrorReporter.BAD_JSDOC_ANNOTATION, TypeCheck.CONFLICTING_EXTENDED_TYPE, TypeCheck.CONFLICTING_IMPLEMENTED_TYPE, TypeCheck.CONFLICTING_SHAPE_TYPE, TypeCheck.ENUM_NOT_CONSTANT, TypeCheck.INCOMPATIBLE_EXTENDED_PROPERTY_TYPE, TypeCheck.MULTIPLE_VAR_DEF, TypeCheck.UNKNOWN_OVERRIDE, TypeValidator.INTERFACE_METHOD_NOT_IMPLEMENTED);
    private final List<Scope> scopes = new ArrayList<Scope>();
    private Scope globalScope;
    private NewTypeInference.WarningReporter warnings;
    private JSTypeCreatorFromJSDoc typeParser;
    private final AbstractCompiler compiler;
    private final CodingConvention convention;
    private final Map<Node, String> anonFunNames = new HashMap<Node, String>();
    private static final String ANON_FUN_PREFIX = "%anon_fun";
    private int freshId = 1;
    private Map<Node, NominalType.RawNominalType> nominaltypesByNode = new HashMap<Node, NominalType.RawNominalType>();
    private HashBasedTable<NominalType.RawNominalType, String, PropertyDef> propertyDefs = HashBasedTable.create();
    private Map<Node, JSType> castTypes = new HashMap<Node, JSType>();
    private Map<Node, JSType> declaredObjLitProps = new HashMap<Node, JSType>();
    private JSTypes commonTypes;

    GlobalTypeInfo(AbstractCompiler compiler) {
        this.warnings = new NewTypeInference.WarningReporter(compiler);
        this.compiler = compiler;
        this.convention = compiler.getCodingConvention();
        this.typeParser = new JSTypeCreatorFromJSDoc(this.convention);
        this.commonTypes = JSTypes.make();
    }

    Collection<Scope> getScopes() {
        return this.scopes;
    }

    JSTypes getTypesUtilObject() {
        return this.commonTypes;
    }

    JSType getCastType(Node n) {
        JSType t = this.castTypes.get(n);
        Preconditions.checkNotNull((Object)t);
        return t;
    }

    JSType getPropDeclaredType(Node n) {
        return this.declaredObjLitProps.get(n);
    }

    String getFunInternalName(Node n) {
        Preconditions.checkArgument((boolean)n.isFunction());
        if (this.anonFunNames.containsKey(n)) {
            return this.anonFunNames.get(n);
        }
        Node fnNameNode = NodeUtil.getFunctionNameNode(n);
        Preconditions.checkState((fnNameNode != null ? 1 : 0) != 0);
        Preconditions.checkState((boolean)fnNameNode.isName());
        return fnNameNode.getString();
    }

    @Override
    public void process(Node externs, Node root) {
        Preconditions.checkArgument((externs == null || externs.isSyntheticBlock() ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)root.isSyntheticBlock());
        this.globalScope = new Scope(root, null, (List)ImmutableList.of(), this.commonTypes);
        this.scopes.add(this.globalScope);
        CollectNamedTypes rootCnt = new CollectNamedTypes(this.globalScope);
        if (externs != null) {
            new NodeTraversal(this.compiler, rootCnt).traverse(externs);
        }
        new NodeTraversal(this.compiler, rootCnt).traverse(root);
        this.globalScope.resolveTypedefs(this.typeParser);
        this.globalScope.resolveEnums(this.typeParser);
        for (int i = 1; i < this.scopes.size(); ++i) {
            Scope s = this.scopes.get(i);
            CollectNamedTypes cnt = new CollectNamedTypes(s);
            new NodeTraversal(this.compiler, cnt).traverse(s.getBody());
            s.resolveTypedefs(this.typeParser);
            s.resolveEnums(this.typeParser);
            if (!NewTypeInference.measureMem) continue;
            NewTypeInference.updatePeakMem();
        }
        ProcessScope rootPs = new ProcessScope(this.globalScope);
        if (externs != null) {
            new NodeTraversal(this.compiler, rootPs).traverse(externs);
        }
        new NodeTraversal(this.compiler, rootPs).traverse(root);
        rootPs.finishProcessingScope();
        for (int i = 1; i < this.scopes.size(); ++i) {
            Scope s = this.scopes.get(i);
            ProcessScope ps = new ProcessScope(s);
            new NodeTraversal(this.compiler, ps).traverse(s.getBody());
            ps.finishProcessingScope();
            if (!NewTypeInference.measureMem) continue;
            NewTypeInference.updatePeakMem();
        }
        this.reportInheritanceErrors();
        this.nominaltypesByNode = null;
        this.propertyDefs = null;
        for (Scope s : this.scopes) {
            s.removeTmpData();
        }
        Map<Node, String> unknownTypes = this.typeParser.getUnknownTypesMap();
        for (Map.Entry<Node, String> unknownTypeEntry : unknownTypes.entrySet()) {
            this.warnings.add(JSError.make(unknownTypeEntry.getKey(), UNRECOGNIZED_TYPE_NAME, unknownTypeEntry.getValue()));
        }
        for (JSError warning : this.typeParser.getWarnings()) {
            this.warnings.add(warning);
        }
        this.typeParser = null;
        this.compiler.setSymbolTable(this);
        this.warnings = null;
        Collections.reverse(this.scopes);
    }

    private Collection<PropertyDef> getPropDefsFromInterface(NominalType nominalType, String pname) {
        Preconditions.checkArgument((boolean)nominalType.isFinalized());
        Preconditions.checkArgument((boolean)nominalType.isInterface());
        if (nominalType.getPropDeclaredType(pname) == null) {
            return ImmutableSet.of();
        }
        if (this.propertyDefs.get((Object)nominalType.getId(), (Object)pname) != null) {
            return ImmutableSet.of((Object)this.propertyDefs.get((Object)nominalType.getId(), (Object)pname));
        }
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (NominalType interf : nominalType.getInstantiatedInterfaces()) {
            result.addAll(this.getPropDefsFromInterface(interf, pname));
        }
        return result.build();
    }

    private PropertyDef getPropDefFromClass(NominalType nominalType, String pname) {
        while (nominalType.getPropDeclaredType(pname) != null) {
            Preconditions.checkArgument((boolean)nominalType.isFinalized());
            Preconditions.checkArgument((boolean)nominalType.isClass());
            if (this.propertyDefs.get((Object)nominalType.getId(), (Object)pname) != null) {
                return (PropertyDef)this.propertyDefs.get((Object)nominalType.getId(), (Object)pname);
            }
            nominalType = nominalType.getInstantiatedSuperclass();
        }
        return null;
    }

    private void reportInheritanceErrors() {
        LinkedList<Node> workset = new LinkedList<Node>(this.nominaltypesByNode.keySet());
        int iterations = 0;
        int MAX_ITERATIONS = 50000;
        block0: while (!workset.isEmpty()) {
            Preconditions.checkState((iterations < 50000 ? 1 : 0) != 0);
            Node funNode = (Node)workset.removeFirst();
            NominalType.RawNominalType rawNominalType = this.nominaltypesByNode.get(funNode);
            NominalType superClass = rawNominalType.getSuperClass();
            Set<String> nonInheritedPropNames = rawNominalType.getAllOwnProps();
            if (superClass != null && !superClass.isFinalized()) {
                workset.addLast(funNode);
                ++iterations;
                continue;
            }
            for (NominalType superInterf : rawNominalType.getInterfaces()) {
                if (superInterf.isFinalized()) continue;
                workset.addLast(funNode);
                ++iterations;
                continue block0;
            }
            HashMultimap propMethodTypesToProcess = HashMultimap.create();
            HashMultimap propTypesToProcess = HashMultimap.create();
            if (superClass != null) {
                Preconditions.checkState((boolean)superClass.isFinalized());
                for (String pname : superClass.getAllPropsOfClass()) {
                    nonInheritedPropNames.remove(pname);
                    this.checkSuperProperty(rawNominalType, superClass, pname, (Multimap<String, DeclaredFunctionType>)propMethodTypesToProcess, (Multimap<String, JSType>)propTypesToProcess);
                }
            }
            for (NominalType superInterf : rawNominalType.getInterfaces()) {
                Preconditions.checkState((boolean)superInterf.isFinalized());
                for (String pname : superInterf.getAllPropsOfInterface()) {
                    nonInheritedPropNames.remove(pname);
                    this.checkSuperProperty(rawNominalType, superInterf, pname, (Multimap<String, DeclaredFunctionType>)propMethodTypesToProcess, (Multimap<String, JSType>)propTypesToProcess);
                }
            }
            for (String pname : propMethodTypesToProcess.keySet()) {
                Collection methodTypes = propMethodTypesToProcess.get((Object)pname);
                Preconditions.checkState((!methodTypes.isEmpty() ? 1 : 0) != 0);
                PropertyDef localPropDef = (PropertyDef)this.propertyDefs.get((Object)rawNominalType, (Object)pname);
                DeclaredFunctionType superMethodType = DeclaredFunctionType.meet(methodTypes);
                DeclaredFunctionType updatedMethodType = localPropDef.methodType.withTypeInfoFromSuper(superMethodType);
                localPropDef.updateMethodType(updatedMethodType);
                propTypesToProcess.put((Object)pname, (Object)this.commonTypes.fromFunctionType(updatedMethodType.toFunctionType()));
            }
            block6: for (String pname : propTypesToProcess.keySet()) {
                Collection defs = propTypesToProcess.get((Object)pname);
                Preconditions.checkState((!defs.isEmpty() ? 1 : 0) != 0);
                JSType resultType = JSType.TOP;
                for (JSType inheritedType : defs) {
                    if (!(resultType = JSType.meet(resultType, inheritedType)).isBottom()) {
                        resultType = inheritedType;
                        continue;
                    }
                    this.warnings.add(JSError.make(funNode, TypeCheck.INCOMPATIBLE_EXTENDED_PROPERTY_TYPE, NodeUtil.getFunctionName(funNode), pname, "", ""));
                    continue block6;
                }
                rawNominalType.addProtoProperty(pname, resultType, false);
            }
            for (String pname : nonInheritedPropNames) {
                Node defSite = ((PropertyDef)this.propertyDefs.get((Object)rawNominalType, (Object)pname)).defSite;
                JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(defSite);
                if (jsdoc == null || !jsdoc.isOverride()) continue;
                this.warnings.add(JSError.make(defSite, TypeCheck.UNKNOWN_OVERRIDE, pname, rawNominalType.getName()));
            }
            rawNominalType.finalizeNominalType();
        }
    }

    private void checkSuperProperty(NominalType.RawNominalType current, NominalType superType, String pname, Multimap<String, DeclaredFunctionType> propMethodTypesToProcess, Multimap<String, JSType> propTypesToProcess) {
        JSType localPropType;
        JSType inheritedPropType = superType.getPropDeclaredType(pname);
        if (inheritedPropType == null) {
            return;
        }
        ImmutableSet inheritedPropDefs = superType.isInterface() ? this.getPropDefsFromInterface(superType, pname) : ImmutableSet.of((Object)this.getPropDefFromClass(superType, pname));
        if (superType.isInterface() && current.isClass() && !current.mayHaveProp(pname)) {
            this.warnings.add(JSError.make(((PropertyDef)inheritedPropDefs.iterator().next()).defSite, TypeValidator.INTERFACE_METHOD_NOT_IMPLEMENTED, pname, superType.toString(), current.toString()));
            return;
        }
        PropertyDef localPropDef = (PropertyDef)this.propertyDefs.get((Object)current, (Object)pname);
        JSType jSType = localPropType = localPropDef == null ? null : current.getInstancePropDeclaredType(pname);
        if (localPropDef != null && superType.isClass() && localPropType.getFunType() != null && superType.hasConstantProp(pname)) {
            this.warnings.add(JSError.make(localPropDef.defSite, CANNOT_OVERRIDE_FINAL_METHOD, pname));
            return;
        }
        if (localPropType == null) {
            propTypesToProcess.put((Object)pname, (Object)inheritedPropType);
        } else if (!localPropType.isSubtypeOf(inheritedPropType)) {
            this.warnings.add(JSError.make(localPropDef.defSite, INVALID_PROP_OVERRIDE, pname, inheritedPropType.toString(), localPropType.toString()));
        } else if (localPropDef.methodType != null) {
            for (PropertyDef inheritedPropDef : inheritedPropDefs) {
                if (inheritedPropDef.methodType == null) continue;
                propMethodTypesToProcess.put((Object)pname, (Object)inheritedPropDef.methodType);
            }
        }
    }

    private JSType getTypeDeclarationFromJsdoc(JSDocInfo jsdoc, Scope s) {
        return this.typeParser.getNodeTypeDeclaration(jsdoc, null, s);
    }

    private FunctionType getDeclaredFunctionTypeOfCalleeIfAny(Node fn, Scope currentScope) {
        Preconditions.checkArgument((boolean)fn.getParent().isCall());
        if (!(fn.isFunction() || fn.isQualifiedName() && !fn.isThis())) {
            return null;
        }
        if (fn.isFunction()) {
            return currentScope.getScope(this.getFunInternalName(fn)).getDeclaredType().toFunctionType();
        }
        if (fn.isName()) {
            JSType type = currentScope.getDeclaredTypeOf(fn.getString());
            return type == null ? null : type.getFunType();
        }
        Preconditions.checkState((boolean)fn.isGetProp());
        Node recv = fn.getFirstChild();
        QualifiedName recvQname = QualifiedName.fromNode(recv);
        Preconditions.checkNotNull((Object)recvQname);
        if (!currentScope.isNamespace(recvQname)) {
            return null;
        }
        JSType type = currentScope.getNamespace(recvQname).getPropDeclaredType(fn.getLastChild().getString());
        return type == null ? null : type.getFunType();
    }

    private static boolean isClassPropAccess(Node n, Scope s) {
        return n.isGetProp() && n.getFirstChild().isThis() && (s.isConstructor() || s.isPrototypeMethod());
    }

    private static boolean isPropertyDeclaration(Node getProp) {
        Preconditions.checkArgument((boolean)getProp.isGetProp());
        Node parent = getProp.getParent();
        return parent.isExprResult() || parent.isAssign() && parent.getParent().isExprResult();
    }

    private static boolean isPrototypeProperty(Node getProp) {
        if (!getProp.isGetProp()) {
            return false;
        }
        Node recv = getProp.getFirstChild();
        return recv.isGetProp() && recv.getLastChild().getString().equals("prototype");
    }

    private static boolean isPrototypePropertyDeclaration(Node n) {
        return NodeUtil.isExprAssign(n) && GlobalTypeInfo.isPrototypeProperty(n.getFirstChild().getFirstChild());
    }

    private static boolean isAnnotatedAsConst(Node defSite) {
        return NodeUtil.hasConstAnnotation(defSite) && !NodeUtil.getBestJSDocInfo(defSite).isConstructor();
    }

    private static Node fromDefsiteToName(Node defSite) {
        if (defSite.isVar()) {
            return defSite.getFirstChild();
        }
        if (defSite.isGetProp()) {
            return defSite.getLastChild();
        }
        if (defSite.isStringKey()) {
            return defSite;
        }
        throw new RuntimeException("Unknown defsite: " + Token.name(defSite.getType()));
    }

    private boolean isConst(Node defSite) {
        return GlobalTypeInfo.isAnnotatedAsConst(defSite) || NodeUtil.isConstantByConvention(this.convention, GlobalTypeInfo.fromDefsiteToName(defSite));
    }

    static class Scope
    implements DeclaredTypeRegistry {
        private final Scope parent;
        private final Node root;
        private final String name;
        private final JSTypes commonTypes;
        private final Map<String, JSType> locals = new HashMap<String, JSType>();
        private final Map<String, JSType> externs;
        private final Set<String> constVars = new HashSet<String>();
        private final List<String> formals;
        private final Set<String> outerVars = new HashSet<String>();
        private final Map<String, Scope> localFunDefs = new HashMap<String, Scope>();
        private Set<String> unknownTypeNames = new HashSet<String>();
        private Map<String, NominalType.RawNominalType> localClassDefs = new HashMap<String, NominalType.RawNominalType>();
        private Map<String, Typedef> localTypedefs = new HashMap<String, Typedef>();
        private Map<String, EnumType> localEnums = new HashMap<String, EnumType>();
        private Map<String, NamespaceLit> localNamespaces = new HashMap<String, NamespaceLit>();
        private Set<EnumType> qualifiedEnums = new HashSet<EnumType>();
        private DeclaredFunctionType declaredType;

        private Scope(Node root, Scope parent, List<String> formals, JSTypes commonTypes) {
            if (parent == null) {
                this.name = null;
                this.externs = new HashMap<String, JSType>();
            } else {
                String nameOnAst = root.getFirstChild().getString();
                this.name = nameOnAst.isEmpty() ? null : nameOnAst;
                this.externs = ImmutableMap.of();
            }
            this.root = root;
            this.parent = parent;
            this.formals = formals;
            this.commonTypes = commonTypes;
        }

        Node getRoot() {
            return this.root;
        }

        private Node getBody() {
            Preconditions.checkArgument((boolean)this.root.isFunction());
            return NodeUtil.getFunctionBody(this.root);
        }

        String getReadableName() {
            return this.isTopLevel() ? null : NodeUtil.getFunctionName(this.root);
        }

        String getName() {
            return this.name;
        }

        private void setDeclaredType(DeclaredFunctionType declaredType) {
            this.declaredType = declaredType;
        }

        DeclaredFunctionType getDeclaredType() {
            return this.declaredType;
        }

        boolean isFunction() {
            return this.root.isFunction();
        }

        private boolean isTopLevel() {
            return this.parent == null;
        }

        private boolean isConstructor() {
            if (!this.root.isFunction()) {
                return false;
            }
            JSDocInfo fnDoc = NodeUtil.getFunctionJSDocInfo(this.root);
            return fnDoc != null && fnDoc.isConstructor();
        }

        private boolean isPrototypeMethod() {
            Preconditions.checkArgument((this.root != null ? 1 : 0) != 0);
            return NodeUtil.isPrototypeMethod(this.root);
        }

        private void addUnknownTypeNames(List<String> names) {
            Preconditions.checkState((boolean)this.isTopLevel());
            this.unknownTypeNames.addAll(names);
        }

        private void addLocalFunDef(String name, Scope scope) {
            Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0);
            Preconditions.checkArgument((!name.contains(".") ? 1 : 0) != 0);
            Preconditions.checkArgument((!this.isDefinedLocally(name) ? 1 : 0) != 0);
            this.localFunDefs.put(name, scope);
        }

        boolean isFormalParam(String name) {
            return this.formals.contains(name);
        }

        boolean isLocalVar(String name) {
            return this.locals.containsKey(name);
        }

        boolean isLocalExtern(String name) {
            return this.externs.containsKey(name);
        }

        boolean isLocalFunDef(String name) {
            return this.localFunDefs.containsKey(name);
        }

        boolean isDefinedLocally(String name) {
            Preconditions.checkNotNull((Object)name);
            Preconditions.checkState((!name.contains(".") ? 1 : 0) != 0);
            return this.locals.containsKey(name) || this.formals.contains(name) || this.localFunDefs.containsKey(name) || "this".equals(name) || this.externs.containsKey(name) || this.localNamespaces != null && this.localNamespaces.containsKey(name) || this.localTypedefs != null && this.localTypedefs.containsKey(name) || this.localEnums != null && this.localEnums.containsKey(name);
        }

        private boolean isDefined(Node qnameNode) {
            Preconditions.checkArgument((boolean)qnameNode.isQualifiedName());
            if (qnameNode.isThis()) {
                return true;
            }
            if (qnameNode.isName()) {
                return this.isDefinedLocally(qnameNode.getString());
            }
            QualifiedName qname = QualifiedName.fromNode(qnameNode);
            String leftmost = qname.getLeftmostName();
            if (this.isNamespace(leftmost)) {
                return this.getNamespace(leftmost).isDefined(qname.getAllButLeftmost());
            }
            return this.parent == null ? false : this.parent.isDefined(qnameNode);
        }

        private boolean isNamespace(Node expr) {
            if (expr.isName()) {
                return this.isNamespace(expr.getString());
            }
            if (!expr.isGetProp()) {
                return false;
            }
            return this.isNamespace(QualifiedName.fromNode(expr));
        }

        private boolean isNamespace(QualifiedName qname) {
            if (qname == null) {
                return false;
            }
            String leftmost = qname.getLeftmostName();
            return this.isNamespace(leftmost) && (qname.isIdentifier() || this.getNamespace(leftmost).hasSubnamespace(qname.getAllButLeftmost()));
        }

        private boolean isNamespace(String name) {
            Preconditions.checkArgument((!name.contains(".") ? 1 : 0) != 0);
            return this.localNamespaces.containsKey(name) || this.localClassDefs.containsKey(name) || this.localEnums.containsKey(name) || this.parent != null && this.parent.isNamespace(name);
        }

        private boolean isNamespaceLiteral(String name) {
            return this.localNamespaces.containsKey(name);
        }

        private boolean isVisibleInScope(String name) {
            Preconditions.checkArgument((!name.contains(".") ? 1 : 0) != 0);
            return this.isDefinedLocally(name) || name.equals(this.name) || this.parent != null && this.parent.isVisibleInScope(name);
        }

        boolean isConstVar(String name) {
            Preconditions.checkArgument((!name.contains(".") ? 1 : 0) != 0);
            return this.constVars.contains(name) || this.parent != null && this.parent.isConstVar(name);
        }

        private boolean isOuterVarEarly(String name) {
            Preconditions.checkArgument((!name.contains(".") ? 1 : 0) != 0);
            return !this.isDefinedLocally(name) && this.parent != null && this.parent.isVisibleInScope(name);
        }

        boolean isUndeclaredFormal(String name) {
            Preconditions.checkArgument((!name.contains(".") ? 1 : 0) != 0);
            return this.formals.contains(name) && this.getDeclaredTypeOf(name) == null;
        }

        List<String> getFormals() {
            return new ArrayList<String>(this.formals);
        }

        Set<String> getOuterVars() {
            return new HashSet<String>(this.outerVars);
        }

        Set<String> getLocalFunDefs() {
            return new HashSet<String>(this.localFunDefs.keySet());
        }

        boolean isOuterVar(String name) {
            return this.outerVars.contains(name);
        }

        boolean hasThis() {
            return this.isFunction() && this.getDeclaredType().getThisType() != null;
        }

        private NominalType.RawNominalType getNominalType(QualifiedName qname) {
            if (qname.isIdentifier()) {
                String name = qname.getLeftmostName();
                NominalType.RawNominalType rnt = this.localClassDefs.get(name);
                if (rnt != null) {
                    return rnt;
                }
                return this.parent == null ? null : this.parent.getNominalType(qname);
            }
            Namespace ns = this.getNamespace(qname.getLeftmostName());
            if (ns == null) {
                return null;
            }
            return ns.getNominalType(qname.getAllButLeftmost());
        }

        private JSType lookupTypeByQname(QualifiedName qname) {
            Preconditions.checkArgument((!qname.isIdentifier() ? 1 : 0) != 0);
            Namespace ns = this.getNamespace(qname.getLeftmostName());
            if (ns == null) {
                return null;
            }
            NominalType.RawNominalType rawType = ns.getNominalType(qname.getAllButLeftmost());
            if (rawType == null) {
                return null;
            }
            return rawType.getInstanceAsJSType();
        }

        @Override
        public JSType lookupTypeByName(String name) {
            if (name.contains(".")) {
                JSType type = this.lookupTypeByQname(QualifiedName.fromQname(name));
                return type != null ? type : this.getUnresolvedTypeByName(name);
            }
            if (this.declaredType != null && this.declaredType.isTypeVariableInScope(name)) {
                return JSType.fromTypeVar(name);
            }
            NominalType.RawNominalType rawNominalType = this.localClassDefs.get(name);
            if (rawNominalType != null) {
                return rawNominalType.getInstanceAsJSType();
            }
            JSType t = this.getUnresolvedTypeByName(name);
            if (t != null) {
                return t;
            }
            return this.parent == null ? null : this.parent.lookupTypeByName(name);
        }

        JSType getUnresolvedTypeByName(String name) {
            if (this.unknownTypeNames.contains(name)) {
                return JSType.UNKNOWN;
            }
            return null;
        }

        @Override
        public JSTypes getCommonTypes() {
            if (this.isTopLevel()) {
                return this.commonTypes;
            }
            return this.parent.getCommonTypes();
        }

        @Override
        public JSType getDeclaredTypeOf(String name) {
            Namespace ns;
            Preconditions.checkArgument((!name.contains(".") ? 1 : 0) != 0);
            if ("this".equals(name)) {
                if (!this.hasThis()) {
                    return null;
                }
                return this.getDeclaredType().getThisType().getInstanceAsJSType();
            }
            int formalIndex = this.formals.indexOf(name);
            if (formalIndex != -1) {
                JSType formalType = this.declaredType.getFormalType(formalIndex);
                if (formalType == null || formalType.isBottom()) {
                    return null;
                }
                return formalType;
            }
            JSType localType = this.locals.get(name);
            if (localType != null) {
                Preconditions.checkState((!localType.isBottom() ? 1 : 0) != 0, (String)"%s was bottom", (Object[])new Object[]{name});
                return localType;
            }
            JSType externType = this.externs.get(name);
            if (externType != null) {
                Preconditions.checkState((!externType.isBottom() ? 1 : 0) != 0);
                return externType;
            }
            Scope s = this.localFunDefs.get(name);
            if (s != null && s.getDeclaredType() != null) {
                return this.getCommonTypes().fromFunctionType(s.getDeclaredType().toFunctionType());
            }
            if (name.equals(this.name)) {
                return this.getCommonTypes().fromFunctionType(this.getDeclaredType().toFunctionType());
            }
            if (this.localNamespaces != null && (ns = (Namespace)this.localNamespaces.get(name)) != null) {
                return ns.toJSType();
            }
            if (this.isDefinedLocally(name)) {
                return null;
            }
            if (this.parent != null) {
                return this.parent.getDeclaredTypeOf(name);
            }
            return null;
        }

        boolean hasUndeclaredFormalsOrOuters() {
            for (String formal : this.formals) {
                if (this.getDeclaredTypeOf(formal) != null) continue;
                return true;
            }
            for (String outer : this.outerVars) {
                JSType declType = this.getDeclaredTypeOf(outer);
                if (declType != null && (declType.getFunType() == null || !declType.getFunType().getReturnType().isUnknown())) continue;
                return true;
            }
            return false;
        }

        private Scope getScopeHelper(String fnName) {
            Scope s = this.localFunDefs.get(fnName);
            if (s != null) {
                return s;
            }
            if (this.parent != null && !this.isDefinedLocally(fnName)) {
                return this.parent.getScopeHelper(fnName);
            }
            return null;
        }

        boolean isKnownFunction(String fnName) {
            return this.getScopeHelper(fnName) != null;
        }

        boolean isExternalFunction(String fnName) {
            Scope s = (Scope)Preconditions.checkNotNull((Object)this.getScopeHelper(fnName));
            return s.root.isFromExterns();
        }

        Scope getScope(String fnName) {
            Scope s = this.getScopeHelper(fnName);
            Preconditions.checkState((s != null ? 1 : 0) != 0);
            return s;
        }

        Set<String> getLocals() {
            return ImmutableSet.copyOf(this.locals.keySet());
        }

        Set<String> getExterns() {
            return ImmutableSet.copyOf(this.externs.keySet());
        }

        private void addLocal(String name, JSType declType, boolean isConstant, boolean isFromExterns) {
            Preconditions.checkArgument((!this.isDefinedLocally(name) ? 1 : 0) != 0);
            if (isConstant) {
                this.constVars.add(name);
            }
            if (isFromExterns) {
                this.externs.put(name, declType);
            } else {
                this.locals.put(name, declType);
            }
        }

        private void addNamespace(Node qnameNode) {
            Preconditions.checkArgument((!this.isNamespace(qnameNode) ? 1 : 0) != 0);
            if (qnameNode.isName()) {
                this.localNamespaces.put(qnameNode.getString(), new NamespaceLit());
            } else {
                QualifiedName qname = QualifiedName.fromNode(qnameNode);
                Namespace ns = this.getNamespace(qname.getLeftmostName());
                ns.addSubnamespace(qname.getAllButLeftmost());
            }
        }

        private void updateType(String name, JSType newDeclType) {
            if (this.locals.containsKey(name)) {
                this.locals.put(name, newDeclType);
            } else if (this.parent != null) {
                this.parent.updateType(name, newDeclType);
            } else {
                throw new RuntimeException("Cannot update type of unknown variable: " + name);
            }
        }

        private void addOuterVar(String name) {
            this.outerVars.add(name);
        }

        private void addNominalType(Node qnameNode, NominalType.RawNominalType rawNominalType) {
            if (qnameNode.isName()) {
                Preconditions.checkState((!this.localClassDefs.containsKey(qnameNode.getString()) ? 1 : 0) != 0);
                this.localClassDefs.put(qnameNode.getString(), rawNominalType);
            } else {
                Preconditions.checkArgument((!this.isDefined(qnameNode) ? 1 : 0) != 0);
                QualifiedName qname = QualifiedName.fromNode(qnameNode);
                Namespace ns = this.getNamespace(qname.getLeftmostName());
                ns.addNominalType(qname.getAllButLeftmost(), rawNominalType);
            }
        }

        private void addTypedef(Node qnameNode, Typedef td) {
            if (qnameNode.isName()) {
                Preconditions.checkState((!this.localTypedefs.containsKey(qnameNode.getString()) ? 1 : 0) != 0);
                this.localTypedefs.put(qnameNode.getString(), td);
            } else {
                Preconditions.checkState((!this.isDefined(qnameNode) ? 1 : 0) != 0);
                QualifiedName qname = QualifiedName.fromNode(qnameNode);
                Namespace ns = this.getNamespace(qname.getLeftmostName());
                ns.addTypedef(qname.getAllButLeftmost(), td);
            }
        }

        @Override
        public Typedef getTypedef(String name) {
            if (!name.contains(".")) {
                if (this.isDefinedLocally(name)) {
                    return this.localTypedefs.get(name);
                }
            } else {
                QualifiedName qname = QualifiedName.fromQname(name);
                Namespace ns = this.getNamespace(qname.getLeftmostName());
                if (ns != null) {
                    return ns.getTypedef(qname.getAllButLeftmost());
                }
            }
            if (this.parent != null) {
                return this.parent.getTypedef(name);
            }
            return null;
        }

        private void addEnum(Node qnameNode, EnumType e) {
            if (qnameNode.isName()) {
                Preconditions.checkState((!this.localEnums.containsKey(qnameNode.getString()) ? 1 : 0) != 0);
                this.localEnums.put(qnameNode.getString(), e);
            } else {
                Preconditions.checkState((!this.isDefined(qnameNode) ? 1 : 0) != 0);
                QualifiedName qname = QualifiedName.fromNode(qnameNode);
                Namespace ns = this.getNamespace(qname.getLeftmostName());
                ns.addEnum(qname.getAllButLeftmost(), e);
                this.qualifiedEnums.add(e);
            }
        }

        @Override
        public EnumType getEnum(String name) {
            if (name == null) {
                return null;
            }
            if (!name.contains(".")) {
                if (this.isDefinedLocally(name)) {
                    return this.localEnums.get(name);
                }
            } else {
                QualifiedName qname = QualifiedName.fromQname(name);
                Namespace ns = this.getNamespace(qname.getLeftmostName());
                if (ns != null) {
                    return ns.getEnumType(qname.getAllButLeftmost());
                }
            }
            if (this.parent != null) {
                return this.parent.getEnum(name);
            }
            return null;
        }

        private Namespace getNamespace(QualifiedName qname) {
            Namespace ns = this.getNamespace(qname.getLeftmostName());
            return qname.isIdentifier() ? ns : ns.getSubnamespace(qname.getAllButLeftmost());
        }

        private Namespace getNamespace(String name) {
            Preconditions.checkArgument((!name.contains(".") ? 1 : 0) != 0);
            Namespace ns = this.localNamespaces.get(name);
            if (ns != null) {
                return ns;
            }
            ns = this.localClassDefs.get(name);
            if (ns != null) {
                return ns;
            }
            ns = this.localEnums.get(name);
            if (ns != null) {
                return ns;
            }
            return this.parent == null ? null : this.parent.getNamespace(name);
        }

        private void resolveTypedefs(JSTypeCreatorFromJSDoc typeParser) {
            for (Typedef td : this.localTypedefs.values()) {
                if (td.isResolved()) continue;
                typeParser.resolveTypedef(td, this);
            }
        }

        private void resolveEnums(JSTypeCreatorFromJSDoc typeParser) {
            for (EnumType e : this.localEnums.values()) {
                if (e.isResolved()) continue;
                typeParser.resolveEnum(e, this);
            }
            for (EnumType e : this.qualifiedEnums) {
                if (e.isResolved()) continue;
                typeParser.resolveEnum(e, this);
            }
            this.qualifiedEnums = null;
        }

        private void removeTmpData() {
            this.unknownTypeNames = null;
            for (Map.Entry<String, NamespaceLit> entry : this.localNamespaces.entrySet()) {
                this.locals.put(entry.getKey(), entry.getValue().toJSType());
            }
            for (Map.Entry<String, Namespace> entry : this.localEnums.entrySet()) {
                this.locals.put(entry.getKey(), ((EnumType)entry.getValue()).toJSType());
            }
            this.localNamespaces = null;
            this.localClassDefs = null;
            this.localTypedefs = null;
            this.localEnums = null;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.isTopLevel()) {
                sb.append("<TOP SCOPE>");
            } else {
                sb.append(this.getReadableName());
                sb.append('(');
                Joiner.on((char)',').appendTo(sb, this.formals);
                sb.append(')');
            }
            sb.append(" with root: ");
            sb.append(this.root);
            return sb.toString();
        }
    }

    private static class PropertyDef {
        final Node defSite;
        DeclaredFunctionType methodType;
        final Scope methodScope;

        PropertyDef(Node defSite, DeclaredFunctionType methodType, Scope methodScope) {
            Preconditions.checkArgument((defSite.isGetProp() || NodeUtil.isObjectLitKey(defSite) ? 1 : 0) != 0);
            this.defSite = defSite;
            this.methodType = methodType;
            this.methodScope = methodScope;
        }

        void updateMethodType(DeclaredFunctionType updatedType) {
            this.methodType = updatedType;
            if (this.methodScope != null) {
                this.methodScope.setDeclaredType(updatedType);
            }
        }
    }

    private class ProcessScope
    extends NodeTraversal.AbstractShallowCallback {
        private final Scope currentScope;
        private final Multimap<String, Node> undeclaredVars;
        private Set<Node> lendsObjlits = new HashSet<Node>();

        ProcessScope(Scope currentScope) {
            this.currentScope = currentScope;
            this.undeclaredVars = HashMultimap.create();
        }

        void finishProcessingScope() {
            for (Node objlit : this.lendsObjlits) {
                this.processLendsNode(objlit);
            }
            this.lendsObjlits = null;
        }

        void processLendsNode(Node objlit) {
            JSDocInfo jsdoc = objlit.getJSDocInfo();
            String lendsName = jsdoc.getLendsName();
            Preconditions.checkNotNull((Object)lendsName);
            QualifiedName lendsQname = QualifiedName.fromQname(lendsName);
            if (this.currentScope.isNamespace(lendsQname)) {
                this.processLendsToNamespace(lendsQname, lendsName, objlit);
            } else {
                NominalType.RawNominalType rawType = this.checkValidLendsToPrototypeAndGetClass(lendsQname, lendsName, objlit);
                if (rawType == null) {
                    return;
                }
                for (Node prop : objlit.children()) {
                    String pname = NodeUtil.getObjectLitKeyName(prop);
                    this.mayAddPropToPrototype(rawType, pname, prop, prop.getFirstChild());
                }
            }
        }

        void processLendsToNamespace(QualifiedName lendsQname, String lendsName, Node objlit) {
            NominalType.RawNominalType rawType = this.currentScope.getNominalType(lendsQname);
            if (rawType != null && rawType.isInterface()) {
                GlobalTypeInfo.this.warnings.add(JSError.make(objlit, LENDS_ON_BAD_TYPE, lendsName));
                return;
            }
            Namespace borrowerNamespace = this.currentScope.getNamespace(lendsQname);
            for (Node prop : objlit.children()) {
                String pname = NodeUtil.getObjectLitKeyName(prop);
                JSType propDeclType = (JSType)GlobalTypeInfo.this.declaredObjLitProps.get(prop);
                if (propDeclType != null) {
                    borrowerNamespace.addProperty(pname, propDeclType, false);
                    continue;
                }
                JSType t = this.simpleInferExprType(prop.getFirstChild());
                if (t == null) {
                    t = JSType.UNKNOWN;
                }
                borrowerNamespace.addProperty(pname, t, false);
            }
        }

        NominalType.RawNominalType checkValidLendsToPrototypeAndGetClass(QualifiedName lendsQname, String lendsName, Node objlit) {
            if (!lendsQname.getRightmostName().equals("prototype")) {
                GlobalTypeInfo.this.warnings.add(JSError.make(objlit, LENDS_ON_BAD_TYPE, lendsName));
                return null;
            }
            QualifiedName recv = lendsQname.getAllButRightmost();
            NominalType.RawNominalType rawType = this.currentScope.getNominalType(recv);
            if (rawType == null || rawType.isInterface()) {
                GlobalTypeInfo.this.warnings.add(JSError.make(objlit, LENDS_ON_BAD_TYPE, lendsName));
            }
            return rawType;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getType()) {
                case 105: {
                    Node grandparent = parent.getParent();
                    if (grandparent != null && GlobalTypeInfo.isPrototypePropertyDeclaration(grandparent)) break;
                    this.visitFunctionLate(n, null);
                    break;
                }
                case 38: {
                    String name = n.getString();
                    if (name == null || "undefined".equals(name) || parent.isFunction()) {
                        return;
                    }
                    if (parent.isVar() || parent.isCatch()) {
                        if (NodeUtil.isNamespaceDecl(n) || NodeUtil.isTypedefDecl(n) || NodeUtil.isEnumDecl(n)) {
                            if (this.currentScope.isDefinedLocally(name)) break;
                            this.currentScope.addLocal(name, JSType.UNKNOWN, false, n.isFromExterns());
                            break;
                        }
                        Node initializer = n.getFirstChild();
                        if (initializer != null && initializer.isFunction() || this.currentScope.isDefinedLocally(name)) break;
                        this.undeclaredVars.removeAll((Object)name);
                        if (parent.isCatch()) {
                            this.currentScope.addLocal(name, JSType.UNKNOWN, false, n.isFromExterns());
                            break;
                        }
                        boolean isConst = GlobalTypeInfo.this.isConst(parent);
                        JSType declType = this.getVarTypeFromAnnotation(n);
                        if (isConst && !this.mayWarnAboutNoInit(n) && declType == null) {
                            declType = this.inferConstTypeFromRhs(n);
                        }
                        this.currentScope.addLocal(name, declType, isConst, n.isFromExterns());
                        break;
                    }
                    if (this.currentScope.isOuterVarEarly(name)) {
                        this.currentScope.addOuterVar(name);
                        break;
                    }
                    if (this.currentScope.getTypedef(name) == null && (name.equals(this.currentScope.getName()) || this.currentScope.isDefinedLocally(name))) break;
                    this.undeclaredVars.put((Object)name, (Object)n);
                    break;
                }
                case 33: {
                    if (!parent.isExprResult()) break;
                    this.visitPropertyDeclaration(n);
                    break;
                }
                case 86: {
                    Node lvalue = n.getFirstChild();
                    if (!lvalue.isGetProp() || !parent.isExprResult()) break;
                    this.visitPropertyDeclaration(lvalue);
                    break;
                }
                case 155: {
                    GlobalTypeInfo.this.castTypes.put(n, GlobalTypeInfo.this.getTypeDeclarationFromJsdoc(n.getJSDocInfo(), this.currentScope));
                    break;
                }
                case 64: {
                    Node receiver;
                    JSDocInfo jsdoc = n.getJSDocInfo();
                    if (jsdoc != null && jsdoc.getLendsName() != null) {
                        this.lendsObjlits.add(n);
                    }
                    Node node = receiver = parent.isAssign() ? parent.getFirstChild() : parent;
                    if (NodeUtil.isNamespaceDecl(receiver) && this.currentScope.isNamespace(receiver)) {
                        for (Node prop : n.children()) {
                            this.visitNamespacePropertyDeclaration(prop, receiver, prop.getString());
                        }
                    } else {
                        for (Node prop : n.children()) {
                            if (prop.getJSDocInfo() != null) {
                                GlobalTypeInfo.this.declaredObjLitProps.put(prop, GlobalTypeInfo.this.getTypeDeclarationFromJsdoc(prop.getJSDocInfo(), this.currentScope));
                            }
                            if (!GlobalTypeInfo.isAnnotatedAsConst(prop)) continue;
                            GlobalTypeInfo.this.warnings.add(JSError.make(prop, MISPLACED_CONST_ANNOTATION, new String[0]));
                        }
                    }
                    break;
                }
            }
        }

        private void visitPropertyDeclaration(Node getProp) {
            if (GlobalTypeInfo.isClassPropAccess(getProp, this.currentScope)) {
                if (GlobalTypeInfo.isAnnotatedAsConst(getProp) && this.currentScope.isPrototypeMethod()) {
                    GlobalTypeInfo.this.warnings.add(JSError.make(getProp, MISPLACED_CONST_ANNOTATION, new String[0]));
                }
                this.visitClassPropertyDeclaration(getProp);
                return;
            }
            if (GlobalTypeInfo.isPropertyDeclaration(getProp) && GlobalTypeInfo.isPrototypeProperty(getProp)) {
                this.visitPrototypePropertyDeclaration(getProp);
                return;
            }
            if (GlobalTypeInfo.isPropertyDeclaration(getProp) && this.isStaticCtorProp(getProp, this.currentScope)) {
                this.visitConstructorPropertyDeclaration(getProp);
                return;
            }
            if (GlobalTypeInfo.isPropertyDeclaration(getProp) && this.currentScope.isNamespace(getProp.getFirstChild())) {
                this.visitNamespacePropertyDeclaration(getProp);
                return;
            }
            if (GlobalTypeInfo.isAnnotatedAsConst(getProp)) {
                GlobalTypeInfo.this.warnings.add(JSError.make(getProp, MISPLACED_CONST_ANNOTATION, new String[0]));
            }
        }

        private boolean isStaticCtorProp(Node getProp, Scope s) {
            Preconditions.checkArgument((boolean)getProp.isGetProp());
            if (!getProp.isQualifiedName()) {
                return false;
            }
            Node receiverObj = getProp.getFirstChild();
            if (!s.isLocalFunDef(receiverObj.getQualifiedName())) {
                return false;
            }
            return null != this.currentScope.getNominalType(QualifiedName.fromNode(receiverObj));
        }

        private Scope visitFunctionLate(Node fn, NominalType.RawNominalType ownerType) {
            Preconditions.checkArgument((boolean)fn.isFunction());
            String fnName = NodeUtil.getFunctionName(fn);
            if (fnName != null && !fnName.contains(".")) {
                this.undeclaredVars.removeAll((Object)fnName);
            }
            String internalName = GlobalTypeInfo.this.getFunInternalName(fn);
            Scope fnScope = this.currentScope.getScope(internalName);
            this.updateFnScope(fnScope, ownerType);
            return fnScope;
        }

        private void visitPrototypePropertyDeclaration(Node getProp) {
            Preconditions.checkArgument((boolean)getProp.isGetProp());
            Node parent = getProp.getParent();
            Node initializer = parent.isAssign() ? parent.getLastChild() : null;
            Node ctorNameNode = NodeUtil.getPrototypeClassName(getProp);
            QualifiedName ctorQname = QualifiedName.fromNode(ctorNameNode);
            NominalType.RawNominalType rawType = this.currentScope.getNominalType(ctorQname);
            if (rawType == null) {
                if (initializer != null && initializer.isFunction()) {
                    this.visitFunctionLate(initializer, null);
                }
                return;
            }
            if (!this.currentScope.isDefined(ctorNameNode)) {
                GlobalTypeInfo.this.warnings.add(JSError.make(getProp, CTOR_IN_DIFFERENT_SCOPE, new String[0]));
                if (initializer != null && initializer.isFunction()) {
                    this.visitFunctionLate(initializer, rawType);
                }
                return;
            }
            String pname = NodeUtil.getPrototypePropertyName(getProp);
            this.mayAddPropToPrototype(rawType, pname, getProp, initializer);
        }

        private void visitConstructorPropertyDeclaration(Node getProp) {
            Preconditions.checkArgument((boolean)getProp.isGetProp());
            if (this.isNamedType(getProp)) {
                return;
            }
            String ctorName = getProp.getFirstChild().getQualifiedName();
            QualifiedName ctorQname = QualifiedName.fromNode(getProp.getFirstChild());
            Preconditions.checkState((boolean)this.currentScope.isLocalFunDef(ctorName));
            NominalType.RawNominalType classType = this.currentScope.getNominalType(ctorQname);
            String pname = getProp.getLastChild().getString();
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(getProp);
            JSType propDeclType = this.getTypeAtPropDeclNode(getProp, jsdoc);
            boolean isConst = GlobalTypeInfo.this.isConst(getProp);
            if (propDeclType != null || isConst) {
                JSType previousPropType = classType.getCtorPropDeclaredType(pname);
                if (classType.hasCtorProp(pname) && previousPropType != null && !this.suppressDupPropWarning(jsdoc, propDeclType, previousPropType)) {
                    GlobalTypeInfo.this.warnings.add(JSError.make(getProp, REDECLARED_PROPERTY, pname, classType.toString()));
                    return;
                }
                if (isConst && !this.mayWarnAboutNoInit(getProp) && propDeclType == null) {
                    propDeclType = this.inferConstTypeFromRhs(getProp);
                }
                classType.addCtorProperty(pname, propDeclType, isConst);
                getProp.putBooleanProp(75, true);
                if (isConst) {
                    getProp.putBooleanProp(76, true);
                }
            } else {
                classType.addUndeclaredCtorProperty(pname);
            }
        }

        private void visitNamespacePropertyDeclaration(Node getProp) {
            Preconditions.checkArgument((boolean)getProp.isGetProp());
            if (this.isNamedType(getProp)) {
                return;
            }
            Node recv = getProp.getFirstChild();
            String pname = getProp.getLastChild().getString();
            this.visitNamespacePropertyDeclaration(getProp, recv, pname);
        }

        private void visitNamespacePropertyDeclaration(Node declNode, Node recv, String pname) {
            Preconditions.checkArgument((declNode.isGetProp() || declNode.isStringKey() ? 1 : 0) != 0);
            Preconditions.checkArgument((boolean)this.currentScope.isNamespace(recv));
            EnumType et = this.currentScope.getEnum(recv.getQualifiedName());
            if (et != null && et.enumLiteralHasKey(pname)) {
                return;
            }
            Namespace ns = this.currentScope.getNamespace(QualifiedName.fromNode(recv));
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(declNode);
            JSType propDeclType = this.getTypeAtPropDeclNode(declNode, jsdoc);
            boolean isConst = GlobalTypeInfo.this.isConst(declNode);
            if (propDeclType != null || isConst) {
                JSType previousPropType = ns.getPropDeclaredType(pname);
                if (ns.hasProp(pname) && previousPropType != null && !this.suppressDupPropWarning(jsdoc, propDeclType, previousPropType)) {
                    GlobalTypeInfo.this.warnings.add(JSError.make(declNode, REDECLARED_PROPERTY, pname, ns.toString()));
                    return;
                }
                if (isConst && !this.mayWarnAboutNoInit(declNode) && propDeclType == null) {
                    propDeclType = this.inferConstTypeFromRhs(declNode);
                }
                ns.addProperty(pname, propDeclType, isConst);
                declNode.putBooleanProp(75, true);
                if (declNode.isGetProp() && isConst) {
                    declNode.putBooleanProp(76, true);
                }
            } else {
                JSType t;
                Node initializer = NodeUtil.getInitializer(declNode);
                JSType jSType = t = initializer == null ? null : this.simpleInferExprType(initializer);
                if (t == null) {
                    t = JSType.UNKNOWN;
                }
                ns.addUndeclaredProperty(pname, t, false);
            }
        }

        private void visitClassPropertyDeclaration(Node getProp) {
            Preconditions.checkArgument((boolean)getProp.isGetProp());
            NominalType thisType = this.currentScope.getDeclaredType().getThisType();
            if (thisType == null) {
                return;
            }
            NominalType.RawNominalType rawNominalType = thisType.getRawNominalType();
            String pname = getProp.getLastChild().getString();
            JSType declType = GlobalTypeInfo.this.getTypeDeclarationFromJsdoc(NodeUtil.getBestJSDocInfo(getProp), this.currentScope);
            boolean isConst = GlobalTypeInfo.this.isConst(getProp);
            if (declType != null || isConst) {
                this.mayWarnAboutExistingProp(rawNominalType, pname, getProp, declType);
                if (isConst && !this.mayWarnAboutNoInit(getProp) && declType == null) {
                    declType = this.inferConstTypeFromRhs(getProp);
                }
                if (this.mayAddPropToType(getProp, rawNominalType)) {
                    rawNominalType.addClassProperty(pname, declType, isConst);
                }
                if (isConst) {
                    getProp.putBooleanProp(76, true);
                }
            } else if (this.mayAddPropToType(getProp, rawNominalType)) {
                rawNominalType.addUndeclaredClassProperty(pname);
            }
            GlobalTypeInfo.this.propertyDefs.put((Object)rawNominalType, (Object)pname, (Object)new PropertyDef(getProp, null, null));
        }

        private JSType getTypeAtPropDeclNode(Node declNode, JSDocInfo jsdoc) {
            Preconditions.checkArgument((!this.currentScope.isNamespace(declNode) ? 1 : 0) != 0);
            Node initializer = NodeUtil.getInitializer(declNode);
            if (initializer != null && initializer.isFunction()) {
                return GlobalTypeInfo.this.commonTypes.fromFunctionType(this.currentScope.getScope(GlobalTypeInfo.this.getFunInternalName(initializer)).getDeclaredType().toFunctionType());
            }
            return GlobalTypeInfo.this.getTypeDeclarationFromJsdoc(jsdoc, this.currentScope);
        }

        boolean mayWarnAboutNoInit(Node constExpr) {
            if (constExpr.isFromExterns()) {
                return false;
            }
            Node initializer = NodeUtil.getInitializer(constExpr);
            if (initializer == null) {
                GlobalTypeInfo.this.warnings.add(JSError.make(constExpr, CONST_WITHOUT_INITIALIZER, new String[0]));
                return true;
            }
            return false;
        }

        private JSType inferConstTypeFromRhs(Node constExpr) {
            if (constExpr.isFromExterns()) {
                GlobalTypeInfo.this.warnings.add(JSError.make(constExpr, COULD_NOT_INFER_CONST_TYPE, new String[0]));
                return null;
            }
            Node rhs = NodeUtil.getInitializer(constExpr);
            JSType rhsType = this.simpleInferExprType(rhs);
            if (rhsType == null) {
                GlobalTypeInfo.this.warnings.add(JSError.make(constExpr, COULD_NOT_INFER_CONST_TYPE, new String[0]));
                return null;
            }
            return rhsType;
        }

        private JSType simpleInferExprType(Node n) {
            switch (n.getType()) {
                case 47: {
                    return GlobalTypeInfo.this.commonTypes.getRegexpType();
                }
                case 63: {
                    if (!n.hasChildren()) {
                        return null;
                    }
                    Node child = n.getFirstChild();
                    JSType arrayType = this.simpleInferExprType(child);
                    if (arrayType == null) {
                        return null;
                    }
                    while (null != (child = child.getNext())) {
                        if (arrayType.equals(this.simpleInferExprType(child))) continue;
                        return null;
                    }
                    return GlobalTypeInfo.this.commonTypes.getArrayInstance(arrayType);
                }
                case 44: {
                    return JSType.TRUE_TYPE;
                }
                case 43: {
                    return JSType.FALSE_TYPE;
                }
                case 38: {
                    String varName = n.getString();
                    if (varName.equals("undefined")) {
                        return JSType.UNDEFINED;
                    }
                    if (this.currentScope.isNamespaceLiteral(varName)) {
                        return null;
                    }
                    return this.currentScope.getDeclaredTypeOf(varName);
                }
                case 64: {
                    JSType objLitType = JSType.TOP_OBJECT;
                    for (Node prop : n.children()) {
                        JSType propType = this.simpleInferExprType(prop.getFirstChild());
                        if (propType == null) {
                            return null;
                        }
                        objLitType = objLitType.withProperty(new QualifiedName(NodeUtil.getObjectLitKeyName(prop)), propType);
                    }
                    return objLitType;
                }
                case 33: {
                    Node recv = n.getFirstChild();
                    if (recv.isQualifiedName()) {
                        EnumType et = this.currentScope.getEnum(recv.getQualifiedName());
                        if (et != null && et.enumLiteralHasKey(n.getLastChild().getString())) {
                            return et.getEnumeratedType();
                        }
                        if (this.currentScope.isNamespace(recv)) {
                            return this.currentScope.lookupTypeByQname(QualifiedName.fromNode(n));
                        }
                        JSType recvType = this.simpleInferExprType(recv);
                        QualifiedName qname = new QualifiedName(n.getLastChild().getString());
                        if (recvType != null && recvType.mayHaveProp(qname)) {
                            return recvType.getProp(qname);
                        }
                    }
                    return null;
                }
                case 85: 
                case 86: {
                    return this.simpleInferExprType(n.getLastChild());
                }
                case 30: 
                case 37: {
                    JSType ratorType = this.simpleInferExprType(n.getFirstChild());
                    if (ratorType == null) {
                        return null;
                    }
                    FunctionType funType = ratorType.getFunType();
                    if (funType == null) {
                        return null;
                    }
                    if (funType.isGeneric()) {
                        ImmutableList.Builder argTypes = ImmutableList.builder();
                        for (Node argNode = n.getFirstChild().getNext(); argNode != null; argNode = argNode.getNext()) {
                            JSType t = this.simpleInferExprType(argNode);
                            if (t == null) {
                                return null;
                            }
                            argTypes.add((Object)t);
                        }
                        if ((funType = funType.instantiateGenericsFromArgumentTypes((List<JSType>)argTypes.build())) == null) {
                            return null;
                        }
                    }
                    return funType.getReturnType();
                }
            }
            switch (NodeUtil.getKnownValueType(n)) {
                case NULL: {
                    return JSType.NULL;
                }
                case VOID: {
                    return JSType.UNDEFINED;
                }
                case NUMBER: {
                    return JSType.NUMBER;
                }
                case STRING: {
                    return JSType.STRING;
                }
                case BOOLEAN: {
                    return JSType.BOOLEAN;
                }
            }
            return null;
        }

        private boolean mayAddPropToType(Node getProp, NominalType.RawNominalType rawType) {
            if (!rawType.isStruct()) {
                return true;
            }
            Node parent = getProp.getParent();
            return parent.isAssign() && getProp == parent.getFirstChild() && this.currentScope.isConstructor();
        }

        private boolean mayWarnAboutExistingProp(NominalType.RawNominalType classType, String pname, Node propCreationNode, JSType typeInJsdoc) {
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(propCreationNode);
            JSType previousPropType = classType.getInstancePropDeclaredType(pname);
            if (classType.mayHaveOwnProp(pname) && previousPropType != null && !this.suppressDupPropWarning(jsdoc, typeInJsdoc, previousPropType)) {
                GlobalTypeInfo.this.warnings.add(JSError.make(propCreationNode, REDECLARED_PROPERTY, pname, classType.toString()));
                return true;
            }
            return false;
        }

        private boolean suppressDupPropWarning(JSDocInfo propCreationJsdoc, JSType typeInJsdoc, JSType previousType) {
            if (propCreationJsdoc == null || !propCreationJsdoc.getSuppressions().contains("duplicate")) {
                return false;
            }
            return typeInJsdoc != null && previousType != null && typeInJsdoc.equals(previousType);
        }

        private DeclaredFunctionType computeFnDeclaredType(JSDocInfo fnDoc, String functionName, Node declNode, NominalType.RawNominalType ownerType, Scope parentScope) {
            DeclaredFunctionType t;
            int index;
            JSType declTypeFromCallee;
            FunctionType calleeDeclType;
            Preconditions.checkArgument((declNode.isFunction() || declNode.isGetProp() ? 1 : 0) != 0);
            Node parent = declNode.getParent();
            if (fnDoc == null && !NodeUtil.functionHasInlineJsdocs(declNode) && parent.isCall() && declNode != parent.getFirstChild() && (calleeDeclType = GlobalTypeInfo.this.getDeclaredFunctionTypeOfCalleeIfAny(parent.getFirstChild(), parentScope)) != null && (declTypeFromCallee = calleeDeclType.getFormalType(index = parent.getIndexOfChild(declNode) - 1)) != null && (t = this.computeFnDeclaredTypeFromCallee(declNode, declTypeFromCallee)) != null) {
                return t;
            }
            ImmutableList<String> typeParameters = fnDoc == null ? null : fnDoc.getTemplateTypeNames();
            FunctionTypeBuilder builder = GlobalTypeInfo.this.typeParser.getFunctionType(fnDoc, declNode, ownerType, parentScope);
            NominalType.RawNominalType ctorType = null;
            if (fnDoc != null) {
                NominalType parentClass = null;
                if (fnDoc.hasBaseType()) {
                    if (!fnDoc.isConstructor()) {
                        GlobalTypeInfo.this.warnings.add(JSError.make(declNode, EXTENDS_NOT_ON_CTOR_OR_INTERF, functionName));
                    } else {
                        Node docNode = fnDoc.getBaseType().getRoot();
                        if (GlobalTypeInfo.this.typeParser.hasKnownType(docNode, ownerType, parentScope, typeParameters)) {
                            parentClass = GlobalTypeInfo.this.typeParser.getNominalType(docNode, ownerType, parentScope, typeParameters);
                            if (parentClass == null) {
                                GlobalTypeInfo.this.warnings.add(JSError.make(declNode, EXTENDS_NON_OBJECT, functionName, docNode.toStringTree()));
                            } else if (parentClass.isInterface()) {
                                GlobalTypeInfo.this.warnings.add(JSError.make(declNode, TypeCheck.CONFLICTING_EXTENDED_TYPE, "constructor", functionName));
                                parentClass = null;
                            }
                        }
                    }
                }
                ctorType = declNode.isFunction() ? (NominalType.RawNominalType)GlobalTypeInfo.this.nominaltypesByNode.get(declNode) : null;
                ImmutableSet<NominalType> implementedIntfs = GlobalTypeInfo.this.typeParser.getImplementedInterfaces(fnDoc, ownerType, parentScope, typeParameters);
                if (ctorType == null && (fnDoc.isConstructor() || fnDoc.isInterface())) {
                    return builder.buildDeclaration();
                }
                if (fnDoc.isConstructor()) {
                    String className = ctorType.toString();
                    if (parentClass == null && !"Object".equals(functionName)) {
                        parentClass = GlobalTypeInfo.this.commonTypes.getObjectType();
                    }
                    if (parentClass != null) {
                        if (!ctorType.addSuperClass(parentClass)) {
                            GlobalTypeInfo.this.warnings.add(JSError.make(declNode, INHERITANCE_CYCLE, className));
                        } else if (parentClass != GlobalTypeInfo.this.commonTypes.getObjectType()) {
                            if (ctorType.isStruct() && !parentClass.isStruct()) {
                                GlobalTypeInfo.this.warnings.add(JSError.make(declNode, TypeCheck.CONFLICTING_SHAPE_TYPE, "struct", className));
                            } else if (ctorType.isDict() && !parentClass.isDict()) {
                                GlobalTypeInfo.this.warnings.add(JSError.make(declNode, TypeCheck.CONFLICTING_SHAPE_TYPE, "dict", className));
                            }
                        }
                    }
                    if (ctorType.isDict() && !implementedIntfs.isEmpty()) {
                        GlobalTypeInfo.this.warnings.add(JSError.make(declNode, DICT_IMPLEMENTS_INTERF, className));
                    }
                    boolean noCycles = ctorType.addInterfaces(implementedIntfs);
                    Preconditions.checkState((boolean)noCycles);
                    builder.addNominalType(ctorType.getAsNominalType());
                } else if (fnDoc.isInterface()) {
                    boolean noCycles;
                    if (!implementedIntfs.isEmpty()) {
                        GlobalTypeInfo.this.warnings.add(JSError.make(declNode, TypeCheck.CONFLICTING_IMPLEMENTED_TYPE, functionName));
                    }
                    if (!(noCycles = ctorType.addInterfaces(GlobalTypeInfo.this.typeParser.getExtendedInterfaces(fnDoc, ownerType, parentScope, typeParameters)))) {
                        GlobalTypeInfo.this.warnings.add(JSError.make(declNode, INHERITANCE_CYCLE, ctorType.toString()));
                    }
                    builder.addNominalType(ctorType.getAsNominalType());
                } else if (!implementedIntfs.isEmpty()) {
                    GlobalTypeInfo.this.warnings.add(JSError.make(declNode, IMPLEMENTS_WITHOUT_CONSTRUCTOR, functionName));
                }
            }
            if (ownerType != null) {
                builder.addReceiverType(ownerType.getAsNominalType());
            }
            DeclaredFunctionType result = builder.buildDeclaration();
            if (ctorType != null) {
                ctorType.setCtorFunction(result.toFunctionType());
            }
            return result;
        }

        private DeclaredFunctionType computeFnDeclaredTypeFromCallee(Node declNode, JSType declaredTypeAsJSType) {
            Preconditions.checkArgument((boolean)declNode.isFunction());
            Preconditions.checkArgument((boolean)declNode.getParent().isCall());
            Preconditions.checkNotNull((Object)declaredTypeAsJSType);
            FunctionType funType = declaredTypeAsJSType.getFunType();
            if (funType == null) {
                return null;
            }
            DeclaredFunctionType declType = funType.toDeclaredFunctionType();
            if (declType == null) {
                return null;
            }
            int numFormals = declNode.getChildAtIndex(1).getChildCount();
            int reqArity = declType.getRequiredArity();
            int optArity = declType.getOptionalArity();
            boolean hasRestFormals = declType.hasRestFormals();
            if (reqArity == optArity && !hasRestFormals) {
                return numFormals == reqArity ? declType : null;
            }
            if (numFormals == optArity && !hasRestFormals || numFormals == optArity + 1 && hasRestFormals) {
                return declType;
            }
            return null;
        }

        private void updateFnScope(Scope fnScope, NominalType.RawNominalType ownerType) {
            Node fn = fnScope.getRoot();
            Preconditions.checkState((boolean)fn.isFunction());
            JSDocInfo fnDoc = NodeUtil.getFunctionJSDocInfo(fn);
            String functionName = GlobalTypeInfo.this.getFunInternalName(fn);
            DeclaredFunctionType declFunType = this.computeFnDeclaredType(fnDoc, functionName, fn, ownerType, this.currentScope);
            fnScope.setDeclaredType(declFunType);
        }

        private JSType getVarTypeFromAnnotation(Node nameNode) {
            Preconditions.checkArgument((boolean)nameNode.getParent().isVar());
            Node varNode = nameNode.getParent();
            JSType varType = GlobalTypeInfo.this.getTypeDeclarationFromJsdoc(varNode.getJSDocInfo(), this.currentScope);
            if (varNode.getChildCount() > 1 && varType != null) {
                GlobalTypeInfo.this.warnings.add(JSError.make(varNode, TypeCheck.MULTIPLE_VAR_DEF, new String[0]));
            }
            String varName = nameNode.getString();
            JSType nameNodeType = GlobalTypeInfo.this.getTypeDeclarationFromJsdoc(nameNode.getJSDocInfo(), this.currentScope);
            if (nameNodeType != null) {
                if (varType != null) {
                    GlobalTypeInfo.this.warnings.add(JSError.make(nameNode, DUPLICATE_JSDOC, varName));
                }
                return nameNodeType;
            }
            return varType;
        }

        private void mayAddPropToPrototype(NominalType.RawNominalType rawType, String pname, Node defSite, Node initializer) {
            JSType propDeclType;
            DeclaredFunctionType methodType;
            Scope methodScope;
            if (initializer != null && initializer.isFunction()) {
                if (initializer.getLastChild().hasChildren() && rawType.isInterface()) {
                    GlobalTypeInfo.this.warnings.add(JSError.make(initializer.getLastChild(), TypeCheck.INTERFACE_METHOD_NOT_EMPTY, new String[0]));
                }
                methodScope = this.visitFunctionLate(initializer, rawType);
                methodType = methodScope.getDeclaredType();
                propDeclType = GlobalTypeInfo.this.commonTypes.fromFunctionType(methodType.toFunctionType());
            } else {
                JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(defSite);
                if (jsdoc != null && jsdoc.containsFunctionDeclaration()) {
                    methodScope = null;
                    methodType = this.computeFnDeclaredType(jsdoc, pname, defSite, rawType, this.currentScope);
                    propDeclType = GlobalTypeInfo.this.commonTypes.fromFunctionType(methodType.toFunctionType());
                } else if (jsdoc != null && jsdoc.hasType()) {
                    methodScope = null;
                    methodType = null;
                    propDeclType = GlobalTypeInfo.this.typeParser.getNodeTypeDeclaration(jsdoc, rawType, this.currentScope);
                } else {
                    methodScope = null;
                    methodType = null;
                    propDeclType = null;
                }
            }
            GlobalTypeInfo.this.propertyDefs.put((Object)rawType, (Object)pname, (Object)new PropertyDef(defSite, methodType, methodScope));
            boolean isConst = GlobalTypeInfo.this.isConst(defSite);
            if (propDeclType != null || isConst) {
                if (this.mayWarnAboutExistingProp(rawType, pname, defSite, propDeclType)) {
                    return;
                }
                if (defSite.isGetProp() && propDeclType == null && isConst && !this.mayWarnAboutNoInit(defSite)) {
                    propDeclType = this.inferConstTypeFromRhs(defSite);
                }
                rawType.addProtoProperty(pname, propDeclType, isConst);
                if (defSite.isGetProp()) {
                    defSite.putBooleanProp(75, true);
                    if (isConst) {
                        defSite.putBooleanProp(76, true);
                    }
                }
            } else {
                rawType.addUndeclaredProtoProperty(pname);
            }
        }

        private boolean isNamedType(Node getProp) {
            return this.currentScope.isNamespace(getProp) || NodeUtil.isTypedefDecl(getProp);
        }
    }

    private class CollectNamedTypes
    extends NodeTraversal.AbstractShallowCallback {
        private final Scope currentScope;

        CollectNamedTypes(Scope s) {
            this.currentScope = s;
        }

        private void processQualifiedDefinition(Node qnameNode) {
            Preconditions.checkArgument((boolean)qnameNode.isGetProp());
            Preconditions.checkArgument((boolean)qnameNode.isQualifiedName());
            Node recv = qnameNode.getFirstChild();
            if (!this.currentScope.isNamespace(recv)) {
                return;
            }
            if (NodeUtil.isNamespaceDecl(qnameNode)) {
                this.visitNamespace(qnameNode);
            } else if (NodeUtil.isTypedefDecl(qnameNode)) {
                this.visitTypedef(qnameNode);
            } else if (NodeUtil.isEnumDecl(qnameNode)) {
                this.visitEnum(qnameNode);
            } else if (NodeUtil.isAliasedNominalTypeDecl(qnameNode)) {
                this.maybeRecordAliasedNominalType(qnameNode);
            } else if (!this.currentScope.isDefined(qnameNode)) {
                Namespace ns = this.currentScope.getNamespace(QualifiedName.fromNode(recv));
                String pname = qnameNode.getLastChild().getString();
                ns.addUndeclaredProperty(pname, JSType.UNKNOWN, false);
            }
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            block0 : switch (n.getType()) {
                case 105: {
                    this.visitFunctionEarly(n);
                    break;
                }
                case 118: {
                    Node nameNode = n.getFirstChild();
                    if (NodeUtil.isNamespaceDecl(nameNode)) {
                        this.visitNamespace(nameNode);
                        break;
                    }
                    if (NodeUtil.isTypedefDecl(nameNode)) {
                        this.visitTypedef(nameNode);
                        break;
                    }
                    if (NodeUtil.isEnumDecl(nameNode)) {
                        this.visitEnum(nameNode);
                        break;
                    }
                    if (!NodeUtil.isAliasedNominalTypeDecl(nameNode)) break;
                    this.maybeRecordAliasedNominalType(nameNode);
                    break;
                }
                case 130: {
                    Node expr = n.getFirstChild();
                    switch (expr.getType()) {
                        case 86: {
                            if (!expr.getFirstChild().isGetProp()) {
                                return;
                            }
                            expr = expr.getFirstChild();
                        }
                        case 33: {
                            if (GlobalTypeInfo.isPrototypeProperty(expr) || NodeUtil.referencesThis(expr) || !expr.isQualifiedName()) {
                                return;
                            }
                            this.processQualifiedDefinition(expr);
                            break block0;
                        }
                        case 37: {
                            List<String> decls = GlobalTypeInfo.this.convention.identifyTypeDeclarationCall(expr);
                            if (decls == null || decls.isEmpty()) {
                                return;
                            }
                            this.currentScope.addUnknownTypeNames(decls);
                            break block0;
                        }
                    }
                    break;
                }
            }
        }

        private void visitNamespace(Node qnameNode) {
            if (this.currentScope.isDefined(qnameNode)) {
                return;
            }
            if (qnameNode.isGetProp()) {
                Preconditions.checkState((boolean)qnameNode.getParent().isAssign());
                qnameNode.getParent().putBooleanProp(75, true);
            }
            this.currentScope.addNamespace(qnameNode);
        }

        private void visitTypedef(Node qnameNode) {
            Preconditions.checkState((boolean)qnameNode.isQualifiedName());
            qnameNode.putBooleanProp(75, true);
            if (NodeUtil.getInitializer(qnameNode) != null) {
                GlobalTypeInfo.this.warnings.add(JSError.make(qnameNode, CANNOT_INIT_TYPEDEF, new String[0]));
            }
            if (this.currentScope.isDefined(qnameNode)) {
                return;
            }
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(qnameNode);
            Typedef td = Typedef.make(jsdoc.getTypedefType());
            this.currentScope.addTypedef(qnameNode, td);
        }

        private void visitEnum(Node qnameNode) {
            EnumType et;
            Preconditions.checkState((boolean)qnameNode.isQualifiedName());
            qnameNode.putBooleanProp(75, true);
            if (this.currentScope.isDefined(qnameNode)) {
                return;
            }
            Node init = NodeUtil.getInitializer(qnameNode);
            if (init != null && init.isQualifiedName() && (et = this.currentScope.getEnum(init.getQualifiedName())) != null) {
                this.currentScope.addEnum(qnameNode, et);
                return;
            }
            if (init == null || !init.isObjectLit() || init.getFirstChild() == null) {
                GlobalTypeInfo.this.warnings.add(JSError.make(qnameNode, MALFORMED_ENUM, new String[0]));
                return;
            }
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(qnameNode);
            HashSet<String> propNames = new HashSet<String>();
            for (Node prop : init.children()) {
                String pname = NodeUtil.getObjectLitKeyName(prop);
                if (propNames.contains(pname)) {
                    GlobalTypeInfo.this.warnings.add(JSError.make(qnameNode, DUPLICATE_PROP_IN_ENUM, pname));
                }
                if (!GlobalTypeInfo.this.convention.isValidEnumKey(pname)) {
                    GlobalTypeInfo.this.warnings.add(JSError.make(prop, TypeCheck.ENUM_NOT_CONSTANT, pname));
                }
                propNames.add(pname);
            }
            this.currentScope.addEnum(qnameNode, EnumType.make(qnameNode.getQualifiedName(), jsdoc.getEnumParameterType(), (Collection<String>)ImmutableSet.copyOf(propNames)));
        }

        private void visitFunctionEarly(Node fn) {
            JSDocInfo fnDoc = NodeUtil.getFunctionJSDocInfo(fn);
            Node nameNode = NodeUtil.getFunctionNameNode(fn);
            String internalName = this.createFunctionInternalName(fn, nameNode);
            boolean isRedeclaration = nameNode == null || !nameNode.isQualifiedName() ? false : (nameNode.isName() ? this.currentScope.isDefinedLocally(nameNode.getString()) : this.currentScope.isDefined(nameNode));
            ArrayList<String> formals = this.collectFormals(fn, fnDoc);
            this.createFunctionScope(fn, formals, internalName);
            this.maybeRecordNominalType(fn, nameNode, fnDoc, isRedeclaration);
        }

        private String createFunctionInternalName(Node fn, Node nameNode) {
            String internalName = null;
            if (nameNode == null || !nameNode.isName()) {
                internalName = GlobalTypeInfo.ANON_FUN_PREFIX + GlobalTypeInfo.this.freshId;
                GlobalTypeInfo.this.anonFunNames.put(fn, internalName);
                GlobalTypeInfo.this.freshId++;
            } else if (this.currentScope.isDefinedLocally(nameNode.getString())) {
                String fnName = nameNode.getString();
                Preconditions.checkState((!fnName.contains(".") ? 1 : 0) != 0);
                internalName = GlobalTypeInfo.ANON_FUN_PREFIX + GlobalTypeInfo.this.freshId;
                GlobalTypeInfo.this.anonFunNames.put(fn, internalName);
                GlobalTypeInfo.this.freshId++;
            } else {
                internalName = nameNode.getString();
            }
            return internalName;
        }

        private void createFunctionScope(Node fn, ArrayList<String> formals, String internalName) {
            Scope fnScope = new Scope(fn, this.currentScope, formals, null);
            if (!fn.isFromExterns()) {
                GlobalTypeInfo.this.scopes.add(fnScope);
            }
            this.currentScope.addLocalFunDef(internalName, fnScope);
        }

        private ArrayList<String> collectFormals(Node fn, JSDocInfo fnDoc) {
            Preconditions.checkArgument((boolean)fn.isFunction());
            ArrayList<String> formals = new ArrayList<String>();
            ArrayList<String> tmpRestFormals = new ArrayList<String>();
            for (Node param = NodeUtil.getFunctionParameters(fn).getFirstChild(); param != null; param = param.getNext()) {
                if (JSTypeCreatorFromJSDoc.isRestArg(fnDoc, param.getString()) && param.getNext() == null) {
                    tmpRestFormals.add(param.getString());
                    continue;
                }
                formals.add(param.getString());
            }
            if (fnDoc != null) {
                for (String formalInJsdoc : fnDoc.getParameterNames()) {
                    if (formals.contains(formalInJsdoc) || tmpRestFormals.contains(formalInJsdoc)) continue;
                    String functionName = NodeUtil.getFunctionName(fn);
                    GlobalTypeInfo.this.warnings.add(JSError.make(fn, INEXISTENT_PARAM, formalInJsdoc, functionName));
                }
            }
            return formals;
        }

        private void maybeRecordNominalType(Node fn, Node nameNode, JSDocInfo fnDoc, boolean isRedeclaration) {
            if (fnDoc != null && (fnDoc.isConstructor() || fnDoc.isInterface())) {
                QualifiedName qname = QualifiedName.fromNode(nameNode);
                if (qname == null) {
                    GlobalTypeInfo.this.warnings.add(JSError.make(fn, ANONYMOUS_NOMINAL_TYPE, new String[0]));
                    return;
                }
                ImmutableList<String> typeParameters = fnDoc.getTemplateTypeNames();
                NominalType.RawNominalType rawNominalType = fnDoc.isInterface() ? NominalType.RawNominalType.makeInterface(qname, typeParameters) : (fnDoc.makesStructs() ? NominalType.RawNominalType.makeStructClass(qname, typeParameters) : (fnDoc.makesDicts() ? NominalType.RawNominalType.makeDictClass(qname, typeParameters) : NominalType.RawNominalType.makeUnrestrictedClass(qname, typeParameters)));
                GlobalTypeInfo.this.nominaltypesByNode.put(fn, rawNominalType);
                if (isRedeclaration) {
                    return;
                }
                if (nameNode.isName() || this.currentScope.isNamespace(nameNode.getFirstChild())) {
                    if (nameNode.isGetProp()) {
                        fn.getParent().getFirstChild().putBooleanProp(75, true);
                    } else if (this.currentScope.isTopLevel()) {
                        this.maybeRecordBuiltinType(nameNode.getString(), rawNominalType);
                    }
                    this.currentScope.addNominalType(nameNode, rawNominalType);
                }
            } else if (fnDoc != null) {
                if (fnDoc.makesStructs()) {
                    GlobalTypeInfo.this.warnings.add(JSError.make(fn, STRUCTDICT_WITHOUT_CTOR, "@struct"));
                } else if (fnDoc.makesDicts()) {
                    GlobalTypeInfo.this.warnings.add(JSError.make(fn, STRUCTDICT_WITHOUT_CTOR, "@dict"));
                }
            }
        }

        private void maybeRecordBuiltinType(String name, NominalType.RawNominalType rawNominalType) {
            switch (name) {
                case "Function": {
                    GlobalTypeInfo.this.commonTypes.setFunctionType(rawNominalType);
                    break;
                }
                case "Object": {
                    GlobalTypeInfo.this.commonTypes.setObjectType(rawNominalType);
                    break;
                }
                case "Number": {
                    GlobalTypeInfo.this.commonTypes.setNumberInstance(rawNominalType.getInstanceAsJSType());
                    break;
                }
                case "String": {
                    GlobalTypeInfo.this.commonTypes.setStringInstance(rawNominalType.getInstanceAsJSType());
                    break;
                }
                case "Boolean": {
                    GlobalTypeInfo.this.commonTypes.setBooleanInstance(rawNominalType.getInstanceAsJSType());
                    break;
                }
                case "RegExp": {
                    GlobalTypeInfo.this.commonTypes.setRegexpInstance(rawNominalType.getInstanceAsJSType());
                    break;
                }
                case "Array": {
                    GlobalTypeInfo.this.commonTypes.setArrayType(rawNominalType);
                }
            }
        }

        private void maybeRecordAliasedNominalType(Node nameNode) {
            Preconditions.checkArgument((boolean)nameNode.isQualifiedName());
            Node aliasedDef = nameNode.getParent();
            Preconditions.checkState((aliasedDef.isVar() || aliasedDef.isAssign() ? 1 : 0) != 0);
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(aliasedDef);
            Node init = NodeUtil.getInitializer(nameNode);
            NominalType.RawNominalType rawType = this.currentScope.getNominalType(QualifiedName.fromNode(init));
            String initQname = init.getQualifiedName();
            if (jsdoc.isConstructor()) {
                if (rawType == null || rawType.isInterface()) {
                    GlobalTypeInfo.this.warnings.add(JSError.make(init, EXPECTED_CONSTRUCTOR, initQname));
                    return;
                }
            } else if (jsdoc.isInterface() && (rawType == null || !rawType.isInterface())) {
                GlobalTypeInfo.this.warnings.add(JSError.make(init, EXPECTED_INTERFACE, initQname));
                return;
            }
            this.currentScope.addNominalType(nameNode, rawType);
        }
    }
}

