/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.lint;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.HashSet;

public final class CheckEnums
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    public static final DiagnosticType DUPLICATE_ENUM_VALUE = DiagnosticType.warning("JSC_DUPLICATE_ENUM_VALUE", "The value {0} is duplicated in this enum.");
    private final AbstractCompiler compiler;

    public CheckEnums(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        JSDocInfo jsdoc;
        if (n.isObjectLit() && (jsdoc = NodeUtil.getBestJSDocInfo(n)) != null && jsdoc.hasEnumParameterType()) {
            this.checkDuplicateEnumValues(t, n);
        }
    }

    private void checkDuplicateEnumValues(NodeTraversal t, Node n) {
        HashSet<String> values = new HashSet<String>();
        for (Node child : n.children()) {
            String value;
            Node valueNode = child.getFirstChild();
            if (valueNode.isString()) {
                value = valueNode.getString();
            } else if (valueNode.isNumber()) {
                value = Double.toString(valueNode.getDouble());
            } else {
                return;
            }
            if (values.contains(value)) {
                t.report(valueNode, DUPLICATE_ENUM_VALUE, value);
                continue;
            }
            values.add(value);
        }
    }
}

