/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.newtypes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.newtypes.DeclaredTypeRegistry;
import com.google.javascript.jscomp.newtypes.EnumType;
import com.google.javascript.jscomp.newtypes.FunctionType;
import com.google.javascript.jscomp.newtypes.FunctionTypeBuilder;
import com.google.javascript.jscomp.newtypes.JSType;
import com.google.javascript.jscomp.newtypes.JSTypes;
import com.google.javascript.jscomp.newtypes.NominalType;
import com.google.javascript.jscomp.newtypes.ObjectType;
import com.google.javascript.jscomp.newtypes.Typedef;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JSTypeCreatorFromJSDoc {
    public static final DiagnosticType INVALID_GENERICS_INSTANTIATION = DiagnosticType.warning("JSC_INVALID_GENERICS_INSTANTIATION", "Invalid generics instantiation for {0}.\nExpected {1} type argument(s), but found {2}.");
    public static final DiagnosticType BAD_JSDOC_ANNOTATION = DiagnosticType.warning("JSC_BAD_JSDOC_ANNOTATION", "Bad JSDoc annotation. {0}");
    private final CodingConvention convention;
    private int howmanyTypeVars = 0;
    private static final JSType OBJECT_OR_NULL = JSType.join(JSType.TOP_OBJECT, JSType.NULL);
    private Set<JSError> warnings = new HashSet<JSError>();
    private Map<Node, String> unknownTypeNames = new HashMap<Node, String>();
    private JSType qmarkFunctionOrNull = null;

    public JSTypeCreatorFromJSDoc(CodingConvention convention) {
        this.convention = convention;
    }

    private JSType getQmarkFunctionOrNull(JSTypes commonTypes) {
        if (this.qmarkFunctionOrNull == null) {
            this.qmarkFunctionOrNull = JSType.join(commonTypes.qmarkFunction(), JSType.NULL);
        }
        return this.qmarkFunctionOrNull;
    }

    public JSType getNodeTypeDeclaration(JSDocInfo jsdoc, NominalType.RawNominalType ownerType, DeclaredTypeRegistry registry) {
        return this.getNodeTypeDeclaration(jsdoc, ownerType, registry, null);
    }

    private JSType getNodeTypeDeclaration(JSDocInfo jsdoc, NominalType.RawNominalType ownerType, DeclaredTypeRegistry registry, ImmutableList<String> typeParameters) {
        if (jsdoc == null) {
            return null;
        }
        return this.getTypeFromJSTypeExpression(jsdoc.getType(), ownerType, registry, typeParameters);
    }

    public Set<JSError> getWarnings() {
        return this.warnings;
    }

    public Map<Node, String> getUnknownTypesMap() {
        return this.unknownTypeNames;
    }

    private JSType getTypeFromJSTypeExpression(JSTypeExpression expr, NominalType.RawNominalType ownerType, DeclaredTypeRegistry registry, ImmutableList<String> typeParameters) {
        if (expr == null) {
            return null;
        }
        JSType result = this.getTypeFromNode(expr.getRoot(), ownerType, registry, typeParameters);
        return result;
    }

    @VisibleForTesting
    JSType getTypeFromNode(Node n, NominalType.RawNominalType ownerType, DeclaredTypeRegistry registry, ImmutableList<String> typeParameters) {
        try {
            return this.getTypeFromNodeHelper(n, ownerType, registry, typeParameters);
        }
        catch (UnknownTypeException e) {
            return JSType.UNKNOWN;
        }
    }

    private JSType getTypeFromNodeHelper(Node n, NominalType.RawNominalType ownerType, DeclaredTypeRegistry registry, ImmutableList<String> typeParameters) throws UnknownTypeException {
        Preconditions.checkNotNull((Object)n);
        switch (n.getType()) {
            case 309: {
                return this.getRecordTypeHelper(n, ownerType, registry, typeParameters);
            }
            case 124: {
                return JSType.UNKNOWN;
            }
            case 122: {
                return JSType.UNDEFINED;
            }
            case 308: {
                this.warn("The [] type syntax is no longer supported. Please use Array.<T> instead.", n);
                return JSType.UNKNOWN;
            }
            case 40: {
                return this.getNamedTypeHelper(n, ownerType, registry, typeParameters);
            }
            case 301: {
                JSType union = JSType.BOTTOM;
                for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
                    union = JSType.join(union, this.getTypeFromNodeHelper(child, ownerType, registry, typeParameters));
                }
                return union;
            }
            case 306: {
                return this.getTypeFromNodeHelper(n.getFirstChild(), ownerType, registry, typeParameters).removeType(JSType.NULL);
            }
            case 304: {
                Node child = n.getFirstChild();
                if (child == null) {
                    return JSType.UNKNOWN;
                }
                return JSType.join(JSType.NULL, this.getTypeFromNodeHelper(child, ownerType, registry, typeParameters));
            }
            case 302: {
                return JSType.TOP;
            }
            case 105: {
                return this.getFunTypeHelper(n, ownerType, registry, typeParameters);
            }
        }
        throw new IllegalArgumentException("Unsupported type exp: " + Token.name(n.getType()) + " " + n.toStringTree());
    }

    private JSType getRecordTypeHelper(Node n, NominalType.RawNominalType ownerType, DeclaredTypeRegistry registry, ImmutableList<String> typeParameters) throws UnknownTypeException {
        HashMap<String, JSType> fields = new HashMap<String, JSType>();
        for (Node fieldTypeNode = n.getFirstChild().getFirstChild(); fieldTypeNode != null; fieldTypeNode = fieldTypeNode.getNext()) {
            boolean isFieldTypeDeclared = fieldTypeNode.getType() == 310;
            Node fieldNameNode = isFieldTypeDeclared ? fieldTypeNode.getFirstChild() : fieldTypeNode;
            String fieldName = fieldNameNode.getString();
            if (fieldName.startsWith("'") || fieldName.startsWith("\"")) {
                fieldName = fieldName.substring(1, fieldName.length() - 1);
            }
            JSType fieldType = !isFieldTypeDeclared ? JSType.UNKNOWN : this.getTypeFromNodeHelper(fieldTypeNode.getLastChild(), ownerType, registry, typeParameters);
            fields.put(fieldName, fieldType);
        }
        return JSType.fromObjectType(ObjectType.fromProperties(fields));
    }

    private static boolean isNonnullAndContains(ImmutableList<String> collection, String str) {
        return collection != null && collection.contains((Object)str);
    }

    private static boolean hasTypeVariable(ImmutableList<String> typeParameters, NominalType.RawNominalType ownerType, String typeName) {
        return JSTypeCreatorFromJSDoc.isNonnullAndContains(typeParameters, typeName) || ownerType != null && JSTypeCreatorFromJSDoc.isNonnullAndContains(ownerType.getTypeParameters(), typeName);
    }

    private JSType getNamedTypeHelper(Node n, NominalType.RawNominalType ownerType, DeclaredTypeRegistry registry, ImmutableList<String> outerTypeParameters) throws UnknownTypeException {
        String typeName;
        switch (typeName = n.getString()) {
            case "boolean": {
                return JSType.BOOLEAN;
            }
            case "null": {
                return JSType.NULL;
            }
            case "number": {
                return JSType.NUMBER;
            }
            case "string": {
                return JSType.STRING;
            }
            case "undefined": 
            case "void": {
                return JSType.UNDEFINED;
            }
            case "Function": {
                return this.getQmarkFunctionOrNull(registry.getCommonTypes());
            }
            case "Object": {
                return OBJECT_OR_NULL;
            }
        }
        if (JSTypeCreatorFromJSDoc.hasTypeVariable(outerTypeParameters, ownerType, typeName)) {
            return JSType.fromTypeVar(typeName);
        }
        Typedef td = registry.getTypedef(typeName);
        if (td != null) {
            return this.getTypedefType(td, registry);
        }
        EnumType e = registry.getEnum(typeName);
        if (e != null) {
            return this.getEnumPropType(e, registry);
        }
        JSType namedType = registry.lookupTypeByName(typeName);
        if (namedType == null) {
            this.unknownTypeNames.put(n, typeName);
            throw new UnknownTypeException("Unhandled type: " + typeName);
        }
        if (namedType.isTypeVariable()) {
            ++this.howmanyTypeVars;
            return namedType;
        }
        if (namedType.isUnknown()) {
            return namedType;
        }
        return this.getNominalTypeHelper(namedType, n, ownerType, registry, outerTypeParameters);
    }

    private JSType getTypedefType(Typedef td, DeclaredTypeRegistry registry) {
        this.resolveTypedef(td, registry);
        return td.getType();
    }

    public void resolveTypedef(Typedef td, DeclaredTypeRegistry registry) {
        JSType tdType;
        Preconditions.checkState((td != null ? 1 : 0) != 0, (Object)"getTypedef should only be called when we know that the typedef is defined");
        if (td.isResolved()) {
            return;
        }
        JSTypeExpression texp = td.getTypeExpr();
        if (texp == null) {
            this.warn("Circular type definitions are not allowed.", td.getTypeExprForErrorReporting().getRoot());
            tdType = JSType.UNKNOWN;
        } else {
            tdType = this.getTypeFromJSTypeExpression(texp, null, registry, null);
        }
        td.resolveTypedef(tdType);
    }

    private JSType getEnumPropType(EnumType e, DeclaredTypeRegistry registry) {
        this.resolveEnum(e, registry);
        return e.getPropType();
    }

    public void resolveEnum(EnumType e, DeclaredTypeRegistry registry) {
        JSType enumeratedType;
        Preconditions.checkState((e != null ? 1 : 0) != 0, (Object)"getEnum should only be called when we know that the enum is defined");
        if (e.isResolved()) {
            return;
        }
        JSTypeExpression texp = e.getTypeExpr();
        if (texp == null) {
            this.warn("Circular type definitions are not allowed.", e.getTypeExprForErrorReporting().getRoot());
            enumeratedType = JSType.UNKNOWN;
        } else {
            int numTypeVars = this.howmanyTypeVars;
            enumeratedType = this.getTypeFromJSTypeExpression(texp, null, registry, null);
            if (this.howmanyTypeVars > numTypeVars) {
                this.warn("An enum type cannot include type variables.", texp.getRoot());
                enumeratedType = JSType.UNKNOWN;
                this.howmanyTypeVars = numTypeVars;
            } else if (enumeratedType.isTop()) {
                this.warn("An enum type cannot be *. Use ? if you do not want the elements checked.", texp.getRoot());
                enumeratedType = JSType.UNKNOWN;
            } else if (enumeratedType.isUnion()) {
                this.warn("An enum type cannot be a union type.", texp.getRoot());
                enumeratedType = JSType.UNKNOWN;
            }
        }
        e.resolveEnum(enumeratedType);
    }

    private JSType getNominalTypeHelper(JSType namedType, Node n, NominalType.RawNominalType ownerType, DeclaredTypeRegistry registry, ImmutableList<String> outerTypeParameters) throws UnknownTypeException {
        int typeParamsSize;
        NominalType uninstantiated = namedType.getNominalTypeIfUnique();
        NominalType.RawNominalType rawType = uninstantiated.getRawNominalType();
        if (!rawType.isGeneric() && !n.hasChildren()) {
            return rawType.getInstanceAsNullableJSType();
        }
        ImmutableList.Builder typeList = ImmutableList.builder();
        if (n.hasChildren()) {
            Preconditions.checkState((boolean)n.getFirstChild().isBlock());
            for (Node child : n.getFirstChild().children()) {
                JSType childType = this.getTypeFromNodeHelper(child, ownerType, registry, outerTypeParameters);
                typeList.add((Object)childType);
            }
        }
        ImmutableList typeArguments = typeList.build();
        ImmutableList<String> typeParameters = rawType.getTypeParameters();
        int typeArgsSize = typeArguments.size();
        if (typeArgsSize != (typeParamsSize = typeParameters.size())) {
            String nominalTypeName = uninstantiated.getName();
            if (!nominalTypeName.equals("Object")) {
                this.warnings.add(JSError.make(n, INVALID_GENERICS_INSTANTIATION, nominalTypeName, String.valueOf(typeParamsSize), String.valueOf(typeArgsSize)));
            }
            return JSType.join(JSType.NULL, JSType.fromObjectType(ObjectType.fromNominalType(uninstantiated.instantiateGenerics(JSTypeCreatorFromJSDoc.fixLengthOfTypeList(typeParameters.size(), (List<JSType>)typeArguments)))));
        }
        return JSType.join(JSType.NULL, JSType.fromObjectType(ObjectType.fromNominalType(uninstantiated.instantiateGenerics((List<JSType>)typeArguments))));
    }

    private static List<JSType> fixLengthOfTypeList(int desiredLength, List<JSType> typeList) {
        int length = typeList.size();
        if (length == desiredLength) {
            return typeList;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < desiredLength; ++i) {
            builder.add((Object)(i < length ? typeList.get(i) : JSType.UNKNOWN));
        }
        return builder.build();
    }

    private JSType getFunTypeHelper(Node jsdocNode, NominalType.RawNominalType ownerType, DeclaredTypeRegistry registry, ImmutableList<String> typeParameters) throws UnknownTypeException {
        FunctionType funType = this.getFunTypeBuilder(jsdocNode, ownerType, registry, typeParameters).buildFunction();
        return registry.getCommonTypes().fromFunctionType(funType);
    }

    private FunctionTypeBuilder getFunTypeBuilder(Node jsdocNode, NominalType.RawNominalType ownerType, DeclaredTypeRegistry registry, ImmutableList<String> typeParameters) throws UnknownTypeException {
        FunctionTypeBuilder builder = new FunctionTypeBuilder();
        Node child = jsdocNode.getFirstChild();
        if (child.getType() == 42) {
            builder.addReceiverType(this.getNominalType(child.getFirstChild(), ownerType, registry, typeParameters));
            child = child.getNext();
        } else if (child.getType() == 30) {
            builder.addNominalType(this.getNominalType(child.getFirstChild(), ownerType, registry, typeParameters));
            child = child.getNext();
        }
        if (child.getType() == 83) {
            for (Node arg = child.getFirstChild(); arg != null; arg = arg.getNext()) {
                try {
                    switch (arg.getType()) {
                        case 307: {
                            builder.addOptFormal(this.getTypeFromNodeHelper(arg.getFirstChild(), ownerType, registry, typeParameters));
                            break;
                        }
                        case 305: {
                            Node restNode = arg.getFirstChild();
                            builder.addRestFormals(restNode == null ? JSType.UNKNOWN : this.getTypeFromNodeHelper(restNode, ownerType, registry, typeParameters));
                            break;
                        }
                        default: {
                            builder.addReqFormal(this.getTypeFromNodeHelper(arg, ownerType, registry, typeParameters));
                            break;
                        }
                    }
                    continue;
                }
                catch (FunctionTypeBuilder.WrongParameterOrderException e) {
                    this.warn("Wrong parameter order: required parameters are first, then optional, then varargs", jsdocNode);
                }
            }
            child = child.getNext();
        }
        builder.addRetType(this.getTypeFromNodeHelper(child, ownerType, registry, typeParameters));
        return builder;
    }

    public boolean hasKnownType(Node n, NominalType.RawNominalType ownerType, DeclaredTypeRegistry registry, ImmutableList<String> typeParameters) {
        try {
            this.getTypeFromNodeHelper(n, ownerType, registry, typeParameters);
        }
        catch (UnknownTypeException e) {
            return false;
        }
        return true;
    }

    public NominalType getNominalType(Node n, NominalType.RawNominalType ownerType, DeclaredTypeRegistry registry, ImmutableList<String> typeParameters) {
        JSType wrappedClass = this.getTypeFromNode(n, ownerType, registry, typeParameters);
        if (wrappedClass == null) {
            return null;
        }
        return wrappedClass.getNominalTypeIfUnique();
    }

    public ImmutableSet<NominalType> getImplementedInterfaces(JSDocInfo jsdoc, NominalType.RawNominalType ownerType, DeclaredTypeRegistry registry, ImmutableList<String> typeParameters) {
        return this.getInterfacesHelper(jsdoc, ownerType, registry, typeParameters, true);
    }

    public ImmutableSet<NominalType> getExtendedInterfaces(JSDocInfo jsdoc, NominalType.RawNominalType ownerType, DeclaredTypeRegistry registry, ImmutableList<String> typeParameters) {
        return this.getInterfacesHelper(jsdoc, ownerType, registry, typeParameters, false);
    }

    private ImmutableSet<NominalType> getInterfacesHelper(JSDocInfo jsdoc, NominalType.RawNominalType ownerType, DeclaredTypeRegistry registry, ImmutableList<String> typeParameters, boolean implementedIntfs) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (JSTypeExpression texp : implementedIntfs ? jsdoc.getImplementedInterfaces() : jsdoc.getExtendedInterfaces()) {
            Node expRoot = texp.getRoot();
            if (!this.hasKnownType(expRoot, ownerType, registry, typeParameters)) continue;
            NominalType nt = this.getNominalType(expRoot, ownerType, registry, typeParameters);
            if (nt != null && nt.isInterface()) {
                builder.add((Object)nt);
                continue;
            }
            String errorMsg = implementedIntfs ? "Cannot implement non-interface" : "Cannot extend non-interface";
            this.warn(errorMsg, jsdoc.getAssociatedNode());
        }
        return builder.build();
    }

    private static boolean isQmarkFunction(Node jsdocNode) {
        if (jsdocNode.getType() == 306) {
            jsdocNode = jsdocNode.getFirstChild();
        }
        return jsdocNode.isString() && jsdocNode.getString().equals("Function");
    }

    public FunctionTypeBuilder getFunctionType(JSDocInfo jsdoc, Node declNode, NominalType.RawNominalType ownerType, DeclaredTypeRegistry registry) {
        try {
            if (jsdoc != null && jsdoc.getType() != null) {
                Node jsdocNode = jsdoc.getType().getRoot();
                int tokenType = jsdocNode.getType();
                if (tokenType == 105) {
                    if (declNode.isFunction()) {
                        return this.getFunTypeFromAtTypeJsdoc(jsdoc, declNode, ownerType, registry);
                    }
                    try {
                        return this.getFunTypeBuilder(jsdocNode, ownerType, registry, null);
                    }
                    catch (UnknownTypeException e) {
                        return FunctionTypeBuilder.qmarkFunctionBuilder();
                    }
                }
                if (JSTypeCreatorFromJSDoc.isQmarkFunction(jsdocNode)) {
                    return FunctionTypeBuilder.qmarkFunctionBuilder();
                }
                this.warn("The function is annotated with a non-function jsdoc. Ignoring jsdoc.", declNode);
            }
            return this.getFunTypeFromTypicalFunctionJsdoc(jsdoc, declNode, ownerType, registry, false);
        }
        catch (FunctionTypeBuilder.WrongParameterOrderException e) {
            this.warn("Wrong parameter order: required parameters are first, then optional, then varargs. Ignoring jsdoc.", declNode);
            return FunctionTypeBuilder.qmarkFunctionBuilder();
        }
    }

    private FunctionTypeBuilder getFunTypeFromAtTypeJsdoc(JSDocInfo jsdoc, Node funNode, NominalType.RawNominalType ownerType, DeclaredTypeRegistry registry) {
        Node paramType;
        Preconditions.checkArgument((boolean)funNode.isFunction());
        FunctionTypeBuilder builder = new FunctionTypeBuilder();
        Node childJsdoc = jsdoc.getType().getRoot().getFirstChild();
        Node param = funNode.getFirstChild().getNext().getFirstChild();
        boolean warnedForMissingTypes = false;
        boolean warnedForInlineJsdoc = false;
        if (childJsdoc.getType() == 42) {
            builder.addReceiverType(this.getNominalType(childJsdoc.getFirstChild(), ownerType, registry, null));
            childJsdoc = childJsdoc.getNext();
        } else if (childJsdoc.getType() == 30) {
            builder.addNominalType(this.getNominalType(childJsdoc.getFirstChild(), ownerType, registry, null));
            childJsdoc = childJsdoc.getNext();
        }
        if (childJsdoc.getType() == 83) {
            paramType = childJsdoc.getFirstChild();
            childJsdoc = childJsdoc.getNext();
        } else {
            paramType = null;
        }
        while (param != null) {
            if (paramType == null) {
                if (!warnedForMissingTypes) {
                    this.warn("The function has more formal parameters than the types declared in the JSDoc", funNode);
                    warnedForMissingTypes = true;
                }
                builder.addOptFormal(JSType.UNKNOWN);
            } else {
                if (!warnedForInlineJsdoc && param.getJSDocInfo() != null) {
                    this.warn("The function cannot have both an @type jsdoc and inline jsdocs. Ignoring inline jsdocs.", param);
                    warnedForInlineJsdoc = true;
                }
                switch (paramType.getType()) {
                    case 307: {
                        builder.addOptFormal(this.getTypeFromNode(paramType.getFirstChild(), ownerType, registry, null));
                        break;
                    }
                    case 305: {
                        if (warnedForMissingTypes) break;
                        this.warn("The function has more formal parameters than the types declared in the JSDoc", funNode);
                        warnedForMissingTypes = true;
                        builder.addOptFormal(JSType.UNKNOWN);
                        break;
                    }
                    default: {
                        builder.addReqFormal(this.getTypeFromNode(paramType, ownerType, registry, null));
                    }
                }
                paramType = paramType.getNext();
            }
            param = param.getNext();
        }
        if (paramType != null) {
            if (paramType.getType() == 305) {
                builder.addRestFormals(this.getTypeFromNode(paramType.getFirstChild(), ownerType, registry, null));
            } else {
                this.warn("The function has fewer formal parameters than the types declared in the JSDoc", funNode);
            }
        }
        if (!warnedForInlineJsdoc && funNode.getFirstChild().getJSDocInfo() != null) {
            this.warn("The function cannot have both an @type jsdoc and inline jsdocs. Ignoring the inline return jsdoc.", funNode);
        }
        if (jsdoc.getReturnType() != null) {
            this.warn("The function cannot have both an @type jsdoc and @return jsdoc. Ignoring @return jsdoc.", funNode);
        }
        if (funNode.getParent().isSetterDef()) {
            if (childJsdoc != null) {
                this.warn("Cannot declare a return type on a setter", funNode);
            }
            builder.addRetType(JSType.UNDEFINED);
        } else {
            builder.addRetType(this.getTypeFromNode(childJsdoc, ownerType, registry, null));
        }
        return builder;
    }

    private FunctionTypeBuilder getFunTypeFromTypicalFunctionJsdoc(JSDocInfo jsdoc, Node funNode, NominalType.RawNominalType ownerType, DeclaredTypeRegistry registry, boolean ignoreJsdoc) {
        JSTypeExpression retTypeExp;
        Preconditions.checkArgument((!ignoreJsdoc || jsdoc == null ? 1 : 0) != 0);
        Preconditions.checkArgument((!ignoreJsdoc || funNode.isFunction() ? 1 : 0) != 0);
        boolean ignoreFunNode = !funNode.isFunction();
        FunctionTypeBuilder builder = new FunctionTypeBuilder();
        Node params = ignoreFunNode ? null : funNode.getFirstChild().getNext();
        ImmutableList<String> typeParameters = null;
        Node parent = funNode.getParent();
        if (jsdoc != null && !(typeParameters = jsdoc.getTemplateTypeNames()).isEmpty()) {
            if (parent.isSetterDef() || parent.isGetterDef()) {
                ignoreJsdoc = true;
                jsdoc = null;
                this.warn("@template can't be used with getters/setters", funNode);
            } else {
                builder.addTypeParameters(typeParameters);
            }
        }
        ParamIterator iterator = new ParamIterator(params, jsdoc);
        while (iterator.hasNext()) {
            Node jsdocNode;
            String pname = iterator.nextString();
            Node param = iterator.getNode();
            JSType inlineParamType = ignoreJsdoc || ignoreFunNode ? null : this.getNodeTypeDeclaration(param.getJSDocInfo(), ownerType, registry, typeParameters);
            boolean isRequired = true;
            boolean isRestFormals = false;
            JSTypeExpression texp = jsdoc == null ? null : jsdoc.getParameterType(pname);
            Node node = jsdocNode = texp == null ? null : texp.getRoot();
            if (param != null) {
                if (this.convention.isOptionalParameter(param)) {
                    isRequired = false;
                } else if (this.convention.isVarArgsParameter(param)) {
                    isRequired = false;
                    isRestFormals = true;
                }
            }
            JSType fnParamType = null;
            if (jsdocNode != null) {
                if (jsdocNode.getType() == 307) {
                    isRequired = false;
                    jsdocNode = jsdocNode.getFirstChild();
                } else if (jsdocNode.getType() == 305) {
                    isRequired = false;
                    isRestFormals = true;
                    jsdocNode = jsdocNode.getFirstChild();
                }
                fnParamType = this.getTypeFromNode(jsdocNode, ownerType, registry, typeParameters);
            }
            if (inlineParamType != null) {
                builder.addReqFormal(inlineParamType);
                if (fnParamType == null) continue;
                this.warn("Found two JsDoc comments for formal parameter " + pname, param);
                continue;
            }
            if (isRequired) {
                builder.addReqFormal(fnParamType);
                continue;
            }
            if (isRestFormals) {
                builder.addRestFormals(fnParamType == null ? JSType.UNKNOWN : fnParamType);
                continue;
            }
            builder.addOptFormal(fnParamType);
        }
        JSDocInfo inlineRetJsdoc = ignoreJsdoc ? null : funNode.getFirstChild().getJSDocInfo();
        JSTypeExpression jSTypeExpression = retTypeExp = jsdoc == null ? null : jsdoc.getReturnType();
        if (parent.isSetterDef()) {
            JSDocInfo jSDocInfo = inlineRetJsdoc = ignoreJsdoc ? null : funNode.getLastChild().getJSDocInfo();
            if (retTypeExp != null || inlineRetJsdoc != null) {
                this.warn("Cannot declare a return type on a setter", funNode);
            }
            builder.addRetType(JSType.UNDEFINED);
        } else if (inlineRetJsdoc != null) {
            builder.addRetType(this.getNodeTypeDeclaration(inlineRetJsdoc, ownerType, registry, typeParameters));
            if (retTypeExp != null) {
                this.warn("Found two JsDoc comments for the return type", funNode);
            }
        } else {
            builder.addRetType(this.getTypeFromJSTypeExpression(retTypeExp, ownerType, registry, typeParameters));
        }
        return builder;
    }

    public static boolean isRestArg(JSDocInfo funJsdoc, String formalParamName) {
        if (funJsdoc == null) {
            return false;
        }
        JSTypeExpression texp = funJsdoc.getParameterType(formalParamName);
        Node jsdocNode = texp == null ? null : texp.getRoot();
        return jsdocNode != null && jsdocNode.getType() == 305;
    }

    void warn(String msg, Node faultyNode) {
        this.warnings.add(JSError.make(faultyNode, BAD_JSDOC_ANNOTATION, msg));
    }

    private static class ParamIterator {
        Iterator<String> paramNames;
        Node params;
        int index = -1;

        ParamIterator(Node params, JSDocInfo jsdoc) {
            Preconditions.checkArgument((params != null || jsdoc != null ? 1 : 0) != 0);
            if (params != null) {
                this.params = params;
                this.paramNames = null;
            } else {
                this.params = null;
                this.paramNames = jsdoc.getParameterNames().iterator();
            }
        }

        boolean hasNext() {
            if (this.paramNames != null) {
                return this.paramNames.hasNext();
            }
            return this.index + 1 < this.params.getChildCount();
        }

        String nextString() {
            if (this.paramNames != null) {
                return this.paramNames.next();
            }
            ++this.index;
            return this.params.getChildAtIndex(this.index).getString();
        }

        Node getNode() {
            if (this.paramNames != null) {
                return null;
            }
            return this.params.getChildAtIndex(this.index);
        }
    }

    public static class UnknownTypeException
    extends Exception {
        UnknownTypeException(String cause) {
            super(cause);
        }
    }
}

