/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.refactoring;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.DependencyOptions;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.refactoring.JsFlumeCallback;
import com.google.javascript.refactoring.Scanner;
import com.google.javascript.refactoring.SuggestedFix;
import com.google.javascript.rhino.Node;
import java.util.List;

public final class RefactoringDriver {
    private final Scanner scanner;
    private final Compiler compiler;
    private final Node rootNode;

    private RefactoringDriver(Scanner scanner, List<SourceFile> inputs, List<SourceFile> externs) {
        this.scanner = scanner;
        this.compiler = this.createCompiler(inputs, externs);
        this.rootNode = this.compiler.getRoot();
    }

    public List<SuggestedFix> drive() {
        JsFlumeCallback callback = new JsFlumeCallback(this.scanner, null);
        NodeTraversal.traverse(this.compiler, this.rootNode, callback);
        return callback.getFixes();
    }

    public Compiler getCompiler() {
        return this.compiler;
    }

    private Compiler createCompiler(List<SourceFile> inputs, List<SourceFile> externs) {
        CompilerOptions options = RefactoringDriver.getCompilerOptions();
        Compiler compiler = new Compiler();
        compiler.disableThreads();
        compiler.compile(externs, inputs, options);
        return compiler;
    }

    @VisibleForTesting
    static CompilerOptions getCompilerOptions() {
        CompilerOptions options = new CompilerOptions();
        DependencyOptions deps = new DependencyOptions();
        deps.setDependencySorting(true);
        options.setDependencyOptions(deps);
        options.ideMode = true;
        options.checkSuspiciousCode = true;
        options.checkSymbols = true;
        options.checkTypes = true;
        options.closurePass = true;
        options.preserveGoogRequires = true;
        options.setAcceptConstKeyword(true);
        return options;
    }

    public static class Builder {
        private static final Function<String, SourceFile> TO_SOURCE_FILE_FN = new Function<String, SourceFile>(){

            public SourceFile apply(String file) {
                return new SourceFile.Builder().buildFromFile(file);
            }
        };
        private final Scanner scanner;
        private final ImmutableList.Builder<SourceFile> inputs = ImmutableList.builder();
        private final ImmutableList.Builder<SourceFile> externs = ImmutableList.builder();

        public Builder(Scanner scanner) {
            this.scanner = scanner;
        }

        public Builder addExternsFromFile(String filename) {
            this.externs.add((Object)SourceFile.fromFile(filename));
            return this;
        }

        public Builder addExternsFromCode(String code) {
            this.externs.add((Object)SourceFile.fromCode("externs", code));
            return this;
        }

        public Builder addExterns(List<SourceFile> externs) {
            this.externs.addAll(externs);
            return this;
        }

        public Builder addExternsFromFile(List<String> externs) {
            this.externs.addAll((Iterable)Lists.transform(externs, TO_SOURCE_FILE_FN));
            return this;
        }

        public Builder addInputsFromFile(String filename) {
            this.inputs.add((Object)SourceFile.fromFile(filename));
            return this;
        }

        public Builder addInputsFromCode(String code) {
            this.inputs.add((Object)SourceFile.fromCode("input", code));
            return this;
        }

        public Builder addInputs(List<SourceFile> inputs) {
            this.inputs.addAll(inputs);
            return this;
        }

        public Builder addInputsFromFile(List<String> inputs) {
            this.inputs.addAll((Iterable)Lists.transform(inputs, TO_SOURCE_FILE_FN));
            return this;
        }

        public RefactoringDriver build() {
            return new RefactoringDriver(this.scanner, (List)this.inputs.build(), (List)this.externs.build());
        }
    }
}

