/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.Maps;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.DiagnosticType;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;

abstract class ES6ModuleLoader {
    static final String MODULE_SLASH = "/";
    static final String INDEX_FILE = "index.js";
    static final DiagnosticType LOAD_ERROR = DiagnosticType.error("JSC_ES6_MODULE_LOAD_ERROR", "Failed to load module \"{0}\"");

    ES6ModuleLoader() {
    }

    static boolean isRelativeIdentifier(String name) {
        return name.startsWith("./") || name.startsWith("../");
    }

    abstract String locate(String var1, CompilerInput var2);

    abstract CompilerInput load(String var1) throws LoadFailedException;

    abstract String getLoadAddress(CompilerInput var1);

    static ES6ModuleLoader createNaiveLoader(AbstractCompiler compiler, String moduleRoot) {
        return new NaiveModuleLoader(compiler, moduleRoot);
    }

    private static class NaiveModuleLoader
    extends ES6ModuleLoader {
        private final Map<String, CompilerInput> inputsByAddress = Maps.newHashMap();
        private final String moduleRoot;
        private final URI moduleRootURI;

        private NaiveModuleLoader(AbstractCompiler compiler, String moduleRoot) {
            this.moduleRoot = moduleRoot;
            this.moduleRootURI = NaiveModuleLoader.createUri(moduleRoot);
            for (CompilerInput input : compiler.getInputsInOrder()) {
                this.inputsByAddress.put(this.getLoadAddress(input), input);
            }
        }

        @Override
        String locate(String name, CompilerInput referrer) {
            URI base = NaiveModuleLoader.isRelativeIdentifier(name) ? NaiveModuleLoader.createUri(referrer) : this.moduleRootURI;
            return this.convertSourceUriToModuleAddress(base.resolve(NaiveModuleLoader.createUri(name)));
        }

        @Override
        CompilerInput load(String name) {
            return this.inputsByAddress.get(name);
        }

        @Override
        String getLoadAddress(CompilerInput input) {
            return this.convertSourceUriToModuleAddress(NaiveModuleLoader.createUri(input));
        }

        private static URI createUri(CompilerInput input) {
            return NaiveModuleLoader.createUri(input.getName().replace("\\", ES6ModuleLoader.MODULE_SLASH));
        }

        private static URI createUri(String uri) {
            try {
                return new URI(uri);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }

        private String resolveInFileSystem(String filename) {
            File index;
            File f = new File(filename);
            if (f.exists() && f.isDirectory() && (index = new File(f, ES6ModuleLoader.INDEX_FILE)).exists()) {
                return this.moduleRootURI.relativize(index.toURI()).getPath();
            }
            return filename;
        }

        private String convertSourceUriToModuleAddress(URI uri) {
            String filename = this.resolveInFileSystem(uri.normalize().toString());
            filename = filename.replace("\\", ES6ModuleLoader.MODULE_SLASH);
            if (!this.moduleRoot.isEmpty() && filename.indexOf(this.moduleRoot) == 0) {
                filename = filename.substring(this.moduleRoot.length());
            }
            return filename;
        }
    }

    static class LoadFailedException
    extends Exception {
        LoadFailedException() {
        }
    }
}

