/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.ClosureCodingConvention;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CodingConventions;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.StaticSourceFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GoogleCodingConvention
extends CodingConventions.Proxy {
    private static final long serialVersionUID = 1L;
    private static final String OPTIONAL_ARG_PREFIX = "opt_";
    private static final String VAR_ARGS_NAME = "var_args";
    private static final Pattern ENUM_KEY_PATTERN = Pattern.compile("[A-Z0-9][A-Z0-9_]*");
    private static final Pattern PACKAGE_WITH_TEST_DIR = Pattern.compile("^(.*)/(?:test|tests|testing)/(?:[^/]+)$");

    public GoogleCodingConvention() {
        this(new ClosureCodingConvention());
    }

    public GoogleCodingConvention(CodingConvention convention) {
        super(convention);
    }

    @Override
    public boolean isConstant(String name) {
        if (name.length() <= 1) {
            return false;
        }
        int pos = name.lastIndexOf(36);
        if (pos >= 0 && (name = name.substring(pos + 1)).isEmpty()) {
            return false;
        }
        return this.isConstantKey(name);
    }

    @Override
    public boolean isConstantKey(String name) {
        if (name.isEmpty() || !Character.isUpperCase(name.charAt(0))) {
            return false;
        }
        return name.toUpperCase().equals(name);
    }

    @Override
    public boolean isValidEnumKey(String key) {
        return ENUM_KEY_PATTERN.matcher(key).matches();
    }

    @Override
    public boolean isOptionalParameter(Node parameter) {
        return super.isOptionalParameter(parameter) || parameter.getString().startsWith(OPTIONAL_ARG_PREFIX);
    }

    @Override
    public boolean isVarArgsParameter(Node parameter) {
        return super.isVarArgsParameter(parameter) || VAR_ARGS_NAME.equals(parameter.getString());
    }

    @Override
    public boolean isExported(String name, boolean local) {
        return super.isExported(name, local) || !local && name.startsWith("_");
    }

    @Override
    public String getPackageName(StaticSourceFile source) {
        String name = source.getName();
        Matcher m = PACKAGE_WITH_TEST_DIR.matcher(name);
        if (m.find()) {
            return m.group(1);
        }
        int lastSlash = name.lastIndexOf(47);
        return lastSlash == -1 ? "" : name.substring(0, lastSlash);
    }

    @Override
    public boolean isPrivate(String name) {
        return name.endsWith("_") && !this.isExported(name);
    }
}

