/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.deps.DependencyInfo;
import com.google.javascript.jscomp.deps.SortedDependencies;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class JSModule
implements DependencyInfo,
Serializable {
    private static final long serialVersionUID = 1L;
    static final DiagnosticType CIRCULAR_DEPENDENCY_ERROR = DiagnosticType.error("JSC_CIRCULAR_DEP", "Circular dependency detected: {0}");
    private final String name;
    private final List<CompilerInput> inputs = new ArrayList<CompilerInput>();
    private final List<JSModule> deps = new ArrayList<JSModule>();
    private int depth;

    public JSModule(String name) {
        this.name = name;
        this.depth = -1;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public List<String> getProvides() {
        return ImmutableList.of((Object)this.name);
    }

    public List<String> getRequires() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (JSModule m : this.deps) {
            builder.add((Object)m.getName());
        }
        return builder.build();
    }

    @Override
    public String getPathRelativeToClosureBase() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isModule() {
        throw new UnsupportedOperationException();
    }

    public void add(SourceFile file) {
        this.add(new CompilerInput(file));
    }

    public void add(CompilerInput input) {
        this.inputs.add(input);
        input.setModule(this);
    }

    void addAndOverrideModule(CompilerInput input) {
        this.inputs.add(input);
        input.overrideModule(this);
    }

    public void addAfter(CompilerInput input, CompilerInput other) {
        Preconditions.checkState((boolean)this.inputs.contains(other));
        this.inputs.add(this.inputs.indexOf(other), input);
        input.setModule(this);
    }

    public void addDependency(JSModule dep) {
        Preconditions.checkNotNull((Object)dep);
        Preconditions.checkState((dep != this ? 1 : 0) != 0, (String)"Cannot add dependency on self", (Object[])new Object[]{this});
        this.deps.add(dep);
    }

    public void remove(CompilerInput input) {
        input.setModule(null);
        this.inputs.remove(input);
    }

    public void removeAll() {
        for (CompilerInput input : this.inputs) {
            input.setModule(null);
        }
        this.inputs.clear();
    }

    public List<JSModule> getDependencies() {
        return this.deps;
    }

    List<String> getSortedDependencyNames() {
        ArrayList names = Lists.newArrayList();
        for (JSModule module : this.getDependencies()) {
            names.add(module.getName());
        }
        Collections.sort(names);
        return names;
    }

    public Set<JSModule> getAllDependencies() {
        HashSet allDeps = Sets.newHashSet(this.deps);
        ArrayDeque stack = Queues.newArrayDeque(this.deps);
        while (!stack.isEmpty()) {
            JSModule module = (JSModule)stack.pop();
            for (JSModule dep : module.getDependencies()) {
                if (!allDeps.add(dep)) continue;
                stack.push(dep);
            }
        }
        return allDeps;
    }

    public Set<JSModule> getThisAndAllDependencies() {
        Set<JSModule> deps = this.getAllDependencies();
        deps.add(this);
        return deps;
    }

    public List<CompilerInput> getInputs() {
        return this.inputs;
    }

    public CompilerInput getByName(String name) {
        for (CompilerInput input : this.inputs) {
            if (!name.equals(input.getName())) continue;
            return input;
        }
        return null;
    }

    public boolean removeByName(String name) {
        boolean found = false;
        Iterator<CompilerInput> iter = this.inputs.iterator();
        while (iter.hasNext()) {
            CompilerInput file = iter.next();
            if (!name.equals(file.getName())) continue;
            iter.remove();
            file.setModule(null);
            found = true;
        }
        return found;
    }

    public String toString() {
        return this.name;
    }

    public void clearAsts() {
        for (CompilerInput input : this.inputs) {
            input.clearAst();
        }
    }

    public void sortInputsByDeps(Compiler compiler) {
        for (CompilerInput input : this.inputs) {
            input.setCompiler(compiler);
        }
        try {
            List<CompilerInput> sortedList = new SortedDependencies<CompilerInput>(Collections.unmodifiableList(this.inputs)).getSortedList();
            this.inputs.clear();
            this.inputs.addAll(sortedList);
        }
        catch (SortedDependencies.CircularDependencyException e) {
            compiler.report(JSError.make(CIRCULAR_DEPENDENCY_ERROR, e.getMessage()));
        }
    }

    public static JSModule[] sortJsModules(Collection<JSModule> modules) throws SortedDependencies.CircularDependencyException {
        List sortedList = new SortedDependencies(Lists.newArrayList(modules)).getSortedList();
        return sortedList.toArray(new JSModule[sortedList.size()]);
    }

    public void setDepth(int dep) {
        this.depth = dep;
    }

    public int getDepth() {
        return this.depth;
    }
}

