/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.DependencyOptions;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.deps.SortedDependencies;
import com.google.javascript.jscomp.graph.LinkedDirectedGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class JSModuleGraph {
    private List<JSModule> modules;
    private List<List<JSModule>> modulesByDepth;
    private Map<JSModule, Set<JSModule>> dependencyMap = Maps.newHashMap();

    public JSModuleGraph(JSModule[] modulesInDepOrder) {
        this((List<JSModule>)ImmutableList.copyOf((Object[])modulesInDepOrder));
    }

    public JSModuleGraph(List<JSModule> modulesInDepOrder) {
        Preconditions.checkState((modulesInDepOrder.size() == Sets.newHashSet(modulesInDepOrder).size() ? 1 : 0) != 0, (Object)"Found duplicate modules");
        this.modules = ImmutableList.copyOf(modulesInDepOrder);
        this.modulesByDepth = Lists.newArrayList();
        for (JSModule module : modulesInDepOrder) {
            int depth = 0;
            for (JSModule dep : module.getDependencies()) {
                int depDepth = dep.getDepth();
                if (depDepth < 0) {
                    throw new ModuleDependenceException(String.format("Modules not in dependency order: %s preceded %s", module.getName(), dep.getName()), module, dep);
                }
                depth = Math.max(depth, depDepth + 1);
            }
            module.setDepth(depth);
            if (depth == this.modulesByDepth.size()) {
                this.modulesByDepth.add(new ArrayList());
            }
            this.modulesByDepth.get(depth).add(module);
        }
    }

    Iterable<JSModule> getAllModules() {
        return this.modules;
    }

    Map<String, JSModule> getModulesByName() {
        HashMap result = Maps.newHashMap();
        for (JSModule m : this.modules) {
            result.put(m.getName(), m);
        }
        return result;
    }

    int getModuleCount() {
        return this.modules.size();
    }

    JSModule getRootModule() {
        return (JSModule)Iterables.getOnlyElement((Iterable)this.modulesByDepth.get(0));
    }

    JsonArray toJson() {
        JsonArray modules = new JsonArray();
        for (JSModule module : this.getAllModules()) {
            JsonObject node = new JsonObject();
            try {
                node.add("name", (JsonElement)new JsonPrimitive(module.getName()));
                JsonArray deps = new JsonArray();
                node.add("dependencies", (JsonElement)deps);
                for (JSModule jSModule : module.getDependencies()) {
                    deps.add((JsonElement)new JsonPrimitive(jSModule.getName()));
                }
                JsonArray transitiveDeps = new JsonArray();
                node.add("transitive-dependencies", (JsonElement)transitiveDeps);
                for (JSModule m3 : this.getTransitiveDepsDeepestFirst(module)) {
                    transitiveDeps.add((JsonElement)new JsonPrimitive(m3.getName()));
                }
                JsonArray jsonArray = new JsonArray();
                node.add("inputs", (JsonElement)jsonArray);
                for (CompilerInput input : module.getInputs()) {
                    jsonArray.add((JsonElement)new JsonPrimitive(input.getSourceFile().getOriginalPath()));
                }
                modules.add((JsonElement)node);
            }
            catch (JsonParseException e) {
                Throwables.propagate((Throwable)e);
            }
        }
        return modules;
    }

    public boolean dependsOn(JSModule src, JSModule m) {
        Set<JSModule> deps = this.dependencyMap.get(src);
        if (deps == null) {
            deps = this.getTransitiveDepsDeepestFirst(src);
            this.dependencyMap.put(src, deps);
        }
        return deps.contains(m);
    }

    JSModule getDeepestCommonDependency(JSModule m1, JSModule m2) {
        int m1Depth = m1.getDepth();
        int m2Depth = m2.getDepth();
        for (int depth = Math.min(m1Depth, m2Depth) - 1; depth >= 0; --depth) {
            List<JSModule> modulesAtDepth = this.modulesByDepth.get(depth);
            for (int i = modulesAtDepth.size() - 1; i >= 0; --i) {
                JSModule m = modulesAtDepth.get(i);
                if (!this.dependsOn(m1, m) || !this.dependsOn(m2, m)) continue;
                return m;
            }
        }
        return null;
    }

    public JSModule getDeepestCommonDependencyInclusive(JSModule m1, JSModule m2) {
        if (m2 == m1 || this.dependsOn(m2, m1)) {
            return m1;
        }
        if (this.dependsOn(m1, m2)) {
            return m2;
        }
        return this.getDeepestCommonDependency(m1, m2);
    }

    public JSModule getDeepestCommonDependencyInclusive(Collection<JSModule> modules) {
        Iterator<JSModule> iter = modules.iterator();
        JSModule dep = iter.next();
        while (iter.hasNext()) {
            dep = this.getDeepestCommonDependencyInclusive(dep, iter.next());
        }
        return dep;
    }

    Set<JSModule> getTransitiveDepsDeepestFirst(JSModule m) {
        Set<JSModule> deps = this.dependencyMap.get(m);
        if (deps != null) {
            return deps;
        }
        deps = new TreeSet<JSModule>(new InverseDepthComparator());
        JSModuleGraph.addDeps(deps, m);
        this.dependencyMap.put(m, deps);
        return deps;
    }

    private static void addDeps(Set<JSModule> deps, JSModule m) {
        for (JSModule dep : m.getDependencies()) {
            deps.add(dep);
            JSModuleGraph.addDeps(deps, dep);
        }
    }

    public void coalesceDuplicateFiles() {
        LinkedHashMultimap fileRefs = LinkedHashMultimap.create();
        for (JSModule module : this.modules) {
            for (CompilerInput jsFile : module.getInputs()) {
                fileRefs.put((Object)jsFile.getName(), (Object)module);
            }
        }
        for (String path : fileRefs.keySet()) {
            Collection refModules = fileRefs.get((Object)path);
            if (refModules.size() <= 1) continue;
            JSModule depModule = this.getDeepestCommonDependencyInclusive(refModules);
            CompilerInput file = ((JSModule)refModules.iterator().next()).getByName(path);
            for (JSModule module : refModules) {
                if (module == depModule) continue;
                module.removeByName(path);
            }
            if (refModules.contains(depModule)) continue;
            depModule.add(file);
        }
    }

    public List<CompilerInput> manageDependencies(List<String> entryPoints, List<CompilerInput> inputs) throws SortedDependencies.CircularDependencyException, MissingModuleException, SortedDependencies.MissingProvideException {
        DependencyOptions depOptions = new DependencyOptions();
        depOptions.setDependencySorting(true);
        depOptions.setDependencyPruning(true);
        depOptions.setEntryPoints(entryPoints);
        return this.manageDependencies(depOptions, inputs);
    }

    public List<CompilerInput> manageDependencies(DependencyOptions depOptions, List<CompilerInput> inputs) throws SortedDependencies.CircularDependencyException, SortedDependencies.MissingProvideException, MissingModuleException {
        JSModule module3;
        SortedDependencies<CompilerInput> sorter = new SortedDependencies<CompilerInput>(inputs);
        Collection<CompilerInput> entryPointInputs = this.createEntryPointInputs(depOptions, inputs, sorter);
        List<CompilerInput> absoluteOrder = sorter.getDependenciesOf(inputs, depOptions.shouldSortDependencies());
        LinkedListMultimap entryPointInputsPerModule = LinkedListMultimap.create();
        for (CompilerInput input : entryPointInputs) {
            module3 = input.getModule();
            Preconditions.checkNotNull((Object)module3);
            entryPointInputsPerModule.put((Object)module3, (Object)input);
        }
        for (JSModule module2 : this.getAllModules()) {
            module2.removeAll();
        }
        for (JSModule module2 : entryPointInputsPerModule.keySet()) {
            List<CompilerInput> transitiveClosure = sorter.getDependenciesOf(entryPointInputsPerModule.get((Object)module2), depOptions.shouldSortDependencies());
            for (CompilerInput input : transitiveClosure) {
                JSModule oldModule = input.getModule();
                if (oldModule == null) {
                    input.setModule(module2);
                    continue;
                }
                input.setModule(null);
                input.setModule(this.getDeepestCommonDependencyInclusive(oldModule, module2));
            }
        }
        for (CompilerInput input : absoluteOrder) {
            module3 = input.getModule();
            if (module3 == null) continue;
            module3.add(input);
        }
        ImmutableList.Builder result = ImmutableList.builder();
        for (JSModule module3 : this.getAllModules()) {
            result.addAll(module3.getInputs());
        }
        return result.build();
    }

    private Collection<CompilerInput> createEntryPointInputs(DependencyOptions depOptions, List<CompilerInput> inputs, SortedDependencies<CompilerInput> sorter) throws MissingModuleException, SortedDependencies.MissingProvideException {
        LinkedHashSet entryPointInputs = Sets.newLinkedHashSet();
        Map<String, JSModule> modulesByName = this.getModulesByName();
        if (depOptions.shouldPruneDependencies()) {
            if (!depOptions.shouldDropMoochers()) {
                entryPointInputs.addAll(sorter.getInputsWithoutProvides());
            }
            Iterator<String> iterator = depOptions.getEntryPoints().iterator();
            while (iterator.hasNext()) {
                String entryPoint;
                String inputName = entryPoint = iterator.next();
                int splitPoint = entryPoint.indexOf(58);
                CompilerInput entryPointInput = null;
                if (splitPoint != -1) {
                    String moduleName = entryPoint.substring(0, splitPoint);
                    inputName = entryPoint.substring(Math.min(splitPoint + 1, entryPoint.length() - 1));
                    JSModule module = modulesByName.get(moduleName);
                    if (module == null) {
                        throw new MissingModuleException(moduleName);
                    }
                    entryPointInput = sorter.getInputProviding(inputName);
                    entryPointInput.overrideModule(module);
                } else {
                    entryPointInput = sorter.getInputProviding(inputName);
                }
                entryPointInputs.add(entryPointInput);
            }
            CompilerInput baseJs = sorter.maybeGetInputProviding("goog");
            if (baseJs != null) {
                entryPointInputs.add(baseJs);
            }
        } else {
            entryPointInputs.addAll(inputs);
        }
        return entryPointInputs;
    }

    LinkedDirectedGraph<JSModule, String> toGraphvizGraph() {
        LinkedDirectedGraph<JSModule, String> graphViz = LinkedDirectedGraph.create();
        for (JSModule module : this.getAllModules()) {
            graphViz.createNode(module);
            for (JSModule dep : module.getDependencies()) {
                graphViz.createNode(dep);
                graphViz.connect(module, "->", dep);
            }
        }
        return graphViz;
    }

    private static int depthCompare(JSModule m1, JSModule m2) {
        int d2;
        if (m1 == m2) {
            return 0;
        }
        int d1 = m1.getDepth();
        return d1 < (d2 = m2.getDepth()) ? -1 : (d2 == d1 ? m1.getName().compareTo(m2.getName()) : 1);
    }

    public static class MissingModuleException
    extends Exception {
        MissingModuleException(String moduleName) {
            super(moduleName);
        }
    }

    protected static class ModuleDependenceException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 1L;
        private final JSModule module;
        private final JSModule dependentModule;

        protected ModuleDependenceException(String message, JSModule module, JSModule dependentModule) {
            super(message);
            this.module = module;
            this.dependentModule = dependentModule;
        }

        public JSModule getModule() {
            return this.module;
        }

        public JSModule getDependentModule() {
            return this.dependentModule;
        }
    }

    private static class InverseDepthComparator
    implements Comparator<JSModule> {
        private InverseDepthComparator() {
        }

        @Override
        public int compare(JSModule m1, JSModule m2) {
            return JSModuleGraph.depthCompare(m2, m1);
        }
    }
}

