/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class JsMessage {
    private static final String MESSAGE_REPRESENTATION_FORMAT = "{$%s}";
    private final String key;
    private final String id;
    private final List<CharSequence> parts;
    private final Set<String> placeholders;
    private final String desc;
    private final boolean hidden;
    private final String meaning;
    private final String sourceName;
    private final boolean isAnonymous;
    private final boolean isExternal;

    private JsMessage(String sourceName, String key, boolean isAnonymous, boolean isExternal, String id, List<CharSequence> parts, Set<String> placeholders, String desc, boolean hidden, String meaning) {
        Preconditions.checkState((key != null ? 1 : 0) != 0);
        Preconditions.checkState((id != null ? 1 : 0) != 0);
        this.key = key;
        this.id = id;
        this.parts = Collections.unmodifiableList(parts);
        this.placeholders = Collections.unmodifiableSet(placeholders);
        this.desc = desc;
        this.hidden = hidden;
        this.meaning = meaning;
        this.sourceName = sourceName;
        this.isAnonymous = isAnonymous;
        this.isExternal = isExternal;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String getKey() {
        return this.key;
    }

    public boolean isAnonymous() {
        return this.isAnonymous;
    }

    public boolean isExternal() {
        return this.isExternal;
    }

    public String getId() {
        return this.id;
    }

    public String getDesc() {
        return this.desc;
    }

    String getMeaning() {
        return this.meaning;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public List<CharSequence> parts() {
        return this.parts;
    }

    public Set<String> placeholders() {
        return this.placeholders;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (CharSequence p : this.parts) {
            sb.append(p.toString());
        }
        return sb.toString();
    }

    public boolean isEmpty() {
        for (CharSequence part : this.parts) {
            if (part.length() <= 0) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JsMessage)) {
            return false;
        }
        JsMessage m = (JsMessage)o;
        return this.id.equals(m.id) && this.key.equals(m.key) && this.isAnonymous == m.isAnonymous && this.parts.equals(m.parts) && (this.meaning == null ? m.meaning == null : this.meaning.equals(m.meaning)) && this.placeholders.equals(m.placeholders) && (this.desc == null ? m.desc == null : this.desc.equals(m.desc)) && (this.sourceName == null ? m.sourceName == null : this.sourceName.equals(m.sourceName)) && this.hidden == m.hidden;
    }

    public int hashCode() {
        int hash = this.key.hashCode();
        hash = 31 * hash + (this.isAnonymous ? 1 : 0);
        hash = 31 * hash + this.id.hashCode();
        hash = 31 * hash + this.parts.hashCode();
        hash = 31 * hash + (this.desc != null ? this.desc.hashCode() : 0);
        hash = 31 * hash + (this.hidden ? 1 : 0);
        hash = 31 * hash + (this.sourceName != null ? this.sourceName.hashCode() : 0);
        return hash;
    }

    public static interface IdGenerator {
        public String generateId(String var1, List<CharSequence> var2);
    }

    static final class Hash {
        private static final long SEED64 = 3141592653589793238L;
        private static final long CONSTANT64 = -2266404186210603134L;

        private Hash() {
        }

        static long hash64(@Nullable String value) {
            return Hash.hash64(value, 3141592653589793238L);
        }

        private static long hash64(@Nullable String value, long seed) {
            if (value == null) {
                return Hash.hash64(null, 0, 0, seed);
            }
            return Hash.hash64(value.getBytes(StandardCharsets.UTF_8), seed);
        }

        private static long hash64(byte[] value, long seed) {
            return Hash.hash64(value, 0, value == null ? 0 : value.length, seed);
        }

        private static long hash64(byte[] value, int offset, int length, long seed) {
            long a;
            long b = a = -2266404186210603134L;
            long c = seed;
            int keylen = length;
            while (keylen >= 24) {
                a += Hash.word64At(value, offset);
                a -= (b += Hash.word64At(value, offset + 8));
                a -= (c += Hash.word64At(value, offset + 16));
                b -= c;
                b -= (a ^= c >>> 43);
                c -= a;
                c -= (b ^= a << 9);
                a -= b;
                a -= (c ^= b >>> 8);
                b -= c;
                b -= (a ^= c >>> 38);
                c -= a;
                c -= (b ^= a << 23);
                a -= b;
                a -= (c ^= b >>> 5);
                b -= c;
                b -= (a ^= c >>> 35);
                c -= a;
                c -= (b ^= a << 49);
                a -= b;
                a -= (c ^= b >>> 11);
                b -= c;
                b -= (a ^= c >>> 12);
                c -= a;
                c -= (b ^= a << 18);
                c ^= b >>> 22;
                keylen -= 24;
                offset += 24;
            }
            c += (long)length;
            if (keylen >= 16) {
                if (keylen == 23) {
                    c += (long)value[offset + 22] << 56;
                }
                if (keylen >= 22) {
                    c += ((long)value[offset + 21] & 0xFFL) << 48;
                }
                if (keylen >= 21) {
                    c += ((long)value[offset + 20] & 0xFFL) << 40;
                }
                if (keylen >= 20) {
                    c += ((long)value[offset + 19] & 0xFFL) << 32;
                }
                if (keylen >= 19) {
                    c += ((long)value[offset + 18] & 0xFFL) << 24;
                }
                if (keylen >= 18) {
                    c += ((long)value[offset + 17] & 0xFFL) << 16;
                }
                if (keylen >= 17) {
                    c += ((long)value[offset + 16] & 0xFFL) << 8;
                }
                if (keylen >= 16) {
                    b += Hash.word64At(value, offset + 8);
                    a += Hash.word64At(value, offset);
                }
            } else if (keylen >= 8) {
                if (keylen == 15) {
                    b += ((long)value[offset + 14] & 0xFFL) << 48;
                }
                if (keylen >= 14) {
                    b += ((long)value[offset + 13] & 0xFFL) << 40;
                }
                if (keylen >= 13) {
                    b += ((long)value[offset + 12] & 0xFFL) << 32;
                }
                if (keylen >= 12) {
                    b += ((long)value[offset + 11] & 0xFFL) << 24;
                }
                if (keylen >= 11) {
                    b += ((long)value[offset + 10] & 0xFFL) << 16;
                }
                if (keylen >= 10) {
                    b += ((long)value[offset + 9] & 0xFFL) << 8;
                }
                if (keylen >= 9) {
                    b += (long)value[offset + 8] & 0xFFL;
                }
                if (keylen >= 8) {
                    a += Hash.word64At(value, offset);
                }
            } else {
                if (keylen == 7) {
                    a += ((long)value[offset + 6] & 0xFFL) << 48;
                }
                if (keylen >= 6) {
                    a += ((long)value[offset + 5] & 0xFFL) << 40;
                }
                if (keylen >= 5) {
                    a += ((long)value[offset + 4] & 0xFFL) << 32;
                }
                if (keylen >= 4) {
                    a += ((long)value[offset + 3] & 0xFFL) << 24;
                }
                if (keylen >= 3) {
                    a += ((long)value[offset + 2] & 0xFFL) << 16;
                }
                if (keylen >= 2) {
                    a += ((long)value[offset + 1] & 0xFFL) << 8;
                }
                if (keylen >= 1) {
                    a += (long)value[offset + 0] & 0xFFL;
                }
            }
            return Hash.mix64(a, b, c);
        }

        private static long word64At(byte[] bytes, int offset) {
            return ((long)bytes[offset + 0] & 0xFFL) + (((long)bytes[offset + 1] & 0xFFL) << 8) + (((long)bytes[offset + 2] & 0xFFL) << 16) + (((long)bytes[offset + 3] & 0xFFL) << 24) + (((long)bytes[offset + 4] & 0xFFL) << 32) + (((long)bytes[offset + 5] & 0xFFL) << 40) + (((long)bytes[offset + 6] & 0xFFL) << 48) + (((long)bytes[offset + 7] & 0xFFL) << 56);
        }

        private static long mix64(long a, long b, long c) {
            a -= b;
            a -= c;
            b -= c;
            b -= (a ^= c >>> 43);
            c -= a;
            c -= (b ^= a << 9);
            a -= b;
            a -= (c ^= b >>> 8);
            b -= c;
            b -= (a ^= c >>> 38);
            c -= a;
            c -= (b ^= a << 23);
            a -= b;
            a -= (c ^= b >>> 5);
            b -= c;
            b -= (a ^= c >>> 35);
            c -= a;
            c -= (b ^= a << 49);
            a -= b;
            a -= (c ^= b >>> 11);
            b -= c;
            b -= (a ^= c >>> 12);
            c -= a;
            c -= (b ^= a << 18);
            return c ^= b >>> 22;
        }
    }

    public static class Builder {
        private static final Pattern MSG_EXTERNAL_PATTERN = Pattern.compile("MSG_EXTERNAL_(\\d+)");
        private String key;
        private String meaning;
        private String desc;
        private boolean hidden;
        private List<CharSequence> parts = Lists.newLinkedList();
        private Set<String> placeholders = Sets.newHashSet();
        private String sourceName;

        private static String getExternalMessageId(String identifier) {
            Matcher m = MSG_EXTERNAL_PATTERN.matcher(identifier);
            return m.matches() ? m.group(1) : null;
        }

        public Builder() {
            this(null);
        }

        public Builder(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public Builder setKey(String key) {
            this.key = key;
            return this;
        }

        public Builder setSourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        public Builder appendPlaceholderReference(String name) {
            Preconditions.checkNotNull((Object)name, (Object)"Placeholder name could not be null");
            this.parts.add(new PlaceholderReference(name));
            this.placeholders.add(name);
            return this;
        }

        public Builder appendStringPart(String part) {
            Preconditions.checkNotNull((Object)part, (Object)"String part of the message could not be null");
            this.parts.add(part);
            return this;
        }

        public Set<String> getPlaceholders() {
            return this.placeholders;
        }

        public Builder setDesc(String desc) {
            this.desc = desc;
            return this;
        }

        public Builder setMeaning(String meaning) {
            this.meaning = meaning;
            return this;
        }

        public Builder setIsHidden(boolean hidden) {
            this.hidden = hidden;
            return this;
        }

        public boolean hasParts() {
            return !this.parts.isEmpty();
        }

        public List<CharSequence> getParts() {
            return this.parts;
        }

        public JsMessage build() {
            return this.build(null);
        }

        public JsMessage build(IdGenerator idGenerator) {
            String externalId;
            boolean isAnonymous = false;
            boolean isExternal = false;
            String id = null;
            if (this.getKey() == null) {
                this.key = "MSG_" + Builder.fingerprint(this.getParts());
                isAnonymous = true;
            }
            if (!isAnonymous && (externalId = Builder.getExternalMessageId(this.key)) != null) {
                isExternal = true;
                id = externalId;
            }
            if (!isExternal) {
                String defactoMeaning = this.meaning != null ? this.meaning : this.key;
                id = idGenerator == null ? defactoMeaning : idGenerator.generateId(defactoMeaning, this.parts);
            }
            return new JsMessage(this.sourceName, this.key, isAnonymous, isExternal, id, this.parts, this.placeholders, this.desc, this.hidden, this.meaning);
        }

        private static String fingerprint(List<CharSequence> messageParts) {
            StringBuilder sb = new StringBuilder();
            for (CharSequence part : messageParts) {
                if (part instanceof PlaceholderReference) {
                    sb.append(part.toString());
                    continue;
                }
                sb.append(part);
            }
            long nonnegativeHash = Long.MAX_VALUE & Hash.hash64(sb.toString());
            return Long.toString(nonnegativeHash, 36).toUpperCase();
        }
    }

    public static class PlaceholderReference
    implements CharSequence {
        private final String name;

        PlaceholderReference(String name) {
            this.name = name;
        }

        @Override
        public int length() {
            return this.name.length();
        }

        @Override
        public char charAt(int index) {
            return this.name.charAt(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.name.subSequence(start, end);
        }

        public String getName() {
            return this.name;
        }

        @Override
        public String toString() {
            return String.format(JsMessage.MESSAGE_REPRESENTATION_FORMAT, this.name);
        }

        public boolean equals(Object o) {
            return o == this || o instanceof PlaceholderReference && this.name.equals(((PlaceholderReference)o).name);
        }

        public int hashCode() {
            return 31 * this.name.hashCode();
        }
    }

    public static enum Style {
        LEGACY,
        RELAX,
        CLOSURE;


        static Style getFromParams(boolean useClosure, boolean allowLegacyMessages) {
            if (useClosure) {
                return allowLegacyMessages ? RELAX : CLOSURE;
            }
            return LEGACY;
        }
    }
}

