/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.ScopeCreator;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.StaticSymbolTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

class MemoizedScopeCreator
implements ScopeCreator,
StaticSymbolTable<Scope.Var, Scope.Var> {
    private final Map<Node, Scope> scopes = Maps.newLinkedHashMap();
    private final ScopeCreator delegate;

    MemoizedScopeCreator(ScopeCreator delegate) {
        this.delegate = delegate;
    }

    @Override
    public Iterable<Scope.Var> getReferences(Scope.Var var) {
        return ImmutableList.of((Object)var);
    }

    public Scope getScope(Scope.Var var) {
        return var.scope;
    }

    @Override
    public Iterable<Scope.Var> getAllSymbols() {
        ArrayList vars = Lists.newArrayList();
        for (Scope s : this.scopes.values()) {
            Iterables.addAll((Collection)vars, s.getAllSymbols());
        }
        return vars;
    }

    @Override
    public Scope createScope(Node n, Scope parent) {
        Scope scope = this.scopes.get(n);
        if (scope == null) {
            scope = this.delegate.createScope(n, parent);
            this.scopes.put(n, scope);
        } else {
            Preconditions.checkState((parent == scope.getParent() ? 1 : 0) != 0);
        }
        return scope;
    }

    Collection<Scope> getAllMemoizedScopes() {
        ArrayList temp = Lists.newArrayList(this.scopes.values());
        Collections.reverse(temp);
        return Collections.unmodifiableCollection(temp);
    }

    void removeScopesForScript(String scriptName) {
        for (Node scopeRoot : ImmutableSet.copyOf(this.scopes.keySet())) {
            if (!scriptName.equals(scopeRoot.getSourceFileName())) continue;
            this.scopes.remove(scopeRoot);
        }
    }

    @Override
    public boolean hasBlockScope() {
        return this.delegate.hasBlockScope();
    }
}

