/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NameGenerator;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

final class RenameLabels
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final Supplier<String> nameSupplier;
    private final boolean removeUnused;

    RenameLabels(AbstractCompiler compiler) {
        this(compiler, new DefaultNameSupplier(), true);
    }

    RenameLabels(AbstractCompiler compiler, NameGenerator nameGen) {
        this(compiler, new DefaultNameSupplier(nameGen), true);
        nameGen.restartNaming();
    }

    RenameLabels(AbstractCompiler compiler, Supplier<String> supplier, boolean removeUnused) {
        this.compiler = compiler;
        this.nameSupplier = supplier;
        this.removeUnused = removeUnused;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, new ProcessLabels());
    }

    private static class LabelNamespace {
        final Map<String, LabelInfo> renameMap = new HashMap<String, LabelInfo>();

        private LabelNamespace() {
        }
    }

    private static class LabelInfo {
        boolean referenced = false;
        final int id;

        LabelInfo(int id) {
            this.id = id;
        }
    }

    class ProcessLabels
    implements NodeTraversal.ScopedCallback {
        final Deque<LabelNamespace> namespaceStack = new ArrayDeque<LabelNamespace>();
        final ArrayList<String> names = new ArrayList();

        ProcessLabels() {
            this.namespaceStack.push(new LabelNamespace());
        }

        @Override
        public void enterScope(NodeTraversal nodeTraversal) {
            this.namespaceStack.push(new LabelNamespace());
        }

        @Override
        public void exitScope(NodeTraversal nodeTraversal) {
            this.namespaceStack.pop();
        }

        @Override
        public boolean shouldTraverse(NodeTraversal nodeTraversal, Node node, Node parent) {
            if (node.isLabel()) {
                LabelNamespace current = this.namespaceStack.peek();
                int currentDepth = current.renameMap.size() + 1;
                String name = node.getFirstChild().getString();
                LabelInfo li = new LabelInfo(currentDepth);
                Preconditions.checkState((!current.renameMap.containsKey(name) ? 1 : 0) != 0);
                current.renameMap.put(name, li);
                if (this.names.size() < currentDepth) {
                    this.names.add((String)RenameLabels.this.nameSupplier.get());
                }
                String newName = this.getNameForId(currentDepth);
                RenameLabels.this.compiler.addToDebugLog("label renamed: " + name + " => " + newName);
            }
            return true;
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node parent) {
            switch (node.getType()) {
                case 126: {
                    this.visitLabel(node, parent);
                    break;
                }
                case 116: 
                case 117: {
                    this.visitBreakOrContinue(node);
                }
            }
        }

        private void visitBreakOrContinue(Node node) {
            Node nameNode = node.getFirstChild();
            if (nameNode != null) {
                String name = nameNode.getString();
                Preconditions.checkState((!name.isEmpty() ? 1 : 0) != 0);
                LabelInfo li = this.getLabelInfo(name);
                if (li != null) {
                    String newName = this.getNameForId(li.id);
                    li.referenced = true;
                    if (!name.equals(newName)) {
                        nameNode.setString(newName);
                        RenameLabels.this.compiler.reportCodeChange();
                    }
                }
            }
        }

        private void visitLabel(Node node, Node parent) {
            Node nameNode = node.getFirstChild();
            Preconditions.checkState((nameNode != null ? 1 : 0) != 0);
            String name = nameNode.getString();
            LabelInfo li = this.getLabelInfo(name);
            if (li.referenced || !RenameLabels.this.removeUnused) {
                String newName = this.getNameForId(li.id);
                if (!name.equals(newName)) {
                    nameNode.setString(newName);
                    RenameLabels.this.compiler.reportCodeChange();
                }
            } else {
                Node newChild = node.getLastChild();
                node.removeChild(newChild);
                parent.replaceChild(node, newChild);
                if (newChild.isBlock()) {
                    NodeUtil.tryMergeBlock(newChild);
                }
                RenameLabels.this.compiler.reportCodeChange();
            }
            this.namespaceStack.peek().renameMap.remove(name);
        }

        String getNameForId(int id) {
            return this.names.get(id - 1);
        }

        LabelInfo getLabelInfo(String name) {
            return this.namespaceStack.peek().renameMap.get(name);
        }
    }

    static class DefaultNameSupplier
    implements Supplier<String> {
        private final NameGenerator nameGenerator;

        private DefaultNameSupplier(NameGenerator nameGen) {
            this.nameGenerator = nameGen;
        }

        private DefaultNameSupplier() {
            this.nameGenerator = new NameGenerator(new HashSet<String>(), "", null);
        }

        public String get() {
            return this.nameGenerator.generateNextName();
        }
    }
}

