/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.graph;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.javascript.jscomp.graph.Annotation;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.jscomp.graph.FixedPointGraphTraversal;
import com.google.javascript.jscomp.graph.GraphNode;

public class GraphReachability<N, E>
implements FixedPointGraphTraversal.EdgeCallback<N, E> {
    private final DiGraph<N, E> graph;
    private final Predicate<EdgeTuple<N, E>> edgePredicate;
    public static final Annotation REACHABLE = new Annotation(){};

    public GraphReachability(DiGraph<N, E> graph) {
        this(graph, null);
    }

    public GraphReachability(DiGraph<N, E> graph, Predicate<EdgeTuple<N, E>> edgePredicate) {
        this.graph = graph;
        this.edgePredicate = edgePredicate;
    }

    public void compute(N entry) {
        this.graph.clearNodeAnnotations();
        this.graph.getNode(entry).setAnnotation(REACHABLE);
        FixedPointGraphTraversal.newTraversal(this).computeFixedPoint(this.graph, entry);
    }

    public void recompute(N reachableNode) {
        GraphNode newReachable = this.graph.getNode(reachableNode);
        Preconditions.checkState((newReachable.getAnnotation() != REACHABLE ? 1 : 0) != 0);
        newReachable.setAnnotation(REACHABLE);
        FixedPointGraphTraversal.newTraversal(this).computeFixedPoint(this.graph, reachableNode);
    }

    @Override
    public boolean traverseEdge(N source, E e, N destination) {
        GraphNode destNode;
        if (this.graph.getNode(source).getAnnotation() == REACHABLE && (this.edgePredicate == null || this.edgePredicate.apply(new EdgeTuple<N, E>(source, e, destination))) && (destNode = this.graph.getNode(destination)).getAnnotation() != REACHABLE) {
            destNode.setAnnotation(REACHABLE);
            return true;
        }
        return false;
    }

    public static final class EdgeTuple<N, E> {
        public final N sourceNode;
        public final E edge;

        public EdgeTuple(N sourceNode, E edge, N destNode) {
            this.sourceNode = sourceNode;
            this.edge = edge;
        }
    }
}

