/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.newtypes;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.newtypes.JSType;
import com.google.javascript.jscomp.newtypes.Namespace;
import com.google.javascript.jscomp.newtypes.ObjectKind;
import com.google.javascript.jscomp.newtypes.ObjectType;
import com.google.javascript.jscomp.newtypes.PersistentMap;
import com.google.javascript.jscomp.newtypes.Property;
import com.google.javascript.jscomp.newtypes.QualifiedName;
import com.google.javascript.jscomp.newtypes.TypeWithProperties;
import com.google.javascript.rhino.JSTypeExpression;
import java.util.Collection;

public class EnumType
extends Namespace
implements TypeWithProperties {
    private State state;
    private JSTypeExpression typeExpr;
    private String name;
    private JSType declaredType;
    private JSType enumPropType;
    private JSType enumObjType;
    private ImmutableSet<String> props;

    private EnumType(String name, JSTypeExpression typeExpr, Collection<String> props) {
        Preconditions.checkNotNull((Object)typeExpr);
        this.state = State.NOT_RESOLVED;
        this.name = name;
        this.typeExpr = typeExpr;
        this.props = ImmutableSet.copyOf(props);
    }

    public static EnumType make(String name, JSTypeExpression typeExpr, Collection<String> props) {
        return new EnumType(name, typeExpr, props);
    }

    public boolean isResolved() {
        return this.state == State.RESOLVED;
    }

    public JSType getEnumeratedType() {
        Preconditions.checkState((this.state == State.RESOLVED ? 1 : 0) != 0);
        return this.declaredType;
    }

    public JSType getPropType() {
        Preconditions.checkState((this.state == State.RESOLVED ? 1 : 0) != 0);
        return this.enumPropType;
    }

    @Override
    public JSType toJSType() {
        Preconditions.checkState((this.state == State.RESOLVED ? 1 : 0) != 0);
        if (this.enumObjType == null) {
            this.enumObjType = this.computeObjType();
        }
        return this.enumObjType;
    }

    public JSTypeExpression getTypeExpr() {
        Preconditions.checkState((this.state != State.RESOLVED ? 1 : 0) != 0);
        if (this.state == State.DURING_RESOLUTION) {
            return null;
        }
        this.state = State.DURING_RESOLUTION;
        return this.typeExpr;
    }

    public JSTypeExpression getTypeExprForErrorReporting() {
        Preconditions.checkState((this.state == State.DURING_RESOLUTION ? 1 : 0) != 0);
        return this.typeExpr;
    }

    void resolveEnum(JSType t) {
        Preconditions.checkNotNull((Object)t);
        if (this.state == State.RESOLVED) {
            return;
        }
        Preconditions.checkState((this.state == State.DURING_RESOLUTION ? 1 : 0) != 0, (String)"Expected state DURING_RESOLUTION but found %s", (Object[])new Object[]{this.state.toString()});
        this.state = State.RESOLVED;
        this.typeExpr = null;
        this.declaredType = t;
        this.enumPropType = JSType.fromEnum(this);
    }

    private JSType computeObjType() {
        Preconditions.checkState((this.enumPropType != null ? 1 : 0) != 0);
        PersistentMap<String, Property> propMap = this.otherProps;
        for (String s : this.props) {
            propMap = propMap.with(s, Property.makeConstant(this.enumPropType, this.enumPropType));
        }
        return this.withNamedTypes(ObjectType.makeObjectType(null, propMap, null, false, ObjectKind.UNRESTRICTED));
    }

    @Override
    public JSType getProp(QualifiedName qname) {
        return this.declaredType.getProp(qname);
    }

    @Override
    public JSType getDeclaredProp(QualifiedName qname) {
        return this.declaredType.getDeclaredProp(qname);
    }

    @Override
    public boolean mayHaveProp(QualifiedName qname) {
        return this.declaredType.mayHaveProp(qname);
    }

    @Override
    public boolean hasProp(QualifiedName qname) {
        return this.declaredType.hasProp(qname);
    }

    @Override
    public boolean hasConstantProp(QualifiedName qname) {
        return this.declaredType.hasConstantProp(qname);
    }

    public boolean enumLiteralHasKey(String name) {
        return this.props.contains((Object)name);
    }

    static boolean hasNonScalar(ImmutableSet<EnumType> enums) {
        if (enums == null) {
            return false;
        }
        for (EnumType e : enums) {
            if (!e.declaredType.hasNonScalar()) continue;
            return true;
        }
        return false;
    }

    static ImmutableSet<EnumType> union(ImmutableSet<EnumType> s1, ImmutableSet<EnumType> s2) {
        if (s1 == null) {
            return s2;
        }
        if (s2 == null || s1.equals(s2)) {
            return s1;
        }
        return Sets.union(s1, s2).immutableCopy();
    }

    static ImmutableSet<EnumType> normalizeForJoin(ImmutableSet<EnumType> newEnums, JSType joinWithoutEnums) {
        boolean recreateEnums = false;
        for (EnumType e : newEnums) {
            if (!e.declaredType.isSubtypeOf(joinWithoutEnums)) continue;
            recreateEnums = true;
            break;
        }
        if (!recreateEnums) {
            return newEnums;
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (EnumType e : newEnums) {
            if (e.declaredType.isSubtypeOf(joinWithoutEnums)) continue;
            builder.add((Object)e);
        }
        return builder.build();
    }

    static boolean areSubtypes(JSType t1, JSType t2) {
        ImmutableSet<EnumType> s1 = t1.getEnums();
        if (s1 == null) {
            return true;
        }
        ImmutableSet<EnumType> s2 = t2.getEnums();
        for (EnumType e : s1) {
            if (s2 != null && s2.contains((Object)e) || e.declaredType.isSubtypeOf(t2)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.name;
    }

    private static enum State {
        NOT_RESOLVED,
        DURING_RESOLUTION,
        RESOLVED;

    }
}

