/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.refactoring;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.JsAst;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.refactoring.JsSourceMatcher;
import com.google.javascript.refactoring.Match;
import com.google.javascript.refactoring.NodeMetadata;
import com.google.javascript.refactoring.Scanner;
import com.google.javascript.refactoring.SuggestedFix;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class RefasterJsScanner
extends Scanner {
    private String templateJs = null;
    private ImmutableList<RefasterJsTemplate> templates;
    private RefasterJsTemplate matchedTemplate;

    public void loadRefasterJsTemplate(String refasterjsTemplate) throws IOException {
        Preconditions.checkState((this.templateJs == null ? 1 : 0) != 0, (Object)"Can't load RefasterJs template since a template is already loaded.");
        this.templateJs = Thread.currentThread().getContextClassLoader().getResource(refasterjsTemplate) != null ? Resources.toString((URL)Resources.getResource((String)refasterjsTemplate), (Charset)StandardCharsets.UTF_8) : Files.toString((File)new File(refasterjsTemplate), (Charset)StandardCharsets.UTF_8);
    }

    public void loadRefasterJsTemplateFromCode(String refasterJsTemplate) throws IOException {
        Preconditions.checkState((this.templateJs == null ? 1 : 0) != 0, (Object)"Can't load RefasterJs template since a template is already loaded.");
        this.templateJs = refasterJsTemplate;
    }

    @Override
    public boolean matches(Node node, NodeMetadata metadata) {
        if (this.templates == null) {
            try {
                this.initialize(metadata.getCompiler());
            }
            catch (Exception e) {
                Throwables.propagate((Throwable)e);
            }
        }
        this.matchedTemplate = null;
        for (RefasterJsTemplate template : this.templates) {
            if (!template.matcher.matches(node, metadata)) continue;
            this.matchedTemplate = template;
            return true;
        }
        return false;
    }

    @Override
    public List<SuggestedFix> processMatch(Match match) {
        SuggestedFix.Builder fix = new SuggestedFix.Builder();
        Node newNode = this.transformNode(this.matchedTemplate.afterTemplate.getLastChild(), this.matchedTemplate.matcher.getTemplateNodeToMatchMap());
        Node nodeToReplace = match.getNode();
        fix.setOriginalMatchedNode(nodeToReplace);
        fix.replace(nodeToReplace, newNode, match.getMetadata().getCompiler());
        Node n = match.getNode().getNext();
        for (int i = 1; i < this.matchedTemplate.beforeTemplate.getLastChild().getChildCount(); ++i) {
            Preconditions.checkNotNull((Object)n, (String)"Found mismatched sibling count between before template and matched node.\nTemplate: %s\nMatch: %s", (Object[])new Object[]{this.matchedTemplate.beforeTemplate.getLastChild(), match.getNode()});
            fix.delete(n);
            n = n.getNext();
        }
        for (String require : this.matchedTemplate.getGoogRequiresToAdd()) {
            fix.addGoogRequire(match, require);
        }
        for (String require : this.matchedTemplate.getGoogRequiresToRemove()) {
            fix.removeGoogRequire(match, require);
        }
        return ImmutableList.of((Object)fix.build());
    }

    private Node transformNode(Node templateNode, Map<String, Node> templateNodeToMatchMap) {
        String name;
        Node clone = templateNode.cloneNode();
        if (templateNode.isName() && templateNodeToMatchMap.containsKey(name = templateNode.getString())) {
            Node templateMatch = templateNodeToMatchMap.get(name);
            Preconditions.checkNotNull((Object)templateMatch, (String)"Match for %s is null", (Object[])new Object[]{name});
            if (templateNode.getParent().isVar()) {
                clone.setString(templateMatch.getString());
            } else {
                return templateMatch.cloneTree();
            }
        }
        for (Node child : templateNode.children()) {
            clone.addChildToBack(this.transformNode(child, templateNodeToMatchMap));
        }
        return clone;
    }

    void initialize(AbstractCompiler compiler) throws Exception {
        Preconditions.checkState((!Strings.isNullOrEmpty((String)this.templateJs) ? 1 : 0) != 0, (Object)"The template JS must be loaded before the scanner is used. Make sure that the template file is not empty.");
        Node scriptRoot = new JsAst(SourceFile.fromCode("template", this.templateJs)).getAstRoot(compiler);
        HashMap beforeTemplates = Maps.newHashMap();
        HashMap afterTemplates = Maps.newHashMap();
        for (Node templateNode : scriptRoot.children()) {
            String templateName;
            if (!templateNode.isFunction()) continue;
            String fnName = templateNode.getFirstChild().getQualifiedName();
            if (fnName.startsWith("before_")) {
                templateName = fnName.substring("before_".length());
                Preconditions.checkState((!beforeTemplates.containsKey(templateName) ? 1 : 0) != 0, (String)"Found existing template with the same name: %s", (Object[])new Object[]{beforeTemplates.get(templateName)});
                Preconditions.checkState((boolean)templateNode.getLastChild().hasChildren(), (Object)"Before templates are not allowed to be empty!");
                beforeTemplates.put(templateName, templateNode);
                continue;
            }
            if (!fnName.startsWith("after_")) continue;
            templateName = fnName.substring("after_".length());
            Preconditions.checkState((!afterTemplates.containsKey(templateName) ? 1 : 0) != 0, (String)"Found existing template with the same name: %s", (Object[])new Object[]{afterTemplates.get(templateName)});
            afterTemplates.put(templateName, templateNode);
        }
        Preconditions.checkState((!beforeTemplates.isEmpty() ? 1 : 0) != 0, (Object)"Did not find any RefasterJs templates! Make sure that there are 2 functions defined with the same name, one with a \"before_\" prefix and one with a \"after_\" prefix");
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String templateName : beforeTemplates.keySet()) {
            Preconditions.checkState((boolean)afterTemplates.containsKey(templateName), (String)"Found before template without a corresponding after template. Make sure there is an after_%s function defined.", (Object[])new Object[]{templateName});
            builder.add((Object)new RefasterJsTemplate(compiler, (Node)beforeTemplates.get(templateName), (Node)afterTemplates.get(templateName)));
        }
        this.templates = builder.build();
    }

    private static class RefasterJsTemplate {
        private static final Pattern ADD_GOOG_REQUIRE_PATTERN = Pattern.compile("\\+require\\s+\\{([^}]+)\\}");
        private static final Pattern REMOVE_GOOG_REQUIRE_PATTERN = Pattern.compile("-require\\s+\\{([^}]+)\\}");
        final JsSourceMatcher matcher;
        final Node beforeTemplate;
        final Node afterTemplate;

        RefasterJsTemplate(AbstractCompiler compiler, Node beforeTemplate, Node afterTemplate) {
            this.matcher = new JsSourceMatcher(compiler, beforeTemplate);
            this.beforeTemplate = beforeTemplate;
            this.afterTemplate = afterTemplate;
        }

        List<String> getGoogRequiresToAdd() {
            return this.getGoogRequiresFromPattern(ADD_GOOG_REQUIRE_PATTERN);
        }

        List<String> getGoogRequiresToRemove() {
            return this.getGoogRequiresFromPattern(REMOVE_GOOG_REQUIRE_PATTERN);
        }

        private List<String> getGoogRequiresFromPattern(Pattern pattern) {
            JSDocInfo jsDoc = NodeUtil.getBestJSDocInfo(this.beforeTemplate);
            if (jsDoc == null) {
                return ImmutableList.of();
            }
            String jsDocContent = jsDoc.getOriginalCommentString();
            if (jsDocContent == null) {
                return ImmutableList.of();
            }
            ImmutableList.Builder requires = ImmutableList.builder();
            Matcher m = pattern.matcher(jsDocContent);
            while (m.find()) {
                requires.add((Object)m.group(1));
            }
            return requires.build();
        }
    }
}

