/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.JSModuleGraph;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

class AliasExternals
implements CompilerPass {
    private static final int DEFAULT_REQUIRED_USAGE = 4;
    private int requiredUsage = 4;
    private static final int MIN_PROP_SIZE = 4;
    static final String PROTOTYPE_PROPERTY_NAME = AliasExternals.getArrayNotationNameFor("prototype");
    private final Map<String, Symbol> props = Maps.newHashMap();
    private final List<Node> accessors = Lists.newArrayList();
    private final List<Node> mutators = Lists.newArrayList();
    private final Map<Node, Node> replacementMap = new IdentityHashMap<Node, Node>();
    private final Map<String, Symbol> globals = Maps.newHashMap();
    private final AbstractCompiler compiler;
    private final JSModuleGraph moduleGraph;
    private Node defaultRoot;
    private Map<JSModule, Node> moduleRoots;
    private final Set<String> unaliasableGlobals = Sets.newHashSet((Object[])new String[]{"arguments", "eval", "NodeFilter", "JSCompiler_renameProperty"});
    private final Set<String> aliasableGlobals = Sets.newHashSet();

    AliasExternals(AbstractCompiler compiler, JSModuleGraph moduleGraph) {
        this(compiler, moduleGraph, null, null);
    }

    AliasExternals(AbstractCompiler compiler, JSModuleGraph moduleGraph, @Nullable String unaliasableGlobals, @Nullable String aliasableGlobals) {
        this.compiler = compiler;
        this.moduleGraph = moduleGraph;
        if (!Strings.isNullOrEmpty((String)unaliasableGlobals) && !Strings.isNullOrEmpty((String)aliasableGlobals)) {
            throw new IllegalArgumentException("Cannot pass in both unaliasable and aliasable globals; you must choose one or the other.");
        }
        if (!Strings.isNullOrEmpty((String)unaliasableGlobals)) {
            Iterables.addAll(this.unaliasableGlobals, (Iterable)Splitter.on((char)',').split((CharSequence)unaliasableGlobals));
        }
        if (!Strings.isNullOrEmpty((String)aliasableGlobals)) {
            Iterables.addAll(this.aliasableGlobals, (Iterable)Splitter.on((char)',').split((CharSequence)aliasableGlobals));
        }
        if (moduleGraph != null) {
            this.moduleRoots = Maps.newHashMap();
        }
    }

    public void setRequiredUsage(int usage) {
        this.requiredUsage = usage;
    }

    @Override
    public void process(Node externs, Node root) {
        this.defaultRoot = root.getFirstChild();
        Preconditions.checkState((boolean)this.defaultRoot.isScript());
        this.aliasProperties(externs, root);
        this.aliasGlobals(externs, root);
    }

    private void aliasProperties(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, externs, new GetAliasableNames(this.aliasableGlobals));
        this.props.put("prototype", this.newSymbolForProperty("prototype"));
        NodeTraversal.traverse(this.compiler, root, new PropertyGatherer());
        for (Symbol prop : this.props.values()) {
            if (prop.name.length() < 4) continue;
            if (prop.accessorCount >= this.requiredUsage) {
                prop.aliasAccessor = true;
            }
            if (prop.mutatorCount < this.requiredUsage) continue;
            prop.aliasMutator = true;
        }
        for (Node propInfo : this.accessors) {
            this.replaceAccessor(propInfo);
        }
        for (Node propInfo : this.mutators) {
            this.replaceMutator(propInfo);
        }
        for (Symbol prop : this.props.values()) {
            if (!prop.aliasAccessor) continue;
            this.addAccessorPropName(prop.name, this.getAddingRoot(prop.deepestModuleAccess));
        }
        for (Symbol prop : this.props.values()) {
            if (!prop.aliasMutator) continue;
            this.addMutatorFunction(prop.name, this.getAddingRoot(prop.deepestModuleMutate));
        }
    }

    private void replaceAccessor(Node getPropNode) {
        Node propNameNode = getPropNode.getLastChild();
        String propName = propNameNode.getString();
        if (this.props.get((Object)propName).aliasAccessor) {
            Node propSrc = getPropNode.getFirstChild();
            getPropNode.removeChild(propSrc);
            Node newNameNode = IR.name(AliasExternals.getArrayNotationNameFor(propName));
            Node elemNode = IR.getelem(propSrc, newNameNode);
            this.replaceNode(getPropNode.getParent(), getPropNode, elemNode);
            this.compiler.reportCodeChange();
        }
    }

    private void replaceMutator(Node getPropNode) {
        Node propNameNode = getPropNode.getLastChild();
        Node parentNode = getPropNode.getParent();
        Symbol prop = this.props.get(propNameNode.getString());
        if (prop.aliasMutator) {
            Node propSrc = getPropNode.getFirstChild();
            Node propDest = parentNode.getLastChild();
            getPropNode.removeChild(propSrc);
            getPropNode.removeChild(propNameNode);
            parentNode.removeChild(propDest);
            Node callName = IR.name(AliasExternals.getMutatorFor(propNameNode.getString()));
            Node call = IR.call(callName, propSrc, propDest);
            call.putBooleanProp(50, true);
            this.replaceNode(parentNode.getParent(), parentNode, call);
            this.compiler.reportCodeChange();
        }
    }

    private void replaceNode(Node parent, Node before, Node after) {
        if (this.replacementMap.containsKey(parent)) {
            parent = this.replacementMap.get(parent);
        }
        parent.replaceChild(before, after);
        this.replacementMap.put(before, after);
    }

    private void addAccessorPropName(String propName, Node root) {
        Node propValue = IR.string(propName);
        Node propNameNode = IR.name(AliasExternals.getArrayNotationNameFor(propName));
        propNameNode.addChildToFront(propValue);
        Node var = IR.var(propNameNode);
        root.addChildToFront(var);
        this.compiler.reportCodeChange();
    }

    private void addMutatorFunction(String propName, Node root) {
        String functionName = AliasExternals.getMutatorFor(propName);
        String localPropName = AliasExternals.getMutatorFor(propName) + "$a";
        String localValueName = AliasExternals.getMutatorFor(propName) + "$b";
        Node fnNode = IR.function(IR.name(functionName), IR.paramList(IR.name(localPropName), IR.name(localValueName)), IR.block(IR.returnNode(IR.assign(IR.getprop(IR.name(localPropName), IR.string(propName)), IR.name(localValueName)))));
        root.addChildToFront(fnNode);
        this.compiler.reportCodeChange();
    }

    private Node getAddingRoot(JSModule m) {
        if (m != null) {
            Node root = this.moduleRoots.get(m);
            if (root != null) {
                return root;
            }
            root = this.compiler.getNodeForCodeInsertion(m);
            if (root != null) {
                this.moduleRoots.put(m, root);
                return root;
            }
        }
        return this.defaultRoot;
    }

    private static String getMutatorFor(String prop) {
        return "SETPROP_" + prop;
    }

    private static String getArrayNotationNameFor(String prop) {
        return "$$PROP_" + prop;
    }

    private void aliasGlobals(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, externs, new GetGlobals());
        NodeTraversal.traverse(this.compiler, root, new GlobalGatherer());
        for (Symbol global : this.globals.values()) {
            if (global.mutatorCount > 0) continue;
            int currentBytes = global.name.length() * global.accessorCount;
            int aliasedBytes = 8 + global.name.length() + 2 * global.accessorCount;
            if (aliasedBytes >= currentBytes) continue;
            global.aliasAccessor = true;
        }
        for (Symbol global : this.globals.values()) {
            for (Node globalUse : global.uses) {
                this.replaceGlobalUse(globalUse);
            }
            if (!global.aliasAccessor) continue;
            this.addGlobalAliasNode(global, this.getAddingRoot(global.deepestModuleAccess));
        }
    }

    private void replaceGlobalUse(Node globalUse) {
        String globalName = globalUse.getString();
        if (this.globals.get((Object)globalName).aliasAccessor) {
            globalUse.setString("GLOBAL_" + globalName);
            globalUse.putBooleanProp(43, false);
            this.compiler.reportCodeChange();
        }
    }

    private void addGlobalAliasNode(Symbol global, Node root) {
        String globalName = global.name;
        Node globalValue = IR.name(global.name);
        globalValue.putBooleanProp(43, global.isConstant);
        Node globalNameNode = IR.name("GLOBAL_" + globalName);
        globalNameNode.addChildToFront(globalValue);
        Node var = IR.var(globalNameNode);
        root.addChildToFront(var);
        this.compiler.reportCodeChange();
    }

    private Symbol newSymbolForGlobalVar(Node name) {
        return new Symbol(name.getString(), name.getBooleanProp(43));
    }

    private Symbol newSymbolForProperty(String name) {
        return new Symbol(name, false);
    }

    private class Symbol {
        public final String name;
        public int accessorCount = 0;
        public int mutatorCount = 0;
        public boolean aliasMutator = false;
        public boolean aliasAccessor = false;
        public final boolean isConstant;
        JSModule deepestModuleAccess = null;
        JSModule deepestModuleMutate = null;
        List<Node> uses = Lists.newArrayList();

        private Symbol(String name, boolean isConstant) {
            this.name = name;
            this.isConstant = isConstant;
        }

        void recordAccessor(NodeTraversal t) {
            ++this.accessorCount;
            if (AliasExternals.this.moduleGraph != null) {
                this.deepestModuleAccess = this.deepestModuleAccess == null ? t.getModule() : AliasExternals.this.moduleGraph.getDeepestCommonDependencyInclusive(t.getModule(), this.deepestModuleAccess);
            }
        }

        void recordMutator(NodeTraversal t) {
            ++this.mutatorCount;
            if (AliasExternals.this.moduleGraph != null) {
                this.deepestModuleMutate = this.deepestModuleMutate == null ? t.getModule() : AliasExternals.this.moduleGraph.getDeepestCommonDependencyInclusive(t.getModule(), this.deepestModuleMutate);
            }
        }
    }

    private final class GlobalGatherer
    extends NodeTraversal.AbstractPostOrderCallback {
        private GlobalGatherer() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isName()) {
                String name = n.getString();
                Var var = t.getScope().getVar(name);
                if (var != null && var.isLocal()) {
                    return;
                }
                Symbol global = (Symbol)AliasExternals.this.globals.get(name);
                if (global != null) {
                    boolean isFirst;
                    if (n.getParent().isVar() || n.getParent().isFunction()) {
                        AliasExternals.this.globals.remove(name);
                    }
                    boolean bl = isFirst = parent.getFirstChild() == n;
                    if (NodeUtil.isAssignmentOp(parent) && isFirst || parent.isNew() && isFirst || parent.isInc() || parent.isDec()) {
                        global.recordMutator(t);
                    } else {
                        global.recordAccessor(t);
                    }
                    global.uses.add(n);
                }
            }
        }
    }

    private class GetGlobals
    extends NodeTraversal.AbstractShallowCallback {
        private GetGlobals() {
        }

        private void getGlobalName(NodeTraversal t, Node dest, Node parent) {
            if (dest.isName()) {
                boolean aliasable;
                JSDocInfo docInfo = dest.getJSDocInfo() == null ? parent.getJSDocInfo() : dest.getJSDocInfo();
                boolean bl = aliasable = !AliasExternals.this.unaliasableGlobals.contains(dest.getString()) && (docInfo == null || !docInfo.isNoAlias());
                if (aliasable) {
                    String name = dest.getString();
                    Var var = t.getScope().getVar(name);
                    if (var != null && !var.isLocal()) {
                        AliasExternals.this.globals.put(name, AliasExternals.this.newSymbolForGlobalVar(dest));
                    }
                }
            }
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getType()) {
                case 105: {
                    this.getGlobalName(t, n.getFirstChild(), n);
                    break;
                }
                case 118: {
                    for (Node varChild = n.getFirstChild(); varChild != null; varChild = varChild.getNext()) {
                        this.getGlobalName(t, varChild, n);
                    }
                    break;
                }
            }
        }
    }

    private final class PropertyGatherer
    extends NodeTraversal.AbstractPostOrderCallback {
        private PropertyGatherer() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isGetProp()) {
                String name;
                Node propNameNode = n.getLastChild();
                if (this.canReplaceWithGetProp(propNameNode, n, parent)) {
                    name = propNameNode.getString();
                    ((Symbol)AliasExternals.this.props.get(name)).recordAccessor(t);
                    AliasExternals.this.accessors.add(n);
                }
                if (this.canReplaceWithSetProp(propNameNode, n, parent)) {
                    name = propNameNode.getString();
                    ((Symbol)AliasExternals.this.props.get(name)).recordMutator(t);
                    AliasExternals.this.mutators.add(n);
                }
            }
        }

        private boolean canReplaceWithGetProp(Node propNameNode, Node getPropNode, Node parent) {
            boolean isCallTarget = parent.isCall() && parent.getFirstChild() == getPropNode;
            boolean isAssignTarget = NodeUtil.isAssignmentOp(parent) && parent.getFirstChild() == getPropNode;
            boolean isIncOrDec = parent.isInc() || parent.isDec();
            return propNameNode.isString() && !isAssignTarget && (!isCallTarget || !"eval".equals(propNameNode.getString())) && !isIncOrDec && AliasExternals.this.props.containsKey(propNameNode.getString());
        }

        private boolean canReplaceWithSetProp(Node propNameNode, Node getPropNode, Node parent) {
            boolean isAssignTarget = parent.isAssign() && parent.getFirstChild() == getPropNode;
            return propNameNode.isString() && isAssignTarget && AliasExternals.this.props.containsKey(propNameNode.getString());
        }
    }

    private class GetAliasableNames
    extends NodeTraversal.AbstractPostOrderCallback {
        private final Set<String> whitelist;

        public GetAliasableNames(Set<String> whitelist) {
            this.whitelist = whitelist;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getType()) {
                case 33: 
                case 35: {
                    Node dest = n.getFirstChild().getNext();
                    if (!dest.isString() || !this.whitelist.isEmpty() && !this.whitelist.contains(dest.getString())) break;
                    AliasExternals.this.props.put(dest.getString(), AliasExternals.this.newSymbolForProperty(dest.getString()));
                }
            }
        }
    }
}

