/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NameGenerator;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.TypeValidator;
import com.google.javascript.jscomp.graph.AdjacencyGraph;
import com.google.javascript.jscomp.graph.Annotation;
import com.google.javascript.jscomp.graph.GraphColoring;
import com.google.javascript.jscomp.graph.GraphNode;
import com.google.javascript.jscomp.graph.SubGraph;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

class AmbiguateProperties
implements CompilerPass {
    private static final Logger logger = Logger.getLogger(AmbiguateProperties.class.getName());
    private final AbstractCompiler compiler;
    private final List<Node> stringNodesToRename = Lists.newArrayList();
    private final char[] reservedCharacters;
    private final Map<String, Property> propertyMap = Maps.newHashMap();
    private final Set<String> externedNames;
    private final Set<String> quotedNames = Sets.newHashSet();
    private Map<String, String> renamingMap = null;
    private static final Comparator<Property> FREQUENCY_COMPARATOR = new Comparator<Property>(){

        @Override
        public int compare(Property p1, Property p2) {
            if (p1.numOccurrences != p2.numOccurrences) {
                return p2.numOccurrences - p1.numOccurrences;
            }
            return p1.oldName.compareTo(p2.oldName);
        }
    };
    private BiMap<JSType, Integer> intForType = HashBiMap.create();
    private Map<JSType, JSTypeBitSet> relatedBitsets = Maps.newHashMap();
    private final Set<JSType> invalidatingTypes;
    static final String SKIP_PREFIX = "JSAbstractCompiler";

    AmbiguateProperties(AbstractCompiler compiler, char[] reservedCharacters) {
        Preconditions.checkState((boolean)compiler.getLifeCycleStage().isNormalized());
        this.compiler = compiler;
        this.reservedCharacters = reservedCharacters;
        JSTypeRegistry r = compiler.getTypeRegistry();
        this.invalidatingTypes = Sets.newHashSet((Object[])new JSType[]{r.getNativeType(JSTypeNative.ALL_TYPE), r.getNativeType(JSTypeNative.FUNCTION_FUNCTION_TYPE), r.getNativeType(JSTypeNative.FUNCTION_INSTANCE_TYPE), r.getNativeType(JSTypeNative.FUNCTION_PROTOTYPE), r.getNativeType(JSTypeNative.GLOBAL_THIS), r.getNativeType(JSTypeNative.OBJECT_TYPE), r.getNativeType(JSTypeNative.OBJECT_PROTOTYPE), r.getNativeType(JSTypeNative.OBJECT_FUNCTION_TYPE), r.getNativeType(JSTypeNative.TOP_LEVEL_PROTOTYPE)});
        for (TypeValidator.TypeMismatch mis : compiler.getTypeMismatches()) {
            this.addInvalidatingType(mis.typeA);
            this.addInvalidatingType(mis.typeB);
        }
        this.externedNames = compiler.getExternProperties();
    }

    static AmbiguateProperties makePassForTesting(AbstractCompiler compiler, char[] reservedCharacters) {
        AmbiguateProperties ap = new AmbiguateProperties(compiler, reservedCharacters);
        ap.renamingMap = Maps.newHashMap();
        return ap;
    }

    private void addInvalidatingType(JSType type) {
        if ((type = type.restrictByNotNullOrUndefined()).isUnionType()) {
            for (JSType alt : type.toMaybeUnionType().getAlternates()) {
                this.addInvalidatingType(alt);
            }
        }
        this.invalidatingTypes.add(type);
        ObjectType objType = ObjectType.cast(type);
        if (objType != null && objType.isInstanceType()) {
            this.invalidatingTypes.add(objType.getImplicitPrototype());
        }
    }

    Map<String, String> getRenamingMap() {
        Preconditions.checkNotNull(this.renamingMap);
        return this.renamingMap;
    }

    private int getIntForType(JSType type) {
        if (type != null && type.isTemplatizedType()) {
            type = type.toMaybeTemplatizedType().getReferencedType();
        }
        if (this.intForType.containsKey((Object)type)) {
            return (Integer)this.intForType.get((Object)type);
        }
        int newInt = this.intForType.size() + 1;
        this.intForType.put((Object)type, (Object)newInt);
        return newInt;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, new ProcessProperties());
        ImmutableSet.Builder reservedNames = ImmutableSet.builder().addAll(this.externedNames).addAll(this.quotedNames);
        int numRenamedPropertyNames = 0;
        int numSkippedPropertyNames = 0;
        ArrayList<PropertyGraphNode> nodes = new ArrayList<PropertyGraphNode>(this.propertyMap.size());
        for (Property prop : this.propertyMap.values()) {
            if (prop.skipAmbiguating) {
                ++numSkippedPropertyNames;
                reservedNames.add((Object)prop.oldName);
                continue;
            }
            ++numRenamedPropertyNames;
            nodes.add(new PropertyGraphNode(prop));
        }
        PropertyGraph graph = new PropertyGraph(nodes);
        GraphColoring.GreedyGraphColoring<Property, Void> coloring = new GraphColoring.GreedyGraphColoring<Property, Void>(graph, FREQUENCY_COMPARATOR);
        int numNewPropertyNames = ((GraphColoring)coloring).color();
        NameGenerator nameGen = new NameGenerator((Set<String>)reservedNames.build(), "", this.reservedCharacters);
        String[] colorMap = new String[numNewPropertyNames];
        for (int i = 0; i < numNewPropertyNames; ++i) {
            colorMap[i] = nameGen.generateNextName();
        }
        for (PropertyGraphNode node : graph.getNodes()) {
            node.getValue().newName = colorMap[node.getAnnotation().hashCode()];
            if (this.renamingMap == null) continue;
            this.renamingMap.put(node.getValue().oldName, node.getValue().newName);
        }
        for (Node n : this.stringNodesToRename) {
            String oldName = n.getString();
            Property p = this.propertyMap.get(oldName);
            if (p == null || p.newName == null) continue;
            Preconditions.checkState((boolean)oldName.equals(p.oldName));
            if (p.newName.equals(oldName)) continue;
            n.setString(p.newName);
            this.compiler.reportCodeChange();
        }
        logger.fine("Collapsed " + numRenamedPropertyNames + " properties into " + numNewPropertyNames + " and skipped renaming " + numSkippedPropertyNames + " properties.");
    }

    private BitSet getRelatedTypesOnNonUnion(JSType type) {
        if (this.relatedBitsets.containsKey(type)) {
            return this.relatedBitsets.get(type);
        }
        throw new RuntimeException("Related types should have been computed for type: " + type + " but have not been.");
    }

    private void computeRelatedTypes(JSType type) {
        if (type.isUnionType() && (type = type.restrictByNotNullOrUndefined()).isUnionType()) {
            for (JSType alt : type.toMaybeUnionType().getAlternates()) {
                this.computeRelatedTypes(alt);
            }
            return;
        }
        if (this.relatedBitsets.containsKey(type)) {
            return;
        }
        JSTypeBitSet related = new JSTypeBitSet(this.intForType.size());
        this.relatedBitsets.put(type, related);
        related.set(this.getIntForType(type));
        if (type.isFunctionPrototypeType()) {
            this.addRelatedInstance(((ObjectType)type).getOwnerFunction(), related);
            return;
        }
        FunctionType constructor = type.toObjectType().getConstructor();
        if (constructor != null && constructor.getSubTypes() != null) {
            for (FunctionType subType : constructor.getSubTypes()) {
                this.addRelatedInstance(subType, related);
            }
        }
        for (FunctionType implementor : this.compiler.getTypeRegistry().getDirectImplementors(type.toObjectType())) {
            this.addRelatedInstance(implementor, related);
        }
    }

    private void addRelatedInstance(FunctionType constructor, JSTypeBitSet related) {
        if (constructor.hasInstanceType()) {
            ObjectType instanceType = constructor.getInstanceType();
            related.set(this.getIntForType(instanceType.getImplicitPrototype()));
            this.computeRelatedTypes(instanceType);
            related.or(this.relatedBitsets.get(instanceType));
        }
    }

    private boolean isInvalidatingType(JSType type) {
        if (type.isUnionType() && (type = type.restrictByNotNullOrUndefined()).isUnionType()) {
            for (JSType alt : type.toMaybeUnionType().getAlternates()) {
                if (!this.isInvalidatingType(alt)) continue;
                return true;
            }
            return false;
        }
        ObjectType objType = ObjectType.cast(type);
        return objType == null || this.invalidatingTypes.contains(objType) || !objType.hasReferenceName() || objType.isUnknownType() || objType.isEmptyType() || objType.isEnumType() || objType.autoboxesTo() != null;
    }

    private Property getProperty(String name) {
        Property prop = this.propertyMap.get(name);
        if (prop == null) {
            prop = new Property(name);
            this.propertyMap.put(name, prop);
        }
        return prop;
    }

    private JSType getJSType(Node n) {
        JSType jsType = n.getJSType();
        if (jsType == null) {
            return this.compiler.getTypeRegistry().getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }
        return jsType;
    }

    private class JSTypeBitSet
    extends BitSet {
        private static final long serialVersionUID = 1L;

        private JSTypeBitSet(int size) {
            super(size);
        }

        private JSTypeBitSet() {
        }

        @Override
        public String toString() {
            int from = 0;
            int current = 0;
            ArrayList types = Lists.newArrayList();
            while (-1 != (current = this.nextSetBit(from))) {
                types.add(((JSType)AmbiguateProperties.this.intForType.inverse().get((Object)current)).toString());
                from = current + 1;
            }
            return Joiner.on((String)" && ").join((Iterable)types);
        }
    }

    private class Property {
        final String oldName;
        String newName;
        int numOccurrences;
        boolean skipAmbiguating;
        JSTypeBitSet relatedTypes;

        Property(String name) {
            this.relatedTypes = new JSTypeBitSet(AmbiguateProperties.this.intForType.size());
            this.oldName = name;
            if (name.startsWith(AmbiguateProperties.SKIP_PREFIX)) {
                this.skipAmbiguating = true;
            }
        }

        void addType(JSType newType) {
            if (this.skipAmbiguating) {
                return;
            }
            ++this.numOccurrences;
            if (newType.isUnionType() && (newType = newType.restrictByNotNullOrUndefined()).isUnionType()) {
                for (JSType alt : newType.toMaybeUnionType().getAlternates()) {
                    this.addNonUnionType(alt);
                }
                return;
            }
            this.addNonUnionType(newType);
        }

        private void addNonUnionType(JSType newType) {
            if (this.skipAmbiguating || AmbiguateProperties.this.isInvalidatingType(newType)) {
                this.skipAmbiguating = true;
                return;
            }
            if (!this.relatedTypes.get(AmbiguateProperties.this.getIntForType(newType))) {
                AmbiguateProperties.this.computeRelatedTypes(newType);
                this.relatedTypes.or(AmbiguateProperties.this.getRelatedTypesOnNonUnion(newType));
            }
        }
    }

    private class ProcessProperties
    extends NodeTraversal.AbstractPostOrderCallback {
        private ProcessProperties() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getType()) {
                case 33: {
                    Node propNode = n.getFirstChild().getNext();
                    JSType jstype = AmbiguateProperties.this.getJSType(n.getFirstChild());
                    this.maybeMarkCandidate(propNode, jstype);
                    break;
                }
                case 64: {
                    for (Node key = n.getFirstChild(); key != null; key = key.getNext()) {
                        if (!key.isQuotedString()) {
                            JSType jstype = AmbiguateProperties.this.getJSType(n.getFirstChild());
                            this.maybeMarkCandidate(key, jstype);
                            continue;
                        }
                        AmbiguateProperties.this.quotedNames.add(key.getString());
                    }
                    break;
                }
                case 35: {
                    Node child = n.getLastChild();
                    if (!child.isString()) break;
                    AmbiguateProperties.this.quotedNames.add(child.getString());
                }
            }
        }

        private void maybeMarkCandidate(Node n, JSType type) {
            String name = n.getString();
            if (!AmbiguateProperties.this.externedNames.contains(name)) {
                AmbiguateProperties.this.stringNodesToRename.add(n);
                this.recordProperty(name, type);
            }
        }

        private Property recordProperty(String name, JSType type) {
            Property prop = AmbiguateProperties.this.getProperty(name);
            prop.addType(type);
            return prop;
        }
    }

    class PropertyGraphNode
    implements GraphNode<Property, Void> {
        Property property;
        protected Annotation annotation;

        PropertyGraphNode(Property property) {
            this.property = property;
        }

        @Override
        public Property getValue() {
            return this.property;
        }

        @Override
        public <A extends Annotation> A getAnnotation() {
            return (A)this.annotation;
        }

        @Override
        public void setAnnotation(Annotation data) {
            this.annotation = data;
        }
    }

    class PropertySubGraph
    implements SubGraph<Property, Void> {
        JSTypeBitSet relatedTypes;

        PropertySubGraph() {
            this.relatedTypes = new JSTypeBitSet(AmbiguateProperties.this.intForType.size());
        }

        @Override
        public boolean isIndependentOf(Property prop) {
            return !this.relatedTypes.intersects(prop.relatedTypes);
        }

        @Override
        public void addNode(Property prop) {
            this.relatedTypes.or(prop.relatedTypes);
        }
    }

    class PropertyGraph
    implements AdjacencyGraph<Property, Void> {
        private final ArrayList<PropertyGraphNode> nodes;

        PropertyGraph(ArrayList<PropertyGraphNode> nodes) {
            this.nodes = nodes;
        }

        public List<PropertyGraphNode> getNodes() {
            return this.nodes;
        }

        @Override
        public GraphNode<Property, Void> getNode(Property property) {
            throw new RuntimeException("PropertyGraph#getNode is never called.");
        }

        @Override
        public SubGraph<Property, Void> newSubGraph() {
            return new PropertySubGraph();
        }

        @Override
        public void clearNodeAnnotations() {
            for (PropertyGraphNode node : this.nodes) {
                node.setAnnotation(null);
            }
        }

        @Override
        public int getWeight(Property value) {
            return value.numOccurrences;
        }
    }
}

