/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.SyntacticScopeCreator;
import com.google.javascript.jscomp.TypedVar;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class CheckRequiresForConstructors
implements HotSwapCompilerPass {
    private final AbstractCompiler compiler;
    private final CodingConvention codingConvention;
    static final DiagnosticType MISSING_REQUIRE_WARNING = DiagnosticType.disabled("JSC_MISSING_REQUIRE_WARNING", "''{0}'' used but not goog.require''d");

    CheckRequiresForConstructors(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.codingConvention = compiler.getCodingConvention();
    }

    @Override
    public void process(Node externs, Node root) {
        CheckRequiresForConstructorsCallback callback = new CheckRequiresForConstructorsCallback();
        NodeTraversal.traverseRootsTyped(this.compiler, callback, externs, root);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        CheckRequiresForConstructorsCallback callback = new CheckRequiresForConstructorsCallback();
        Scope globalScope = SyntacticScopeCreator.makeTyped(this.compiler).createScope(scriptRoot, null);
        new NodeTraversal(this.compiler, callback).traverseWithScope(scriptRoot, globalScope);
    }

    private static boolean isClassName(String name) {
        return name != null && name.length() > 1 && Character.isUpperCase(name.charAt(0)) && !name.equals(name.toUpperCase());
    }

    private static String getOutermostClassName(String className) {
        for (String part : Splitter.on((char)'.').split((CharSequence)className)) {
            if (!CheckRequiresForConstructors.isClassName(part)) continue;
            return className.substring(0, className.indexOf(part) + part.length());
        }
        return null;
    }

    private class CheckRequiresForConstructorsCallback
    implements NodeTraversal.Callback {
        private final Set<String> constructors = new HashSet<String>();
        private final Set<String> requires = new HashSet<String>();
        private final Map<String, Node> usages = new HashMap<String, Node>();

        private CheckRequiresForConstructorsCallback() {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            return parent == null || !parent.isScript() || !t.getInput().isExtern();
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getType()) {
                case 86: 
                case 118: {
                    this.maybeAddConstructor(t, n);
                    break;
                }
                case 105: {
                    if (NodeUtil.isStatement(n)) {
                        this.maybeAddConstructor(t, n);
                    }
                    this.maybeAddJsDocUsages(t, n);
                    break;
                }
                case 37: {
                    this.visitCallNode(n, parent);
                    break;
                }
                case 132: {
                    this.visitScriptNode(t);
                    break;
                }
                case 30: {
                    this.visitNewNode(t, n);
                }
            }
        }

        private void visitScriptNode(NodeTraversal t) {
            HashSet<String> classNames = new HashSet<String>();
            for (Map.Entry<String, Node> entry : this.usages.entrySet()) {
                boolean notProvidedByRequires;
                String className = entry.getKey();
                Node node = entry.getValue();
                String outermostClassName = CheckRequiresForConstructors.getOutermostClassName(className);
                String nonNullClassName = outermostClassName != null ? outermostClassName : className;
                String parentNamespace = null;
                int separatorIndex = nonNullClassName.lastIndexOf(46);
                if (separatorIndex > 0) {
                    parentNamespace = nonNullClassName.substring(0, separatorIndex);
                }
                boolean notProvidedByConstructors = this.constructors == null || !this.constructors.contains(className) && !this.constructors.contains(outermostClassName);
                boolean bl = notProvidedByRequires = this.requires == null || !this.requires.contains(className) && !this.requires.contains(outermostClassName) && !this.requires.contains(parentNamespace);
                if (!notProvidedByConstructors || !notProvidedByRequires || classNames.contains(className)) continue;
                CheckRequiresForConstructors.this.compiler.report(t.makeError(node, MISSING_REQUIRE_WARNING, className));
                classNames.add(className);
            }
            this.usages.clear();
            this.requires.clear();
            this.constructors.clear();
        }

        private void visitCallNode(Node n, Node parent) {
            String required = CheckRequiresForConstructors.this.codingConvention.extractClassNameIfRequire(n, parent);
            if (required != null) {
                this.requires.add(required);
            }
        }

        private void visitNewNode(NodeTraversal t, Node n) {
            Node qNameNode = n.getFirstChild();
            if (!qNameNode.isQualifiedName()) {
                return;
            }
            Node root = NodeUtil.getRootOfQualifiedName(qNameNode);
            if (!root.isName()) {
                return;
            }
            String name = root.getString();
            TypedVar var = t.getTypedScope().getVar(name);
            if (var != null && (var.isLocal() || var.isExtern())) {
                return;
            }
            this.usages.put(n.getFirstChild().getQualifiedName(), n);
        }

        private void maybeAddConstructor(NodeTraversal t, Node n) {
            JSDocInfo info = n.getJSDocInfo();
            if (info != null) {
                String ctorName = n.getFirstChild().getQualifiedName();
                if (info.isConstructor() || info.isInterface()) {
                    this.constructors.add(ctorName);
                } else {
                    JSType type;
                    JSTypeExpression typeExpr = info.getType();
                    if (typeExpr != null && (type = typeExpr.evaluate(t.getTypedScope(), CheckRequiresForConstructors.this.compiler.getTypeIRegistry())).isConstructor()) {
                        this.constructors.add(ctorName);
                    }
                }
            }
        }

        private void maybeAddJsDocUsages(NodeTraversal t, Node n) {
            JSDocInfo info = NodeUtil.getBestJSDocInfo(n);
            if (info != null) {
                for (JSTypeExpression expr : info.getImplementedInterfaces()) {
                    this.maybeAddJsDocUsage(t, n, expr);
                }
                if (info.getBaseType() != null) {
                    this.maybeAddJsDocUsage(t, n, info.getBaseType());
                }
            }
        }

        private void maybeAddJsDocUsage(NodeTraversal t, Node n, JSTypeExpression expr) {
            Node typeNode = expr.getRoot();
            Preconditions.checkState((typeNode.getType() == 306 ? 1 : 0) != 0);
            Node child = typeNode.getFirstChild();
            Preconditions.checkState((boolean)child.isString());
            String rootName = (String)Splitter.on((char)'.').split((CharSequence)child.getString()).iterator().next();
            TypedVar var = t.getTypedScope().getVar(rootName);
            if (var != null && var.isExtern()) {
                return;
            }
            this.usages.put(child.getString(), n);
        }
    }
}

