/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.Es6ToEs3Converter;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;

public class Es6TypedToEs6Converter
implements NodeTraversal.Callback,
HotSwapCompilerPass {
    static final DiagnosticType CANNOT_CONVERT_MEMBER_VARIABLES = DiagnosticType.error("JSC_CANNOT_CONVERT_FIELDS", "Can only convert class member variables (fields) in declarations or the right hand side of a simple assignment.");
    private final AbstractCompiler compiler;

    Es6TypedToEs6Converter(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        NodeTraversal.traverse(this.compiler, scriptRoot, this);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (n.getType() != 158) {
            return;
        }
        Node classNode = n;
        Node classMembers = classNode.getLastChild();
        Node constructor = null;
        boolean hasMemberVariable = false;
        for (Node member : classMembers.children()) {
            if (member.isMemberFunctionDef() && member.getString().equals("constructor")) {
                constructor = member.getFirstChild();
            } else {
                hasMemberVariable |= member.isMemberVariableDef() || member.isComputedProp() && member.getBooleanProp(75);
            }
            if (constructor == null || !hasMemberVariable) continue;
            break;
        }
        if (!hasMemberVariable) {
            return;
        }
        Preconditions.checkNotNull(constructor, (Object)"Constructor should be added by Es6ConvertSuper");
        Es6ToEs3Converter.ClassDeclarationMetadata metadata = Es6ToEs3Converter.ClassDeclarationMetadata.create(n, parent);
        if (metadata == null) {
            this.compiler.report(JSError.make(n, CANNOT_CONVERT_MEMBER_VARIABLES, new String[0]));
            return;
        }
        Node classNameAccess = NodeUtil.newQName(this.compiler, metadata.fullClassName);
        Node memberVarInsertionPoint = null;
        for (Node member : classMembers.children()) {
            if (!member.isMemberVariableDef() && !member.getBooleanProp(75)) continue;
            this.compiler.reportCodeChange();
            member.getParent().removeChild(member);
            Node qualifiedMemberAccess = Es6ToEs3Converter.getQualifiedMemberAccess(this.compiler, member, classNameAccess, IR.thisNode());
            qualifiedMemberAccess.setJSDocInfo(member.getJSDocInfo());
            Node newNode = NodeUtil.newExpr(qualifiedMemberAccess);
            newNode.useSourceInfoIfMissingFromForTree(member);
            if (member.isStaticMember()) {
                metadata.insertStaticMember(newNode);
                continue;
            }
            constructor.getLastChild().addChildAfter(newNode, memberVarInsertionPoint);
            memberVarInsertionPoint = newNode;
        }
    }
}

