/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.TypeIRegistry;
import com.google.javascript.rhino.jstype.JSType;

public final class ImplicitNullabilityCheck
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    static final DiagnosticType IMPLICITLY_NULLABLE_JSDOC = DiagnosticType.warning("JSC_IMPLICITLY_NULLABLE_JSDOC", "Name {0} in JSDoc is implicitly nullable.\nPlease add a '!' to make it non-nullable, or a '?' to make it explicitly nullable.");
    private final AbstractCompiler compiler;

    public ImplicitNullabilityCheck(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverseRoots(this.compiler, this, externs, root);
    }

    @Override
    public void visit(final NodeTraversal t, Node n, Node p) {
        JSDocInfo info = n.getJSDocInfo();
        if (info == null) {
            return;
        }
        final TypeIRegistry registry = this.compiler.getTypeIRegistry();
        for (Node typeRoot : info.getTypeNodes()) {
            NodeUtil.visitPreOrder(typeRoot, new NodeUtil.Visitor(){

                @Override
                public void visit(Node node) {
                    String typeName;
                    if (!node.isString()) {
                        return;
                    }
                    Node parent = node.getParent();
                    if (parent != null) {
                        switch (parent.getType()) {
                            case 30: 
                            case 42: 
                            case 304: 
                            case 306: {
                                return;
                            }
                        }
                    }
                    if ((typeName = node.getString()).equals("null") || registry.getType(typeName) == null) {
                        return;
                    }
                    JSType type = (JSType)registry.createTypeFromCommentNode(node, "[internal]", null);
                    if (type.isNullable()) {
                        ImplicitNullabilityCheck.this.reportWarning(t, node, typeName);
                    }
                }
            }, (Predicate<Node>)Predicates.alwaysTrue());
        }
    }

    void reportWarning(NodeTraversal t, Node n, String name) {
        this.compiler.report(t.makeError(n, IMPLICITLY_NULLABLE_JSDOC, name));
    }
}

