/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodeChangeHandler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PassFactory;
import com.google.javascript.jscomp.PerformanceTracker;
import com.google.javascript.jscomp.Tracer;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

class PhaseOptimizer
implements CompilerPass {
    private static final Logger logger = Logger.getLogger(PhaseOptimizer.class.getName());
    private final AbstractCompiler compiler;
    private final PerformanceTracker tracker;
    private final List<CompilerPass> passes;
    private boolean inLoop;
    private PassFactory sanityCheck;
    private boolean printAstHashcodes = false;
    private double progress = 0.0;
    private double progressStep = 0.0;
    private final ProgressRange progressRange;
    private NamedPass currentPass;
    private Map<NamedPass, Integer> lastRuns;
    private Node currentScope;
    private int timestamp;
    private int lastChange;
    private static final int START_TIME = 0;
    private final Node jsRoot;
    private boolean crossScopeReporting;
    private Node lastAst;
    private Map<Node, Node> mtoc;
    @VisibleForTesting
    static final List<String> OPTIMAL_ORDER = ImmutableList.of((Object)"deadAssignmentsElimination", (Object)"inlineFunctions", (Object)"removeUnusedPrototypeProperties", (Object)"removeUnreachableCode", (Object)"removeUnusedVars", (Object)"minimizeExitPoints", (Object)"inlineVariables", (Object)"collapseObjectLiterals", (Object)"peepholeOptimizations");
    static final int MAX_LOOPS = 100;
    static final String OPTIMIZE_LOOP_ERROR = "Fixed point loop exceeded the maximum number of iterations.";

    PhaseOptimizer(AbstractCompiler comp, PerformanceTracker tracker, ProgressRange range) {
        this.compiler = comp;
        this.jsRoot = comp.getJsRoot();
        this.tracker = tracker;
        this.passes = Lists.newArrayList();
        this.progressRange = range;
        this.inLoop = false;
        this.crossScopeReporting = false;
        this.lastChange = 0;
        this.timestamp = 0;
    }

    void consume(List<PassFactory> factories) {
        Loop currentLoop = new Loop();
        boolean isCurrentLoopPopulated = false;
        for (PassFactory factory : factories) {
            if (factory.isOneTimePass()) {
                if (isCurrentLoopPopulated) {
                    this.passes.add(currentLoop);
                    currentLoop = new Loop();
                    isCurrentLoopPopulated = false;
                }
                this.addOneTimePass(factory);
                continue;
            }
            currentLoop.addLoopedPass(factory);
            isCurrentLoopPopulated = true;
        }
        if (isCurrentLoopPopulated) {
            this.passes.add(currentLoop);
        }
    }

    @VisibleForTesting
    void addOneTimePass(PassFactory factory) {
        this.passes.add(new NamedPass(factory));
    }

    Loop addFixedPointLoop() {
        Loop loop = new Loop();
        this.passes.add(loop);
        return loop;
    }

    void setSanityCheck(PassFactory sanityCheck) {
        this.sanityCheck = sanityCheck;
        this.setSanityCheckState();
    }

    private void setSanityCheckState() {
        if (this.inLoop) {
            this.lastAst = this.jsRoot.cloneTree();
            this.mtoc = NodeUtil.mapMainToClone(this.jsRoot, this.lastAst);
        }
    }

    void setPrintAstHashcodes(boolean printAstHashcodes) {
        this.printAstHashcodes = printAstHashcodes;
    }

    @Override
    public void process(Node externs, Node root) {
        this.progress = 0.0;
        this.progressStep = 0.0;
        if (this.progressRange != null) {
            this.progressStep = (this.progressRange.maxValue - this.progressRange.initialValue) / (double)this.passes.size();
            this.progress = this.progressRange.initialValue;
        }
        for (CompilerPass pass : this.passes) {
            pass.process(externs, root);
            if (!this.hasHaltingErrors()) continue;
            return;
        }
    }

    private void maybePrintAstHashcodes(String passName, Node root) {
        if (this.printAstHashcodes) {
            String hashCodeMsg = "AST hashCode after " + passName + ": " + this.compiler.toSource(root).hashCode();
            System.err.println(hashCodeMsg);
            this.compiler.addToDebugLog(hashCodeMsg);
        }
    }

    private void maybeSanityCheck(Node externs, Node root) {
        if (this.sanityCheck != null) {
            this.sanityCheck.create(this.compiler).process(externs, root);
            if (this.inLoop && !this.currentPass.name.equals("crossModuleCodeMotion") && !this.currentPass.name.equals("crossModuleMethodMotion")) {
                NodeUtil.verifyScopeChanges(this.mtoc, this.jsRoot, true, this.compiler);
            }
        }
    }

    private boolean hasHaltingErrors() {
        return this.compiler.hasHaltingErrors();
    }

    void setScope(Node n) {
        if (this.inLoop) {
            this.currentScope = n.isFunction() ? n : this.getEnclosingScope(n);
        }
    }

    boolean hasScopeChanged(Node n) {
        if (!this.inLoop) {
            return true;
        }
        int timeOfLastRun = this.lastRuns.get(this.currentPass);
        return timeOfLastRun == 0 || n.getChangeTime() > timeOfLastRun;
    }

    private Node getEnclosingScope(Node n) {
        while (n != this.jsRoot && n.getParent() != null) {
            if (!(n = n.getParent()).isFunction()) continue;
            return n;
        }
        return n;
    }

    void reportChangeToEnclosingScope(Node n) {
        this.lastChange = this.timestamp;
        this.getEnclosingScope(n).setChangeTime(this.timestamp);
        ++this.timestamp;
    }

    void startCrossScopeReporting() {
        this.crossScopeReporting = true;
    }

    void endCrossScopeReporting() {
        this.crossScopeReporting = false;
    }

    static class ProgressRange {
        public final double initialValue;
        public final double maxValue;

        public ProgressRange(double initialValue, double maxValue) {
            this.initialValue = initialValue;
            this.maxValue = maxValue;
        }
    }

    @VisibleForTesting
    class Loop
    implements CompilerPass {
        private final List<NamedPass> myPasses = Lists.newArrayList();
        private final Set<String> myNames = Sets.newHashSet();
        private ScopedChangeHandler scopeHandler;

        Loop() {
        }

        void addLoopedPass(PassFactory factory) {
            String name = factory.getName();
            Preconditions.checkArgument((!this.myNames.contains(name) ? 1 : 0) != 0, (String)"Already a pass with name '%s' in this loop", (Object[])new Object[]{name});
            this.myNames.add(name);
            this.myPasses.add(new NamedPass(factory));
        }

        @Override
        public void process(Node externs, Node root) {
            Preconditions.checkState((!PhaseOptimizer.this.inLoop ? 1 : 0) != 0, (Object)"Nested loops are forbidden");
            PhaseOptimizer.this.inLoop = true;
            this.optimizePasses();
            this.scopeHandler = new ScopedChangeHandler();
            PhaseOptimizer.this.compiler.addChangeHandler(this.scopeHandler);
            PhaseOptimizer.this.setScope(root);
            PhaseOptimizer.this.lastRuns = new HashMap();
            for (NamedPass pass : this.myPasses) {
                PhaseOptimizer.this.lastRuns.put(pass, 0);
            }
            HashSet madeChanges = Sets.newHashSet();
            HashSet runInPrevIter = Sets.newHashSet();
            State state = State.RUN_PASSES_NOT_RUN_IN_PREV_ITER;
            int count = 0;
            try {
                while (true) {
                    if (count++ > 100) {
                        PhaseOptimizer.this.compiler.throwInternalError(PhaseOptimizer.OPTIMIZE_LOOP_ERROR, null);
                    }
                    boolean lastIterMadeChanges = false;
                    for (NamedPass pass : this.myPasses) {
                        if (state == State.RUN_PASSES_NOT_RUN_IN_PREV_ITER && !runInPrevIter.contains(pass) || state == State.RUN_PASSES_THAT_CHANGED_STH_IN_PREV_ITER && madeChanges.contains(pass)) {
                            PhaseOptimizer.this.timestamp++;
                            PhaseOptimizer.this.currentPass = pass;
                            pass.process(externs, root);
                            runInPrevIter.add(pass);
                            PhaseOptimizer.this.lastRuns.put(pass, PhaseOptimizer.this.timestamp);
                            if (PhaseOptimizer.this.hasHaltingErrors()) {
                                return;
                            }
                            if (this.scopeHandler.hasCodeChangedSinceLastCall()) {
                                madeChanges.add(pass);
                                lastIterMadeChanges = true;
                                continue;
                            }
                            madeChanges.remove(pass);
                            continue;
                        }
                        runInPrevIter.remove(pass);
                    }
                    if (state == State.RUN_PASSES_NOT_RUN_IN_PREV_ITER) {
                        if (lastIterMadeChanges) {
                            state = State.RUN_PASSES_THAT_CHANGED_STH_IN_PREV_ITER;
                            continue;
                        }
                        return;
                    }
                    if (lastIterMadeChanges) continue;
                    state = State.RUN_PASSES_NOT_RUN_IN_PREV_ITER;
                }
            }
            finally {
                PhaseOptimizer.this.inLoop = false;
                PhaseOptimizer.this.compiler.removeChangeHandler(this.scopeHandler);
            }
        }

        private void optimizePasses() {
            ArrayList optimalPasses = Lists.newArrayList();
            block0: for (String passInOptimalOrder : OPTIMAL_ORDER) {
                for (NamedPass loopablePass : this.myPasses) {
                    if (!loopablePass.name.equals(passInOptimalOrder)) continue;
                    optimalPasses.add(loopablePass);
                    continue block0;
                }
            }
            this.myPasses.removeAll(optimalPasses);
            this.myPasses.addAll(optimalPasses);
        }
    }

    private class ScopedChangeHandler
    implements CodeChangeHandler {
        private int lastCodeChangeQuery;

        ScopedChangeHandler() {
            this.lastCodeChangeQuery = PhaseOptimizer.this.timestamp;
        }

        @Override
        public void reportChange() {
            if (PhaseOptimizer.this.crossScopeReporting) {
                return;
            }
            PhaseOptimizer.this.lastChange = PhaseOptimizer.this.timestamp;
            PhaseOptimizer.this.currentScope.setChangeTime(PhaseOptimizer.this.timestamp);
            PhaseOptimizer.this.timestamp++;
        }

        private boolean hasCodeChangedSinceLastCall() {
            boolean result = PhaseOptimizer.this.lastChange > this.lastCodeChangeQuery;
            this.lastCodeChangeQuery = PhaseOptimizer.this.timestamp;
            PhaseOptimizer.this.timestamp++;
            return result;
        }
    }

    class NamedPass
    implements CompilerPass {
        final String name;
        private final PassFactory factory;
        private Tracer tracer;

        NamedPass(PassFactory factory) {
            this.name = factory.getName();
            this.factory = factory;
        }

        @Override
        public void process(Node externs, Node root) {
            logger.fine(this.name);
            if (PhaseOptimizer.this.sanityCheck != null) {
                PhaseOptimizer.this.setSanityCheckState();
            }
            if (PhaseOptimizer.this.tracker != null) {
                PhaseOptimizer.this.tracker.recordPassStart(this.name, this.factory.isOneTimePass());
            }
            this.tracer = new Tracer("JSCompiler");
            PhaseOptimizer.this.compiler.beforePass(this.name);
            this.factory.create(PhaseOptimizer.this.compiler).process(externs, root);
            PhaseOptimizer.this.compiler.afterPass(this.name);
            try {
                if (PhaseOptimizer.this.progressRange == null) {
                    PhaseOptimizer.this.compiler.setProgress(-1.0, this.name);
                } else {
                    PhaseOptimizer.this.progress = PhaseOptimizer.this.progress + PhaseOptimizer.this.progressStep;
                    PhaseOptimizer.this.compiler.setProgress(PhaseOptimizer.this.progress, this.name);
                }
                long traceRuntime = this.tracer.stop();
                if (PhaseOptimizer.this.tracker != null) {
                    PhaseOptimizer.this.tracker.recordPassStop(this.name, traceRuntime);
                }
                PhaseOptimizer.this.maybePrintAstHashcodes(this.name, root);
                PhaseOptimizer.this.maybeSanityCheck(externs, root);
            }
            catch (IllegalStateException e) {
                throw new RuntimeException("Sanity check failed for " + this.name, e);
            }
        }

        public String toString() {
            return "pass: " + this.name;
        }
    }

    static enum State {
        RUN_PASSES_NOT_RUN_IN_PREV_ITER,
        RUN_PASSES_THAT_CHANGED_STH_IN_PREV_ITER;

    }
}

