/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.StaticSymbolTable;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.SimpleReference;
import com.google.javascript.rhino.jstype.SimpleSlot;
import com.google.javascript.rhino.jstype.StaticTypedScope;
import java.util.Collections;
import java.util.Map;

final class PreprocessorSymbolTable
implements StaticTypedScope<JSType>,
StaticSymbolTable<SimpleSlot, Reference> {
    private final Map<String, SimpleSlot> symbols = Maps.newHashMap();
    private final Multimap<String, Reference> refs = ArrayListMultimap.create();
    private final Node root;

    PreprocessorSymbolTable(Node root) {
        this.root = root;
    }

    @Override
    public Node getRootNode() {
        return this.root;
    }

    @Override
    public JSType getTypeOfThis() {
        return null;
    }

    @Override
    public StaticTypedScope<JSType> getParentScope() {
        return null;
    }

    @Override
    public SimpleSlot getSlot(String name) {
        return this.symbols.get(name);
    }

    @Override
    public SimpleSlot getOwnSlot(String name) {
        return this.getSlot(name);
    }

    @Override
    public Iterable<Reference> getReferences(SimpleSlot symbol) {
        return Collections.unmodifiableCollection(this.refs.get((Object)symbol.getName()));
    }

    @Override
    public Iterable<SimpleSlot> getAllSymbols() {
        return Collections.unmodifiableCollection(this.symbols.values());
    }

    public StaticTypedScope<JSType> getScope(SimpleSlot slot) {
        return this;
    }

    void addReference(Node node) {
        String name = node.getQualifiedName();
        Preconditions.checkNotNull((Object)name);
        if (!this.symbols.containsKey(name)) {
            this.symbols.put(name, new SimpleSlot(name, null, true));
        }
        this.refs.put((Object)name, (Object)new Reference(this.symbols.get(name), node));
    }

    static final class Reference
    extends SimpleReference<SimpleSlot> {
        Reference(SimpleSlot symbol, Node node) {
            super(symbol, node);
        }
    }
}

