/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.GlobalNamespace;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.TypeI;
import com.google.javascript.rhino.TypeIRegistry;
import com.google.javascript.rhino.jstype.JSTypeNative;
import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ProcessDefines
implements CompilerPass {
    private static final Set<String> KNOWN_DEFINES = ImmutableSet.of((Object)"COMPILED");
    private final AbstractCompiler compiler;
    private final Map<String, Node> dominantReplacements;
    private GlobalNamespace namespace = null;
    static final DiagnosticType UNKNOWN_DEFINE_WARNING = DiagnosticType.warning("JSC_UNKNOWN_DEFINE_WARNING", "unknown @define variable {0}");
    static final DiagnosticType INVALID_DEFINE_TYPE_ERROR = DiagnosticType.error("JSC_INVALID_DEFINE_TYPE_ERROR", "@define tag only permits literal types");
    static final DiagnosticType INVALID_DEFINE_INIT_ERROR = DiagnosticType.error("JSC_INVALID_DEFINE_INIT_ERROR", "illegal initialization of @define variable {0}");
    static final DiagnosticType NON_GLOBAL_DEFINE_INIT_ERROR = DiagnosticType.error("JSC_NON_GLOBAL_DEFINE_INIT_ERROR", "@define variable {0} assignment must be global");
    static final DiagnosticType DEFINE_NOT_ASSIGNABLE_ERROR = DiagnosticType.error("JSC_DEFINE_NOT_ASSIGNABLE_ERROR", "@define variable {0} cannot be reassigned due to code at {1}.");
    private static final MessageFormat REASON_DEFINE_NOT_ASSIGNABLE = new MessageFormat("line {0} of {1}");

    ProcessDefines(AbstractCompiler compiler, Map<String, Node> replacements) {
        this.compiler = compiler;
        this.dominantReplacements = replacements;
    }

    ProcessDefines injectNamespace(GlobalNamespace namespace) {
        this.namespace = namespace;
        return this;
    }

    @Override
    public void process(Node externs, Node root) {
        if (this.namespace == null) {
            this.namespace = new GlobalNamespace(this.compiler, root);
        }
        this.overrideDefines(this.collectDefines(root, this.namespace));
    }

    private void overrideDefines(Map<String, DefineInfo> allDefines) {
        boolean changed = false;
        for (Map.Entry<String, DefineInfo> def : allDefines.entrySet()) {
            String defineName = def.getKey();
            DefineInfo info = def.getValue();
            Node inputValue = this.dominantReplacements.get(defineName);
            Node finalValue = inputValue != null ? inputValue : info.getLastValue();
            if (finalValue == info.initialValue) continue;
            info.initialValueParent.replaceChild(info.initialValue, finalValue.cloneTree());
            this.compiler.addToDebugLog("Overriding @define variable " + defineName);
            changed = changed || finalValue.getType() != info.initialValue.getType() || !finalValue.isEquivalentTo(info.initialValue);
        }
        if (changed) {
            this.compiler.reportCodeChange();
        }
        Sets.SetView unusedReplacements = Sets.difference(this.dominantReplacements.keySet(), (Set)Sets.union(KNOWN_DEFINES, allDefines.keySet()));
        for (String unknownDefine : unusedReplacements) {
            this.compiler.report(JSError.make(UNKNOWN_DEFINE_WARNING, unknownDefine));
        }
    }

    private static String format(MessageFormat format, Object ... params) {
        return format.format(params);
    }

    private boolean isValidDefineType(JSTypeExpression expression) {
        TypeIRegistry registry = this.compiler.getTypeIRegistry();
        TypeI type = expression.evaluateInEmptyScope(registry);
        return !type.isUnknownType() && type.isSubtypeOf((TypeI)registry.getNativeType(JSTypeNative.NUMBER_STRING_BOOLEAN));
    }

    private Map<String, DefineInfo> collectDefines(Node root, GlobalNamespace namespace) {
        ArrayList allDefines = Lists.newArrayList();
        block0: for (GlobalNamespace.Name name : namespace.getNameIndex().values()) {
            GlobalNamespace.Ref decl = name.getDeclaration();
            if (name.docInfo != null && name.docInfo.isDefine()) {
                if (this.isValidDefineType(name.docInfo.getType())) {
                    allDefines.add(name);
                    continue;
                }
                JSError error = JSError.make(decl.node, INVALID_DEFINE_TYPE_ERROR, new String[0]);
                this.compiler.report(error);
                continue;
            }
            for (GlobalNamespace.Ref ref : name.getRefs()) {
                if (ref == decl) continue;
                Node n = ref.node;
                Node parent = ref.node.getParent();
                JSDocInfo info = n.getJSDocInfo();
                if (info == null && parent.isVar() && parent.hasOneChild()) {
                    info = parent.getJSDocInfo();
                }
                if (info == null || !info.isDefine()) continue;
                allDefines.add(name);
                continue block0;
            }
        }
        CollectDefines pass = new CollectDefines(this.compiler, allDefines);
        NodeTraversal.traverse(this.compiler, root, pass);
        return pass.getAllDefines();
    }

    private static final class DefineInfo {
        public final Node initialValueParent;
        public final Node initialValue;
        private Node lastValue;
        private boolean isAssignable;
        private String reasonNotAssignable;

        public DefineInfo(Node initialValue, Node initialValueParent) {
            this.initialValueParent = initialValueParent;
            this.initialValue = initialValue;
            this.lastValue = initialValue;
            this.isAssignable = true;
        }

        public void setNotAssignable(String reason) {
            this.isAssignable = false;
            this.reasonNotAssignable = reason;
        }

        public String getReasonWhyNotAssignable() {
            return this.reasonNotAssignable;
        }

        public boolean recordAssignment(Node value) {
            this.lastValue = value;
            return this.isAssignable;
        }

        public Node getLastValue() {
            return this.lastValue;
        }
    }

    private static final class CollectDefines
    implements NodeTraversal.Callback {
        private final AbstractCompiler compiler;
        private final Map<String, DefineInfo> assignableDefines;
        private final Map<String, DefineInfo> allDefines;
        private final Map<Node, RefInfo> allRefInfo;
        private Node lvalueToRemoveLater = null;
        private final Deque<Integer> assignAllowed;

        CollectDefines(AbstractCompiler compiler, List<GlobalNamespace.Name> listOfDefines) {
            this.compiler = compiler;
            this.allDefines = Maps.newHashMap();
            this.assignableDefines = Maps.newHashMap();
            this.assignAllowed = new ArrayDeque<Integer>();
            this.assignAllowed.push(1);
            this.allRefInfo = Maps.newHashMap();
            for (GlobalNamespace.Name name : listOfDefines) {
                GlobalNamespace.Ref decl = name.getDeclaration();
                if (decl != null) {
                    this.allRefInfo.put(decl.node, new RefInfo(decl, name));
                }
                for (GlobalNamespace.Ref ref : name.getRefs()) {
                    if (ref == decl || ref.getTwin() != null && ref.getTwin().isSet()) continue;
                    this.allRefInfo.put(ref.node, new RefInfo(ref, name));
                }
            }
        }

        Map<String, DefineInfo> getAllDefines() {
            return this.allDefines;
        }

        @Override
        public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
            this.updateAssignAllowedStack(n, true);
            return true;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            RefInfo refInfo = this.allRefInfo.get(n);
            if (refInfo != null) {
                GlobalNamespace.Ref ref = refInfo.ref;
                GlobalNamespace.Name name = refInfo.name;
                String fullName = name.getFullName();
                switch (ref.type) {
                    case SET_FROM_GLOBAL: 
                    case SET_FROM_LOCAL: {
                        Node valParent = CollectDefines.getValueParent(ref);
                        Node val = valParent.getLastChild();
                        if (valParent.isAssign() && name.isSimpleName() && name.getDeclaration() == ref) {
                            this.compiler.report(t.makeError(val, INVALID_DEFINE_INIT_ERROR, fullName));
                            break;
                        }
                        if (!this.processDefineAssignment(t, fullName, val, valParent)) break;
                        refInfo.name.removeRef(ref);
                        this.lvalueToRemoveLater = valParent;
                        break;
                    }
                    default: {
                        DefineInfo info;
                        if (!t.inGlobalScope() || (info = this.assignableDefines.get(fullName)) == null) break;
                        CollectDefines.setDefineInfoNotAssignable(info, t);
                        this.assignableDefines.remove(fullName);
                    }
                }
            }
            if (!t.inGlobalScope() && n.getJSDocInfo() != null && n.getJSDocInfo().isDefine()) {
                this.compiler.report(t.makeError(n, NON_GLOBAL_DEFINE_INIT_ERROR, ""));
            }
            if (this.lvalueToRemoveLater == n) {
                this.lvalueToRemoveLater = null;
                if (n.isAssign()) {
                    Node last = n.getLastChild();
                    n.removeChild(last);
                    parent.replaceChild(n, last);
                } else {
                    Preconditions.checkState((boolean)n.isName());
                    n.removeChild(n.getFirstChild());
                }
                this.compiler.reportCodeChange();
            }
            if (n.isCall() && t.inGlobalScope()) {
                for (DefineInfo info : this.assignableDefines.values()) {
                    CollectDefines.setDefineInfoNotAssignable(info, t);
                }
                this.assignableDefines.clear();
            }
            this.updateAssignAllowedStack(n, false);
        }

        private void updateAssignAllowedStack(Node n, boolean entering) {
            switch (n.getType()) {
                case 98: 
                case 105: 
                case 108: 
                case 110: 
                case 111: 
                case 113: 
                case 115: {
                    if (entering) {
                        this.assignAllowed.push(0);
                        break;
                    }
                    this.assignAllowed.remove();
                }
            }
        }

        private boolean isAssignAllowed() {
            return this.assignAllowed.element() == 1;
        }

        private boolean processDefineAssignment(NodeTraversal t, String name, Node value, Node valueParent) {
            if (value == null || !NodeUtil.isValidDefineValue(value, this.allDefines.keySet())) {
                this.compiler.report(t.makeError(value, INVALID_DEFINE_INIT_ERROR, name));
            } else if (!this.isAssignAllowed()) {
                this.compiler.report(t.makeError(valueParent, NON_GLOBAL_DEFINE_INIT_ERROR, name));
            } else {
                DefineInfo info = this.allDefines.get(name);
                if (info == null) {
                    info = new DefineInfo(value, valueParent);
                    this.allDefines.put(name, info);
                    this.assignableDefines.put(name, info);
                } else {
                    if (info.recordAssignment(value)) {
                        return true;
                    }
                    this.compiler.report(t.makeError(valueParent, DEFINE_NOT_ASSIGNABLE_ERROR, name, info.getReasonWhyNotAssignable()));
                }
            }
            return false;
        }

        private static Node getValueParent(GlobalNamespace.Ref ref) {
            return ref.node.getParent() != null && ref.node.getParent().isVar() ? ref.node : ref.node.getParent();
        }

        private static void setDefineInfoNotAssignable(DefineInfo info, NodeTraversal t) {
            info.setNotAssignable(ProcessDefines.format(REASON_DEFINE_NOT_ASSIGNABLE, new Object[]{t.getLineNumber(), t.getSourceName()}));
        }

        private static class RefInfo {
            final GlobalNamespace.Ref ref;
            final GlobalNamespace.Name name;

            RefInfo(GlobalNamespace.Ref ref, GlobalNamespace.Name name) {
                this.ref = ref;
                this.name = name;
            }
        }
    }
}

