/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.TypedVar;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.StaticTypedScope;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class TypedScope
extends Scope
implements StaticTypedScope<JSType> {
    private final Map<String, TypedVar> vars = new LinkedHashMap<String, TypedVar>();
    private final TypedScope parent;
    private final boolean isBottom;
    private static final Predicate<TypedVar> DECLARATIVELY_UNBOUND_VARS_WITHOUT_TYPES = new Predicate<TypedVar>(){

        public boolean apply(TypedVar var) {
            return var.getParentNode() != null && var.getType() == null && var.getParentNode().isVar() && !var.isExtern();
        }
    };
    private TypeResolver typeResolver;

    TypedScope(TypedScope parent, Node rootNode) {
        super(parent, rootNode);
        this.parent = parent;
        this.isBottom = false;
    }

    private TypedScope(Node rootNode, boolean isBottom) {
        super(rootNode);
        this.parent = null;
        this.isBottom = isBottom;
    }

    static TypedScope createGlobalScope(Node rootNode) {
        return new TypedScope(rootNode, false);
    }

    static TypedScope createLatticeBottom(Node rootNode) {
        return new TypedScope(rootNode, true);
    }

    boolean isBottom() {
        return this.isBottom;
    }

    @Override
    int getDepth() {
        return this.depth;
    }

    @Override
    public Node getRootNode() {
        return this.rootNode;
    }

    @Override
    public TypedScope getParent() {
        return this.parent;
    }

    @Override
    TypedScope getGlobalScope() {
        TypedScope result = this;
        while (result.getParent() != null) {
            result = result.getParent();
        }
        return result;
    }

    @Override
    public StaticTypedScope<JSType> getParentScope() {
        return this.parent;
    }

    @Override
    public JSType getTypeOfThis() {
        if (this.isGlobal()) {
            return ObjectType.cast(this.rootNode.getJSType());
        }
        Preconditions.checkState((boolean)this.rootNode.isFunction());
        JSType nodeType = this.rootNode.getJSType();
        if (nodeType != null && nodeType.isFunctionType()) {
            return nodeType.toMaybeFunctionType().getTypeOfThis();
        }
        return null;
    }

    @Override
    Var declare(String name, Node nameNode, CompilerInput input) {
        throw new IllegalStateException("Method declare(untyped) cannot be called on typed scopes.");
    }

    TypedVar declare(String name, Node nameNode, JSType type, CompilerInput input) {
        return this.declare(name, nameNode, type, input, true);
    }

    TypedVar declare(String name, Node nameNode, JSType type, CompilerInput input, boolean inferred) {
        Preconditions.checkState((name != null && !name.isEmpty() ? 1 : 0) != 0);
        TypedVar var = new TypedVar(inferred, name, nameNode, type, this, this.vars.size(), input);
        this.vars.put(name, var);
        return var;
    }

    @Override
    void undeclare(Var var) {
        TypedVar tvar = (TypedVar)var;
        Preconditions.checkState((tvar.scope == this ? 1 : 0) != 0);
        Preconditions.checkState((this.vars.get(tvar.name) == tvar ? 1 : 0) != 0);
        this.vars.remove(tvar.name);
    }

    @Override
    public TypedVar getSlot(String name) {
        return this.getVar(name);
    }

    @Override
    public TypedVar getOwnSlot(String name) {
        return this.vars.get(name);
    }

    @Override
    public TypedVar getVar(String name) {
        TypedScope scope = this;
        while (scope != null) {
            TypedVar var = scope.vars.get(name);
            if (var != null) {
                return var;
            }
            scope = scope.parent;
        }
        return null;
    }

    @Override
    public Var getArgumentsVar() {
        throw new IllegalStateException("Method getArgumentsVar cannot be called on typed scopes.");
    }

    @Override
    public boolean isDeclared(String name, boolean recurse) {
        TypedScope scope = this;
        while (true) {
            if (scope.vars.containsKey(name)) {
                return true;
            }
            if (scope.parent == null || !recurse) break;
            scope = scope.parent;
        }
        return false;
    }

    public Iterator<TypedVar> getVars() {
        return this.vars.values().iterator();
    }

    @Override
    Iterable<Var> getVarIterable() {
        throw new IllegalStateException("Method getVarIterable cannot be called on typed scopes.");
    }

    public Iterable<TypedVar> getAllSymbols() {
        return Collections.unmodifiableCollection(this.vars.values());
    }

    @Override
    public int getVarCount() {
        return this.vars.size();
    }

    @Override
    public boolean isGlobal() {
        return this.parent == null;
    }

    @Override
    public boolean isLocal() {
        return this.parent != null;
    }

    public Iterator<TypedVar> getDeclarativelyUnboundVarsWithoutTypes() {
        return Iterators.filter(this.getVars(), DECLARATIVELY_UNBOUND_VARS_WITHOUT_TYPES);
    }

    void resolveTypes() {
        if (this.typeResolver != null) {
            this.typeResolver.resolveTypes();
            this.typeResolver = null;
        }
    }

    void setTypeResolver(TypeResolver resolver) {
        this.typeResolver = resolver;
    }

    @Override
    public boolean isBlockScope() {
        throw new IllegalStateException("Method isBlockScope cannot be called on typed scopes.");
    }

    @Override
    public boolean isHoistScope() {
        throw new IllegalStateException("Method isHoistScope cannot be called on typed scopes.");
    }

    @Override
    public boolean isFunctionBlockScope() {
        throw new IllegalStateException("Method isFunctionBlockScope cannot be called on typed scopes.");
    }

    @Override
    public Scope getClosestHoistScope() {
        throw new IllegalStateException("Method getClosestHoistScope cannot be called on typed scopes.");
    }

    static interface TypeResolver {
        public void resolveTypes();
    }
}

