/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.TypedScope;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.StaticRef;
import com.google.javascript.rhino.StaticSlot;
import com.google.javascript.rhino.StaticSourceFile;

public class Var
implements StaticSlot,
StaticRef {
    final String name;
    final Node nameNode;
    final CompilerInput input;
    final int index;
    final Scope scope;

    Var(String name, Node nameNode, Scope scope, int index, CompilerInput input) {
        this.name = name;
        this.nameNode = nameNode;
        this.scope = scope;
        this.index = index;
        this.input = input;
    }

    static Var makeArgumentsVar(Scope scope) {
        Preconditions.checkArgument((!(scope instanceof TypedScope) ? 1 : 0) != 0);
        return new Arguments(scope);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Node getNode() {
        return this.nameNode;
    }

    CompilerInput getInput() {
        return this.input;
    }

    @Override
    public StaticSourceFile getSourceFile() {
        return this.nameNode.getStaticSourceFile();
    }

    @Override
    public Var getSymbol() {
        return this;
    }

    @Override
    public Var getDeclaration() {
        return this.nameNode == null ? null : this;
    }

    public Node getParentNode() {
        return this.nameNode == null ? null : this.nameNode.getParent();
    }

    public boolean isBleedingFunction() {
        return NodeUtil.isFunctionExpression(this.getParentNode());
    }

    Scope getScope() {
        return this.scope;
    }

    public boolean isGlobal() {
        return this.scope.isGlobal();
    }

    public boolean isLocal() {
        return this.scope.isLocal();
    }

    boolean isExtern() {
        return this.input == null || this.input.isExtern();
    }

    public boolean isInferredConst() {
        if (this.nameNode == null) {
            return false;
        }
        return this.nameNode.getBooleanProp(64) || this.nameNode.getBooleanProp(43);
    }

    public boolean isDefine() {
        JSDocInfo info = this.getJSDocInfo();
        return info != null && info.isDefine();
    }

    public Node getInitialValue() {
        return NodeUtil.getRValueOfLValue(this.nameNode);
    }

    public Node getNameNode() {
        return this.nameNode;
    }

    @Override
    public JSDocInfo getJSDocInfo() {
        return this.nameNode == null ? null : NodeUtil.getBestJSDocInfo(this.nameNode);
    }

    public boolean equals(Object other) {
        if (!(other instanceof Var)) {
            return false;
        }
        Var otherVar = (Var)other;
        return otherVar.nameNode == this.nameNode;
    }

    public int hashCode() {
        return this.nameNode.hashCode();
    }

    public String toString() {
        return "Var " + this.name;
    }

    boolean isVar() {
        return this.declarationType() == 118;
    }

    boolean isLet() {
        return this.declarationType() == 162;
    }

    boolean isConst() {
        return this.declarationType() == 149;
    }

    boolean isParam() {
        return this.declarationType() == 83;
    }

    private int declarationType() {
        ImmutableSet types = ImmutableSet.of((Object)118, (Object)162, (Object)149, (Object)105, (Object)158, (Object)120, (Object[])new Integer[]{83});
        for (Node current = this.nameNode; current != null; current = current.getParent()) {
            if (!types.contains(current.getType())) continue;
            return current.getType();
        }
        throw new IllegalStateException("The nameNode for " + this + " must be a descendant" + " of one of: " + types);
    }

    private static class Arguments
    extends Var {
        Arguments(Scope scope) {
            super("arguments", null, scope, -1, null);
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof Arguments)) {
                return false;
            }
            Arguments otherVar = (Arguments)other;
            return otherVar.scope.getRootNode() == this.scope.getRootNode();
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this);
        }
    }
}

