/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.deps;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.deps.DependencyInfo;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;

public class SortedDependencies<INPUT extends DependencyInfo> {
    private final List<INPUT> inputs;
    private final List<INPUT> sortedList;
    private final List<INPUT> noProvides;
    private final Map<String, INPUT> provideMap = Maps.newHashMap();

    public SortedDependencies(List<INPUT> inputs) throws CircularDependencyException {
        this.inputs = Lists.newArrayList(inputs);
        this.noProvides = Lists.newArrayList();
        for (Object input : inputs) {
            Collection<String> currentProvides = input.getProvides();
            if (currentProvides.isEmpty()) {
                this.noProvides.add(input);
            }
            for (String provide : currentProvides) {
                this.provideMap.put(provide, input);
            }
        }
        HashMultimap deps = HashMultimap.create();
        for (DependencyInfo input : inputs) {
            for (String req : input.getRequires()) {
                DependencyInfo dep = (DependencyInfo)this.provideMap.get(req);
                if (dep == null || dep == input) continue;
                deps.put((Object)input, (Object)dep);
            }
        }
        this.sortedList = SortedDependencies.topologicalStableSort(inputs, deps);
        if (this.sortedList.size() < inputs.size()) {
            ArrayList subGraph = Lists.newArrayList(inputs);
            subGraph.removeAll(this.sortedList);
            throw new CircularDependencyException(this.cycleToString(this.findCycle(subGraph, (Multimap<INPUT, INPUT>)deps)));
        }
    }

    public INPUT getInputProviding(String symbol) throws MissingProvideException {
        if (this.provideMap.containsKey(symbol)) {
            return (INPUT)((DependencyInfo)this.provideMap.get(symbol));
        }
        throw new MissingProvideException(symbol);
    }

    public INPUT maybeGetInputProviding(String symbol) {
        return (INPUT)((DependencyInfo)this.provideMap.get(symbol));
    }

    private List<INPUT> findCycle(List<INPUT> subGraph, Multimap<INPUT, INPUT> deps) {
        return this.findCycle((DependencyInfo)subGraph.get(0), Sets.newHashSet(subGraph), deps, Sets.newHashSet());
    }

    private List<INPUT> findCycle(INPUT current, Set<INPUT> subGraph, Multimap<INPUT, INPUT> deps, Set<INPUT> covered) {
        if (covered.add(current)) {
            List<INPUT> cycle = this.findCycle(this.findRequireInSubGraphOrFail(current, subGraph), subGraph, deps, covered);
            if (cycle.get(0) != cycle.get(cycle.size() - 1)) {
                cycle.add(current);
            }
            return cycle;
        }
        ArrayList cycle = Lists.newArrayList();
        cycle.add(current);
        return cycle;
    }

    private INPUT findRequireInSubGraphOrFail(INPUT input, Set<INPUT> subGraph) {
        for (String symbol : input.getRequires()) {
            DependencyInfo candidate = (DependencyInfo)this.provideMap.get(symbol);
            if (!subGraph.contains(candidate)) continue;
            return (INPUT)candidate;
        }
        throw new IllegalStateException("no require found in subgraph");
    }

    private String cycleToString(List<INPUT> cycle) {
        ArrayList symbols = Lists.newArrayList();
        for (int i = cycle.size() - 1; i >= 0; --i) {
            symbols.add(((DependencyInfo)cycle.get(i)).getProvides().iterator().next());
        }
        symbols.add(symbols.get(0));
        return Joiner.on((String)" -> ").join((Iterable)symbols);
    }

    public List<INPUT> getSortedList() {
        return Collections.unmodifiableList(this.sortedList);
    }

    public List<INPUT> getSortedDependenciesOf(List<INPUT> roots) {
        return this.getDependenciesOf(roots, true);
    }

    public List<INPUT> getDependenciesOf(List<INPUT> roots, boolean sorted) {
        Preconditions.checkArgument((boolean)this.inputs.containsAll(roots));
        HashSet included = Sets.newHashSet();
        ArrayDeque<INPUT> worklist = new ArrayDeque<INPUT>(roots);
        while (!worklist.isEmpty()) {
            DependencyInfo current = (DependencyInfo)worklist.pop();
            if (!included.add(current)) continue;
            for (String req : current.getRequires()) {
                DependencyInfo dep = (DependencyInfo)this.provideMap.get(req);
                if (dep == null) continue;
                worklist.add(dep);
            }
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (DependencyInfo current : sorted ? this.sortedList : this.inputs) {
            if (!included.contains(current)) continue;
            builder.add((Object)current);
        }
        return builder.build();
    }

    public List<INPUT> getInputsWithoutProvides() {
        return Collections.unmodifiableList(this.noProvides);
    }

    private static <T> List<T> topologicalStableSort(List<T> items, Multimap<T, T> deps) {
        if (items.isEmpty()) {
            return Lists.newArrayList();
        }
        final HashMap originalIndex = Maps.newHashMap();
        for (int i = 0; i < items.size(); ++i) {
            originalIndex.put(items.get(i), i);
        }
        PriorityQueue<Object> inDegreeZero = new PriorityQueue<Object>(items.size(), new Comparator<T>(){

            @Override
            public int compare(T a, T b) {
                return (Integer)originalIndex.get(a) - (Integer)originalIndex.get(b);
            }
        });
        ArrayList result = Lists.newArrayList();
        HashMultiset inDegree = HashMultiset.create();
        ArrayListMultimap reverseDeps = ArrayListMultimap.create();
        Multimaps.invertFrom(deps, (Multimap)reverseDeps);
        for (T item : items) {
            Collection itemDeps = deps.get(item);
            inDegree.add(item, itemDeps.size());
            if (!itemDeps.isEmpty()) continue;
            inDegreeZero.add(item);
        }
        while (!inDegreeZero.isEmpty()) {
            Object item = inDegreeZero.remove();
            result.add(item);
            for (Object inWaiting : reverseDeps.get(item)) {
                inDegree.remove(inWaiting, 1);
                if (inDegree.count(inWaiting) != 0) continue;
                inDegreeZero.add(inWaiting);
            }
        }
        return result;
    }

    public static class MissingProvideException
    extends Exception {
        MissingProvideException(String provide) {
            super(provide);
        }
    }

    public static class CircularDependencyException
    extends Exception {
        CircularDependencyException(String message) {
            super(message);
        }
    }
}

