/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.newtypes;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.newtypes.DeclaredFunctionType;
import com.google.javascript.jscomp.newtypes.DeclaredTypeRegistry;
import com.google.javascript.jscomp.newtypes.EnumType;
import com.google.javascript.jscomp.newtypes.FunctionTypeBuilder;
import com.google.javascript.jscomp.newtypes.JSType;
import com.google.javascript.jscomp.newtypes.JSTypes;
import com.google.javascript.jscomp.newtypes.NominalType;
import com.google.javascript.jscomp.newtypes.ObjectType;
import com.google.javascript.jscomp.newtypes.Typedef;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JSTypeCreatorFromJSDoc {
    public static final DiagnosticType INVALID_GENERICS_INSTANTIATION = DiagnosticType.warning("JSC_INVALID_GENERICS_INSTANTIATION", "Invalid generics instantiation for {0}.\nExpected {1} type argument(s), but found {2}.");
    public static final DiagnosticType BAD_JSDOC_ANNOTATION = DiagnosticType.warning("JSC_BAD_JSDOC_ANNOTATION", "Bad JSDoc annotation. {0}");
    public static final DiagnosticType EXTENDS_NON_OBJECT = DiagnosticType.warning("JSC_EXTENDS_NON_OBJECT", "{0} extends non-object type {1}.\n");
    public static final DiagnosticType EXTENDS_NOT_ON_CTOR_OR_INTERF = DiagnosticType.warning("JSC_EXTENDS_NOT_ON_CTOR_OR_INTERF", "@extends used without @constructor or @interface for {0}.\n");
    public static final DiagnosticType INHERITANCE_CYCLE = DiagnosticType.warning("JSC_INHERITANCE_CYCLE", "Cycle detected in inheritance chain of type {0}");
    public static final DiagnosticType DICT_IMPLEMENTS_INTERF = DiagnosticType.warning("JSC_DICT_IMPLEMENTS_INTERF", "Class {0} is a dict. Dicts can't implement interfaces.");
    public static final DiagnosticType IMPLEMENTS_WITHOUT_CONSTRUCTOR = DiagnosticType.warning("JSC_IMPLEMENTS_WITHOUT_CONSTRUCTOR", "@implements used without @constructor or @interface for {0}");
    public static final DiagnosticType CONFLICTING_SHAPE_TYPE = DiagnosticType.warning("JSC_CONFLICTING_SHAPE_TYPE", "{1} cannot extend this type; {0}s can only extend {0}s");
    public static final DiagnosticType CONFLICTING_EXTENDED_TYPE = DiagnosticType.warning("JSC_CONFLICTING_EXTENDED_TYPE", "{1} cannot extend this type; {0}s can only extend {0}s");
    public static final DiagnosticType CONFLICTING_IMPLEMENTED_TYPE = DiagnosticType.warning("JSC_CONFLICTING_IMPLEMENTED_TYPE", "{0} cannot implement this type; an interface can only extend, but not implement interfaces");
    private final CodingConvention convention;
    private int howmanyTypeVars = 0;
    private final JSType objectOrNull;
    private Set<JSError> warnings = new LinkedHashSet<JSError>();
    private Map<Node, String> unknownTypeNames = new LinkedHashMap<Node, String>();
    private DeclaredFunctionType qmarkFunctionDeclared;
    private JSType qmarkFunctionOrNull = null;

    public JSTypeCreatorFromJSDoc(CodingConvention convention) {
        this.objectOrNull = JSType.join(JSType.TOP_OBJECT, JSType.NULL);
        this.qmarkFunctionDeclared = FunctionTypeBuilder.qmarkFunctionBuilder().buildDeclaration();
        this.convention = convention;
    }

    private JSType getQmarkFunctionOrNull(JSTypes commonTypes) {
        if (this.qmarkFunctionOrNull == null) {
            this.qmarkFunctionOrNull = JSType.join(commonTypes.qmarkFunction(), JSType.NULL);
        }
        return this.qmarkFunctionOrNull;
    }

    public JSType getDeclaredTypeOfNode(JSDocInfo jsdoc, NominalType.RawNominalType ownerType, DeclaredTypeRegistry registry) {
        return this.getDeclaredTypeOfNode(jsdoc, registry, ownerType == null ? ImmutableList.of() : ownerType.getTypeParameters());
    }

    private JSType getDeclaredTypeOfNode(JSDocInfo jsdoc, DeclaredTypeRegistry registry, ImmutableList<String> typeParameters) {
        if (jsdoc == null) {
            return null;
        }
        return this.getTypeFromJSTypeExpression(jsdoc.getType(), registry, typeParameters);
    }

    public Set<JSError> getWarnings() {
        return this.warnings;
    }

    public Map<Node, String> getUnknownTypesMap() {
        return this.unknownTypeNames;
    }

    private JSType getTypeFromJSTypeExpression(JSTypeExpression expr, DeclaredTypeRegistry registry, ImmutableList<String> typeParameters) {
        if (expr == null) {
            return null;
        }
        return this.getTypeFromComment(expr.getRoot(), registry, typeParameters == null ? ImmutableList.of() : typeParameters);
    }

    private JSType getTypeFromComment(Node n, DeclaredTypeRegistry registry, ImmutableList<String> typeParameters) {
        try {
            return this.getTypeFromCommentHelper(n, registry, typeParameters);
        }
        catch (UnknownTypeException e) {
            return JSType.UNKNOWN;
        }
    }

    private JSType getMaybeTypeFromComment(Node n, DeclaredTypeRegistry registry, ImmutableList<String> typeParameters) {
        try {
            return this.getTypeFromCommentHelper(n, registry, typeParameters);
        }
        catch (UnknownTypeException e) {
            return null;
        }
    }

    private JSType getTypeFromCommentHelper(Node n, DeclaredTypeRegistry registry, ImmutableList<String> typeParameters) throws UnknownTypeException {
        Preconditions.checkNotNull((Object)n);
        Preconditions.checkNotNull(typeParameters);
        switch (n.getType()) {
            case 309: {
                return this.getRecordTypeHelper(n, registry, typeParameters);
            }
            case 124: {
                return JSType.UNKNOWN;
            }
            case 122: {
                return JSType.UNDEFINED;
            }
            case 308: {
                this.warn("The [] type syntax is no longer supported. Please use Array.<T> instead.", n);
                return JSType.UNKNOWN;
            }
            case 40: {
                return this.getNamedTypeHelper(n, registry, typeParameters);
            }
            case 301: {
                JSType union = JSType.BOTTOM;
                for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
                    JSType nextType = this.getTypeFromCommentHelper(child, registry, typeParameters);
                    if (nextType.isUnknown()) {
                        this.warn("This union type is equivalent to '?'.", n);
                        return JSType.UNKNOWN;
                    }
                    union = JSType.join(union, nextType);
                }
                return union;
            }
            case 306: {
                JSType nullableType = this.getTypeFromCommentHelper(n.getFirstChild(), registry, typeParameters);
                if (nullableType.isTypeVariable()) {
                    this.warn("Cannot use ! to restrict type variable type.\nPrefer to make type argument non-nullable and add null explicitly where needed (e.g. through ?T or T|null)", n);
                }
                return nullableType.removeType(JSType.NULL);
            }
            case 304: {
                Node child = n.getFirstChild();
                if (child == null) {
                    return JSType.UNKNOWN;
                }
                return JSType.join(JSType.NULL, this.getTypeFromCommentHelper(child, registry, typeParameters));
            }
            case 302: {
                return JSType.TOP;
            }
            case 105: {
                return this.getFunTypeHelper(n, null, registry, typeParameters);
            }
        }
        throw new IllegalArgumentException("Unsupported type exp: " + Token.name(n.getType()) + " " + n.toStringTree());
    }

    private JSType getRecordTypeHelper(Node n, DeclaredTypeRegistry registry, ImmutableList<String> typeParameters) throws UnknownTypeException {
        LinkedHashMap<String, JSType> fields = new LinkedHashMap<String, JSType>();
        for (Node fieldTypeNode = n.getFirstChild().getFirstChild(); fieldTypeNode != null; fieldTypeNode = fieldTypeNode.getNext()) {
            boolean isFieldTypeDeclared = fieldTypeNode.getType() == 310;
            Node fieldNameNode = isFieldTypeDeclared ? fieldTypeNode.getFirstChild() : fieldTypeNode;
            String fieldName = fieldNameNode.getString();
            if (fieldName.startsWith("'") || fieldName.startsWith("\"")) {
                fieldName = fieldName.substring(1, fieldName.length() - 1);
            }
            JSType fieldType = !isFieldTypeDeclared ? JSType.UNKNOWN : this.getTypeFromCommentHelper(fieldTypeNode.getLastChild(), registry, typeParameters);
            fields.put(fieldName, fieldType);
        }
        return JSType.fromObjectType(ObjectType.fromProperties(fields));
    }

    private JSType getNamedTypeHelper(Node n, DeclaredTypeRegistry registry, ImmutableList<String> outerTypeParameters) throws UnknownTypeException {
        String typeName;
        switch (typeName = n.getString()) {
            case "boolean": {
                return JSType.BOOLEAN;
            }
            case "null": {
                return JSType.NULL;
            }
            case "number": {
                return JSType.NUMBER;
            }
            case "string": {
                return JSType.STRING;
            }
            case "undefined": 
            case "void": {
                return JSType.UNDEFINED;
            }
            case "Function": {
                return this.getQmarkFunctionOrNull(registry.getCommonTypes());
            }
            case "Object": {
                return this.objectOrNull;
            }
        }
        if (outerTypeParameters.contains((Object)typeName)) {
            return JSType.fromTypeVar(typeName);
        }
        Typedef td = registry.getTypedef(typeName);
        if (td != null) {
            return this.getTypedefType(td, registry);
        }
        EnumType e = registry.getEnum(typeName);
        if (e != null) {
            return this.getEnumPropType(e, registry);
        }
        JSType namedType = registry.lookupTypeByName(typeName);
        if (namedType == null) {
            this.unknownTypeNames.put(n, typeName);
            throw new UnknownTypeException("Unhandled type: " + typeName);
        }
        if (namedType.isTypeVariable()) {
            ++this.howmanyTypeVars;
            return namedType;
        }
        if (namedType.isUnknown()) {
            return namedType;
        }
        return this.getNominalTypeHelper(namedType, n, registry, outerTypeParameters);
    }

    private JSType getTypedefType(Typedef td, DeclaredTypeRegistry registry) {
        this.resolveTypedef(td, registry);
        return td.getType();
    }

    public void resolveTypedef(Typedef td, DeclaredTypeRegistry registry) {
        JSType tdType;
        Preconditions.checkState((td != null ? 1 : 0) != 0, (Object)"getTypedef should only be called when we know that the typedef is defined");
        if (td.isResolved()) {
            return;
        }
        JSTypeExpression texp = td.getTypeExpr();
        if (texp == null) {
            this.warn("Circular type definitions are not allowed.", td.getTypeExprForErrorReporting().getRoot());
            tdType = JSType.UNKNOWN;
        } else {
            tdType = this.getTypeFromJSTypeExpression(texp, registry, null);
        }
        td.resolveTypedef(tdType);
    }

    private JSType getEnumPropType(EnumType e, DeclaredTypeRegistry registry) {
        this.resolveEnum(e, registry);
        return e.getPropType();
    }

    public void resolveEnum(EnumType e, DeclaredTypeRegistry registry) {
        JSType enumeratedType;
        Preconditions.checkState((e != null ? 1 : 0) != 0, (Object)"getEnum should only be called when we know that the enum is defined");
        if (e.isResolved()) {
            return;
        }
        JSTypeExpression texp = e.getTypeExpr();
        if (texp == null) {
            this.warn("Circular type definitions are not allowed.", e.getTypeExprForErrorReporting().getRoot());
            enumeratedType = JSType.UNKNOWN;
        } else {
            int numTypeVars = this.howmanyTypeVars;
            enumeratedType = this.getTypeFromJSTypeExpression(texp, registry, null);
            if (this.howmanyTypeVars > numTypeVars) {
                this.warn("An enum type cannot include type variables.", texp.getRoot());
                enumeratedType = JSType.UNKNOWN;
                this.howmanyTypeVars = numTypeVars;
            } else if (enumeratedType.isTop()) {
                this.warn("An enum type cannot be *. Use ? if you do not want the elements checked.", texp.getRoot());
                enumeratedType = JSType.UNKNOWN;
            } else if (enumeratedType.isUnion()) {
                this.warn("An enum type cannot be a union type.", texp.getRoot());
                enumeratedType = JSType.UNKNOWN;
            }
        }
        e.resolveEnum(enumeratedType);
    }

    private JSType getNominalTypeHelper(JSType namedType, Node n, DeclaredTypeRegistry registry, ImmutableList<String> outerTypeParameters) throws UnknownTypeException {
        int typeParamsSize;
        NominalType uninstantiated = namedType.getNominalTypeIfUnique();
        NominalType.RawNominalType rawType = uninstantiated.getRawNominalType();
        if (!rawType.isGeneric() && !n.hasChildren()) {
            return rawType.getInstanceAsNullableJSType();
        }
        ImmutableList.Builder typeList = ImmutableList.builder();
        if (n.hasChildren()) {
            Preconditions.checkState((boolean)n.getFirstChild().isBlock());
            for (Node child : n.getFirstChild().children()) {
                typeList.add((Object)this.getTypeFromCommentHelper(child, registry, outerTypeParameters));
            }
        }
        ImmutableList typeArguments = typeList.build();
        ImmutableList<String> typeParameters = rawType.getTypeParameters();
        int typeArgsSize = typeArguments.size();
        if (typeArgsSize != (typeParamsSize = typeParameters.size())) {
            if (typeArgsSize > typeParamsSize) {
                this.warnings.add(JSError.make(n, INVALID_GENERICS_INSTANTIATION, uninstantiated.getName(), String.valueOf(typeParamsSize), String.valueOf(typeArgsSize)));
            }
            return JSType.join(JSType.NULL, JSType.fromObjectType(ObjectType.fromNominalType(uninstantiated.instantiateGenerics(JSTypeCreatorFromJSDoc.fixLengthOfTypeList(typeParameters.size(), (List<JSType>)typeArguments)))));
        }
        return JSType.join(JSType.NULL, JSType.fromObjectType(ObjectType.fromNominalType(uninstantiated.instantiateGenerics((List<JSType>)typeArguments))));
    }

    private static List<JSType> fixLengthOfTypeList(int desiredLength, List<JSType> typeList) {
        int length = typeList.size();
        if (length == desiredLength) {
            return typeList;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < desiredLength; ++i) {
            builder.add((Object)(i < length ? typeList.get(i) : JSType.UNKNOWN));
        }
        return builder.build();
    }

    private JSType getFunTypeHelper(Node jsdocNode, NominalType.RawNominalType ownerType, DeclaredTypeRegistry registry, ImmutableList<String> typeParameters) throws UnknownTypeException {
        FunctionTypeBuilder builder = new FunctionTypeBuilder();
        if (ownerType != null) {
            builder.addReceiverType(ownerType.getAsNominalType());
        }
        this.fillInFunTypeBuilder(jsdocNode, ownerType, registry, typeParameters, builder);
        return registry.getCommonTypes().fromFunctionType(builder.buildFunction());
    }

    private void fillInFunTypeBuilder(Node jsdocNode, NominalType.RawNominalType ownerType, DeclaredTypeRegistry registry, ImmutableList<String> typeParameters, FunctionTypeBuilder builder) throws UnknownTypeException {
        Node child = jsdocNode.getFirstChild();
        if (child.getType() == 42) {
            if (ownerType == null) {
                builder.addReceiverType(this.getNominalType(child.getFirstChild(), registry, typeParameters));
            }
            child = child.getNext();
        } else if (child.getType() == 30) {
            builder.addNominalType(this.getNominalType(child.getFirstChild(), registry, typeParameters));
            child = child.getNext();
        }
        if (child.getType() == 83) {
            for (Node arg = child.getFirstChild(); arg != null; arg = arg.getNext()) {
                try {
                    switch (arg.getType()) {
                        case 307: {
                            builder.addOptFormal(this.getTypeFromCommentHelper(arg.getFirstChild(), registry, typeParameters));
                            break;
                        }
                        case 305: {
                            Node restNode = arg.getFirstChild();
                            builder.addRestFormals(restNode == null ? JSType.UNKNOWN : this.getTypeFromCommentHelper(restNode, registry, typeParameters));
                            break;
                        }
                        default: {
                            builder.addReqFormal(this.getTypeFromCommentHelper(arg, registry, typeParameters));
                            break;
                        }
                    }
                    continue;
                }
                catch (FunctionTypeBuilder.WrongParameterOrderException e) {
                    this.warn("Wrong parameter order: required parameters are first, then optional, then varargs", jsdocNode);
                }
            }
            child = child.getNext();
        }
        builder.addRetType(this.getTypeFromCommentHelper(child, registry, typeParameters));
    }

    private NominalType getNominalType(Node n, DeclaredTypeRegistry registry, ImmutableList<String> typeParameters) {
        return this.getTypeFromComment(n, registry, typeParameters).getNominalTypeIfUnique();
    }

    private ImmutableSet<NominalType> getImplementedInterfaces(JSDocInfo jsdoc, DeclaredTypeRegistry registry, ImmutableList<String> typeParameters) {
        return this.getInterfacesHelper(jsdoc, registry, typeParameters, true);
    }

    private ImmutableSet<NominalType> getExtendedInterfaces(JSDocInfo jsdoc, DeclaredTypeRegistry registry, ImmutableList<String> typeParameters) {
        return this.getInterfacesHelper(jsdoc, registry, typeParameters, false);
    }

    private ImmutableSet<NominalType> getInterfacesHelper(JSDocInfo jsdoc, DeclaredTypeRegistry registry, ImmutableList<String> typeParameters, boolean implementedIntfs) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (JSTypeExpression texp : implementedIntfs ? jsdoc.getImplementedInterfaces() : jsdoc.getExtendedInterfaces()) {
            Node expRoot = texp.getRoot();
            JSType interfaceType = this.getMaybeTypeFromComment(expRoot, registry, typeParameters);
            if (interfaceType == null) continue;
            NominalType nt = interfaceType.getNominalTypeIfUnique();
            if (nt != null && nt.isInterface()) {
                builder.add((Object)nt);
                continue;
            }
            String errorMsg = implementedIntfs ? "Cannot implement non-interface" : "Cannot extend non-interface";
            this.warn(errorMsg, jsdoc.getAssociatedNode());
        }
        return builder.build();
    }

    private static boolean isQmarkFunction(Node jsdocNode) {
        if (jsdocNode.getType() == 306) {
            jsdocNode = jsdocNode.getFirstChild();
        }
        return jsdocNode.isString() && jsdocNode.getString().equals("Function");
    }

    public DeclaredFunctionType getFunctionType(JSDocInfo jsdoc, String functionName, Node declNode, NominalType.RawNominalType constructorType, NominalType.RawNominalType ownerType, DeclaredTypeRegistry registry) {
        FunctionTypeBuilder builder = new FunctionTypeBuilder();
        if (ownerType != null) {
            builder.addReceiverType(ownerType.getAsNominalType());
        }
        try {
            if (jsdoc != null && jsdoc.getType() != null) {
                Node jsdocNode = jsdoc.getType().getRoot();
                int tokenType = jsdocNode.getType();
                if (tokenType == 105) {
                    if (declNode.isFunction()) {
                        return this.getFunTypeFromAtTypeJsdoc(jsdoc, declNode, ownerType, registry, builder);
                    }
                    try {
                        this.fillInFunTypeBuilder(jsdocNode, ownerType, registry, (ImmutableList<String>)ImmutableList.of(), builder);
                        return builder.buildDeclaration();
                    }
                    catch (UnknownTypeException e) {
                        return this.qmarkFunctionDeclared;
                    }
                }
                if (JSTypeCreatorFromJSDoc.isQmarkFunction(jsdocNode)) {
                    return this.qmarkFunctionDeclared;
                }
                this.warn("The function is annotated with a non-function jsdoc. Ignoring jsdoc.", declNode);
                return this.getFunTypeFromTypicalFunctionJsdoc(null, functionName, declNode, constructorType, ownerType, registry, builder, true);
            }
            return this.getFunTypeFromTypicalFunctionJsdoc(jsdoc, functionName, declNode, constructorType, ownerType, registry, builder, false);
        }
        catch (FunctionTypeBuilder.WrongParameterOrderException e) {
            this.warn("Wrong parameter order: required parameters are first, then optional, then varargs. Ignoring jsdoc.", declNode);
            return this.qmarkFunctionDeclared;
        }
    }

    private DeclaredFunctionType getFunTypeFromAtTypeJsdoc(JSDocInfo jsdoc, Node funNode, NominalType.RawNominalType ownerType, DeclaredTypeRegistry registry, FunctionTypeBuilder builder) {
        Node paramType;
        ImmutableList<String> typeParameters;
        Preconditions.checkArgument((boolean)funNode.isFunction());
        Node childJsdoc = jsdoc.getType().getRoot().getFirstChild();
        Node param = funNode.getFirstChild().getNext().getFirstChild();
        boolean warnedForMissingTypes = false;
        boolean warnedForInlineJsdoc = false;
        ImmutableList<String> immutableList = typeParameters = ownerType == null ? ImmutableList.of() : ownerType.getTypeParameters();
        if (childJsdoc.getType() == 42) {
            if (ownerType == null) {
                builder.addReceiverType(this.getNominalType(childJsdoc.getFirstChild(), registry, typeParameters));
            }
            childJsdoc = childJsdoc.getNext();
        } else if (childJsdoc.getType() == 30) {
            builder.addNominalType(this.getNominalType(childJsdoc.getFirstChild(), registry, typeParameters));
            childJsdoc = childJsdoc.getNext();
        }
        if (childJsdoc.getType() == 83) {
            paramType = childJsdoc.getFirstChild();
            childJsdoc = childJsdoc.getNext();
        } else {
            paramType = null;
        }
        while (param != null) {
            if (paramType == null) {
                if (!warnedForMissingTypes) {
                    this.warn("The function has more formal parameters than the types declared in the JSDoc", funNode);
                    warnedForMissingTypes = true;
                }
                builder.addOptFormal(JSType.UNKNOWN);
            } else {
                if (!warnedForInlineJsdoc && param.getJSDocInfo() != null) {
                    this.warn("The function cannot have both an @type jsdoc and inline jsdocs. Ignoring inline jsdocs.", param);
                    warnedForInlineJsdoc = true;
                }
                switch (paramType.getType()) {
                    case 307: {
                        builder.addOptFormal(this.getTypeFromComment(paramType.getFirstChild(), registry, typeParameters));
                        break;
                    }
                    case 305: {
                        if (warnedForMissingTypes) break;
                        this.warn("The function has more formal parameters than the types declared in the JSDoc", funNode);
                        warnedForMissingTypes = true;
                        builder.addOptFormal(JSType.UNKNOWN);
                        break;
                    }
                    default: {
                        builder.addReqFormal(this.getTypeFromComment(paramType, registry, typeParameters));
                    }
                }
                paramType = paramType.getNext();
            }
            param = param.getNext();
        }
        if (paramType != null) {
            if (paramType.getType() == 305) {
                builder.addRestFormals(this.getTypeFromComment(paramType.getFirstChild(), registry, typeParameters));
            } else {
                this.warn("The function has fewer formal parameters than the types declared in the JSDoc", funNode);
            }
        }
        if (!warnedForInlineJsdoc && funNode.getFirstChild().getJSDocInfo() != null) {
            this.warn("The function cannot have both an @type jsdoc and inline jsdocs. Ignoring the inline return jsdoc.", funNode);
        }
        if (jsdoc.getReturnType() != null) {
            this.warn("The function cannot have both an @type jsdoc and @return jsdoc. Ignoring @return jsdoc.", funNode);
        }
        if (funNode.getParent().isSetterDef()) {
            if (childJsdoc != null) {
                this.warn("Cannot declare a return type on a setter", funNode);
            }
            builder.addRetType(JSType.UNDEFINED);
        } else {
            builder.addRetType(this.getTypeFromComment(childJsdoc, registry, typeParameters));
        }
        return builder.buildDeclaration();
    }

    private DeclaredFunctionType getFunTypeFromTypicalFunctionJsdoc(JSDocInfo jsdoc, String functionName, Node funNode, NominalType.RawNominalType constructorType, NominalType.RawNominalType ownerType, DeclaredTypeRegistry registry, FunctionTypeBuilder builder, boolean ignoreJsdoc) {
        Preconditions.checkArgument((!ignoreJsdoc || jsdoc == null ? 1 : 0) != 0);
        Preconditions.checkArgument((!ignoreJsdoc || funNode.isFunction() ? 1 : 0) != 0);
        ImmutableList typeParameters = ImmutableList.of();
        Node parent = funNode.getParent();
        if (jsdoc != null && !(typeParameters = jsdoc.getTemplateTypeNames()).isEmpty()) {
            if (parent.isSetterDef() || parent.isGetterDef()) {
                ignoreJsdoc = true;
                jsdoc = null;
                this.warn("@template can't be used with getters/setters", funNode);
            } else {
                builder.addTypeParameters(typeParameters);
            }
        }
        if (ownerType != null) {
            ImmutableList.Builder paramsBuilder = new ImmutableList.Builder();
            paramsBuilder.addAll(typeParameters);
            paramsBuilder.addAll(ownerType.getTypeParameters());
            typeParameters = paramsBuilder.build();
        }
        this.fillInFormalParameterTypes(jsdoc, funNode, typeParameters, registry, builder, ignoreJsdoc);
        this.fillInReturnType(jsdoc, funNode, parent, (ImmutableList<String>)typeParameters, registry, builder, ignoreJsdoc);
        if (jsdoc == null) {
            return builder.buildDeclaration();
        }
        NominalType parentClass = this.getMaybeParentClass(jsdoc, functionName, funNode, (ImmutableList<String>)typeParameters, registry);
        ImmutableSet<NominalType> implementedIntfs = this.getImplementedInterfaces(jsdoc, registry, (ImmutableList<String>)typeParameters);
        if (constructorType == null && (jsdoc.isConstructor() || jsdoc.isInterface())) {
            return builder.buildDeclaration();
        }
        if (jsdoc.isConstructor()) {
            this.handleConstructorAnnotation(functionName, funNode, constructorType, parentClass, implementedIntfs, registry, builder);
        } else if (jsdoc.isInterface()) {
            this.handleInterfaceAnnotation(jsdoc, functionName, funNode, constructorType, implementedIntfs, (ImmutableList<String>)typeParameters, registry, builder);
        } else if (!implementedIntfs.isEmpty()) {
            this.warnings.add(JSError.make(funNode, IMPLEMENTS_WITHOUT_CONSTRUCTOR, functionName));
        }
        if (jsdoc.hasThisType() && ownerType == null) {
            Node thisNode = jsdoc.getThisType().getRoot();
            JSType thisType = this.getMaybeTypeFromComment(thisNode, registry, (ImmutableList<String>)typeParameters);
            NominalType thisTypeAsNominal = thisType == null ? null : thisType.getNominalTypeIfUnique();
            builder.addReceiverType(thisTypeAsNominal);
        }
        return builder.buildDeclaration();
    }

    private void fillInFormalParameterTypes(JSDocInfo jsdoc, Node funNode, ImmutableList<String> typeParameters, DeclaredTypeRegistry registry, FunctionTypeBuilder builder, boolean ignoreJsdoc) {
        boolean ignoreFunNode = !funNode.isFunction();
        Node params = ignoreFunNode ? null : funNode.getFirstChild().getNext();
        ParamIterator iterator = new ParamIterator(params, jsdoc);
        while (iterator.hasNext()) {
            Node jsdocNode;
            String pname = iterator.nextString();
            Node param = iterator.getNode();
            JSType inlineParamType = ignoreJsdoc || ignoreFunNode ? null : this.getDeclaredTypeOfNode(param.getJSDocInfo(), registry, typeParameters);
            boolean isRequired = true;
            boolean isRestFormals = false;
            JSTypeExpression texp = jsdoc == null ? null : jsdoc.getParameterType(pname);
            Node node = jsdocNode = texp == null ? null : texp.getRoot();
            if (param != null) {
                if (this.convention.isOptionalParameter(param)) {
                    isRequired = false;
                } else if (this.convention.isVarArgsParameter(param)) {
                    isRequired = false;
                    isRestFormals = true;
                }
            }
            JSType fnParamType = null;
            if (jsdocNode != null) {
                if (jsdocNode.getType() == 307) {
                    isRequired = false;
                    jsdocNode = jsdocNode.getFirstChild();
                } else if (jsdocNode.getType() == 305) {
                    isRequired = false;
                    isRestFormals = true;
                    jsdocNode = jsdocNode.getFirstChild();
                }
                fnParamType = this.getTypeFromComment(jsdocNode, registry, typeParameters);
            }
            if (inlineParamType != null) {
                builder.addReqFormal(inlineParamType);
                if (fnParamType == null) continue;
                this.warn("Found two JsDoc comments for formal parameter " + pname, param);
                continue;
            }
            if (isRequired) {
                builder.addReqFormal(fnParamType);
                continue;
            }
            if (isRestFormals) {
                builder.addRestFormals(fnParamType == null ? JSType.UNKNOWN : fnParamType);
                continue;
            }
            builder.addOptFormal(fnParamType);
        }
    }

    private void fillInReturnType(JSDocInfo jsdoc, Node funNode, Node parent, ImmutableList<String> typeParameters, DeclaredTypeRegistry registry, FunctionTypeBuilder builder, boolean ignoreJsdoc) {
        JSTypeExpression retTypeExp;
        JSDocInfo inlineRetJsdoc = ignoreJsdoc ? null : funNode.getFirstChild().getJSDocInfo();
        JSTypeExpression jSTypeExpression = retTypeExp = jsdoc == null ? null : jsdoc.getReturnType();
        if (parent.isSetterDef()) {
            JSDocInfo jSDocInfo = inlineRetJsdoc = ignoreJsdoc ? null : funNode.getLastChild().getJSDocInfo();
            if (retTypeExp != null || inlineRetJsdoc != null) {
                this.warn("Cannot declare a return type on a setter", funNode);
            }
            builder.addRetType(JSType.UNDEFINED);
        } else if (inlineRetJsdoc != null) {
            builder.addRetType(this.getDeclaredTypeOfNode(inlineRetJsdoc, registry, typeParameters));
            if (retTypeExp != null) {
                this.warn("Found two JsDoc comments for the return type", funNode);
            }
        } else {
            builder.addRetType(this.getTypeFromJSTypeExpression(retTypeExp, registry, typeParameters));
        }
    }

    private NominalType getMaybeParentClass(JSDocInfo jsdoc, String functionName, Node funNode, ImmutableList<String> typeParameters, DeclaredTypeRegistry registry) {
        if (!jsdoc.hasBaseType()) {
            return null;
        }
        if (!jsdoc.isConstructor()) {
            this.warnings.add(JSError.make(funNode, EXTENDS_NOT_ON_CTOR_OR_INTERF, functionName));
            return null;
        }
        Node docNode = jsdoc.getBaseType().getRoot();
        JSType extendedType = this.getMaybeTypeFromComment(docNode, registry, typeParameters);
        if (extendedType == null) {
            return null;
        }
        NominalType parentClass = extendedType.getNominalTypeIfUnique();
        if (parentClass != null && parentClass.isClass()) {
            return parentClass;
        }
        if (parentClass == null) {
            this.warnings.add(JSError.make(funNode, EXTENDS_NON_OBJECT, functionName, extendedType.toString()));
        } else {
            Preconditions.checkState((boolean)parentClass.isInterface());
            this.warnings.add(JSError.make(funNode, CONFLICTING_EXTENDED_TYPE, "constructor", functionName));
        }
        return null;
    }

    private void handleConstructorAnnotation(String functionName, Node funNode, NominalType.RawNominalType constructorType, NominalType parentClass, ImmutableSet<NominalType> implementedIntfs, DeclaredTypeRegistry registry, FunctionTypeBuilder builder) {
        String className = constructorType.toString();
        NominalType builtinObject = registry.getCommonTypes().getObjectType();
        if (parentClass == null && !functionName.equals("Object")) {
            parentClass = builtinObject;
        }
        if (parentClass != null) {
            if (!constructorType.addSuperClass(parentClass)) {
                this.warnings.add(JSError.make(funNode, INHERITANCE_CYCLE, className));
            } else if (parentClass != builtinObject) {
                if (constructorType.isStruct() && !parentClass.isStruct()) {
                    this.warnings.add(JSError.make(funNode, CONFLICTING_SHAPE_TYPE, "struct", className));
                } else if (constructorType.isDict() && !parentClass.isDict()) {
                    this.warnings.add(JSError.make(funNode, CONFLICTING_SHAPE_TYPE, "dict", className));
                }
            }
        }
        if (constructorType.isDict() && !implementedIntfs.isEmpty()) {
            this.warnings.add(JSError.make(funNode, DICT_IMPLEMENTS_INTERF, className));
        }
        boolean noCycles = constructorType.addInterfaces(implementedIntfs);
        Preconditions.checkState((boolean)noCycles);
        builder.addNominalType(constructorType.getAsNominalType());
    }

    private void handleInterfaceAnnotation(JSDocInfo jsdoc, String functionName, Node funNode, NominalType.RawNominalType constructorType, ImmutableSet<NominalType> implementedIntfs, ImmutableList<String> typeParameters, DeclaredTypeRegistry registry, FunctionTypeBuilder builder) {
        boolean noCycles;
        if (!implementedIntfs.isEmpty()) {
            this.warnings.add(JSError.make(funNode, CONFLICTING_IMPLEMENTED_TYPE, functionName));
        }
        if (!(noCycles = constructorType.addInterfaces(this.getExtendedInterfaces(jsdoc, registry, typeParameters)))) {
            this.warnings.add(JSError.make(funNode, INHERITANCE_CYCLE, constructorType.toString()));
        }
        builder.addNominalType(constructorType.getAsNominalType());
    }

    public static boolean isRestArg(JSDocInfo funJsdoc, String formalParamName) {
        if (funJsdoc == null) {
            return false;
        }
        JSTypeExpression texp = funJsdoc.getParameterType(formalParamName);
        Node jsdocNode = texp == null ? null : texp.getRoot();
        return jsdocNode != null && jsdocNode.getType() == 305;
    }

    void warn(String msg, Node faultyNode) {
        this.warnings.add(JSError.make(faultyNode, BAD_JSDOC_ANNOTATION, msg));
    }

    private static class ParamIterator {
        Iterator<String> paramNames;
        Node params;
        int index = -1;

        ParamIterator(Node params, JSDocInfo jsdoc) {
            Preconditions.checkArgument((params != null || jsdoc != null ? 1 : 0) != 0);
            if (params != null) {
                this.params = params;
                this.paramNames = null;
            } else {
                this.params = null;
                this.paramNames = jsdoc.getParameterNames().iterator();
            }
        }

        boolean hasNext() {
            if (this.paramNames != null) {
                return this.paramNames.hasNext();
            }
            return this.index + 1 < this.params.getChildCount();
        }

        String nextString() {
            if (this.paramNames != null) {
                return this.paramNames.next();
            }
            ++this.index;
            return this.params.getChildAtIndex(this.index).getString();
        }

        Node getNode() {
            if (this.paramNames != null) {
                return null;
            }
            return this.params.getChildAtIndex(this.index);
        }
    }

    public static class UnknownTypeException
    extends Exception {
        UnknownTypeException(String cause) {
            super(cause);
        }
    }
}

