/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.newtypes;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.newtypes.EnumType;
import com.google.javascript.jscomp.newtypes.JSType;
import com.google.javascript.jscomp.newtypes.NamespaceLit;
import com.google.javascript.jscomp.newtypes.NominalType;
import com.google.javascript.jscomp.newtypes.ObjectType;
import com.google.javascript.jscomp.newtypes.PersistentMap;
import com.google.javascript.jscomp.newtypes.Property;
import com.google.javascript.jscomp.newtypes.QualifiedName;
import com.google.javascript.jscomp.newtypes.Typedef;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class Namespace {
    protected Map<String, NominalType.RawNominalType> nominals = null;
    protected Map<String, EnumType> enums = null;
    protected Map<String, NamespaceLit> namespaces = null;
    protected Map<String, Typedef> typedefs = null;
    protected PersistentMap<String, Property> otherProps = PersistentMap.create();

    public boolean isDefined(QualifiedName qname) {
        Namespace ns;
        String name;
        if (qname.isIdentifier()) {
            name = qname.getLeftmostName();
            ns = this;
        } else {
            name = qname.getRightmostName();
            ns = this.getSubnamespace(qname.getAllButRightmost());
            if (ns == null) {
                return false;
            }
        }
        return ns.nominals != null && ns.nominals.containsKey(name) || ns.enums != null && ns.enums.containsKey(name) || ns.namespaces != null && ns.namespaces.containsKey(name) || ns.typedefs != null && ns.typedefs.containsKey(name) || ns.otherProps.containsKey(name);
    }

    public void addSubnamespace(QualifiedName qname) {
        Preconditions.checkState((!this.isDefined(qname) ? 1 : 0) != 0);
        Namespace ns = this.getReceiverNamespace(qname);
        if (ns.namespaces == null) {
            ns.namespaces = new LinkedHashMap<String, NamespaceLit>();
        }
        String name = qname.getRightmostName();
        ns.namespaces.put(name, new NamespaceLit());
    }

    public void addNominalType(QualifiedName qname, NominalType.RawNominalType rawNominalType) {
        Preconditions.checkState((!this.isDefined(qname) ? 1 : 0) != 0);
        Namespace ns = this.getReceiverNamespace(qname);
        if (ns.nominals == null) {
            ns.nominals = new LinkedHashMap<String, NominalType.RawNominalType>();
        }
        String name = qname.getRightmostName();
        ns.nominals.put(name, rawNominalType);
    }

    public void addTypedef(QualifiedName qname, Typedef td) {
        Preconditions.checkState((!this.isDefined(qname) ? 1 : 0) != 0);
        Namespace ns = this.getReceiverNamespace(qname);
        if (ns.typedefs == null) {
            ns.typedefs = new LinkedHashMap<String, Typedef>();
        }
        String name = qname.getRightmostName();
        ns.typedefs.put(name, td);
    }

    public void addEnum(QualifiedName qname, EnumType e) {
        Preconditions.checkState((!this.isDefined(qname) ? 1 : 0) != 0);
        Namespace ns = this.getReceiverNamespace(qname);
        if (ns.enums == null) {
            ns.enums = new LinkedHashMap<String, EnumType>();
        }
        String name = qname.getRightmostName();
        ns.enums.put(name, e);
    }

    private Namespace getLocalSubnamespace(String name) {
        if (this.nominals != null && this.nominals.containsKey(name)) {
            return this.nominals.get(name);
        }
        if (this.namespaces != null && this.namespaces.containsKey(name)) {
            return this.namespaces.get(name);
        }
        if (this.enums != null && this.enums.containsKey(name)) {
            return this.enums.get(name);
        }
        return null;
    }

    private Namespace getReceiverNamespace(QualifiedName qname) {
        if (qname.isIdentifier()) {
            return this;
        }
        return this.getSubnamespace(qname.getAllButRightmost());
    }

    public Namespace getSubnamespace(QualifiedName qname) {
        String leftmost = qname.getLeftmostName();
        Namespace firstNamespace = this.getLocalSubnamespace(leftmost);
        if (firstNamespace == null || qname.isIdentifier()) {
            return firstNamespace;
        }
        return firstNamespace.getSubnamespace(qname.getAllButLeftmost());
    }

    public NominalType.RawNominalType getNominalType(QualifiedName qname) {
        Namespace ns = this.getReceiverNamespace(qname);
        if (ns == null || ns.nominals == null) {
            return null;
        }
        String name = qname.getRightmostName();
        return ns.nominals.get(name);
    }

    public EnumType getEnumType(QualifiedName qname) {
        Namespace ns = this.getReceiverNamespace(qname);
        if (ns == null || ns.enums == null) {
            return null;
        }
        String name = qname.getRightmostName();
        return ns.enums.get(name);
    }

    public Typedef getTypedef(QualifiedName qname) {
        Namespace ns = this.getReceiverNamespace(qname);
        if (ns == null || ns.typedefs == null) {
            return null;
        }
        String name = qname.getRightmostName();
        return ns.typedefs.get(name);
    }

    public boolean hasSubnamespace(QualifiedName qname) {
        return this.getSubnamespace(qname) != null;
    }

    public boolean hasProp(String pname) {
        Property prop = (Property)this.otherProps.get(pname);
        if (prop == null) {
            return false;
        }
        Preconditions.checkState((!prop.isOptional() ? 1 : 0) != 0);
        return true;
    }

    public void addProperty(String pname, JSType type, boolean isConstant) {
        if (type == null && isConstant) {
            type = JSType.UNKNOWN;
        }
        this.otherProps = this.otherProps.with(pname, isConstant ? Property.makeConstant(type, type) : Property.make(type, type));
    }

    public void addUndeclaredProperty(String pname, JSType t, boolean isConstant) {
        if (this.otherProps.containsKey(pname) && !((Property)this.otherProps.get(pname)).getType().isUnknown()) {
            return;
        }
        this.otherProps = this.otherProps.with(pname, isConstant ? Property.makeConstant(t, null) : Property.make(t, null));
    }

    public JSType getPropDeclaredType(String pname) {
        Property p = (Property)this.otherProps.get(pname);
        return p == null ? null : p.getDeclaredType();
    }

    public abstract JSType toJSType();

    protected JSType withNamedTypes(ObjectType obj) {
        if (this.nominals != null) {
            for (Map.Entry<String, Namespace> entry : this.nominals.entrySet()) {
                obj = obj.withProperty(new QualifiedName(entry.getKey()), ((NominalType.RawNominalType)entry.getValue()).toJSType());
            }
        }
        if (this.enums != null) {
            for (Map.Entry<String, Namespace> entry : this.enums.entrySet()) {
                obj = obj.withProperty(new QualifiedName(entry.getKey()), ((EnumType)entry.getValue()).toJSType());
            }
        }
        if (this.namespaces != null) {
            for (Map.Entry<String, Namespace> entry : this.namespaces.entrySet()) {
                obj = obj.withProperty(new QualifiedName(entry.getKey()), ((NamespaceLit)entry.getValue()).toJSType());
            }
        }
        return JSType.fromObjectType(obj);
    }
}

