/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.parsing;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class TypeDeclarationsIRFactory {
    private static final Function<Node, Node.TypeDeclarationNode> CONVERT_TYPE_NODE = new Function<Node, Node.TypeDeclarationNode>(){

        public Node.TypeDeclarationNode apply(Node node) {
            return TypeDeclarationsIRFactory.convertTypeNodeAST(node);
        }
    };

    public static Node.TypeDeclarationNode stringType() {
        return new Node.TypeDeclarationNode(200);
    }

    public static Node.TypeDeclarationNode numberType() {
        return new Node.TypeDeclarationNode(202);
    }

    public static Node.TypeDeclarationNode booleanType() {
        return new Node.TypeDeclarationNode(201);
    }

    public static Node.TypeDeclarationNode nullable(Node.TypeDeclarationNode type) {
        return new Node.TypeDeclarationNode(208, type);
    }

    public static Node.TypeDeclarationNode anyType() {
        return new Node.TypeDeclarationNode(206);
    }

    public static Node.TypeDeclarationNode voidType() {
        return new Node.TypeDeclarationNode(209);
    }

    public static Node.TypeDeclarationNode undefinedType() {
        return new Node.TypeDeclarationNode(214);
    }

    public static Node.TypeDeclarationNode namedType(String typeName) {
        return TypeDeclarationsIRFactory.namedType(Splitter.on((char)'.').split((CharSequence)typeName));
    }

    public static Node.TypeDeclarationNode namedType(Iterable<String> segments) {
        Iterator<String> segmentsIt = segments.iterator();
        Node node = IR.name(segmentsIt.next());
        while (segmentsIt.hasNext()) {
            node = IR.getprop(node, IR.string(segmentsIt.next()));
        }
        return new Node.TypeDeclarationNode(211, node);
    }

    public static Node.TypeDeclarationNode recordType(LinkedHashMap<String, Node.TypeDeclarationNode> properties) {
        Node.TypeDeclarationNode node = new Node.TypeDeclarationNode(213);
        for (Map.Entry<String, Node.TypeDeclarationNode> prop : properties.entrySet()) {
            if (prop.getValue() == null) {
                node.addChildToBack(IR.stringKey(prop.getKey()));
                continue;
            }
            Node stringKey = IR.stringKey(prop.getKey());
            stringKey.addChildToFront(prop.getValue());
            node.addChildToBack(stringKey);
        }
        return node;
    }

    public static Node.TypeDeclarationNode functionType(Node returnType, LinkedHashMap<String, Node.TypeDeclarationNode> parameters, String restName, Node.TypeDeclarationNode restType) {
        Node.TypeDeclarationNode node = new Node.TypeDeclarationNode(203, returnType);
        for (Map.Entry<String, Node.TypeDeclarationNode> parameter : parameters.entrySet()) {
            Node stringKey = IR.stringKey(parameter.getKey());
            stringKey.addChildToFront(parameter.getValue());
            node.addChildToBack(stringKey);
        }
        if (restName != null) {
            Node rest = IR.stringKey(restName);
            if (restType != null) {
                rest.addChildToBack(TypeDeclarationsIRFactory.arrayType(restType));
            }
            node.addChildToBack(TypeDeclarationsIRFactory.restParams(rest));
        }
        return node;
    }

    public static Node.TypeDeclarationNode parameterizedType(Node.TypeDeclarationNode baseType, Iterable<Node.TypeDeclarationNode> typeParameters) {
        if (Iterables.isEmpty(typeParameters)) {
            return baseType;
        }
        Node.TypeDeclarationNode node = new Node.TypeDeclarationNode(204, baseType);
        for (Node node2 : typeParameters) {
            node.addChildToBack(node2);
        }
        return node;
    }

    public static Node.TypeDeclarationNode arrayType(Node elementType) {
        return new Node.TypeDeclarationNode(215, elementType);
    }

    public static Node.TypeDeclarationNode unionType(Iterable<Node.TypeDeclarationNode> options) {
        Preconditions.checkArgument((!Iterables.isEmpty(options) ? 1 : 0) != 0, (Object)"union must have at least one option");
        Node.TypeDeclarationNode node = new Node.TypeDeclarationNode(205);
        for (Node node2 : options) {
            node.addChildToBack(node2);
        }
        return node;
    }

    public static Node.TypeDeclarationNode unionType(Node.TypeDeclarationNode ... options) {
        return TypeDeclarationsIRFactory.unionType(Arrays.asList(options));
    }

    public static Node.TypeDeclarationNode restParams(Node type) {
        Node.TypeDeclarationNode node = new Node.TypeDeclarationNode(210);
        if (type != null) {
            node.addChildToBack(type);
        }
        return node;
    }

    public static Node.TypeDeclarationNode optionalParameter(Node.TypeDeclarationNode parameterType) {
        return new Node.TypeDeclarationNode(212, parameterType);
    }

    @Nullable
    public static Node.TypeDeclarationNode convert(@Nullable JSTypeExpression typeExpr) {
        if (typeExpr == null) {
            return null;
        }
        return TypeDeclarationsIRFactory.convertTypeNodeAST(typeExpr.getRoot());
    }

    @Nullable
    public static Node.TypeDeclarationNode convertTypeNodeAST(Node n) {
        int token = n.getType();
        switch (token) {
            case 124: 
            case 302: {
                return TypeDeclarationsIRFactory.anyType();
            }
            case 122: {
                return TypeDeclarationsIRFactory.undefinedType();
            }
            case 306: {
                return TypeDeclarationsIRFactory.convertTypeNodeAST(n.getFirstChild());
            }
            case 40: {
                String typeName;
                switch (typeName = n.getString()) {
                    case "boolean": {
                        return TypeDeclarationsIRFactory.booleanType();
                    }
                    case "number": {
                        return TypeDeclarationsIRFactory.numberType();
                    }
                    case "string": {
                        return TypeDeclarationsIRFactory.stringType();
                    }
                    case "null": 
                    case "undefined": 
                    case "void": {
                        return null;
                    }
                }
                Node.TypeDeclarationNode root = TypeDeclarationsIRFactory.namedType(typeName);
                if (n.getChildCount() > 0 && n.getFirstChild().isBlock()) {
                    Node block = n.getFirstChild();
                    if ("Array".equals(typeName)) {
                        return TypeDeclarationsIRFactory.arrayType(TypeDeclarationsIRFactory.convertTypeNodeAST(block.getFirstChild()));
                    }
                    return TypeDeclarationsIRFactory.parameterizedType(root, Iterables.filter((Iterable)Iterables.transform(block.children(), CONVERT_TYPE_NODE), (Predicate)Predicates.notNull()));
                }
                return root;
            }
            case 304: {
                Node child = n.getFirstChild();
                return child == null ? TypeDeclarationsIRFactory.anyType() : TypeDeclarationsIRFactory.convertTypeNodeAST(child);
            }
            case 309: {
                LinkedHashMap<String, Node.TypeDeclarationNode> properties = new LinkedHashMap<String, Node.TypeDeclarationNode>();
                for (Node field : n.getFirstChild().children()) {
                    boolean isFieldTypeDeclared = field.getType() == 310;
                    Node fieldNameNode = isFieldTypeDeclared ? field.getFirstChild() : field;
                    String fieldName = fieldNameNode.getString();
                    if (fieldName.startsWith("'") || fieldName.startsWith("\"")) {
                        fieldName = fieldName.substring(1, fieldName.length() - 1);
                    }
                    Node.TypeDeclarationNode fieldType = isFieldTypeDeclared ? TypeDeclarationsIRFactory.convertTypeNodeAST(field.getLastChild()) : null;
                    properties.put(fieldName, fieldType);
                }
                return TypeDeclarationsIRFactory.recordType(properties);
            }
            case 305: {
                return TypeDeclarationsIRFactory.arrayType(TypeDeclarationsIRFactory.convertTypeNodeAST(n.getFirstChild()));
            }
            case 301: {
                ImmutableList types = FluentIterable.from(n.children()).transform(CONVERT_TYPE_NODE).filter(Predicates.notNull()).toList();
                switch (types.size()) {
                    case 0: {
                        return null;
                    }
                    case 1: {
                        return (Node.TypeDeclarationNode)types.get(0);
                    }
                }
                return TypeDeclarationsIRFactory.unionType((Iterable<Node.TypeDeclarationNode>)types);
            }
            case 105: {
                Node.TypeDeclarationNode returnType = TypeDeclarationsIRFactory.anyType();
                LinkedHashMap<String, Node.TypeDeclarationNode> parameters = new LinkedHashMap<String, Node.TypeDeclarationNode>();
                String restName = null;
                Node.TypeDeclarationNode restType = null;
                for (Node child2 : n.children()) {
                    if (child2.isParamList()) {
                        int paramIdx = 1;
                        for (Node param : child2.children()) {
                            String paramName = "p" + paramIdx++;
                            if (param.getType() == 305) {
                                restName = paramName;
                                if (param.getFirstChild() == null) continue;
                                restType = TypeDeclarationsIRFactory.convertTypeNodeAST(param.getFirstChild());
                                continue;
                            }
                            parameters.put(paramName, TypeDeclarationsIRFactory.convertTypeNodeAST(param));
                        }
                        continue;
                    }
                    if (child2.isNew() || child2.isThis()) continue;
                    returnType = TypeDeclarationsIRFactory.convertTypeNodeAST(child2);
                }
                return TypeDeclarationsIRFactory.functionType(returnType, parameters, restName, restType);
            }
            case 307: {
                Node.TypeDeclarationNode optionalParam = TypeDeclarationsIRFactory.convertTypeNodeAST(n.getFirstChild());
                return optionalParam == null ? null : TypeDeclarationsIRFactory.optionalParameter(optionalParam);
            }
        }
        throw new IllegalArgumentException("Unsupported node type: " + Token.name(n.getType()) + " " + n.toStringTree());
    }
}

