/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.type;

import com.google.common.base.Function;
import com.google.javascript.jscomp.type.ChainableReverseAbstractInterpreter;
import com.google.javascript.jscomp.type.FlowScope;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.StaticTypedSlot;
import com.google.javascript.rhino.jstype.UnionType;

public class SemanticReverseAbstractInterpreter
extends ChainableReverseAbstractInterpreter {
    private static final Function<JSType.TypePair, JSType.TypePair> EQ = new Function<JSType.TypePair, JSType.TypePair>(){

        public JSType.TypePair apply(JSType.TypePair p) {
            if (p.typeA == null || p.typeB == null) {
                return null;
            }
            return p.typeA.getTypesUnderEquality(p.typeB);
        }
    };
    private static final Function<JSType.TypePair, JSType.TypePair> NE = new Function<JSType.TypePair, JSType.TypePair>(){

        public JSType.TypePair apply(JSType.TypePair p) {
            if (p.typeA == null || p.typeB == null) {
                return null;
            }
            return p.typeA.getTypesUnderInequality(p.typeB);
        }
    };
    private static final Function<JSType.TypePair, JSType.TypePair> SHEQ = new Function<JSType.TypePair, JSType.TypePair>(){

        public JSType.TypePair apply(JSType.TypePair p) {
            if (p.typeA == null || p.typeB == null) {
                return null;
            }
            return p.typeA.getTypesUnderShallowEquality(p.typeB);
        }
    };
    private static final Function<JSType.TypePair, JSType.TypePair> SHNE = new Function<JSType.TypePair, JSType.TypePair>(){

        public JSType.TypePair apply(JSType.TypePair p) {
            if (p.typeA == null || p.typeB == null) {
                return null;
            }
            return p.typeA.getTypesUnderShallowInequality(p.typeB);
        }
    };
    private final Function<JSType.TypePair, JSType.TypePair> ineq = new Function<JSType.TypePair, JSType.TypePair>(){

        public JSType.TypePair apply(JSType.TypePair p) {
            return new JSType.TypePair(SemanticReverseAbstractInterpreter.this.getRestrictedWithoutUndefined(p.typeA), SemanticReverseAbstractInterpreter.this.getRestrictedWithoutUndefined(p.typeB));
        }
    };

    public SemanticReverseAbstractInterpreter(JSTypeRegistry typeRegistry) {
        super(typeRegistry);
    }

    @Override
    public FlowScope getPreciserScopeKnowingConditionOutcome(Node condition, FlowScope blindScope, boolean outcome) {
        Node right;
        Node left;
        int operatorToken = condition.getType();
        switch (operatorToken) {
            case 12: 
            case 13: 
            case 45: 
            case 46: 
            case 111: {
                boolean resultEqualsValue;
                Node operandNode;
                JSType operandType;
                if (operatorToken == 111) {
                    left = condition.getParent().getFirstChild();
                    right = condition.getFirstChild();
                } else {
                    left = condition.getFirstChild();
                    right = condition.getLastChild();
                }
                Node typeOfNode = null;
                Node stringNode = null;
                if (left.isTypeOf() && right.isString()) {
                    typeOfNode = left;
                    stringNode = right;
                } else if (right.isTypeOf() && left.isString()) {
                    typeOfNode = right;
                    stringNode = left;
                }
                if (typeOfNode == null || stringNode == null || (operandType = this.getTypeIfRefinable(operandNode = typeOfNode.getFirstChild(), blindScope)) == null) break;
                boolean bl = resultEqualsValue = operatorToken == 12 || operatorToken == 45 || operatorToken == 111;
                if (!outcome) {
                    resultEqualsValue = !resultEqualsValue;
                }
                return this.caseTypeOf(operandNode, operandType, stringNode.getString(), resultEqualsValue, blindScope);
            }
        }
        switch (operatorToken) {
            case 101: {
                if (outcome) {
                    return this.caseAndOrNotShortCircuiting(condition.getFirstChild(), condition.getLastChild(), blindScope, true);
                }
                return this.caseAndOrMaybeShortCircuiting(condition.getFirstChild(), condition.getLastChild(), blindScope, true);
            }
            case 100: {
                if (!outcome) {
                    return this.caseAndOrNotShortCircuiting(condition.getFirstChild(), condition.getLastChild(), blindScope, false);
                }
                return this.caseAndOrMaybeShortCircuiting(condition.getFirstChild(), condition.getLastChild(), blindScope, false);
            }
            case 12: {
                if (outcome) {
                    return this.caseEquality(condition, blindScope, EQ);
                }
                return this.caseEquality(condition, blindScope, NE);
            }
            case 13: {
                if (outcome) {
                    return this.caseEquality(condition, blindScope, NE);
                }
                return this.caseEquality(condition, blindScope, EQ);
            }
            case 45: {
                if (outcome) {
                    return this.caseEquality(condition, blindScope, SHEQ);
                }
                return this.caseEquality(condition, blindScope, SHNE);
            }
            case 46: {
                if (outcome) {
                    return this.caseEquality(condition, blindScope, SHNE);
                }
                return this.caseEquality(condition, blindScope, SHEQ);
            }
            case 33: 
            case 38: {
                return this.caseNameOrGetProp(condition, blindScope, outcome);
            }
            case 86: {
                return this.firstPreciserScopeKnowingConditionOutcome(condition.getFirstChild(), this.firstPreciserScopeKnowingConditionOutcome(condition.getFirstChild().getNext(), blindScope, outcome), outcome);
            }
            case 26: {
                return this.firstPreciserScopeKnowingConditionOutcome(condition.getFirstChild(), blindScope, !outcome);
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                if (!outcome) break;
                return this.caseEquality(condition, blindScope, this.ineq);
            }
            case 52: {
                return this.caseInstanceOf(condition.getFirstChild(), condition.getLastChild(), blindScope, outcome);
            }
            case 51: {
                if (!outcome || !condition.getFirstChild().isString()) break;
                return this.caseIn(condition.getLastChild(), condition.getFirstChild().getString(), blindScope);
            }
            case 111: {
                left = condition.getParent().getFirstChild();
                right = condition.getFirstChild();
                if (outcome) {
                    return this.caseEquality(left, right, blindScope, SHEQ);
                }
                return this.caseEquality(left, right, blindScope, SHNE);
            }
        }
        return this.nextPreciserScopeKnowingConditionOutcome(condition, blindScope, outcome);
    }

    private FlowScope caseEquality(Node condition, FlowScope blindScope, Function<JSType.TypePair, JSType.TypePair> merging) {
        return this.caseEquality(condition.getFirstChild(), condition.getLastChild(), blindScope, merging);
    }

    private FlowScope caseEquality(Node left, Node right, FlowScope blindScope, Function<JSType.TypePair, JSType.TypePair> merging) {
        boolean rightIsRefineable;
        boolean leftIsRefineable;
        JSType leftType = this.getTypeIfRefinable(left, blindScope);
        if (leftType != null) {
            leftIsRefineable = true;
        } else {
            leftIsRefineable = false;
            leftType = left.getJSType();
        }
        JSType rightType = this.getTypeIfRefinable(right, blindScope);
        if (rightType != null) {
            rightIsRefineable = true;
        } else {
            rightIsRefineable = false;
            rightType = right.getJSType();
        }
        JSType.TypePair merged = (JSType.TypePair)merging.apply((Object)new JSType.TypePair(leftType, rightType));
        if (merged != null) {
            return this.maybeRestrictTwoNames(blindScope, left, leftType, leftIsRefineable ? merged.typeA : null, right, rightType, rightIsRefineable ? merged.typeB : null);
        }
        return blindScope;
    }

    private FlowScope caseAndOrNotShortCircuiting(Node left, Node right, FlowScope blindScope, boolean outcome) {
        boolean rightIsRefineable;
        JSType restrictedLeftType;
        boolean leftIsRefineable;
        JSType leftType = this.getTypeIfRefinable(left, blindScope);
        if (leftType != null) {
            leftIsRefineable = true;
        } else {
            leftIsRefineable = false;
            leftType = left.getJSType();
            blindScope = this.firstPreciserScopeKnowingConditionOutcome(left, blindScope, outcome);
        }
        JSType jSType = restrictedLeftType = leftType == null ? null : leftType.getRestrictedTypeGivenToBooleanOutcome(outcome);
        if (restrictedLeftType == null) {
            return this.firstPreciserScopeKnowingConditionOutcome(right, blindScope, outcome);
        }
        JSType rightType = this.getTypeIfRefinable(right, blindScope = this.maybeRestrictName(blindScope, left, leftType, leftIsRefineable ? restrictedLeftType : null));
        if (rightType != null) {
            rightIsRefineable = true;
        } else {
            rightIsRefineable = false;
            rightType = right.getJSType();
            blindScope = this.firstPreciserScopeKnowingConditionOutcome(right, blindScope, outcome);
        }
        if (outcome) {
            JSType restrictedRightType = rightType == null ? null : rightType.getRestrictedTypeGivenToBooleanOutcome(outcome);
            return this.maybeRestrictName(blindScope, right, rightType, rightIsRefineable ? restrictedRightType : null);
        }
        return blindScope;
    }

    private FlowScope caseAndOrMaybeShortCircuiting(Node left, Node right, FlowScope blindScope, boolean outcome) {
        FlowScope leftScope = this.firstPreciserScopeKnowingConditionOutcome(left, blindScope, !outcome);
        StaticTypedSlot<JSType> leftVar = leftScope.findUniqueRefinedSlot(blindScope);
        if (leftVar == null) {
            return blindScope == leftScope ? blindScope : blindScope.createChildFlowScope();
        }
        FlowScope rightScope = this.firstPreciserScopeKnowingConditionOutcome(left, blindScope, outcome);
        StaticTypedSlot<JSType> rightVar = (rightScope = this.firstPreciserScopeKnowingConditionOutcome(right, rightScope, !outcome)).findUniqueRefinedSlot(blindScope);
        if (rightVar == null || !leftVar.getName().equals(rightVar.getName())) {
            return blindScope == rightScope ? blindScope : blindScope.createChildFlowScope();
        }
        JSType type = leftVar.getType().getLeastSupertype(rightVar.getType());
        FlowScope informed = blindScope.createChildFlowScope();
        informed.inferSlotType(leftVar.getName(), type);
        return informed;
    }

    private FlowScope maybeRestrictName(FlowScope blindScope, Node node, JSType originalType, JSType restrictedType) {
        if (restrictedType != null && restrictedType != originalType) {
            FlowScope informed = blindScope.createChildFlowScope();
            this.declareNameInScope(informed, node, restrictedType);
            return informed;
        }
        return blindScope;
    }

    private FlowScope maybeRestrictTwoNames(FlowScope blindScope, Node left, JSType originalLeftType, JSType restrictedLeftType, Node right, JSType originalRightType, JSType restrictedRightType) {
        boolean shouldRefineRight;
        boolean shouldRefineLeft = restrictedLeftType != null && restrictedLeftType != originalLeftType;
        boolean bl = shouldRefineRight = restrictedRightType != null && restrictedRightType != originalRightType;
        if (shouldRefineLeft || shouldRefineRight) {
            FlowScope informed = blindScope.createChildFlowScope();
            if (shouldRefineLeft) {
                this.declareNameInScope(informed, left, restrictedLeftType);
            }
            if (shouldRefineRight) {
                this.declareNameInScope(informed, right, restrictedRightType);
            }
            return informed;
        }
        return blindScope;
    }

    private FlowScope caseNameOrGetProp(Node name, FlowScope blindScope, boolean outcome) {
        JSType type = this.getTypeIfRefinable(name, blindScope);
        if (type != null) {
            return this.maybeRestrictName(blindScope, name, type, type.getRestrictedTypeGivenToBooleanOutcome(outcome));
        }
        return blindScope;
    }

    private FlowScope caseTypeOf(Node node, JSType type, String value, boolean resultEqualsValue, FlowScope blindScope) {
        return this.maybeRestrictName(blindScope, node, type, this.getRestrictedByTypeOfResult(type, value, resultEqualsValue));
    }

    private FlowScope caseInstanceOf(Node left, Node right, FlowScope blindScope, boolean outcome) {
        JSType leftType = this.getTypeIfRefinable(left, blindScope);
        if (leftType == null) {
            return blindScope;
        }
        JSType rightType = right.getJSType();
        ObjectType targetType = this.typeRegistry.getNativeObjectType(JSTypeNative.UNKNOWN_TYPE);
        if (rightType != null && rightType.isFunctionType()) {
            targetType = rightType.toMaybeFunctionType();
        }
        ChainableReverseAbstractInterpreter.RestrictByTypeOfResultVisitor visitor = outcome ? new RestrictByTrueInstanceOfResultVisitor(targetType) : new RestrictByFalseInstanceOfResultVisitor(targetType);
        return this.maybeRestrictName(blindScope, left, leftType, leftType.visit(visitor));
    }

    private FlowScope caseIn(Node object, String propertyName, FlowScope blindScope) {
        String propertyQualifiedName;
        String qualifiedName;
        JSType jsType = object.getJSType();
        jsType = this.getRestrictedWithoutNull(jsType);
        jsType = this.getRestrictedWithoutUndefined(jsType);
        boolean hasProperty = false;
        ObjectType objectType = ObjectType.cast(jsType);
        if (objectType != null) {
            hasProperty = objectType.hasProperty(propertyName);
        }
        if (!hasProperty && (qualifiedName = object.getQualifiedName()) != null && blindScope.getSlot(propertyQualifiedName = qualifiedName + "." + propertyName) == null) {
            FlowScope informed = blindScope.createChildFlowScope();
            JSType unknownType = this.typeRegistry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
            informed.inferQualifiedSlot(object, propertyQualifiedName, unknownType, unknownType);
            return informed;
        }
        return blindScope;
    }

    private class RestrictByFalseInstanceOfResultVisitor
    extends ChainableReverseAbstractInterpreter.RestrictByFalseTypeOfResultVisitor {
        private final ObjectType target;

        RestrictByFalseInstanceOfResultVisitor(ObjectType target) {
            this.target = target;
        }

        @Override
        public JSType caseObjectType(ObjectType type) {
            if (this.target.isUnknownType()) {
                return type;
            }
            FunctionType funcTarget = this.target.toMaybeFunctionType();
            if (funcTarget.hasInstanceType()) {
                if (type.isSubtype(funcTarget.getInstanceType())) {
                    return null;
                }
                return type;
            }
            return null;
        }

        @Override
        public JSType caseUnionType(UnionType type) {
            if (this.target.isUnknownType()) {
                return type;
            }
            FunctionType funcTarget = this.target.toMaybeFunctionType();
            if (funcTarget.hasInstanceType()) {
                return type.getRestrictedUnion(funcTarget.getInstanceType());
            }
            return null;
        }

        @Override
        public JSType caseFunctionType(FunctionType type) {
            return this.caseObjectType(type);
        }
    }

    private class RestrictByTrueInstanceOfResultVisitor
    extends ChainableReverseAbstractInterpreter.RestrictByTrueTypeOfResultVisitor {
        private final ObjectType target;

        RestrictByTrueInstanceOfResultVisitor(ObjectType target) {
            this.target = target;
        }

        @Override
        protected JSType caseTopType(JSType type) {
            return this.applyCommonRestriction(type);
        }

        @Override
        public JSType caseUnknownType() {
            FunctionType funcTarget = JSType.toMaybeFunctionType(this.target);
            if (funcTarget != null && funcTarget.hasInstanceType()) {
                return funcTarget.getInstanceType();
            }
            return SemanticReverseAbstractInterpreter.this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }

        @Override
        public JSType caseObjectType(ObjectType type) {
            return this.applyCommonRestriction(type);
        }

        @Override
        public JSType caseUnionType(UnionType type) {
            return this.applyCommonRestriction(type);
        }

        @Override
        public JSType caseFunctionType(FunctionType type) {
            return this.caseObjectType(type);
        }

        private JSType applyCommonRestriction(JSType type) {
            if (this.target.isUnknownType()) {
                return type;
            }
            FunctionType funcTarget = this.target.toMaybeFunctionType();
            if (funcTarget.hasInstanceType()) {
                return type.getGreatestSubtype(funcTarget.getInstanceType());
            }
            return null;
        }
    }
}

