/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckConformance;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JsAst;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Requirement;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.TemplateAstMatcher;
import com.google.javascript.jscomp.parsing.JsDocInfoParser;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.TypeI;
import com.google.javascript.rhino.TypeIRegistry;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.Property;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nullable;

public final class ConformanceRules {
    private ConformanceRules() {
    }

    public static final class NoImplicitlyPublicDecls
    extends AbstractRule {
        public NoImplicitlyPublicDecls(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            super(compiler, requirement);
        }

        @Override
        protected ConformanceResult checkConformance(NodeTraversal t, Node n) {
            if (!t.inGlobalScope() || !n.isExprResult() || !n.getFirstChild().isAssign() || n.getFirstChild().getLastChild() == null || n.getFirstChild().getLastChild().isObjectLit() || NoImplicitlyPublicDecls.isWizDeclaration(n)) {
                return ConformanceResult.CONFORMANCE;
            }
            JSDocInfo ownJsDoc = n.getFirstChild().getJSDocInfo();
            if (ownJsDoc != null && ownJsDoc.isConstructor()) {
                FunctionType functionType = n.getFirstChild().getJSType().toMaybeFunctionType();
                if (functionType == null) {
                    return ConformanceResult.CONFORMANCE;
                }
                ObjectType instanceType = functionType.getInstanceType();
                if (instanceType == null) {
                    return ConformanceResult.CONFORMANCE;
                }
                ConformanceResult result = NoImplicitlyPublicDecls.checkCtorProperties(instanceType);
                if (result != ConformanceResult.CONFORMANCE) {
                    return result;
                }
            }
            return NoImplicitlyPublicDecls.visibilityAtDeclarationOrFileoverview(ownJsDoc, NoImplicitlyPublicDecls.getScriptNode(n));
        }

        private static boolean isWizDeclaration(Node n) {
            Node lastChild = n.getFirstChild().getLastChild();
            if (!lastChild.isCall()) {
                return false;
            }
            Node getprop = lastChild.getFirstChild();
            if (getprop == null || !getprop.isGetProp()) {
                return false;
            }
            Node name = getprop.getFirstChild();
            if (name == null || !name.isName()) {
                return false;
            }
            return "wiz".equals(name.getString());
        }

        private static ConformanceResult checkCtorProperties(ObjectType type) {
            for (String propertyName : type.getOwnPropertyNames()) {
                Node scriptNode;
                Property prop = type.getOwnSlot(propertyName);
                JSDocInfo docInfo = prop.getJSDocInfo();
                ConformanceResult result = NoImplicitlyPublicDecls.visibilityAtDeclarationOrFileoverview(docInfo, scriptNode = NoImplicitlyPublicDecls.getScriptNode(prop.getNode()));
                if (result == ConformanceResult.CONFORMANCE) continue;
                return result;
            }
            return ConformanceResult.CONFORMANCE;
        }

        @Nullable
        private static Node getScriptNode(Node start) {
            for (Node up : start.getAncestors()) {
                if (!up.isScript()) continue;
                return up;
            }
            return null;
        }

        private static ConformanceResult visibilityAtDeclarationOrFileoverview(@Nullable JSDocInfo declaredJsDoc, @Nullable Node scriptNode) {
            if (declaredJsDoc != null && (declaredJsDoc.getVisibility() != JSDocInfo.Visibility.INHERITED || declaredJsDoc.isOverride())) {
                return ConformanceResult.CONFORMANCE;
            }
            if (scriptNode != null && scriptNode.getJSDocInfo() != null && scriptNode.getJSDocInfo().getVisibility() != JSDocInfo.Visibility.INHERITED) {
                return ConformanceResult.CONFORMANCE;
            }
            return ConformanceResult.VIOLATION;
        }
    }

    public static final class RequireFileoverviewVisibility
    extends AbstractRule {
        public RequireFileoverviewVisibility(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            super(compiler, requirement);
        }

        @Override
        protected ConformanceResult checkConformance(NodeTraversal t, Node n) {
            if (!n.isScript()) {
                return ConformanceResult.CONFORMANCE;
            }
            JSDocInfo docInfo = n.getJSDocInfo();
            if (docInfo == null || !docInfo.hasFileOverview()) {
                return ConformanceResult.VIOLATION;
            }
            JSDocInfo.Visibility v = docInfo.getVisibility();
            if (v == null || v == JSDocInfo.Visibility.INHERITED) {
                return ConformanceResult.VIOLATION;
            }
            return ConformanceResult.CONFORMANCE;
        }
    }

    public static final class BanGlobalVars
    extends AbstractRule {
        public BanGlobalVars(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            super(compiler, requirement);
        }

        @Override
        protected ConformanceResult checkConformance(NodeTraversal t, Node n) {
            if (t.inGlobalScope() && this.isDeclaration(n) && !n.getBooleanProp(46) && !this.isWhitelisted(n)) {
                return ConformanceResult.VIOLATION;
            }
            return ConformanceResult.CONFORMANCE;
        }

        private boolean isDeclaration(Node n) {
            return NodeUtil.isNameDeclaration(n) || NodeUtil.isFunctionDeclaration(n) || NodeUtil.isClassDeclaration(n);
        }

        private boolean isWhitelisted(Node n) {
            return n.isVar() && n.getFirstChild().getString().equals("$jscomp");
        }
    }

    public static final class BanUnresolvedType
    extends AbstractRule {
        public BanUnresolvedType(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            super(compiler, requirement);
        }

        @Override
        protected ConformanceResult checkConformance(NodeTraversal t, Node n) {
            Node target;
            JSType type;
            if (n.isGetProp() && (type = (target = n.getFirstChild()).getJSType()) != null && !this.conforms(type) && !this.isWhiteListed(n)) {
                return ConformanceResult.VIOLATION;
            }
            return ConformanceResult.CONFORMANCE;
        }

        private boolean conforms(JSType type) {
            if (type.isUnionType()) {
                for (JSType part : type.toMaybeUnionType().getAlternates()) {
                    if (this.conforms(part)) continue;
                    return false;
                }
                return true;
            }
            return !type.isNoResolvedType();
        }

        private boolean isWhiteListed(Node n) {
            return n.getParent().isCast();
        }
    }

    public static final class BanUnknownDirectThisPropsReferences
    extends AbstractRule {
        private final ImmutableList<CodingConvention.AssertionFunctionSpec> assertions;

        public BanUnknownDirectThisPropsReferences(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            super(compiler, requirement);
            this.assertions = ImmutableList.copyOf(compiler.getCodingConvention().getAssertionFunctions());
        }

        @Override
        protected ConformanceResult checkConformance(NodeTraversal t, Node n) {
            if (n.isGetProp() && this.isKnownThis(n.getFirstChild()) && this.isUnknown(n) && !this.isTemplateType(n) && this.isUsed(n) && !this.isWhiteListed(n)) {
                return ConformanceResult.VIOLATION;
            }
            return ConformanceResult.CONFORMANCE;
        }

        private boolean isKnownThis(Node n) {
            return n.isThis() && !this.isUnknown(n);
        }

        private boolean isUnknown(Node n) {
            JSType type = n.getJSType();
            return type != null && type.isUnknownType();
        }

        private boolean isTemplateType(Node n) {
            JSType type = n.getJSType().restrictByNotNullOrUndefined();
            return type != null && type.isTemplateType();
        }

        private boolean isUsed(Node n) {
            return NodeUtil.isAssignmentOp(n.getParent()) ? NodeUtil.isExpressionResultUsed(n.getParent()) : NodeUtil.isExpressionResultUsed(n);
        }

        private boolean isWhiteListed(Node n) {
            Node parent = n.getParent();
            return n.getParent().isCast() || this.isAssertionCall(n.getParent()) || n.getParent().isAssign() && n.getFirstChild() == n;
        }

        private boolean isAssertionCall(Node n) {
            if (n.isCall() && n.getFirstChild().isQualifiedName()) {
                Node target = n.getFirstChild();
                for (int i = 0; i < this.assertions.size(); ++i) {
                    if (!target.matchesQualifiedName(((CodingConvention.AssertionFunctionSpec)this.assertions.get(i)).getFunctionName())) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public static final class BanUnknownThis
    extends AbstractRule {
        private final Set<Node> reports = Sets.newIdentityHashSet();
        private final ImmutableList<CodingConvention.AssertionFunctionSpec> assertions;

        public BanUnknownThis(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            super(compiler, requirement);
            this.assertions = ImmutableList.copyOf(compiler.getCodingConvention().getAssertionFunctions());
        }

        @Override
        protected ConformanceResult checkConformance(NodeTraversal t, Node n) {
            Node root;
            JSType type;
            if (n.isThis() && (type = n.getJSType()) != null && type.isUnknownType() && !this.isWhiteListed(n) && !this.reports.contains(root = t.getScopeRoot())) {
                this.reports.add(root);
                return ConformanceResult.VIOLATION;
            }
            return ConformanceResult.CONFORMANCE;
        }

        private boolean isWhiteListed(Node n) {
            return n.getParent().isCast() || this.isAssertionCall(n.getParent());
        }

        private boolean isAssertionCall(Node n) {
            if (n.isCall() && n.getFirstChild().isQualifiedName()) {
                Node target = n.getFirstChild();
                for (int i = 0; i < this.assertions.size(); ++i) {
                    if (!target.matchesQualifiedName(((CodingConvention.AssertionFunctionSpec)this.assertions.get(i)).getFunctionName())) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public static final class BanThrowOfNonErrorTypes
    extends AbstractRule {
        final JSType errorObjType;

        public BanThrowOfNonErrorTypes(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            super(compiler, requirement);
            this.errorObjType = (JSType)compiler.getTypeIRegistry().getType("Error");
        }

        @Override
        protected ConformanceResult checkConformance(NodeTraversal t, Node n) {
            JSType thrown;
            if (!(this.errorObjType == null || !n.isThrow() || (thrown = n.getFirstChild().getJSType()) == null || thrown.isUnknownType() || thrown.isAllType() || thrown.isEmptyType() || thrown.isSubtype(this.errorObjType))) {
                return ConformanceResult.VIOLATION;
            }
            return ConformanceResult.CONFORMANCE;
        }
    }

    public static final class BanExpose
    extends AbstractRule {
        public BanExpose(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            super(compiler, requirement);
        }

        @Override
        protected ConformanceResult checkConformance(NodeTraversal t, Node n) {
            JSDocInfo info = n.getJSDocInfo();
            if (info != null && info.isExpose()) {
                return ConformanceResult.VIOLATION;
            }
            return ConformanceResult.CONFORMANCE;
        }
    }

    static class CustomRuleProxy
    implements CheckConformance.Rule {
        final CheckConformance.Rule customRule;
        private static final TypeToken<CheckConformance.Rule> RULE_TYPE = new TypeToken<CheckConformance.Rule>(){};
        private static final TypeToken<AbstractCompiler> COMPILER_TYPE = new TypeToken<AbstractCompiler>(){};
        private static final TypeToken<Requirement> REQUIREMENT_TYPE = new TypeToken<Requirement>(){};

        CustomRuleProxy(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            if (!requirement.hasJavaClass()) {
                throw new CheckConformance.InvalidRequirementSpec("missing java_class");
            }
            this.customRule = this.createRule(compiler, requirement);
        }

        @Override
        public void check(NodeTraversal t, Node n) {
            this.customRule.check(t, n);
        }

        private CheckConformance.Rule createRule(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            try {
                CheckConformance.Rule rule;
                Class<CheckConformance.Rule> custom = this.getRuleClass(requirement.getJavaClass());
                Constructor<?> ctor = this.getRuleConstructor(custom);
                try {
                    rule = (CheckConformance.Rule)ctor.newInstance(compiler, requirement);
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof CheckConformance.InvalidRequirementSpec) {
                        throw (CheckConformance.InvalidRequirementSpec)cause;
                    }
                    throw e;
                }
                return rule;
            }
            catch (CheckConformance.InvalidRequirementSpec e) {
                throw e;
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        private Constructor<?> getRuleConstructor(Class<CheckConformance.Rule> cls) throws CheckConformance.InvalidRequirementSpec {
            for (Constructor<?> ctor : cls.getConstructors()) {
                Class<?>[] paramClasses = ctor.getParameterTypes();
                if (paramClasses.length != 2) continue;
                TypeToken param1 = TypeToken.of(paramClasses[0]);
                TypeToken param2 = TypeToken.of(paramClasses[1]);
                if (!param1.isAssignableFrom(COMPILER_TYPE) || !param2.isAssignableFrom(REQUIREMENT_TYPE)) continue;
                return ctor;
            }
            throw new CheckConformance.InvalidRequirementSpec("No valid class constructors found.");
        }

        private Class<CheckConformance.Rule> getRuleClass(String className) throws CheckConformance.InvalidRequirementSpec {
            Class<CheckConformance.Rule> customClass;
            try {
                customClass = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new CheckConformance.InvalidRequirementSpec("JavaClass not found.");
            }
            if (RULE_TYPE.isAssignableFrom(TypeToken.of(customClass))) {
                Class<CheckConformance.Rule> ruleClass = customClass;
                return ruleClass;
            }
            throw new CheckConformance.InvalidRequirementSpec("JavaClass is not a rule.");
        }
    }

    static class BannedCodePattern
    extends AbstractRule {
        private final ImmutableList<TemplateAstMatcher> restrictions;

        BannedCodePattern(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            super(compiler, requirement);
            if (requirement.getValueCount() == 0) {
                throw new CheckConformance.InvalidRequirementSpec("missing value");
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            for (String value : requirement.getValueList()) {
                Node parseRoot = new JsAst(SourceFile.fromCode("template", value)).getAstRoot(compiler);
                if (!parseRoot.hasOneChild() || !parseRoot.getFirstChild().isFunction()) {
                    throw new CheckConformance.InvalidRequirementSpec("invalid conformance template: " + value);
                }
                Node templateRoot = parseRoot.getFirstChild();
                TemplateAstMatcher astMatcher = new TemplateAstMatcher(compiler, templateRoot);
                builder.add((Object)astMatcher);
            }
            this.restrictions = builder.build();
        }

        @Override
        protected ConformanceResult checkConformance(NodeTraversal t, Node n) {
            boolean possibleViolation = false;
            for (int i = 0; i < this.restrictions.size(); ++i) {
                TemplateAstMatcher matcher = (TemplateAstMatcher)this.restrictions.get(i);
                if (!matcher.matches(n)) continue;
                if (matcher.isLooseMatch()) {
                    possibleViolation = true;
                    continue;
                }
                return ConformanceResult.VIOLATION;
            }
            return possibleViolation ? ConformanceResult.POSSIBLE_VIOLATION : ConformanceResult.CONFORMANCE;
        }
    }

    static class RestrictedMethodCall
    extends AbstractRule {
        private final ImmutableList<Restriction> restrictions;

        RestrictedMethodCall(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            super(compiler, requirement);
            if (requirement.getValueCount() == 0) {
                throw new CheckConformance.InvalidRequirementSpec("missing value");
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            for (String value : requirement.getValueList()) {
                String type = RestrictedMethodCall.getClassFromDeclarationName(value);
                String property = RestrictedMethodCall.getPropertyFromDeclarationName(value);
                String restrictedDecl = RestrictedMethodCall.getTypeFromValue(value);
                if (type == null || property == null || restrictedDecl == null) {
                    throw new CheckConformance.InvalidRequirementSpec("bad prop value");
                }
                FunctionType restrictedCallType = ConformanceUtil.evaluateTypeString(compiler, restrictedDecl).toMaybeFunctionType();
                if (restrictedCallType == null) {
                    throw new CheckConformance.InvalidRequirementSpec("invalid conformance type");
                }
                builder.add((Object)new Restriction(type, property, restrictedCallType));
            }
            this.restrictions = builder.build();
        }

        @Override
        protected ConformanceResult checkConformance(NodeTraversal t, Node n) {
            if (NodeUtil.isGet(n) && ConformanceUtil.isCallTarget(n) && n.getLastChild().isString()) {
                for (int i = 0; i < this.restrictions.size(); ++i) {
                    Restriction r = (Restriction)this.restrictions.get(i);
                    ConformanceResult result = ConformanceResult.CONFORMANCE;
                    if (this.matchesProp(n, r)) {
                        result = this.checkConformance(t, n, r, false);
                    } else if (n.getLastChild().getString().equals("call") && this.matchesProp(n.getFirstChild(), r)) {
                        result = this.checkConformance(t, n, r, true);
                    }
                    if (result == ConformanceResult.CONFORMANCE) continue;
                    return result;
                }
            }
            return ConformanceResult.CONFORMANCE;
        }

        private boolean matchesProp(Node n, Restriction r) {
            return n.isGetProp() && n.getLastChild().getString().equals(r.property);
        }

        private ConformanceResult checkConformance(NodeTraversal t, Node n, Restriction r, boolean isCallInvocation) {
            Node lhs;
            TypeIRegistry registry = t.getCompiler().getTypeIRegistry();
            JSType methodClassType = (JSType)registry.getType(r.type);
            Node node = lhs = isCallInvocation ? n.getFirstChild().getFirstChild() : n.getFirstChild();
            if (methodClassType != null && lhs.getJSType() != null) {
                JSType targetType = lhs.getJSType().restrictByNotNullOrUndefined();
                if (targetType.isUnknownType() || targetType.isNoResolvedType() || targetType.isAllType() || targetType.isEquivalentTo((TypeI)registry.getNativeType(JSTypeNative.OBJECT_TYPE))) {
                    if (!ConformanceUtil.validateCall(this.compiler, n.getParent(), r.restrictedCallType, isCallInvocation)) {
                        return ConformanceResult.POSSIBLE_VIOLATION;
                    }
                } else if (targetType.isSubtype(methodClassType) && !ConformanceUtil.validateCall(this.compiler, n.getParent(), r.restrictedCallType, isCallInvocation)) {
                    return ConformanceResult.VIOLATION;
                }
            }
            return ConformanceResult.CONFORMANCE;
        }

        private static String getPropertyFromDeclarationName(String specName) throws CheckConformance.InvalidRequirementSpec {
            String[] parts = RestrictedMethodCall.removeTypeDecl(specName).split("\\.prototype\\.");
            Preconditions.checkState((parts.length == 1 || parts.length == 2 ? 1 : 0) != 0);
            if (parts.length == 2) {
                return parts[1];
            }
            return null;
        }

        private static String getClassFromDeclarationName(String specName) throws CheckConformance.InvalidRequirementSpec {
            String tmp = RestrictedMethodCall.removeTypeDecl(specName);
            String[] parts = tmp.split("\\.prototype\\.");
            Preconditions.checkState((parts.length == 1 || parts.length == 2 ? 1 : 0) != 0);
            if (parts.length == 2) {
                return parts[0];
            }
            return null;
        }

        private static String removeTypeDecl(String specName) throws CheckConformance.InvalidRequirementSpec {
            int index = specName.indexOf(58);
            if (index < 1) {
                throw new CheckConformance.InvalidRequirementSpec("value should be in the form NAME:TYPE");
            }
            return specName.substring(0, index);
        }

        private static String getTypeFromValue(String specName) {
            int index = specName.indexOf(58);
            if (index < 1) {
                return null;
            }
            return specName.substring(index + 1);
        }

        private static class Restriction {
            final String type;
            final String property;
            final FunctionType restrictedCallType;

            Restriction(String type, String property, FunctionType restrictedCallType) {
                this.type = type;
                this.property = property;
                this.restrictedCallType = restrictedCallType;
            }
        }
    }

    static class RestrictedNameCall
    extends AbstractRule {
        private final ImmutableList<Restriction> restrictions;

        RestrictedNameCall(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            super(compiler, requirement);
            if (requirement.getValueCount() == 0) {
                throw new CheckConformance.InvalidRequirementSpec("missing value");
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            for (String value : requirement.getValueList()) {
                String name = RestrictedNameCall.getNameFromValue(value);
                String restrictedDecl = RestrictedNameCall.getTypeFromValue(value);
                if (name == null || restrictedDecl == null) {
                    throw new CheckConformance.InvalidRequirementSpec("bad prop value");
                }
                FunctionType restrictedCallType = ConformanceUtil.evaluateTypeString(compiler, restrictedDecl).toMaybeFunctionType();
                if (restrictedCallType == null) {
                    throw new CheckConformance.InvalidRequirementSpec("invalid conformance type");
                }
                builder.add((Object)new Restriction(name, restrictedCallType));
            }
            this.restrictions = builder.build();
        }

        @Override
        protected ConformanceResult checkConformance(NodeTraversal t, Node n) {
            if (ConformanceUtil.isCallTarget(n) && n.isQualifiedName()) {
                for (int i = 0; i < this.restrictions.size(); ++i) {
                    Restriction r = (Restriction)this.restrictions.get(i);
                    if (!(n.matchesQualifiedName(r.name) ? !ConformanceUtil.validateCall(this.compiler, n.getParent(), r.restrictedCallType, false) : n.isGetProp() && n.getLastChild().getString().equals("call") && n.getFirstChild().matchesQualifiedName(r.name) && !ConformanceUtil.validateCall(this.compiler, n.getParent(), r.restrictedCallType, true))) continue;
                    return ConformanceResult.VIOLATION;
                }
            }
            return ConformanceResult.CONFORMANCE;
        }

        private static String getNameFromValue(String specName) {
            int index = specName.indexOf(58);
            if (index < 1) {
                return null;
            }
            return specName.substring(0, index);
        }

        private static String getTypeFromValue(String specName) {
            int index = specName.indexOf(58);
            if (index < 1) {
                return null;
            }
            return specName.substring(index + 1);
        }

        private static class Restriction {
            final String name;
            final FunctionType restrictedCallType;

            Restriction(String name, FunctionType restrictedCallType) {
                this.name = name;
                this.restrictedCallType = restrictedCallType;
            }
        }
    }

    private static class ConformanceUtil {
        private ConformanceUtil() {
        }

        static boolean isCallTarget(Node n) {
            Node parent = n.getParent();
            return (parent.isCall() || parent.isNew()) && parent.getFirstChild() == n;
        }

        static JSType evaluateTypeString(AbstractCompiler compiler, String expression) throws CheckConformance.InvalidRequirementSpec {
            Node typeNodes = JsDocInfoParser.parseTypeString(expression);
            if (typeNodes == null) {
                throw new CheckConformance.InvalidRequirementSpec("bad type expression");
            }
            JSTypeExpression typeExpr = new JSTypeExpression(typeNodes, "conformance");
            return typeExpr.evaluate(null, compiler.getTypeIRegistry());
        }

        static boolean validateCall(AbstractCompiler compiler, Node callOrNew, FunctionType functionType, boolean isCallInvocation) {
            Preconditions.checkState((callOrNew.isCall() || callOrNew.isNew() ? 1 : 0) != 0);
            return ConformanceUtil.validateParameterList(compiler, callOrNew, functionType, isCallInvocation) && ConformanceUtil.validateThis(callOrNew, functionType, isCallInvocation);
        }

        private static boolean validateThis(Node callOrNew, FunctionType functionType, boolean isCallInvocation) {
            if (callOrNew.isNew()) {
                return true;
            }
            JSType thisType = functionType.getTypeOfThis();
            if (thisType.isUnknownType()) {
                return true;
            }
            Node thisNode = isCallInvocation ? callOrNew.getFirstChild().getNext() : callOrNew.getFirstChild().getFirstChild();
            JSType thisNodeType = thisNode.getJSType().restrictByNotNullOrUndefined();
            return thisNodeType.isSubtype(thisType);
        }

        private static boolean validateParameterList(AbstractCompiler compiler, Node callOrNew, FunctionType functionType, boolean isCallInvocation) {
            Iterator<Node> arguments = callOrNew.children().iterator();
            arguments.next();
            if (isCallInvocation && arguments.hasNext()) {
                arguments.next();
            }
            Iterator<Node> parameters = functionType.getParameters().iterator();
            Node parameter = null;
            Node argument = null;
            while (arguments.hasNext() && (parameters.hasNext() || parameter != null && parameter.isVarArgs())) {
                if (parameters.hasNext()) {
                    parameter = parameters.next();
                }
                if (ConformanceUtil.validateParameter(ConformanceUtil.getJSType(compiler, argument = arguments.next()), ConformanceUtil.getJSType(compiler, parameter))) continue;
                return false;
            }
            int numArgs = callOrNew.getChildCount() - 1;
            if (isCallInvocation && numArgs > 0) {
                --numArgs;
            }
            int minArgs = functionType.getMinArguments();
            int maxArgs = functionType.getMaxArguments();
            return minArgs <= numArgs && numArgs <= maxArgs;
        }

        static boolean validateParameter(JSType argType, JSType paramType) {
            return argType.isSubtype(paramType);
        }

        static JSType getJSType(AbstractCompiler compiler, Node n) {
            JSType jsType = n.getJSType();
            if (jsType == null) {
                return ConformanceUtil.getNativeType(compiler, JSTypeNative.UNKNOWN_TYPE);
            }
            return jsType;
        }

        static JSType getNativeType(AbstractCompiler compiler, JSTypeNative typeId) {
            return (JSType)compiler.getTypeIRegistry().getNativeType(typeId);
        }
    }

    static class BannedProperty
    extends AbstractRule {
        private final ImmutableList<Property> props;
        private final Requirement.Type requirementType;

        BannedProperty(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            super(compiler, requirement);
            if (requirement.getValueCount() == 0) {
                throw new CheckConformance.InvalidRequirementSpec("missing value");
            }
            Preconditions.checkArgument((requirement.getType() == Requirement.Type.BANNED_PROPERTY || requirement.getType() == Requirement.Type.BANNED_PROPERTY_READ || requirement.getType() == Requirement.Type.BANNED_PROPERTY_WRITE || requirement.getType() == Requirement.Type.BANNED_PROPERTY_CALL ? 1 : 0) != 0);
            this.requirementType = requirement.getType();
            ImmutableList.Builder builder = ImmutableList.builder();
            List<String> values = requirement.getValueList();
            for (String value : values) {
                String type = BannedProperty.getClassFromDeclarationName(value);
                String property = BannedProperty.getPropertyFromDeclarationName(value);
                if (type == null || property == null) {
                    throw new CheckConformance.InvalidRequirementSpec("bad prop value");
                }
                builder.add((Object)new Property(type, property));
            }
            this.props = builder.build();
        }

        @Override
        protected ConformanceResult checkConformance(NodeTraversal t, Node n) {
            for (int i = 0; i < this.props.size(); ++i) {
                Property prop = (Property)this.props.get(i);
                ConformanceResult result = this.checkConformance(t, n, prop);
                if (result == ConformanceResult.CONFORMANCE) continue;
                return result;
            }
            return ConformanceResult.CONFORMANCE;
        }

        private ConformanceResult checkConformance(NodeTraversal t, Node n, Property prop) {
            if (this.isCandidatePropUse(n, prop)) {
                TypeIRegistry registry = t.getCompiler().getTypeIRegistry();
                JSType methodClassType = (JSType)registry.getType(prop.type);
                Node lhs = n.getFirstChild();
                if (methodClassType != null && lhs.getJSType() != null) {
                    JSType targetType = lhs.getJSType().restrictByNotNullOrUndefined();
                    if (targetType.isUnknownType() || targetType.isEmptyType() || targetType.isAllType() || targetType.isEquivalentTo((TypeI)registry.getNativeType(JSTypeNative.OBJECT_TYPE))) {
                        return ConformanceResult.POSSIBLE_VIOLATION;
                    }
                    if (targetType.isSubtype(methodClassType)) {
                        return ConformanceResult.VIOLATION;
                    }
                }
            }
            return ConformanceResult.CONFORMANCE;
        }

        private boolean isCandidatePropUse(Node n, Property prop) {
            if (NodeUtil.isGet(n) && n.getLastChild().isString() && n.getLastChild().getString().equals(prop.property)) {
                if (this.requirementType == Requirement.Type.BANNED_PROPERTY_WRITE) {
                    return NodeUtil.isLValue(n);
                }
                if (this.requirementType == Requirement.Type.BANNED_PROPERTY_READ) {
                    return !NodeUtil.isLValue(n) && NodeUtil.isExpressionResultUsed(n);
                }
                if (this.requirementType == Requirement.Type.BANNED_PROPERTY_CALL) {
                    return ConformanceUtil.isCallTarget(n);
                }
                return true;
            }
            return false;
        }

        private static String getPropertyFromDeclarationName(String specName) {
            String[] parts = specName.split("\\.prototype\\.");
            Preconditions.checkState((parts.length == 1 || parts.length == 2 ? 1 : 0) != 0);
            if (parts.length == 2) {
                return parts[1];
            }
            return null;
        }

        private static String getClassFromDeclarationName(String specName) {
            String[] parts = specName.split("\\.prototype\\.");
            Preconditions.checkState((parts.length == 1 || parts.length == 2 ? 1 : 0) != 0);
            if (parts.length == 2) {
                return parts[0];
            }
            return null;
        }

        private static class Property {
            final String type;
            final String property;

            Property(String type, String property) {
                this.type = type;
                this.property = property;
            }
        }
    }

    static class BannedName
    extends AbstractRule {
        private final List<String> names;

        BannedName(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            super(compiler, requirement);
            if (requirement.getValueCount() == 0) {
                throw new CheckConformance.InvalidRequirementSpec("missing value");
            }
            this.names = requirement.getValueList();
        }

        @Override
        protected ConformanceResult checkConformance(NodeTraversal t, Node n) {
            if ((n.isGetProp() || n.isName()) && n.isQualifiedName()) {
                for (int i = 0; i < this.names.size(); ++i) {
                    String name = this.names.get(i);
                    if (!n.matchesQualifiedName(name)) continue;
                    return ConformanceResult.VIOLATION;
                }
            }
            return ConformanceResult.CONFORMANCE;
        }
    }

    static class BannedDependency
    extends AbstractRule {
        private final List<String> paths;

        BannedDependency(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            super(compiler, requirement);
            this.paths = requirement.getValueList();
            if (this.paths.isEmpty()) {
                throw new CheckConformance.InvalidRequirementSpec("missing value");
            }
        }

        @Override
        protected ConformanceResult checkConformance(NodeTraversal t, Node n) {
            if (n.isScript()) {
                String srcFile = n.getSourceFileName();
                for (int i = 0; i < this.paths.size(); ++i) {
                    String path = this.paths.get(i);
                    if (!srcFile.startsWith(path)) continue;
                    return ConformanceResult.VIOLATION;
                }
            }
            return ConformanceResult.CONFORMANCE;
        }
    }

    public static abstract class AbstractRule
    implements CheckConformance.Rule {
        final AbstractCompiler compiler;
        final String message;
        final ImmutableList<String> whitelist;
        final ImmutableList<String> onlyApplyTo;
        @Nullable
        final Pattern whitelistRegexp;
        @Nullable
        final Pattern onlyApplyToRegexp;

        public AbstractRule(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            boolean hasOnlyApplyTo;
            if (!requirement.hasErrorMessage()) {
                throw new CheckConformance.InvalidRequirementSpec("missing message");
            }
            this.compiler = compiler;
            this.message = requirement.getErrorMessage();
            this.whitelist = ImmutableList.copyOf(requirement.getWhitelistList());
            this.whitelistRegexp = AbstractRule.buildPattern(requirement.getWhitelistRegexpList());
            this.onlyApplyTo = ImmutableList.copyOf(requirement.getOnlyApplyToList());
            this.onlyApplyToRegexp = AbstractRule.buildPattern(requirement.getOnlyApplyToRegexpList());
            boolean hasWhitelist = !this.whitelist.isEmpty() || this.whitelistRegexp != null;
            boolean bl = hasOnlyApplyTo = !this.onlyApplyTo.isEmpty() || this.onlyApplyToRegexp != null;
            if (hasWhitelist && hasOnlyApplyTo) {
                throw new IllegalArgumentException("It is an error to specify both whitelist and only_apply_to");
            }
        }

        @Nullable
        private static Pattern buildPattern(List<String> reqPatterns) throws CheckConformance.InvalidRequirementSpec {
            if (reqPatterns == null || reqPatterns.isEmpty()) {
                return null;
            }
            for (String reqPattern : reqPatterns) {
                try {
                    Pattern.compile(reqPattern);
                }
                catch (PatternSyntaxException e) {
                    throw new CheckConformance.InvalidRequirementSpec("invalid regex pattern");
                }
            }
            Pattern pattern = null;
            try {
                String jointRegExp = "(" + Joiner.on((String)"|").join(reqPatterns) + ")";
                pattern = Pattern.compile(jointRegExp);
            }
            catch (PatternSyntaxException e) {
                throw new RuntimeException("bad joined regexp", e);
            }
            return pattern;
        }

        protected abstract ConformanceResult checkConformance(NodeTraversal var1, Node var2);

        private boolean shouldCheckConformance(Node n) {
            String srcfile = NodeUtil.getSourceName(n);
            if (srcfile == null) {
                return true;
            }
            if (!this.onlyApplyTo.isEmpty() || this.onlyApplyToRegexp != null) {
                return AbstractRule.pathIsInListOrRegexp(srcfile, this.onlyApplyTo, this.onlyApplyToRegexp);
            }
            return !AbstractRule.pathIsInListOrRegexp(srcfile, this.whitelist, this.whitelistRegexp);
        }

        private static boolean pathIsInListOrRegexp(String srcfile, ImmutableList<String> list, @Nullable Pattern regexp) {
            for (int i = 0; i < list.size(); ++i) {
                String entry = (String)list.get(i);
                if (entry.isEmpty() || !srcfile.startsWith(entry)) continue;
                return true;
            }
            return regexp != null && regexp.matcher(srcfile).find();
        }

        @Override
        public final void check(NodeTraversal t, Node n) {
            ConformanceResult confidence = this.checkConformance(t, n);
            if (confidence != ConformanceResult.CONFORMANCE && this.shouldCheckConformance(n)) {
                this.report(t, n, confidence);
            }
        }

        protected void report(NodeTraversal t, Node n, ConformanceResult result) {
            DiagnosticType msg = result == ConformanceResult.VIOLATION ? CheckConformance.CONFORMANCE_VIOLATION : CheckConformance.CONFORMANCE_POSSIBLE_VIOLATION;
            t.report(n, msg, this.message);
        }
    }

    public static enum ConformanceResult {
        CONFORMANCE,
        POSSIBLE_VIOLATION,
        VIOLATION;

    }
}

