/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.List;

class AngularPass
extends NodeTraversal.AbstractPostOrderCallback
implements HotSwapCompilerPass {
    final AbstractCompiler compiler;
    private final List<NodeContext> injectables = new ArrayList<NodeContext>();
    public static final String INJECT_PROPERTY_NAME = "$inject";
    static final DiagnosticType INJECT_IN_NON_GLOBAL_OR_BLOCK_ERROR = DiagnosticType.error("JSC_INJECT_IN_NON_GLOBAL_OR_BLOCK_ERROR", "@ngInject only applies to functions defined in blocks or global scope.");
    static final DiagnosticType INJECT_NON_FUNCTION_ERROR = DiagnosticType.error("JSC_INJECT_NON_FUNCTION_ERROR", "@ngInject can only be used when defining a function or assigning a function expression.");

    public AngularPass(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        this.hotSwapScript(root, null);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        NodeTraversal.traverse(this.compiler, scriptRoot, this);
        boolean codeChanged = false;
        for (NodeContext entry : this.injectables) {
            String name = entry.getName();
            Node fn = entry.getFunctionNode();
            List<Node> dependencies = AngularPass.createDependenciesList(fn);
            if (dependencies.isEmpty()) continue;
            Node dependenciesArray = IR.arraylit(dependencies.toArray(new Node[dependencies.size()]));
            Node statement = IR.exprResult(IR.assign(IR.getelem(NodeUtil.newQName(this.compiler, name), IR.string(INJECT_PROPERTY_NAME)), dependenciesArray));
            NodeUtil.setDebugInformation(statement, entry.getNode(), name);
            Node insertionPoint = entry.getTarget();
            Node next = insertionPoint.getNext();
            while (next != null && NodeUtil.isExprCall(next) && this.compiler.getCodingConvention().getClassesDefinedByCall(next.getFirstChild()) != null) {
                insertionPoint = next;
                next = insertionPoint.getNext();
            }
            insertionPoint.getParent().addChildAfter(statement, insertionPoint);
            codeChanged = true;
        }
        if (codeChanged) {
            this.compiler.reportCodeChange();
        }
    }

    private static List<Node> createDependenciesList(Node n) {
        Preconditions.checkArgument((boolean)n.isFunction());
        Node params = NodeUtil.getFunctionParameters(n);
        if (params != null) {
            return AngularPass.createStringsFromParamList(params);
        }
        return new ArrayList<Node>();
    }

    private static List<Node> createStringsFromParamList(Node params) {
        ArrayList<Node> names = new ArrayList<Node>();
        for (Node param = params.getFirstChild(); param != null && param.isName(); param = param.getNext()) {
            names.add(IR.string(param.getString()).srcref(param));
        }
        return names;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        JSDocInfo docInfo = n.getJSDocInfo();
        if (docInfo != null && docInfo.isNgInject()) {
            this.addNode(n, t);
        }
    }

    private void addNode(Node n, NodeTraversal t) {
        Node target = null;
        Node fn = null;
        String name = null;
        switch (n.getType()) {
            case 86: {
                name = n.getFirstChild().getQualifiedName();
                fn = n;
                while (fn.isAssign()) {
                    fn = fn.getLastChild();
                }
                target = n.getParent();
                break;
            }
            case 105: {
                name = NodeUtil.getFunctionName(n);
                fn = n;
                target = n;
                break;
            }
            case 118: 
            case 149: 
            case 162: {
                name = n.getFirstChild().getString();
                fn = AngularPass.getDeclarationRValue(n);
                target = n;
                break;
            }
            case 160: {
                Node parent = n.getParent();
                if (!parent.isClassMembers()) break;
                Node classNode = parent.getParent();
                String midPart = n.isStaticMember() ? "." : ".prototype.";
                name = NodeUtil.getClassName(classNode) + midPart + n.getString();
                if (n.getString().equals("constructor")) {
                    name = NodeUtil.getClassName(classNode);
                }
                fn = n.getFirstChild();
                target = classNode.getParent().isAssign() ? classNode.getParent().getParent() : classNode;
            }
        }
        if (fn == null || !fn.isFunction()) {
            this.compiler.report(t.makeError(n, INJECT_NON_FUNCTION_ERROR, new String[0]));
            return;
        }
        if (!target.getParent().isScript() && !target.getParent().isBlock()) {
            this.compiler.report(t.makeError(n, INJECT_IN_NON_GLOBAL_OR_BLOCK_ERROR, new String[0]));
            return;
        }
        Preconditions.checkNotNull((Object)name);
        this.injectables.add(new NodeContext(name, n, fn, target));
    }

    private static Node getDeclarationRValue(Node n) {
        Preconditions.checkNotNull((Object)n);
        Preconditions.checkArgument((boolean)NodeUtil.isNameDeclaration(n));
        n = n.getFirstChild().getFirstChild();
        if (n == null) {
            return null;
        }
        while (n.isAssign()) {
            n = n.getLastChild();
        }
        return n;
    }

    static class NodeContext {
        private final String name;
        private final Node node;
        private final Node functionNode;
        private final Node target;

        public NodeContext(String name, Node node, Node functionNode, Node target) {
            this.name = name;
            this.node = node;
            this.functionNode = functionNode;
            this.target = target;
        }

        public String getName() {
            return this.name;
        }

        public Node getNode() {
            return this.node;
        }

        public Node getFunctionNode() {
            return this.functionNode;
        }

        public Node getTarget() {
            return this.target;
        }
    }
}

