/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.InputId;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;

public final class AstValidator
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final ViolationHandler violationHandler;

    public AstValidator(AbstractCompiler compiler, ViolationHandler handler) {
        this.compiler = compiler;
        this.violationHandler = handler;
    }

    public AstValidator(AbstractCompiler compiler) {
        this(compiler, new ViolationHandler(){

            @Override
            public void handleViolation(String message, Node n) {
                throw new IllegalStateException(message + ". Reference node:\n" + n.toStringTree() + "\n Parent node:\n" + (n.getParent() != null ? n.getParent().toStringTree() : " no parent "));
            }
        });
    }

    @Override
    public void process(Node externs, Node root) {
        if (externs != null) {
            this.validateCodeRoot(externs);
        }
        if (root != null) {
            this.validateCodeRoot(root);
        }
    }

    public void validateRoot(Node n) {
        this.validateNodeType(125, n);
        this.validateIsSynthetic(n);
        this.validateChildCount(n, 2);
        this.validateCodeRoot(n.getFirstChild());
        this.validateCodeRoot(n.getLastChild());
    }

    public void validateCodeRoot(Node n) {
        this.validateNodeType(125, n);
        this.validateIsSynthetic(n);
        for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
            this.validateScript(c);
        }
    }

    public void validateScript(Node n) {
        this.validateNodeType(132, n);
        this.validateHasSourceName(n);
        this.validateHasInputId(n);
        for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
            this.validateStatement(c);
        }
    }

    public void validateStatement(Node n) {
        switch (n.getType()) {
            case 126: {
                this.validateLabel(n);
                return;
            }
            case 125: {
                this.validateBlock(n);
                return;
            }
            case 105: {
                this.validateFunctionStatement(n);
                return;
            }
            case 119: {
                this.validateWith(n);
                return;
            }
            case 115: {
                this.validateFor(n);
                return;
            }
            case 163: {
                this.validateForOf(n);
                return;
            }
            case 113: {
                this.validateWhile(n);
                return;
            }
            case 114: {
                this.validateDo(n);
                return;
            }
            case 110: {
                this.validateSwitch(n);
                return;
            }
            case 108: {
                this.validateIf(n);
                return;
            }
            case 118: 
            case 149: 
            case 162: {
                this.validateNameDeclarationHelper(n.getType(), n);
                return;
            }
            case 130: {
                this.validateExprStmt(n);
                return;
            }
            case 4: {
                this.validateReturn(n);
                return;
            }
            case 49: {
                this.validateThrow(n);
                return;
            }
            case 77: {
                this.validateTry(n);
                return;
            }
            case 116: {
                this.validateBreak(n);
                return;
            }
            case 117: {
                this.validateContinue(n);
                return;
            }
            case 124: 
            case 152: {
                this.validateChildless(n);
                return;
            }
            case 158: {
                this.validateClassDeclaration(n, false);
                return;
            }
            case 165: {
                this.validateImport(n);
                return;
            }
            case 169: {
                this.validateExport(n);
                return;
            }
            case 311: {
                this.validateInterface(n);
                return;
            }
            case 314: {
                this.validateEnum(n);
                return;
            }
            case 317: {
                this.validateTypeAlias(n);
                return;
            }
            case 318: {
                this.validateAmbientDeclaration(n);
                return;
            }
        }
        this.violation("Expected statement but was " + Token.name(n.getType()) + ".", n);
    }

    public void validateExpression(Node n) {
        switch (n.getType()) {
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 161: {
                this.validateChildless(n);
                return;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 102: 
            case 103: 
            case 122: 
            case 155: {
                this.validateUnaryOp(n);
                return;
            }
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                this.validateAssignmentExpression(n);
                return;
            }
            case 98: {
                this.validateTrinaryOp(n);
                return;
            }
            case 40: {
                this.validateString(n);
                return;
            }
            case 39: {
                this.validateNumber(n);
                return;
            }
            case 38: {
                this.validateName(n);
                return;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 35: 
            case 45: 
            case 46: 
            case 51: 
            case 52: 
            case 85: 
            case 100: 
            case 101: {
                this.validateBinaryOp(n);
                return;
            }
            case 33: {
                this.validateGetProp(n);
                return;
            }
            case 63: {
                this.validateArrayLit(n);
                return;
            }
            case 64: {
                this.validateObjectLit(n);
                return;
            }
            case 47: {
                this.validateRegExpLit(n);
                return;
            }
            case 37: {
                this.validateCall(n);
                return;
            }
            case 174: {
                this.validateSpread(n);
                return;
            }
            case 30: {
                this.validateNew(n);
                return;
            }
            case 105: {
                this.validateFunctionExpression(n);
                return;
            }
            case 158: {
                this.validateClass(n);
                return;
            }
            case 177: {
                this.validateTemplateLit(n);
                return;
            }
            case 176: {
                this.validateTaggedTemplateLit(n);
                return;
            }
            case 164: {
                this.validateYield(n);
                return;
            }
        }
        this.violation("Expected expression but was " + Token.name(n.getType()), n);
    }

    private void validateYield(Node n) {
        this.validateEs6Feature("yield", n);
        this.validateNodeType(164, n);
        this.validateChildCountIn(n, 0, 1);
        if (n.hasChildren()) {
            this.validateExpression(n.getFirstChild());
        }
    }

    private void validateImport(Node n) {
        this.validateEs6Feature("import statement", n);
        this.validateNodeType(165, n);
        this.validateChildCount(n);
        if (n.getFirstChild().isName()) {
            this.validateName(n.getFirstChild());
        } else {
            this.validateNodeType(124, n.getFirstChild());
        }
        Node secondChild = n.getChildAtIndex(1);
        switch (secondChild.getType()) {
            case 166: {
                this.validateImportSpecifiers(secondChild);
                break;
            }
            case 168: {
                this.validateNonEmptyString(secondChild);
                break;
            }
            default: {
                this.validateNodeType(124, secondChild);
            }
        }
        this.validateString(n.getChildAtIndex(2));
    }

    private void validateImportSpecifiers(Node n) {
        this.validateNodeType(166, n);
        for (Node child : n.children()) {
            this.validateImportSpecifier(child);
        }
    }

    private void validateImportSpecifier(Node n) {
        this.validateNodeType(167, n);
        this.validateChildCountIn(n, 1, 2);
        for (Node child : n.children()) {
            this.validateName(child);
        }
    }

    private void validateExport(Node n) {
        this.validateNodeType(169, n);
        if (n.getBooleanProp(63)) {
            this.validateChildCount(n, 2);
            this.validateNodeType(124, n.getFirstChild());
            this.validateString(n.getChildAtIndex(1));
        } else if (n.getBooleanProp(62)) {
            this.validateChildCount(n, 1);
            this.validateExpression(n.getFirstChild());
        } else {
            this.validateChildCountIn(n, 1, 2);
            if (n.getFirstChild().getType() == 170) {
                this.validateExportSpecifiers(n.getFirstChild());
            } else {
                this.validateStatement(n.getFirstChild());
            }
            if (n.getChildCount() == 2) {
                this.validateString(n.getChildAtIndex(1));
            }
        }
    }

    private void validateExportSpecifiers(Node n) {
        this.validateNodeType(170, n);
        for (Node child : n.children()) {
            this.validateExportSpecifier(child);
        }
    }

    private void validateExportSpecifier(Node n) {
        this.validateNodeType(171, n);
        this.validateChildCountIn(n, 1, 2);
        for (Node child : n.children()) {
            this.validateName(child);
        }
    }

    private void validateTaggedTemplateLit(Node n) {
        this.validateEs6Feature("template literal", n);
        this.validateNodeType(176, n);
        this.validateChildCount(n);
        this.validateExpression(n.getFirstChild());
        this.validateTemplateLit(n.getLastChild());
    }

    private void validateTemplateLit(Node n) {
        this.validateEs6Feature("template literal", n);
        this.validateNodeType(177, n);
        if (!n.hasChildren()) {
            return;
        }
        for (int i = 0; i < n.getChildCount(); ++i) {
            Node child = n.getChildAtIndex(i);
            if (i == 0 && !child.isString()) {
                this.validateExpression(child);
                continue;
            }
            if (child.isString()) {
                this.validateString(child);
                continue;
            }
            this.validateTemplateLitSub(child);
        }
    }

    private void validateTemplateLitSub(Node n) {
        this.validateNodeType(178, n);
        this.validateChildCount(n);
        this.validateExpression(n.getFirstChild());
    }

    private void validateInterface(Node n) {
        this.validateEs6TypedFeature("interface", n);
        this.validateNodeType(311, n);
        this.validateChildCount(n);
        Node name = n.getFirstChild();
        this.validateName(name);
        Node superTypes = name.getNext();
        if (superTypes.isEmpty()) {
            this.validateChildless(superTypes);
        } else {
            this.validateInterfaceExtends(superTypes);
        }
        this.validateInterfaceMembers(n.getLastChild());
    }

    private void validateInterfaceExtends(Node n) {
        this.validateNodeType(312, n);
        for (Node child : n.children()) {
            this.validateNamedType(child);
        }
    }

    private void validateInterfaceMembers(Node n) {
        this.validateNodeType(313, n);
        for (Node child : n.children()) {
            this.validateInterfaceMember(child);
        }
    }

    private void validateInterfaceMember(Node n) {
        switch (n.getType()) {
            case 160: {
                this.validateChildCount(n);
                this.validateFunctionSignature(n.getFirstChild());
                break;
            }
            case 319: {
                this.validateChildless(n);
                break;
            }
            case 320: {
                this.validateChildCount(n);
                this.validateChildless(n.getFirstChild());
                break;
            }
            default: {
                this.violation("Interface contained member of invalid type " + Token.name(n.getType()), n);
            }
        }
    }

    private void validateEnum(Node n) {
        this.validateNodeType(314, n);
        this.validateName(n.getFirstChild());
        this.validateEnumMembers(n.getLastChild());
    }

    private void validateEnumMembers(Node n) {
        this.validateNodeType(315, n);
        for (Node child : n.children()) {
            this.validateObjectLitStringKey(child);
        }
    }

    private void validateClassDeclaration(Node n, boolean isAmbient) {
        this.validateClassHelper(n, isAmbient);
        this.validateName(n.getFirstChild());
    }

    private void validateClass(Node n) {
        this.validateClassHelper(n, false);
    }

    private void validateClassHelper(Node n, boolean isAmbient) {
        this.validateEs6Feature("classes", n);
        this.validateNodeType(158, n);
        this.validateChildCount(n);
        Node name = n.getFirstChild();
        if (name.isEmpty()) {
            this.validateChildless(name);
        } else {
            this.validateName(name);
        }
        Node superClass = name.getNext();
        if (superClass.isEmpty()) {
            this.validateChildless(superClass);
        } else {
            this.validateExpression(superClass);
        }
        this.validateClassMembers(n.getLastChild(), isAmbient);
    }

    private void validateClassMembers(Node n, boolean isAmbient) {
        this.validateNodeType(159, n);
        for (Node c : n.children()) {
            this.validateClassMember(c, isAmbient);
        }
    }

    private void validateClassMember(Node n, boolean isAmbient) {
        switch (n.getType()) {
            case 147: 
            case 148: 
            case 160: {
                this.validateChildCount(n);
                Node function = n.getFirstChild();
                if (isAmbient) {
                    this.validateFunctionSignature(function);
                    break;
                }
                this.validateFunctionExpression(function);
                break;
            }
            case 319: {
                this.validateChildless(n);
                break;
            }
            case 175: {
                this.validateComputedPropClassMethod(n);
                break;
            }
            case 320: {
                this.validateChildCount(n);
                this.validateChildless(n.getFirstChild());
                break;
            }
            case 124: {
                break;
            }
            default: {
                this.violation("Class contained member of invalid type " + Token.name(n.getType()), n);
            }
        }
    }

    private void validateBlock(Node n) {
        this.validateNodeType(125, n);
        for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
            this.validateStatement(c);
        }
    }

    private void validateSyntheticBlock(Node n) {
        this.validateNodeType(125, n);
        this.validateIsSynthetic(n);
        for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
            this.validateStatement(c);
        }
    }

    private void validateIsSynthetic(Node n) {
        if (!n.getBooleanProp(38)) {
            this.violation("Missing 'synthetic block' annotation.", n);
        }
    }

    private void validateHasSourceName(Node n) {
        String sourceName = n.getSourceFileName();
        if (sourceName == null || sourceName.isEmpty()) {
            this.violation("Missing 'source name' annotation.", n);
        }
    }

    private void validateHasInputId(Node n) {
        InputId inputId = n.getInputId();
        if (inputId == null) {
            this.violation("Missing 'input id' annotation.", n);
        }
    }

    private void validateLabel(Node n) {
        this.validateNodeType(126, n);
        this.validateChildCount(n);
        this.validateLabelName(n.getFirstChild());
        this.validateStatement(n.getLastChild());
    }

    private void validateLabelName(Node n) {
        this.validateNodeType(153, n);
        this.validateNonEmptyString(n);
        this.validateChildCount(n);
    }

    private void validateNonEmptyString(Node n) {
        this.validateNonNullString(n);
        if (n.getString().isEmpty()) {
            this.violation("Expected non-empty string.", n);
        }
    }

    private void validateEmptyString(Node n) {
        this.validateNonNullString(n);
        if (!n.getString().isEmpty()) {
            this.violation("Expected empty string.", n);
        }
    }

    private void validateNonNullString(Node n) {
        if (n.getString() == null) {
            this.violation("Expected non-null string.", n);
        }
    }

    private void validateName(Node n) {
        this.validateNodeType(38, n);
        this.validateNonEmptyString(n);
        this.validateChildCount(n);
    }

    private void validateOptionalName(Node n) {
        this.validateNodeType(38, n);
        this.validateNonNullString(n);
        this.validateChildCount(n);
    }

    private void validateEmptyName(Node n) {
        this.validateNodeType(38, n);
        this.validateEmptyString(n);
        this.validateChildCount(n);
    }

    private void validateFunctionStatement(Node n) {
        this.validateNodeType(105, n);
        this.validateChildCount(n);
        this.validateName(n.getFirstChild());
        this.validateParameters(n.getChildAtIndex(1));
        this.validateFunctionBody(n.getLastChild(), false);
    }

    private void validateFunctionExpression(Node n) {
        this.validateFunctionExpressionHelper(n, false);
    }

    private void validateFunctionSignature(Node n) {
        this.validateFunctionExpressionHelper(n, true);
    }

    private void validateFunctionExpressionHelper(Node n, boolean isAmbient) {
        this.validateNodeType(105, n);
        this.validateChildCount(n);
        this.validateParameters(n.getChildAtIndex(1));
        Node name = n.getFirstChild();
        Node body = n.getLastChild();
        if (n.isArrowFunction()) {
            this.validateEs6Feature("arrow functions", n);
            this.validateEmptyName(name);
            if (body.getType() == 125) {
                this.validateBlock(body);
            } else {
                this.validateExpression(body);
            }
        } else {
            this.validateOptionalName(name);
            this.validateFunctionBody(body, isAmbient);
        }
    }

    private void validateFunctionBody(Node n, boolean noBlock) {
        if (noBlock) {
            this.validateNodeType(124, n);
        } else {
            this.validateBlock(n);
        }
    }

    private void validateParameters(Node n) {
        this.validateNodeType(83, n);
        if (this.isEs6OrHigher()) {
            this.validateParametersEs6(n);
        } else {
            this.validateParametersEs5(n);
        }
    }

    private void validateParametersEs5(Node n) {
        for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
            this.validateName(c);
        }
    }

    private void validateParametersEs6(Node n) {
        boolean defaultParams = false;
        for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
            if (c.isRest()) {
                if (c.getNext() != null) {
                    this.violation("Rest parameters must come after all other parameters.", c);
                }
                this.validateRest(c);
                continue;
            }
            if (c.isDefaultValue()) {
                defaultParams = true;
                this.validateDefaultValue(83, c);
                continue;
            }
            if (defaultParams) {
                this.violation("Cannot have a parameter without a default value, after one with a default value.", c);
            }
            if (c.isName()) {
                this.validateName(c);
                continue;
            }
            if (c.isArrayPattern()) {
                this.validateArrayPattern(83, c);
                continue;
            }
            this.validateObjectPattern(83, c);
        }
    }

    private void validateDefaultValue(int type, Node n) {
        this.validateAssignmentExpression(n);
        Node lhs = n.getFirstChild();
        if (lhs.isName()) {
            this.validateName(lhs);
        } else if (lhs.isArrayPattern()) {
            this.validateArrayPattern(type, lhs);
        } else {
            this.validateObjectPattern(type, lhs);
        }
    }

    private void validateCall(Node n) {
        this.validateNodeType(37, n);
        this.validateMinimumChildCount(n, 1);
        for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
            this.validateExpression(c);
        }
    }

    private void validateRest(Node n) {
        this.validateNodeType(173, n);
        this.validateNonEmptyString(n);
        this.validateChildCount(n);
    }

    private void validateSpread(Node n) {
        this.validateNodeType(174, n);
        this.validateChildCount(n);
        Node parent = n.getParent();
        switch (parent.getType()) {
            case 30: 
            case 37: {
                if (n != parent.getFirstChild()) break;
                this.violation("SPREAD node is not callable.", n);
                break;
            }
            case 63: {
                break;
            }
            default: {
                this.violation("SPREAD node should not be the child of a " + Token.name(parent.getType()) + " node.", n);
            }
        }
    }

    private void validateNew(Node n) {
        this.validateNodeType(30, n);
        this.validateMinimumChildCount(n, 1);
        for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
            this.validateExpression(c);
        }
    }

    private void validateNameDeclarationHelper(int type, Node n) {
        this.validateMinimumChildCount(n, 1);
        for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
            this.validateNameDeclarationChild(type, c);
        }
    }

    private void validateNameDeclarationChild(int type, Node n) {
        if (n.isName()) {
            this.validateNonEmptyString(n);
            this.validateMaximumChildCount(n, 1);
            if (n.hasChildren()) {
                this.validateExpression(n.getFirstChild());
            }
        } else if (n.isArrayPattern()) {
            this.validateArrayPattern(type, n);
        } else if (n.isObjectPattern()) {
            this.validateObjectPattern(type, n);
        } else if (n.isDefaultValue()) {
            this.validateDefaultValue(type, n);
        } else if (n.isComputedProp()) {
            this.validateObjectPatternComputedPropKey(type, n);
        } else {
            this.violation("Invalid child for " + Token.name(type) + " node", n);
        }
    }

    private void validateArrayPattern(int type, Node n) {
        this.validateNodeType(156, n);
        for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
            if (c == n.getLastChild() && NodeUtil.isNameDeclaration(n.getParent())) {
                this.validateExpression(c);
                continue;
            }
            if (c.isRest()) {
                this.validateRest(c);
                continue;
            }
            if (c.isEmpty()) {
                this.validateChildless(c);
                continue;
            }
            this.validateNameDeclarationChild(type, c);
        }
    }

    private void validateObjectPattern(int type, Node n) {
        this.validateNodeType(157, n);
        for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
            if (c == n.getLastChild() && NodeUtil.isNameDeclaration(n.getParent())) {
                this.validateExpression(c);
                continue;
            }
            if (c.isStringKey()) {
                this.validateObjectPatternStringKey(type, c);
                continue;
            }
            this.validateNameDeclarationChild(type, c);
        }
    }

    private void validateFor(Node n) {
        this.validateNodeType(115, n);
        if (NodeUtil.isForIn(n)) {
            this.validateChildCount(n, 3);
            this.validateVarOrAssignmentTarget(n.getFirstChild());
            this.validateExpression(n.getChildAtIndex(1));
        } else {
            this.validateChildCount(n, 4);
            this.validateVarOrOptionalExpression(n.getFirstChild());
            this.validateOptionalExpression(n.getChildAtIndex(1));
            this.validateOptionalExpression(n.getChildAtIndex(2));
        }
        this.validateBlock(n.getLastChild());
    }

    private void validateForOf(Node n) {
        this.validateNodeType(163, n);
        this.validateChildCount(n);
        this.validateVarOrAssignmentTarget(n.getFirstChild());
        this.validateExpression(n.getChildAtIndex(1));
        this.validateBlock(n.getLastChild());
    }

    private void validateVarOrOptionalExpression(Node n) {
        if (NodeUtil.isNameDeclaration(n)) {
            this.validateNameDeclarationHelper(n.getType(), n);
        } else {
            this.validateOptionalExpression(n);
        }
    }

    private void validateVarOrAssignmentTarget(Node n) {
        if (NodeUtil.isNameDeclaration(n)) {
            this.validateChildCount(n, 1);
            this.validateNameDeclarationHelper(n.getType(), n);
        } else {
            this.validateAssignmentTarget(n);
        }
    }

    private void validateWith(Node n) {
        this.validateNodeType(119, n);
        this.validateChildCount(n);
        this.validateExpression(n.getFirstChild());
        this.validateBlock(n.getLastChild());
    }

    private void validateWhile(Node n) {
        this.validateNodeType(113, n);
        this.validateChildCount(n);
        this.validateExpression(n.getFirstChild());
        this.validateBlock(n.getLastChild());
    }

    private void validateDo(Node n) {
        this.validateNodeType(114, n);
        this.validateChildCount(n);
        this.validateBlock(n.getFirstChild());
        this.validateExpression(n.getLastChild());
    }

    private void validateIf(Node n) {
        this.validateNodeType(108, n);
        this.validateChildCountIn(n, 2, 3);
        this.validateExpression(n.getFirstChild());
        this.validateBlock(n.getChildAtIndex(1));
        if (n.getChildCount() == 3) {
            this.validateBlock(n.getLastChild());
        }
    }

    private void validateExprStmt(Node n) {
        this.validateNodeType(130, n);
        this.validateChildCount(n);
        this.validateExpression(n.getFirstChild());
    }

    private void validateReturn(Node n) {
        this.validateNodeType(4, n);
        this.validateMaximumChildCount(n, 1);
        if (n.hasChildren()) {
            this.validateExpression(n.getFirstChild());
        }
    }

    private void validateThrow(Node n) {
        this.validateNodeType(49, n);
        this.validateChildCount(n);
        this.validateExpression(n.getFirstChild());
    }

    private void validateBreak(Node n) {
        this.validateNodeType(116, n);
        this.validateMaximumChildCount(n, 1);
        if (n.hasChildren()) {
            this.validateLabelName(n.getFirstChild());
        }
    }

    private void validateContinue(Node n) {
        this.validateNodeType(117, n);
        this.validateMaximumChildCount(n, 1);
        if (n.hasChildren()) {
            this.validateLabelName(n.getFirstChild());
        }
    }

    private void validateTry(Node n) {
        this.validateNodeType(77, n);
        this.validateChildCountIn(n, 2, 3);
        this.validateBlock(n.getFirstChild());
        boolean seenCatchOrFinally = false;
        Node catches = n.getChildAtIndex(1);
        this.validateNodeType(125, catches);
        this.validateMaximumChildCount(catches, 1);
        if (catches.hasChildren()) {
            this.validateCatch(catches.getFirstChild());
            seenCatchOrFinally = true;
        }
        if (n.getChildCount() == 3) {
            this.validateBlock(n.getLastChild());
            seenCatchOrFinally = true;
        }
        if (!seenCatchOrFinally) {
            this.violation("Missing catch or finally for try statement.", n);
        }
    }

    private void validateCatch(Node n) {
        this.validateNodeType(120, n);
        this.validateChildCount(n);
        this.validateName(n.getFirstChild());
        this.validateBlock(n.getLastChild());
    }

    private void validateSwitch(Node n) {
        this.validateNodeType(110, n);
        this.validateMinimumChildCount(n, 1);
        this.validateExpression(n.getFirstChild());
        int defaults = 0;
        for (Node c = n.getFirstChild().getNext(); c != null; c = c.getNext()) {
            this.validateSwitchMember(n.getLastChild());
            if (!c.isDefaultCase()) continue;
            ++defaults;
        }
        if (defaults > 1) {
            this.violation("Expected at most 1 'default' in switch but was " + defaults, n);
        }
    }

    private void validateSwitchMember(Node n) {
        switch (n.getType()) {
            case 111: {
                this.validateCase(n);
                return;
            }
            case 112: {
                this.validateDefaultCase(n);
                return;
            }
        }
        this.violation("Expected switch member but was " + Token.name(n.getType()), n);
    }

    private void validateDefaultCase(Node n) {
        this.validateNodeType(112, n);
        this.validateChildCount(n);
        this.validateSyntheticBlock(n.getLastChild());
    }

    private void validateCase(Node n) {
        this.validateNodeType(111, n);
        this.validateChildCount(n);
        this.validateExpression(n.getFirstChild());
        this.validateSyntheticBlock(n.getLastChild());
    }

    private void validateOptionalExpression(Node n) {
        if (n.isEmpty()) {
            this.validateChildless(n);
        } else {
            this.validateExpression(n);
        }
    }

    private void validateChildless(Node n) {
        this.validateChildCount(n, 0);
    }

    private void validateAssignmentExpression(Node n) {
        this.validateChildCount(n);
        this.validateAssignmentTarget(n.getFirstChild());
        this.validateExpression(n.getLastChild());
    }

    private void validateAssignmentTarget(Node n) {
        if (!n.isValidAssignmentTarget()) {
            this.violation("Expected assignment target expression but was " + Token.name(n.getType()), n);
        }
    }

    private void validateGetProp(Node n) {
        this.validateNodeType(33, n);
        this.validateChildCount(n);
        this.validateExpression(n.getFirstChild());
        Node prop = n.getLastChild();
        this.validateNodeType(40, prop);
        this.validateNonEmptyString(prop);
    }

    private void validateRegExpLit(Node n) {
        this.validateNodeType(47, n);
        this.validateChildCountIn(n, 1, 2);
        for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
            this.validateString(c);
        }
    }

    private void validateString(Node n) {
        this.validateNodeType(40, n);
        this.validateChildCount(n);
        try {
            n.getString();
        }
        catch (UnsupportedOperationException e) {
            this.violation("Invalid STRING node.", n);
        }
    }

    private void validateNumber(Node n) {
        this.validateNodeType(39, n);
        this.validateChildCount(n);
        try {
            n.getDouble();
        }
        catch (UnsupportedOperationException e) {
            this.violation("Invalid NUMBER node.", n);
        }
    }

    private void validateArrayLit(Node n) {
        this.validateNodeType(63, n);
        for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
            this.validateOptionalExpression(c);
        }
    }

    private void validateObjectLit(Node n) {
        this.validateNodeType(64, n);
        for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
            this.validateObjectLitKey(c);
        }
    }

    private void validateObjectLitKey(Node n) {
        switch (n.getType()) {
            case 147: {
                this.validateObjectLitGetKey(n);
                return;
            }
            case 148: {
                this.validateObjectLitSetKey(n);
                return;
            }
            case 154: {
                this.validateObjectLitStringKey(n);
                return;
            }
            case 160: {
                this.validateClassMember(n, false);
                if (n.isStaticMember()) {
                    this.violation("Keys in an object literal should not be static.", n);
                }
                return;
            }
            case 175: {
                this.validateObjectLitComputedPropKey(n);
                return;
            }
        }
        this.violation("Expected object literal key expression but was " + Token.name(n.getType()), n);
    }

    private void validateObjectLitGetKey(Node n) {
        Node functionParams;
        this.validateNodeType(147, n);
        this.validateChildCount(n);
        this.validateObjectLiteralKeyName(n);
        Node function = n.getFirstChild();
        this.validateFunctionExpression(function);
        if (!function.getFirstChild().getString().isEmpty()) {
            this.violation("Expected unnamed function expression.", n);
        }
        if ((functionParams = function.getChildAtIndex(1)).hasChildren()) {
            this.violation("get methods must not have parameters.", n);
        }
    }

    private void validateObjectLitSetKey(Node n) {
        Node functionParams;
        this.validateNodeType(148, n);
        this.validateChildCount(n);
        this.validateObjectLiteralKeyName(n);
        Node function = n.getFirstChild();
        this.validateFunctionExpression(function);
        if (!function.getFirstChild().getString().isEmpty()) {
            this.violation("Expected unnamed function expression.", n);
        }
        if (!(functionParams = function.getChildAtIndex(1)).hasOneChild()) {
            this.violation("set methods must have exactly one parameter.", n);
        }
    }

    private void validateObjectLitStringKey(Node n) {
        this.validateNodeType(154, n);
        this.validateObjectLiteralKeyName(n);
        if (this.isEs6OrHigher()) {
            this.validateChildCountIn(n, 0, 1);
        } else {
            this.validateChildCount(n, 1);
        }
        if (n.hasOneChild()) {
            this.validateExpression(n.getFirstChild());
        }
    }

    private void validateObjectPatternStringKey(int type, Node n) {
        this.validateNodeType(154, n);
        this.validateObjectLiteralKeyName(n);
        this.validateChildCountIn(n, 0, 1);
        if (n.hasOneChild()) {
            this.validateNameDeclarationChild(type, n.getFirstChild());
        }
    }

    private void validateObjectLitComputedPropKey(Node n) {
        this.validateNodeType(175, n);
        this.validateChildCount(n);
        this.validateExpression(n.getFirstChild());
        this.validateExpression(n.getLastChild());
    }

    private void validateObjectPatternComputedPropKey(int type, Node n) {
        this.validateNodeType(175, n);
        this.validateChildCount(n);
        this.validateExpression(n.getFirstChild());
        if (n.getLastChild().isDefaultValue()) {
            this.validateDefaultValue(type, n.getLastChild());
        } else {
            this.validateExpression(n.getLastChild());
        }
    }

    private void validateComputedPropClassMethod(Node n) {
        this.validateNodeType(175, n);
        this.validateExpression(n.getFirstChild());
        if (n.getBooleanProp(75)) {
            this.validateChildCount(n, 1);
        } else {
            this.validateChildCount(n, 2);
            this.validateFunctionExpression(n.getLastChild());
        }
    }

    private void validateObjectLiteralKeyName(Node n) {
        if (n.isQuotedString()) {
            try {
                n.getString();
            }
            catch (UnsupportedOperationException e) {
                this.violation("getString failed for" + Token.name(n.getType()), n);
            }
        } else {
            this.validateNonEmptyString(n);
        }
    }

    private void validateUnaryOp(Node n) {
        this.validateChildCount(n);
        this.validateExpression(n.getFirstChild());
    }

    private void validateBinaryOp(Node n) {
        this.validateChildCount(n);
        this.validateExpression(n.getFirstChild());
        this.validateExpression(n.getLastChild());
    }

    private void validateTrinaryOp(Node n) {
        this.validateChildCount(n);
        Node first = n.getFirstChild();
        this.validateExpression(first);
        this.validateExpression(first.getNext());
        this.validateExpression(n.getLastChild());
    }

    private void validateNamedType(Node n) {
        this.validateNodeType(211, n);
        this.validateChildCount(n);
        this.validateName(n.getFirstChild());
    }

    private void validateTypeAlias(Node n) {
        this.validateEs6TypedFeature("type alias", n);
        this.validateNodeType(317, n);
        this.validateChildCount(n);
    }

    private void validateAmbientDeclaration(Node n) {
        this.validateEs6TypedFeature("ambient declaration", n);
        this.validateNodeType(318, n);
        Node child = n.getFirstChild();
        switch (child.getType()) {
            case 118: 
            case 149: 
            case 162: {
                this.validateNameDeclarationHelper(child.getType(), child);
                break;
            }
            case 105: {
                this.validateFunctionSignature(child);
                break;
            }
            case 158: {
                this.validateClassDeclaration(child, true);
                break;
            }
            case 314: {
                this.validateEnum(child);
            }
        }
    }

    private void violation(String message, Node n) {
        this.violationHandler.handleViolation(message, n);
    }

    private void validateNodeType(int type, Node n) {
        if (n.getType() != type) {
            this.violation("Expected " + Token.name(type) + " but was " + Token.name(n.getType()), n);
        }
    }

    private void validateChildCount(Node n) {
        int expectedArity = Token.arity(n.getType());
        if (expectedArity != -1) {
            this.validateChildCount(n, expectedArity);
        }
    }

    private void validateChildCount(Node n, int expected) {
        int count = n.getChildCount();
        if (expected != count) {
            this.violation("Expected " + expected + " children, but was " + n.getChildCount(), n);
        }
    }

    private void validateChildCountIn(Node n, int min, int max) {
        int count = n.getChildCount();
        if (count < min || count > max) {
            this.violation("Expected child count in [" + min + ", " + max + "], but was " + count, n);
        }
    }

    private void validateMinimumChildCount(Node n, int i) {
        boolean valid = false;
        if (i == 1) {
            valid = n.hasChildren();
        } else if (i == 2) {
            valid = n.hasMoreThanOneChild();
        } else {
            boolean bl = valid = n.getChildCount() >= i;
        }
        if (!valid) {
            this.violation("Expected at least " + i + " children, but was " + n.getChildCount(), n);
        }
    }

    private void validateMaximumChildCount(Node n, int i) {
        boolean valid = false;
        if (i == 1) {
            valid = !n.hasMoreThanOneChild();
        } else if (i == -1) {
            valid = true;
        } else {
            boolean bl = valid = n.getChildCount() <= i;
        }
        if (!valid) {
            this.violation("Expected no more than " + i + " children, but was " + n.getChildCount(), n);
        }
    }

    private void validateEs6Feature(String feature, Node n) {
        if (!this.isEs6OrHigher()) {
            this.violation("Feature '" + feature + "' is only allowed in ES6 mode.", n);
        }
    }

    private boolean isEs6OrHigher() {
        return this.compiler.getLanguageMode().isEs6OrHigher();
    }

    private void validateEs6TypedFeature(String feature, Node n) {
        if (!this.compiler.getLanguageMode().equals((Object)CompilerOptions.LanguageMode.ECMASCRIPT6_TYPED)) {
            this.violation("Feature '" + feature + "' is only allowed in ES6 Typed mode.", n);
        }
    }

    public static interface ViolationHandler {
        public void handleViolation(String var1, Node var2);
    }
}

