/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.DefinitionsRemover;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.SimpleDefinitionFinder;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class ChainCalls
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final Set<Node> badFunctionNodes = new HashSet<Node>();
    private final Set<Node> goodFunctionNodes = new HashSet<Node>();
    private final List<CallSite> callSites = new ArrayList<CallSite>();
    private SimpleDefinitionFinder defFinder;
    private GatherFunctions gatherFunctions = new GatherFunctions();

    ChainCalls(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        this.defFinder = new SimpleDefinitionFinder(this.compiler);
        this.defFinder.process(externs, root);
        NodeTraversal.traverse(this.compiler, root, new GatherCallSites());
        for (CallSite callSite : this.callSites) {
            callSite.parent.removeChild(callSite.n);
            callSite.n.removeChild(callSite.callNode);
            callSite.nextGetPropNode.replaceChild(callSite.nextGetPropFirstChildNode, callSite.callNode);
            this.compiler.reportCodeChange();
        }
    }

    private static class CallSite {
        final Node parent;
        final Node n;
        final Node callNode;
        final Node nextGetPropNode;
        final Node nextGetPropFirstChildNode;

        CallSite(Node parent, Node n, Node callNode, Node nextGetPropNode, Node nextGetPropFirstChildNode) {
            this.parent = parent;
            this.n = n;
            this.callNode = callNode;
            this.nextGetPropNode = nextGetPropNode;
            this.nextGetPropFirstChildNode = nextGetPropFirstChildNode;
        }
    }

    private class GatherCallSites
    extends NodeTraversal.AbstractPostOrderCallback {
        private GatherCallSites() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (!n.isExprResult()) {
                return;
            }
            Node callNode = n.getFirstChild();
            if (!callNode.isCall()) {
                return;
            }
            Node getPropNode = callNode.getFirstChild();
            if (!getPropNode.isGetProp()) {
                return;
            }
            Node getPropFirstChildNode = getPropNode.getFirstChild();
            Collection<DefinitionsRemover.Definition> definitions = ChainCalls.this.defFinder.getDefinitionsReferencedAt(getPropNode);
            if (definitions == null) {
                return;
            }
            for (DefinitionsRemover.Definition definition : definitions) {
                Node rValue = definition.getRValue();
                if (rValue == null) {
                    return;
                }
                if (ChainCalls.this.badFunctionNodes.contains(rValue)) {
                    return;
                }
                if (ChainCalls.this.goodFunctionNodes.contains(rValue)) continue;
                new NodeTraversal(ChainCalls.this.compiler, ChainCalls.this.gatherFunctions).traverseInnerNode(rValue, rValue.getParent(), t.getScope());
                if (!ChainCalls.this.badFunctionNodes.contains(rValue)) continue;
                return;
            }
            Node nextNode = n.getNext();
            if (nextNode == null || !nextNode.isExprResult()) {
                return;
            }
            Node nextCallNode = nextNode.getFirstChild();
            if (!nextCallNode.isCall()) {
                return;
            }
            Node nextGetPropNode = nextCallNode.getFirstChild();
            if (!nextGetPropNode.isGetProp()) {
                return;
            }
            Node nextGetPropFirstChildNode = nextGetPropNode.getFirstChild();
            if (!ChainCalls.this.compiler.areNodesEqualForInlining(nextGetPropFirstChildNode, getPropFirstChildNode)) {
                return;
            }
            if (NodeUtil.mayEffectMutableState(getPropFirstChildNode)) {
                return;
            }
            ChainCalls.this.callSites.add(new CallSite(parent, n, callNode, nextGetPropNode, nextGetPropFirstChildNode));
        }
    }

    private class GatherFunctions
    implements NodeTraversal.ScopedCallback {
        private GatherFunctions() {
        }

        @Override
        public void enterScope(NodeTraversal t) {
            ControlFlowGraph<Node> cfg = t.getControlFlowGraph();
            for (DiGraph.DiGraphEdge<Node, ControlFlowGraph.Branch> s : cfg.getImplicitReturn().getInEdges()) {
                Node exitNode = (Node)s.getSource().getValue();
                if (exitNode.isReturn() && exitNode.getFirstChild() != null && exitNode.getFirstChild().isThis()) continue;
                ChainCalls.this.badFunctionNodes.add(t.getScopeRoot());
                return;
            }
            ChainCalls.this.goodFunctionNodes.add(t.getScopeRoot());
        }

        @Override
        public void exitScope(NodeTraversal t) {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
            return true;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
        }
    }
}

