/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class CheckMissingGetCssName
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final CheckLevel level;
    private final Matcher blacklist;
    static final String GET_CSS_NAME_FUNCTION = "goog.getCssName";
    static final String GET_UNIQUE_ID_FUNCTION = ".getUniqueId";
    static final DiagnosticType MISSING_GETCSSNAME = DiagnosticType.disabled("JSC_MISSING_GETCSSNAME", "missing goog.getCssName around literal ''{0}''");

    CheckMissingGetCssName(AbstractCompiler compiler, CheckLevel level, String blacklistRegex) {
        this.compiler = compiler;
        this.level = level;
        this.blacklist = Pattern.compile("\\b(?:" + blacklistRegex + ")").matcher("");
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (n.isString() && !parent.isGetProp() && !parent.isRegExp()) {
            String s = n.getString();
            this.blacklist.reset(s);
            while (this.blacklist.find()) {
                if (parent.isTemplateLit()) {
                    if (parent.getChildCount() > 1) continue;
                    n = parent;
                }
                if (CheckMissingGetCssName.insideGetCssNameCall(n) || CheckMissingGetCssName.insideGetUniqueIdCall(n) || this.insideAssignmentToIdConstant(n)) continue;
                this.compiler.report(t.makeError(n, this.level, MISSING_GETCSSNAME, this.blacklist.group()));
            }
        }
    }

    private static boolean insideGetCssNameCall(Node n) {
        Node parent = n.getParent();
        return parent.isCall() && parent.getFirstChild().matchesQualifiedName(GET_CSS_NAME_FUNCTION);
    }

    private static boolean insideGetUniqueIdCall(Node n) {
        Node parent = n.getParent();
        String name = parent.isCall() ? parent.getFirstChild().getQualifiedName() : null;
        return name != null && name.endsWith(GET_UNIQUE_ID_FUNCTION);
    }

    private boolean insideAssignmentToIdConstant(Node n) {
        Node parent = n.getParent();
        if (parent.isAssign()) {
            String qname = parent.getFirstChild().getQualifiedName();
            return qname != null && CheckMissingGetCssName.isIdName(qname);
        }
        if (parent.isName()) {
            Node grandParent = parent.getParent();
            if (grandParent != null && NodeUtil.isNameDeclaration(grandParent)) {
                String name = parent.getString();
                return CheckMissingGetCssName.isIdName(name);
            }
            return false;
        }
        return false;
    }

    private static boolean isIdName(String name) {
        return name.endsWith("ID") || name.endsWith("ID_");
    }
}

