/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

final class CheckSideEffects
extends NodeTraversal.AbstractPostOrderCallback
implements HotSwapCompilerPass {
    static final DiagnosticType USELESS_CODE_ERROR = DiagnosticType.warning("JSC_USELESS_CODE", "Suspicious code. {0}");
    static final String PROTECTOR_FN = "JSCOMPILER_PRESERVE";
    private final CheckLevel level;
    private final List<Node> problemNodes = new ArrayList<Node>();
    private final LinkedHashMap<String, String> noSideEffectExterns = new LinkedHashMap();
    private final AbstractCompiler compiler;
    private final boolean protectSideEffectFreeCode;

    CheckSideEffects(AbstractCompiler compiler, CheckLevel level, boolean protectSideEffectFreeCode) {
        this.compiler = compiler;
        this.level = level;
        this.protectSideEffectFreeCode = protectSideEffectFreeCode;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, externs, new GetNoSideEffectExterns());
        NodeTraversal.traverse(this.compiler, root, this);
        if (this.protectSideEffectFreeCode) {
            this.protectSideEffects();
        }
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        NodeTraversal.traverse(this.compiler, scriptRoot, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (n.isEmpty() || n.isComma()) {
            return;
        }
        if (parent == null) {
            return;
        }
        if (n.isExprResult() || n.isBlock()) {
            return;
        }
        if (n.isQualifiedName() && n.getJSDocInfo() != null) {
            return;
        }
        boolean isResultUsed = NodeUtil.isExpressionResultUsed(n);
        boolean isSimpleOp = NodeUtil.isSimpleOperator(n);
        if (!isResultUsed) {
            if (isSimpleOp || !NodeUtil.mayHaveSideEffects(n, t.getCompiler())) {
                String msg = "This code lacks side-effects. Is there a bug?";
                if (n.isString() || n.isTemplateLit()) {
                    msg = "Is there a missing '+' on the previous line?";
                } else if (isSimpleOp) {
                    msg = "The result of the '" + Token.name(n.getType()).toLowerCase() + "' operator is not being used.";
                }
                t.getCompiler().report(t.makeError(n, this.level, USELESS_CODE_ERROR, msg));
                if (!NodeUtil.isStatement(n)) {
                    this.problemNodes.add(n);
                }
            } else if (n.isCall() && (n.getFirstChild().isGetProp() || n.getFirstChild().isName() || n.getFirstChild().isString())) {
                String qname = n.getFirstChild().getQualifiedName();
                boolean isDefinedInSrc = false;
                if (qname != null) {
                    if (n.getFirstChild().isGetProp()) {
                        Node rootNameNode = NodeUtil.getRootOfQualifiedName(n.getFirstChild());
                        isDefinedInSrc = rootNameNode != null && rootNameNode.isName() && t.getScope().getVar(rootNameNode.getString()) != null;
                    } else {
                        boolean bl = isDefinedInSrc = t.getScope().getVar(qname) != null;
                    }
                }
                if (qname != null && this.noSideEffectExterns.containsKey(qname) && !isDefinedInSrc) {
                    this.problemNodes.add(n);
                    String msg = "The result of the extern function call '" + qname + "' is not being used.";
                    t.getCompiler().report(t.makeError(n, this.level, USELESS_CODE_ERROR, msg));
                }
            }
        }
    }

    private void protectSideEffects() {
        if (!this.problemNodes.isEmpty()) {
            this.addExtern();
            for (Node n : this.problemNodes) {
                Node name = IR.name(PROTECTOR_FN).srcref(n);
                name.putBooleanProp(43, true);
                Node replacement = IR.call(name, new Node[0]).srcref(n);
                replacement.putBooleanProp(50, true);
                n.getParent().replaceChild(n, replacement);
                replacement.addChildToBack(n);
            }
            this.compiler.reportCodeChange();
        }
    }

    private void addExtern() {
        Node name = IR.name(PROTECTOR_FN);
        name.putBooleanProp(43, true);
        Node var = IR.var(name);
        JSDocInfoBuilder builder = new JSDocInfoBuilder(false);
        builder.recordNoAlias();
        var.setJSDocInfo(builder.build());
        CompilerInput input = this.compiler.getSynthesizedExternsInput();
        input.getAstRoot(this.compiler).addChildrenToBack(var);
        this.compiler.reportCodeChange();
    }

    private class GetNoSideEffectExterns
    extends NodeTraversal.AbstractPostOrderCallback {
        private GetNoSideEffectExterns() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isFunction()) {
                String name = NodeUtil.getFunctionName(n);
                JSDocInfo jsDoc = NodeUtil.getBestJSDocInfo(n);
                if (jsDoc != null && jsDoc.isNoSideEffects()) {
                    CheckSideEffects.this.noSideEffectExterns.put(name, null);
                }
            }
        }
    }

    static class StripProtection
    extends NodeTraversal.AbstractPostOrderCallback
    implements CompilerPass {
        private final AbstractCompiler compiler;

        StripProtection(AbstractCompiler compiler) {
            this.compiler = compiler;
        }

        @Override
        public void process(Node externs, Node root) {
            NodeTraversal.traverse(this.compiler, root, this);
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            Node target;
            if (n.isCall() && (target = n.getFirstChild()).isName() && target.getString().equals(CheckSideEffects.PROTECTOR_FN)) {
                Node expr = n.getLastChild();
                n.detachChildren();
                parent.replaceChild(n, expr);
            }
        }
    }
}

