/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.Es6SyntacticScopeCreator;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.Node;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class Es6RenameVariablesInParamLists
extends NodeTraversal.AbstractPostOrderCallback
implements HotSwapCompilerPass {
    private final AbstractCompiler compiler;

    public Es6RenameVariablesInParamLists(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (!n.isFunction() || !n.getLastChild().isBlock()) {
            return;
        }
        Node paramList = n.getChildAtIndex(1);
        final CollectReferences collector = new CollectReferences();
        NodeTraversal.traverse(this.compiler, paramList, new NodeTraversal.AbstractPreOrderCallback(){

            @Override
            public final boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
                if (parent == null) {
                    return true;
                }
                if (parent.isDefaultValue() && n == parent.getLastChild() || parent.isComputedProp() && n == parent.getFirstChild()) {
                    NodeTraversal.traverse(Es6RenameVariablesInParamLists.this.compiler, n, collector);
                    return false;
                }
                return true;
            }
        });
        Node block = paramList.getNext();
        Es6SyntacticScopeCreator creator = new Es6SyntacticScopeCreator(this.compiler);
        Scope fScope = creator.createScope(n, t.getScope());
        Scope fBlockScope = creator.createScope(block, fScope);
        HashMap<String, String> currFuncRenameMap = new HashMap<String, String>();
        Iterator it = fBlockScope.getVars();
        while (it.hasNext()) {
            Var var = (Var)it.next();
            String oldName = var.getName();
            if (!collector.currFuncReferences.contains(oldName) || currFuncRenameMap.containsKey(oldName)) continue;
            currFuncRenameMap.put(oldName, oldName + "$" + (String)this.compiler.getUniqueNameIdSupplier().get());
        }
        new NodeTraversal(this.compiler, new RenameReferences(fBlockScope, currFuncRenameMap)).traverseInnerNode(block, block.getParent(), fScope);
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, externs, this);
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        NodeTraversal.traverse(this.compiler, scriptRoot, this);
    }

    private class RenameReferences
    extends NodeTraversal.AbstractPostOrderCallback {
        private final Scope fBlockScope;
        private final Map<String, String> currParamListMap;

        private RenameReferences(Scope scope, Map<String, String> map) {
            this.fBlockScope = scope;
            this.currParamListMap = map;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (!NodeUtil.isReferenceName(n)) {
                return;
            }
            Scope scope = t.getScope();
            String oldName = n.getString();
            if (scope.getRootNode() != this.fBlockScope.getRootNode() && scope.isDeclared(oldName, false)) {
                return;
            }
            if (this.currParamListMap.containsKey(oldName)) {
                n.setString(this.currParamListMap.get(oldName));
                Es6RenameVariablesInParamLists.this.compiler.reportCodeChange();
            }
        }
    }

    private class CollectReferences
    extends NodeTraversal.AbstractPostOrderCallback {
        private final Set<String> currFuncReferences = new HashSet<String>();

        private CollectReferences() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (!NodeUtil.isReferenceName(n)) {
                return;
            }
            this.currFuncReferences.add(n.getString());
        }
    }
}

