/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;

public class Es6RewriteArrowFunction
extends NodeTraversal.AbstractPreOrderCallback
implements HotSwapCompilerPass {
    static final DiagnosticType THIS_REFERENCE_IN_ARROWFUNC_OF_OBJLIT = DiagnosticType.warning("JSC_THIS_REFERENCE_IN_ARROWFUNC_OF_OBJLIT", "You have 'this' reference in an arrow function inside an object literal. The reference may refer to an unintended target after rewrite.");
    private final AbstractCompiler compiler;
    private static final String ARGUMENTS_VAR = "$jscomp$arguments";
    private static final String THIS_VAR = "$jscomp$this";

    public Es6RewriteArrowFunction(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, externs, this);
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        NodeTraversal.traverse(this.compiler, scriptRoot, this);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        switch (n.getType()) {
            case 105: {
                if (!n.isArrowFunction()) break;
                this.visitArrowFunction(t, n);
            }
        }
        return true;
    }

    private void visitArrowFunction(NodeTraversal t, Node n) {
        if (n.getParent().isStringKey() && NodeUtil.referencesThis(n)) {
            this.compiler.report(JSError.make(n, THIS_REFERENCE_IN_ARROWFUNC_OF_OBJLIT, new String[0]));
        }
        n.setIsArrowFunction(false);
        Node body = n.getLastChild();
        if (!body.isBlock()) {
            body.detachFromParent();
            body = IR.block(IR.returnNode(body)).useSourceInfoIfMissingFromForTree(body);
            n.addChildToBack(body);
        }
        UpdateThisAndArgumentsReferences updater = new UpdateThisAndArgumentsReferences();
        NodeTraversal.traverse(this.compiler, body, updater);
        this.addVarDecls(t, updater.changedThis, updater.changedArguments);
        this.compiler.reportCodeChange();
    }

    private void addVarDecls(NodeTraversal t, boolean addThis, boolean addArguments) {
        Node name;
        Node parent;
        Scope scope = t.getScope();
        if (scope.isDeclared(THIS_VAR, false)) {
            addThis = false;
        }
        if (scope.isDeclared(ARGUMENTS_VAR, false)) {
            addArguments = false;
        }
        if ((parent = t.getScopeRoot()).isFunction()) {
            parent = parent.getLastChild();
        }
        if (parent.isSyntheticBlock() && parent.getFirstChild().isScript()) {
            parent = parent.getFirstChild();
        }
        CompilerInput input = this.compiler.getInput(parent.getInputId());
        if (addArguments) {
            name = IR.name(ARGUMENTS_VAR);
            Node argumentsVar = IR.declaration(name, IR.name("arguments"), 149);
            argumentsVar.useSourceInfoIfMissingFromForTree(parent);
            parent.addChildToFront(argumentsVar);
            scope.declare(ARGUMENTS_VAR, name, input);
        }
        if (addThis) {
            name = IR.name(THIS_VAR);
            Node thisVar = IR.declaration(name, IR.thisNode(), 149);
            thisVar.useSourceInfoIfMissingFromForTree(parent);
            parent.addChildToFront(thisVar);
            scope.declare(THIS_VAR, name, input);
        }
    }

    private static class UpdateThisAndArgumentsReferences
    implements NodeTraversal.Callback {
        private boolean changedThis = false;
        private boolean changedArguments = false;

        private UpdateThisAndArgumentsReferences() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isThis()) {
                Node name = IR.name(Es6RewriteArrowFunction.THIS_VAR).srcref(n);
                parent.replaceChild(n, name);
                this.changedThis = true;
            } else if (n.isName() && n.getString().equals("arguments")) {
                Node name = IR.name(Es6RewriteArrowFunction.ARGUMENTS_VAR).srcref(n);
                parent.replaceChild(n, name);
                this.changedArguments = true;
            }
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            return !n.isFunction() || n.isArrowFunction();
        }
    }
}

