/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.Es6ToEs3Converter;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.TypeDeclarationsIR;

public final class Es6TypedToEs6Converter
extends NodeTraversal.AbstractPostOrderCallback
implements HotSwapCompilerPass {
    static final DiagnosticType CANNOT_CONVERT_MEMBER_VARIABLES = DiagnosticType.error("JSC_CANNOT_CONVERT_FIELDS", "Can only convert class member variables (fields) in declarations or the right hand side of a simple assignment.");
    static final DiagnosticType CANNOT_CONVERT_BOUNDED_GENERICS = DiagnosticType.error("JSC_CANNOT_CONVERT_BOUNDED_GENERICS", "Bounded generics are not yet implemented.");
    static final DiagnosticType TYPE_ALIAS_ALREADY_DECLARED = DiagnosticType.error("JSC_TYPE_ALIAS_ALREADY_DECLARED", "Type alias already declared as a variable: {0}");
    static final DiagnosticType TYPE_QUERY_NOT_SUPPORTED = DiagnosticType.error("JSC_TYPE_QUERY_NOT_SUPPORTED", "Type query is currently not supported.");
    static final DiagnosticType UNSUPPORTED_RECORD_TYPE = DiagnosticType.error("JSC_UNSUPPORTED_RECORD_TYPE", "Currently only member variables are supported in record types, please consider using interfaces instead.");
    static final DiagnosticType COMPUTED_PROP_ACCESS_MODIFIER = DiagnosticType.error("JSC_UNSUPPORTED_ACCESS_MODIFIER", "Accessibility is not checked on computed properties");
    private final AbstractCompiler compiler;

    Es6TypedToEs6Converter(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node scriptRoot) {
        NodeTraversal.traverse(this.compiler, externs, this);
        NodeTraversal.traverse(this.compiler, scriptRoot, this);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        NodeTraversal.traverse(this.compiler, scriptRoot, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getType()) {
            case 158: {
                this.maybeAddGenerics(n, n);
                this.visitClass(n, parent);
                break;
            }
            case 311: {
                this.maybeAddGenerics(n, n);
                this.visitInterface(n);
                break;
            }
            case 314: {
                this.visitEnum(n, parent);
                break;
            }
            case 38: 
            case 173: {
                this.maybeVisitColonType(n, n);
                break;
            }
            case 105: {
                Node jsDocNode = parent.getType() == 160 ? parent : n;
                this.maybeAddGenerics(n, jsDocNode);
                this.maybeVisitColonType(n, jsDocNode);
                break;
            }
            case 317: {
                this.visitTypeAlias(t, n, parent);
                break;
            }
            case 318: {
                this.visitAmbientDeclaration(n);
                break;
            }
        }
    }

    private void maybeAddGenerics(Node n, Node jsDocNode) {
        Node name = n.getFirstChild();
        Node generics = (Node)name.getProp(81);
        if (generics != null) {
            JSDocInfoBuilder doc = JSDocInfoBuilder.maybeCopyFrom(jsDocNode.getJSDocInfo());
            for (Node typeName : generics.children()) {
                doc.recordTemplateTypeName(typeName.getString());
                if (!typeName.hasChildren()) continue;
                this.compiler.report(JSError.make(name, CANNOT_CONVERT_BOUNDED_GENERICS, new String[0]));
                return;
            }
            name.removeProp(81);
            jsDocNode.setJSDocInfo(doc.build());
        }
    }

    private void visitClass(Node n, Node parent) {
        JSDocInfoBuilder doc = JSDocInfoBuilder.maybeCopyFrom(n.getJSDocInfo());
        Node interfaces = (Node)n.getProp(82);
        if (interfaces != null) {
            for (Node child : interfaces.children()) {
                Node type = this.convertWithLocation(child);
                doc.recordImplementedInterface(new JSTypeExpression(type, n.getSourceFileName()));
            }
            n.removeProp(82);
        }
        Node classMembers = n.getLastChild();
        Es6ToEs3Converter.ClassDeclarationMetadata metadata = Es6ToEs3Converter.ClassDeclarationMetadata.create(n, parent);
        for (Node member : classMembers.children()) {
            if (member.isIndexSignature()) {
                doc.recordImplementedInterface(this.createIObject(member));
                continue;
            }
            if (!member.isMemberVariableDef() && !member.getBooleanProp(75)) {
                this.maybeAddVisibility(member);
                continue;
            }
            if (metadata == null) {
                this.compiler.report(JSError.make(n, CANNOT_CONVERT_MEMBER_VARIABLES, new String[0]));
                return;
            }
            metadata.insertNodeAndAdvance(this.createPropertyDefinition(member, metadata.fullClassName));
            this.compiler.reportCodeChange();
        }
        n.setJSDocInfo(doc.build());
    }

    private void visitInterface(Node n) {
        Node name = n.getFirstChild();
        Node superTypes = name.getNext();
        JSDocInfoBuilder doc = JSDocInfoBuilder.maybeCopyFrom(n.getJSDocInfo());
        doc.recordInterface();
        if (!superTypes.isEmpty()) {
            for (Node child : superTypes.children()) {
                Node type = this.convertWithLocation(child);
                doc.recordExtendedInterface(new JSTypeExpression(type, n.getSourceFileName()));
            }
        }
        Node insertionPoint = n;
        Node members = n.getLastChild();
        for (Node member : members.children()) {
            if (member.isMemberFunctionDef()) {
                Node function = member.getFirstChild();
                function.getLastChild().setType(125);
                continue;
            }
            if (member.isIndexSignature()) {
                doc.recordExtendedInterface(this.createIObject(member));
                continue;
            }
            Node newNode = this.createPropertyDefinition(member, name.getString());
            insertionPoint.getParent().addChildAfter(newNode, insertionPoint);
            insertionPoint = newNode;
        }
        n.setJSDocInfo(doc.build());
        n.setType(158);
        Node empty = new Node(124).useSourceInfoIfMissingFrom(n);
        n.replaceChild(superTypes, empty);
        members.setType(159);
        this.compiler.reportCodeChange();
    }

    private JSTypeExpression createIObject(Node indexSignature) {
        Node indexType = this.convertWithLocation(indexSignature.getFirstChild().getDeclaredTypeExpression());
        Node declaredType = this.convertWithLocation(indexSignature.getDeclaredTypeExpression());
        Node block = new Node(125, indexType, declaredType);
        Node iObject = IR.string("IObject");
        iObject.addChildrenToFront(block);
        JSTypeExpression bang = new JSTypeExpression(new Node(306, iObject).useSourceInfoIfMissingFromForTree(indexSignature), indexSignature.getSourceFileName());
        indexSignature.detachFromParent();
        this.compiler.reportCodeChange();
        return bang;
    }

    private Node createPropertyDefinition(Node member, String name) {
        member.detachFromParent();
        Node nameAccess = NodeUtil.newQName(this.compiler, name);
        Node prototypeAcess = NodeUtil.newPropertyAccess(this.compiler, nameAccess, "prototype");
        Node qualifiedMemberAccess = Es6ToEs3Converter.getQualifiedMemberAccess(this.compiler, member, nameAccess, prototypeAcess);
        this.maybeVisitColonType(member, member);
        this.maybeAddVisibility(member);
        qualifiedMemberAccess.setJSDocInfo(member.getJSDocInfo());
        Node newNode = NodeUtil.newExpr(qualifiedMemberAccess);
        return newNode.useSourceInfoIfMissingFromForTree(member);
    }

    private void visitEnum(Node n, Node parent) {
        Node name = n.getFirstChild();
        Node members = n.getLastChild();
        double nextValue = 0.0;
        Node[] stringKeys = new Node[members.getChildCount()];
        for (int i = 0; i < members.getChildCount(); ++i) {
            Node child = members.getChildAtIndex(i);
            if (child.hasChildren()) {
                nextValue = child.getFirstChild().getDouble() + 1.0;
            } else {
                double d = nextValue;
                nextValue = d + 1.0;
                child.addChildToFront(IR.number(d));
            }
            stringKeys[i] = child;
        }
        for (Node child : stringKeys) {
            child.detachFromParent();
        }
        Node var = IR.var(name.detachFromParent());
        Node objectlit = IR.objectlit(stringKeys);
        name.addChildToFront(objectlit);
        JSDocInfoBuilder builder = new JSDocInfoBuilder(false);
        builder.recordEnumParameterType(new JSTypeExpression(IR.string("number"), n.getSourceFileName()));
        var.setJSDocInfo(builder.build());
        parent.replaceChild(n, var.useSourceInfoIfMissingFromForTree(n));
        this.compiler.reportCodeChange();
    }

    private void maybeAddVisibility(Node n) {
        JSDocInfo.Visibility access = (JSDocInfo.Visibility)((Object)n.getProp(84));
        if (access != null) {
            if (n.isComputedProp()) {
                this.compiler.report(JSError.make(n, COMPUTED_PROP_ACCESS_MODIFIER, new String[0]));
            }
            JSDocInfoBuilder memberDoc = JSDocInfoBuilder.maybeCopyFrom(n.getJSDocInfo());
            memberDoc.recordVisibility(access);
            n.setJSDocInfo(memberDoc.build());
            n.removeProp(84);
        }
    }

    private void maybeVisitColonType(Node n, Node jsDocNode) {
        Node type = n.getDeclaredTypeExpression();
        boolean hasColonType = type != null;
        type = n.isRest() && hasColonType ? new Node(305, this.convertWithLocation(type.removeFirstChild())) : this.maybeProcessOptionalParameter(n, type);
        if (type == null) {
            return;
        }
        JSDocInfo info = jsDocNode.getJSDocInfo();
        JSDocInfoBuilder builder = JSDocInfoBuilder.maybeCopyFrom(info);
        JSTypeExpression typeExpression = new JSTypeExpression(type, n.getSourceFileName());
        switch (n.getType()) {
            case 105: {
                builder.recordReturnType(typeExpression);
                break;
            }
            case 319: {
                builder.recordType(typeExpression);
                break;
            }
            default: {
                builder.recordType(typeExpression);
                builder.recordInlineType();
            }
        }
        info = builder.build();
        jsDocNode.setJSDocInfo(info);
        if (hasColonType) {
            n.setDeclaredTypeExpression(null);
            this.compiler.reportCodeChange();
        }
    }

    private void visitTypeAlias(NodeTraversal t, Node n, Node parent) {
        String alias = n.getString();
        if (t.getScope().isDeclared(alias, true)) {
            this.compiler.report(JSError.make(n, TYPE_ALIAS_ALREADY_DECLARED, alias));
        }
        Node var = IR.var(IR.name(n.getString())).useSourceInfoFromForTree(n);
        JSDocInfoBuilder builder = new JSDocInfoBuilder(false);
        builder.recordTypedef(new JSTypeExpression(this.convertWithLocation(n.getFirstChild()), n.getSourceFileName()));
        var.setJSDocInfo(builder.build());
        parent.replaceChild(n, var);
        this.compiler.reportCodeChange();
    }

    private void visitAmbientDeclaration(Node n) {
        Node child = n.removeFirstChild();
        JSDocInfoBuilder builder = JSDocInfoBuilder.maybeCopyFrom(child.getJSDocInfo());
        switch (child.getType()) {
            case 105: {
                child.replaceChild(child.getLastChild(), IR.block().useSourceInfoFrom(child));
                break;
            }
            case 158: {
                Node members = child.getLastChild();
                for (Node member : members.children()) {
                    if (!member.isMemberFunctionDef()) continue;
                    Node function = member.getFirstChild();
                    function.replaceChild(function.getLastChild(), IR.block().copyInformationFrom(function));
                }
                break;
            }
            case 118: 
            case 314: {
                builder.addSuppression("duplicate");
                break;
            }
            case 162: {
                child.setType(118);
                break;
            }
            case 149: {
                builder.recordConstancy();
                child.setType(118);
            }
        }
        child.setJSDocInfo(builder.build());
        n.detachFromParent();
        this.compiler.getSynthesizedExternsInput().getAstRoot(this.compiler).addChildToBack(child);
        this.compiler.reportCodeChange();
    }

    private Node maybeCreateAnyType(Node n, Node type) {
        return type == null ? TypeDeclarationsIR.anyType().copyInformationFrom(n) : type;
    }

    private Node maybeProcessOptionalParameter(Node n, Node type) {
        if (n.getBooleanProp(80)) {
            n.putBooleanProp(80, false);
            type = this.maybeCreateAnyType(n, type);
            return new Node(307, this.convertWithLocation(type));
        }
        return type == null ? null : this.convertWithLocation(type);
    }

    private Node convertWithLocation(Node type) {
        return this.convertDeclaredTypeToJSDoc(type).copyInformationFrom(type);
    }

    private Node convertDeclaredTypeToJSDoc(Node type) {
        Preconditions.checkArgument((boolean)(type instanceof Node.TypeDeclarationNode));
        switch (type.getType()) {
            case 200: {
                return IR.string("string");
            }
            case 201: {
                return IR.string("boolean");
            }
            case 202: {
                return IR.string("number");
            }
            case 209: {
                return IR.string("void");
            }
            case 206: {
                return new Node(304);
            }
            case 211: {
                return this.convertNamedType(type);
            }
            case 215: {
                Node arrayType = IR.string("Array");
                Node memberType = this.convertWithLocation(type.getFirstChild());
                arrayType.addChildToFront(new Node(125, memberType).copyInformationFrom(type));
                return new Node(306, arrayType);
            }
            case 204: {
                Node namedType = type.getFirstChild();
                Node result = this.convertWithLocation(namedType);
                Node typeParameterTarget = result.getType() == 306 ? result.getFirstChild() : result;
                Node parameters = IR.block().copyInformationFrom(type);
                typeParameterTarget.addChildToFront(parameters);
                for (Node param = namedType.getNext(); param != null; param = param.getNext()) {
                    parameters.addChildToBack(this.convertWithLocation(param));
                }
                return result;
            }
            case 203: {
                Node returnType = type.getFirstChild();
                Node paramList = new Node(83);
                for (Node param = returnType.getNext(); param != null; param = param.getNext()) {
                    Node paramType = param.getDeclaredTypeExpression();
                    paramType = param.isRest() ? (paramType == null ? new Node(305, new Node(304)) : new Node(305, this.convertWithLocation(paramType.getFirstChild()))) : this.maybeProcessOptionalParameter(param, this.maybeCreateAnyType(param, paramType));
                    paramList.addChildToBack(paramType);
                }
                Node function = new Node(105);
                function.addChildToBack(paramList);
                function.addChildToBack(this.convertWithLocation(returnType));
                return function;
            }
            case 205: {
                Node pipe = new Node(301);
                for (Node child : type.children()) {
                    pipe.addChildToBack(this.convertWithLocation(child));
                }
                return pipe;
            }
            case 213: {
                Node lb = new Node(308);
                for (Node memberVar : type.children()) {
                    if (!memberVar.isMemberVariableDef()) {
                        this.compiler.report(JSError.make(type, UNSUPPORTED_RECORD_TYPE, new String[0]));
                        continue;
                    }
                    Node colon = new Node(310);
                    memberVar.setType(154);
                    Node memberType = this.convertWithLocation(this.maybeCreateAnyType(memberVar, memberVar.getDeclaredTypeExpression()));
                    memberVar.setDeclaredTypeExpression(null);
                    colon.addChildToBack(memberVar.detachFromParent());
                    colon.addChildToBack(memberType);
                    lb.addChildrenToBack(colon);
                }
                return new Node(309, lb);
            }
            case 32: {
                this.compiler.report(JSError.make(type, TYPE_QUERY_NOT_SUPPORTED, new String[0]));
                return new Node(304);
            }
        }
        throw new IllegalArgumentException("Unexpected node type for type conversion: " + type.getType());
    }

    private Node convertNamedType(Node type) {
        Node propTree = type.getFirstChild();
        String dotted = propTree.getQualifiedName();
        return new Node(306, IR.string(dotted));
    }
}

