/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PeepholeCollectPropertyAssignments;
import com.google.javascript.jscomp.PeepholeFoldConstants;
import com.google.javascript.jscomp.PeepholeMinimizeConditions;
import com.google.javascript.jscomp.PeepholeOptimizationsPass;
import com.google.javascript.jscomp.PeepholeRemoveDeadCode;
import com.google.javascript.jscomp.PeepholeReplaceKnownMethods;
import com.google.javascript.jscomp.PeepholeSubstituteAlternateSyntax;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

class ExpandJqueryAliases
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final CodingConvention convention;
    private static final Logger logger = Logger.getLogger(ExpandJqueryAliases.class.getName());
    static final DiagnosticType JQUERY_UNABLE_TO_EXPAND_INVALID_LIT_ERROR = DiagnosticType.warning("JSC_JQUERY_UNABLE_TO_EXPAND_INVALID_LIT", "jQuery.expandedEach call cannot be expanded because the first argument must be an object literal or an array of strings literal.");
    static final DiagnosticType JQUERY_UNABLE_TO_EXPAND_INVALID_NAME_ERROR = DiagnosticType.error("JSC_JQUERY_UNABLE_TO_EXPAND_INVALID_NAME", "jQuery.expandedEach expansion would result in the invalid property name \"{0}\".");
    static final DiagnosticType JQUERY_USELESS_EACH_EXPANSION = DiagnosticType.warning("JSC_JQUERY_USELESS_EACH_EXPANSION", "jQuery.expandedEach was not expanded as no valid property assignments were encountered. Consider using jQuery.each instead.");
    private static final Set<String> JQUERY_EXTEND_NAMES = ImmutableSet.of((Object)"jQuery.extend", (Object)"jQuery.fn.extend", (Object)"jQuery.prototype.extend");
    private static final String JQUERY_EXPANDED_EACH_NAME = "jQuery.expandedEach";
    private final PeepholeOptimizationsPass peepholePasses;

    ExpandJqueryAliases(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.convention = compiler.getCodingConvention();
        boolean late = false;
        this.peepholePasses = new PeepholeOptimizationsPass(compiler, new PeepholeMinimizeConditions(false), new PeepholeSubstituteAlternateSyntax(false), new PeepholeReplaceKnownMethods(false), new PeepholeRemoveDeadCode(), new PeepholeFoldConstants(false), new PeepholeCollectPropertyAssignments());
    }

    public static boolean isJqueryExtendCall(Node n, String qname, AbstractCompiler compiler) {
        if (JQUERY_EXTEND_NAMES.contains(qname)) {
            Node firstArgument = n.getNext();
            if (firstArgument == null) {
                return false;
            }
            Node secondArgument = firstArgument.getNext();
            if (firstArgument.isObjectLit() && secondArgument == null || firstArgument.isName() || NodeUtil.isGet(firstArgument) && !NodeUtil.mayHaveSideEffects(firstArgument, compiler) && secondArgument != null && secondArgument.isObjectLit() && secondArgument.getNext() == null) {
                return true;
            }
        }
        return false;
    }

    public boolean isJqueryExpandedEachCall(Node call, String qName) {
        Preconditions.checkArgument((boolean)call.isCall());
        return call.getFirstChild() != null && JQUERY_EXPANDED_EACH_NAME.equals(qName);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (n.isGetProp() && this.convention.isPrototypeAlias(n)) {
            this.maybeReplaceJqueryPrototypeAlias(n);
        } else if (n.isCall()) {
            String qName;
            Node callTarget = n.getFirstChild();
            if (ExpandJqueryAliases.isJqueryExtendCall(callTarget, qName = callTarget.getQualifiedName(), this.compiler)) {
                this.maybeExpandJqueryExtendCall(n);
            } else if (this.isJqueryExpandedEachCall(n, qName)) {
                this.maybeExpandJqueryEachCall(t, n);
            }
        }
    }

    @Override
    public void process(Node externs, Node root) {
        logger.fine("Expanding Jquery Aliases");
        NodeTraversal.traverse(this.compiler, root, this);
    }

    private void maybeReplaceJqueryPrototypeAlias(Node n) {
        Node fn;
        if (NodeUtil.isLValue(n)) {
            Node maybeAssign = n.getParent();
            while (!NodeUtil.isStatement(maybeAssign) && !maybeAssign.isAssign()) {
                maybeAssign = maybeAssign.getParent();
            }
            if (maybeAssign.isAssign() && ((maybeAssign = maybeAssign.getParent()).isBlock() || maybeAssign.isScript() || NodeUtil.isStatement(maybeAssign))) {
                return;
            }
        }
        if ((fn = n.getLastChild()) != null) {
            n.replaceChild(fn, IR.string("prototype").srcref(fn));
            this.compiler.reportCodeChange();
        }
    }

    private void maybeExpandJqueryExtendCall(Node n) {
        Node callTarget = n.getFirstChild();
        Node objectToExtend = callTarget.getNext();
        Node extendArg = objectToExtend.getNext();
        boolean ensureObjectDefined = true;
        if (extendArg == null) {
            extendArg = objectToExtend;
            objectToExtend = callTarget.getFirstChild();
            ensureObjectDefined = false;
        } else if (objectToExtend.isGetProp() && (objectToExtend.getLastChild().getString().equals("prototype") || this.convention.isPrototypeAlias(objectToExtend))) {
            ensureObjectDefined = false;
        }
        if (!extendArg.hasChildren()) {
            return;
        }
        Node fncBlock = IR.block().srcref(n);
        if (ensureObjectDefined) {
            Node assignVal = IR.or(objectToExtend.cloneTree(), IR.objectlit(new Node[0]).srcref(n)).srcref(n);
            Node assign = IR.assign(objectToExtend.cloneTree(), assignVal).srcref(n);
            fncBlock.addChildrenToFront(IR.exprResult(assign).srcref(n));
        }
        while (extendArg.hasChildren()) {
            Node currentProp = extendArg.removeFirstChild();
            currentProp.setType(40);
            Node propValue = currentProp.removeFirstChild();
            Node newProp = currentProp.isQuotedString() ? IR.getelem(objectToExtend.cloneTree(), currentProp).srcref(currentProp) : IR.getprop(objectToExtend.cloneTree(), currentProp).srcref(currentProp);
            Node assignNode = IR.assign(newProp, propValue).srcref(currentProp);
            fncBlock.addChildToBack(IR.exprResult(assignNode).srcref(currentProp));
        }
        if (n.getParent().isExprResult()) {
            Node parent = n.getParent();
            parent.getParent().replaceChild(parent, fncBlock);
        } else {
            Node targetVal = "jQuery.prototype".equals(objectToExtend.getQualifiedName()) ? objectToExtend.removeFirstChild() : objectToExtend.detachFromParent();
            fncBlock.addChildToBack(IR.returnNode(targetVal).srcref(targetVal));
            Node fnc = IR.function(IR.name("").srcref(n), IR.paramList().srcref(n), fncBlock).srcref(n);
            Node newCallTarget = IR.getprop(fnc, IR.string("call").srcref(n)).srcref(n);
            n.replaceChild(callTarget, newCallTarget);
            n.putBooleanProp(50, false);
            while (newCallTarget.getNext() != null) {
                n.removeChildAfter(newCallTarget);
            }
            n.addChildToBack(IR.thisNode().srcref(n));
        }
        this.compiler.reportCodeChange();
    }

    private void maybeExpandJqueryEachCall(NodeTraversal t, Node n) {
        Node objectToLoopOver = n.getChildAtIndex(1);
        if (objectToLoopOver == null) {
            return;
        }
        Node callbackFunction = objectToLoopOver.getNext();
        if (callbackFunction == null || !callbackFunction.isFunction()) {
            return;
        }
        this.peepholePasses.process(null, n.getChildAtIndex(1));
        Node nClone = n.cloneTree();
        objectToLoopOver = nClone.getChildAtIndex(1);
        if (!(objectToLoopOver.isObjectLit() || objectToLoopOver.isArrayLit() && this.isArrayLitValidForExpansion(objectToLoopOver))) {
            t.report(n, JQUERY_UNABLE_TO_EXPAND_INVALID_LIT_ERROR, new String[]{null});
            return;
        }
        ArrayList<Node> keyNodeReferences = new ArrayList<Node>();
        ArrayList<Node> valueNodeReferences = new ArrayList<Node>();
        new NodeTraversal(this.compiler, new FindCallbackArgumentReferences(callbackFunction, keyNodeReferences, valueNodeReferences, objectToLoopOver.isArrayLit())).traverseInnerNode(NodeUtil.getFunctionBody(callbackFunction), callbackFunction, t.getScope());
        if (keyNodeReferences.isEmpty()) {
            t.report(n, JQUERY_USELESS_EACH_EXPANSION, new String[]{null});
            return;
        }
        Node fncBlock = this.tryExpandJqueryEachCall(t, nClone, callbackFunction, keyNodeReferences, valueNodeReferences);
        if (fncBlock != null && fncBlock.hasChildren()) {
            this.replaceOriginalJqueryEachCall(n, fncBlock);
        } else {
            t.report(n, JQUERY_USELESS_EACH_EXPANSION, new String[]{null});
        }
    }

    private Node tryExpandJqueryEachCall(NodeTraversal t, Node n, Node callbackFunction, List<Node> keyNodes, List<Node> valueNodes) {
        Node callTarget = n.getFirstChild();
        Node objectToLoopOver = callTarget.getNext();
        Node fncBlock = IR.block().srcref(callTarget);
        boolean isValidExpansion = true;
        Node key = objectToLoopOver.getFirstChild();
        Node val = null;
        int i = 0;
        while (key != null) {
            Node origNode;
            int j;
            if (key != null) {
                val = objectToLoopOver.isArrayLit() ? IR.number(i).srcref(key) : key.getFirstChild();
            }
            ArrayList<Node> newKeys = new ArrayList<Node>();
            ArrayList<Node> newValues = new ArrayList<Node>();
            ArrayList<Node> origGetElems = new ArrayList<Node>();
            ArrayList<Node> newGetProps = new ArrayList<Node>();
            for (j = 0; j < keyNodes.size(); ++j) {
                Node ancestor;
                origNode = keyNodes.get(j);
                Node newNode = IR.string(key.getString()).srcref(key);
                newKeys.add(newNode);
                ancestor.replaceChild(origNode, newNode);
                for (ancestor = origNode.getParent(); ancestor != null && !NodeUtil.isStatement(ancestor) && !ancestor.isGetElem(); ancestor = ancestor.getParent()) {
                }
                if (ancestor == null || !ancestor.isGetElem()) continue;
                Node propObject = ancestor;
                while (propObject.isGetProp() || propObject.isGetElem()) {
                    propObject = propObject.getFirstChild();
                }
                Node ancestorClone = ancestor.cloneTree();
                this.peepholePasses.process(null, ancestorClone.getChildAtIndex(1));
                Node prop = ancestorClone.getChildAtIndex(1);
                if (prop.isString() && NodeUtil.isValidPropertyName(CompilerOptions.LanguageMode.ECMASCRIPT3, prop.getString())) {
                    Node target = ancestorClone.getFirstChild();
                    Node newGetProp = IR.getprop(target.detachFromParent(), prop.detachFromParent());
                    newGetProps.add(newGetProp);
                    origGetElems.add(ancestor);
                    ancestor.getParent().replaceChild(ancestor, newGetProp);
                    continue;
                }
                if (prop.isString() && !NodeUtil.isValidPropertyName(CompilerOptions.LanguageMode.ECMASCRIPT3, prop.getString())) {
                    t.report(n, JQUERY_UNABLE_TO_EXPAND_INVALID_NAME_ERROR, prop.getString());
                }
                isValidExpansion = false;
            }
            if (isValidExpansion) {
                for (j = 0; val != null && j < valueNodes.size(); ++j) {
                    origNode = valueNodes.get(j);
                    Node newNode = val.cloneTree();
                    newValues.add(newNode);
                    origNode.getParent().replaceChild(origNode, newNode);
                }
                Node fnc = IR.function(IR.name("").srcref(key), IR.paramList().srcref(key), callbackFunction.getChildAtIndex(2).cloneTree()).srcref(key);
                Node call = IR.call(fnc, new Node[0]).srcref(key);
                call.putBooleanProp(50, true);
                fncBlock.addChildToBack(IR.exprResult(call).srcref(call));
            }
            for (j = 0; j < newGetProps.size(); ++j) {
                ((Node)newGetProps.get(j)).getParent().replaceChild((Node)newGetProps.get(j), (Node)origGetElems.get(j));
            }
            for (j = 0; j < newKeys.size(); ++j) {
                ((Node)newKeys.get(j)).getParent().replaceChild((Node)newKeys.get(j), keyNodes.get(j));
            }
            for (j = 0; j < newValues.size(); ++j) {
                ((Node)newValues.get(j)).getParent().replaceChild((Node)newValues.get(j), valueNodes.get(j));
            }
            if (!isValidExpansion) {
                return null;
            }
            key = key.getNext();
            ++i;
        }
        return fncBlock;
    }

    private void replaceOriginalJqueryEachCall(Node n, Node expandedBlock) {
        if (n.getParent().isExprResult()) {
            Node parent = n.getParent();
            Node grandparent = parent.getParent();
            Node insertAfter = parent;
            while (expandedBlock.hasChildren()) {
                Node child = expandedBlock.getFirstChild().detachFromParent();
                grandparent.addChildAfter(child, insertAfter);
                insertAfter = child;
            }
            grandparent.removeChild(parent);
        } else {
            Node callTarget = n.getFirstChild();
            Node objectToLoopOver = callTarget.getNext();
            objectToLoopOver.detachFromParent();
            Node ret = IR.returnNode(objectToLoopOver).srcref(callTarget);
            expandedBlock.addChildToBack(ret);
            Node fnc = IR.function(IR.name("").srcref(callTarget), IR.paramList().srcref(callTarget), expandedBlock);
            n.replaceChild(callTarget, fnc);
            n.putBooleanProp(50, true);
            while (fnc.getNext() != null) {
                n.removeChildAfter(fnc);
            }
        }
        this.compiler.reportCodeChange();
    }

    private boolean isArrayLitValidForExpansion(Node n) {
        for (Node child : n.children()) {
            if (child.isString()) continue;
            return false;
        }
        return true;
    }

    static class FindCallbackArgumentReferences
    extends NodeTraversal.AbstractPostOrderCallback
    implements NodeTraversal.ScopedCallback {
        private final String keyName;
        private final String valueName;
        private Scope startingScope;
        private List<Node> keyReferences;
        private List<Node> valueReferences;

        FindCallbackArgumentReferences(Node functionRoot, List<Node> keyReferences, List<Node> valueReferences, boolean useArrayMode) {
            Preconditions.checkState((boolean)functionRoot.isFunction());
            String keyString = null;
            String valueString = null;
            Node callbackParams = NodeUtil.getFunctionParameters(functionRoot);
            Node param = callbackParams.getFirstChild();
            if (param != null) {
                Preconditions.checkState((boolean)param.isName());
                keyString = param.getString();
                param = param.getNext();
                if (param != null) {
                    Preconditions.checkState((boolean)param.isName());
                    valueString = param.getString();
                }
            }
            this.keyName = keyString;
            this.valueName = valueString;
            if (useArrayMode) {
                this.keyReferences = valueReferences;
                this.valueReferences = keyReferences;
            } else {
                this.keyReferences = keyReferences;
                this.valueReferences = valueReferences;
            }
            this.startingScope = null;
        }

        private boolean isShadowed(String name, Scope scope) {
            Var nameVar = scope.getVar(name);
            return nameVar != null && nameVar.getScope() != this.startingScope;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            boolean isThis = false;
            if (t.getScope().getClosestHoistScope() == this.startingScope) {
                isThis = n.isThis();
            }
            if (isThis || n.isName() && !this.isShadowed(n.getString(), t.getScope())) {
                String nodeValue;
                String string = nodeValue = isThis ? null : n.getString();
                if (!isThis && this.keyName != null && nodeValue.equals(this.keyName)) {
                    this.keyReferences.add(n);
                } else if (isThis || this.valueName != null && nodeValue.equals(this.valueName)) {
                    this.valueReferences.add(n);
                }
            }
        }

        @Override
        public void enterScope(NodeTraversal t) {
            if (this.startingScope == null) {
                this.startingScope = t.getScope();
            }
        }

        @Override
        public void exitScope(NodeTraversal t) {
        }
    }
}

