/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.LinkedHashMap;

class FindExportableNodes
extends NodeTraversal.AbstractPostOrderCallback {
    static final DiagnosticType NON_GLOBAL_ERROR = DiagnosticType.error("JSC_NON_GLOBAL_ERROR", "@export only applies to symbols/properties defined in the global scope.");
    static final DiagnosticType EXPORT_ANNOTATION_NOT_ALLOWED = DiagnosticType.error("JSC_EXPORT_ANNOTATION_NOT_ALLOWED", "@export is not supported on this expression.");
    private final AbstractCompiler compiler;
    private final LinkedHashMap<String, GenerateNodeContext> exports = new LinkedHashMap();
    private final boolean allowLocalExports;

    FindExportableNodes(AbstractCompiler compiler, boolean allowLocalExports) {
        this.compiler = compiler;
        this.allowLocalExports = allowLocalExports;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        JSDocInfo docInfo = n.getJSDocInfo();
        if (docInfo != null && docInfo.isExport()) {
            JSDocInfo parentInfo;
            if (parent.isAssign() && (n.isFunction() || n.isClass()) && (parentInfo = parent.getJSDocInfo()) != null && parentInfo.isExport()) {
                return;
            }
            String export = null;
            GenerateNodeContext context = null;
            switch (n.getType()) {
                case 105: {
                    if (!parent.isScript()) break;
                    export = NodeUtil.getFunctionName(n);
                    context = new GenerateNodeContext(n, Mode.EXPORT);
                    break;
                }
                case 158: {
                    if (!parent.isScript()) break;
                    export = NodeUtil.getClassName(n);
                    context = new GenerateNodeContext(n, Mode.EXPORT);
                    break;
                }
                case 160: {
                    export = n.getString();
                    context = new GenerateNodeContext(n, Mode.EXPORT);
                    break;
                }
                case 86: {
                    Node grandparent = parent.getParent();
                    if (!parent.isExprResult() || n.getLastChild().isAssign()) break;
                    if (grandparent != null && grandparent.isScript() && n.getFirstChild().isQualifiedName()) {
                        export = n.getFirstChild().getQualifiedName();
                        context = new GenerateNodeContext(n, Mode.EXPORT);
                        break;
                    }
                    if (!this.allowLocalExports || !n.getFirstChild().isGetProp()) break;
                    Node target = n.getFirstChild();
                    export = target.getLastChild().getString();
                    context = new GenerateNodeContext(n, Mode.EXTERN);
                    break;
                }
                case 118: {
                    if (!parent.isScript() || !n.getFirstChild().hasChildren() || n.getFirstChild().getFirstChild().isAssign()) break;
                    export = n.getFirstChild().getString();
                    context = new GenerateNodeContext(n, Mode.EXPORT);
                    break;
                }
                case 33: {
                    if (!this.allowLocalExports || !parent.isExprResult()) break;
                    export = n.getLastChild().getString();
                    context = new GenerateNodeContext(n, Mode.EXTERN);
                    break;
                }
                case 147: 
                case 148: 
                case 154: {
                    if (!this.allowLocalExports) break;
                    export = n.getString();
                    context = new GenerateNodeContext(n, Mode.EXTERN);
                }
            }
            if (export != null) {
                this.exports.put(export, context);
            } else if (!n.isFunction() || !NodeUtil.isObjectLitKey(parent)) {
                if (this.allowLocalExports) {
                    this.compiler.report(t.makeError(n, EXPORT_ANNOTATION_NOT_ALLOWED, new String[0]));
                } else {
                    this.compiler.report(t.makeError(n, NON_GLOBAL_ERROR, new String[0]));
                }
            }
        }
    }

    LinkedHashMap<String, GenerateNodeContext> getExports() {
        return this.exports;
    }

    static class GenerateNodeContext {
        private final Node node;
        private final Mode mode;

        GenerateNodeContext(Node node, Mode mode) {
            this.node = node;
            this.mode = mode;
        }

        Node getNode() {
            return this.node;
        }

        public Mode getMode() {
            return this.mode;
        }
    }

    static enum Mode {
        EXPORT,
        EXTERN;

    }
}

