/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckPathsBetweenNodes;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ControlFlowAnalysis;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.MaybeReachingVariableUse;
import com.google.javascript.jscomp.MustBeReachingVariableDef;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.rhino.Node;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

class FlowSensitiveInlineVariables
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass,
NodeTraversal.ScopedCallback {
    private final AbstractCompiler compiler;
    private final Set<Var> inlinedNewDependencies = new HashSet<Var>();
    private ControlFlowGraph<Node> cfg;
    private List<Candidate> candidates;
    private MustBeReachingVariableDef reachingDef;
    private MaybeReachingVariableUse reachingUses;
    private static final Predicate<Node> SIDE_EFFECT_PREDICATE = new Predicate<Node>(){

        public boolean apply(Node n) {
            if (n == null) {
                return false;
            }
            if (n.isCall() && NodeUtil.functionCallHasSideEffects(n)) {
                return true;
            }
            if (n.isNew() && NodeUtil.constructorCallHasSideEffects(n)) {
                return true;
            }
            if (n.isDelProp()) {
                return true;
            }
            for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
                if (ControlFlowGraph.isEnteringNewCfgNode(c) || !this.apply(c)) continue;
                return true;
            }
            return false;
        }
    };

    public FlowSensitiveInlineVariables(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void enterScope(NodeTraversal t) {
        if (t.inGlobalScope()) {
            return;
        }
        if (100 < t.getScope().getVarCount()) {
            return;
        }
        ControlFlowAnalysis cfa = new ControlFlowAnalysis(this.compiler, false, true);
        Preconditions.checkState((boolean)t.getScopeRoot().isFunction());
        cfa.process(null, t.getScopeRoot());
        this.cfg = cfa.getCfg();
        this.reachingDef = new MustBeReachingVariableDef(this.cfg, t.getScope(), this.compiler);
        this.reachingDef.analyze();
        this.candidates = new LinkedList<Candidate>();
        new NodeTraversal(this.compiler, new GatherCandiates()).traverse(t.getScopeRoot().getLastChild());
        this.reachingUses = new MaybeReachingVariableUse(this.cfg, t.getScope(), this.compiler);
        this.reachingUses.analyze();
        for (Candidate c : this.candidates) {
            if (!c.canInline(t.getScope())) continue;
            c.inlineVariable();
            if (((Candidate)c).defMetadata.depends.isEmpty()) continue;
            this.inlinedNewDependencies.add(t.getScope().getVar(c.varName));
        }
    }

    @Override
    public void exitScope(NodeTraversal t) {
    }

    @Override
    public void process(Node externs, Node root) {
        new NodeTraversal(this.compiler, this).traverseRoots(externs, root);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
    }

    private static boolean checkRightOf(Node n, Node expressionRoot, Predicate<Node> predicate) {
        for (Node p = n; p != expressionRoot; p = p.getParent()) {
            for (Node cur = p.getNext(); cur != null; cur = cur.getNext()) {
                if (!predicate.apply((Object)cur)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean checkLeftOf(Node n, Node expressionRoot, Predicate<Node> predicate) {
        for (Node p = n; p != expressionRoot; p = p.getParent()) {
            for (Node cur = p.getParent().getFirstChild(); cur != p; cur = cur.getNext()) {
                if (!predicate.apply((Object)cur)) continue;
                return true;
            }
        }
        return false;
    }

    private class Candidate {
        private final String varName;
        private Node def;
        private final MustBeReachingVariableDef.Definition defMetadata;
        private final Node use;
        private final Node useCfgNode;
        private int numUsesWithinCfgNode;

        Candidate(String varName, MustBeReachingVariableDef.Definition defMetadata, Node use, Node useCfgNode) {
            Preconditions.checkArgument((boolean)use.isName());
            this.varName = varName;
            this.defMetadata = defMetadata;
            this.use = use;
            this.useCfgNode = useCfgNode;
        }

        private Node getDefCfgNode() {
            return this.defMetadata.node;
        }

        private boolean canInline(final Scope scope) {
            CheckPathsBetweenNodes pathCheck;
            if (this.getDefCfgNode().isFunction()) {
                return false;
            }
            for (Var dependency : this.defMetadata.depends) {
                if (!FlowSensitiveInlineVariables.this.inlinedNewDependencies.contains(dependency)) continue;
                return false;
            }
            this.getDefinition(this.getDefCfgNode());
            this.getNumUseInUseCfgNode(this.useCfgNode);
            if (this.def == null) {
                return false;
            }
            if (this.def.isAssign() && !NodeUtil.isExprAssign(this.def.getParent())) {
                return false;
            }
            if (FlowSensitiveInlineVariables.checkRightOf(this.def, this.getDefCfgNode(), (Predicate<Node>)SIDE_EFFECT_PREDICATE)) {
                return false;
            }
            if (FlowSensitiveInlineVariables.checkLeftOf(this.use, this.useCfgNode, (Predicate<Node>)SIDE_EFFECT_PREDICATE)) {
                return false;
            }
            if (NodeUtil.mayHaveSideEffects(this.def.getLastChild(), FlowSensitiveInlineVariables.this.compiler)) {
                return false;
            }
            if (this.numUsesWithinCfgNode != 1) {
                return false;
            }
            if (NodeUtil.isWithinLoop(this.use)) {
                return false;
            }
            Collection<Node> uses = FlowSensitiveInlineVariables.this.reachingUses.getUses(this.varName, this.getDefCfgNode());
            if (uses.size() != 1) {
                return false;
            }
            if (NodeUtil.has(this.def.getLastChild(), new Predicate<Node>(){

                public boolean apply(Node input) {
                    switch (input.getType()) {
                        case 30: 
                        case 33: 
                        case 35: 
                        case 47: 
                        case 63: 
                        case 64: {
                            return true;
                        }
                        case 38: {
                            Var var = scope.getOwnSlot(input.getString());
                            if (var == null || !var.getParentNode().isCatch()) break;
                            return true;
                        }
                    }
                    return false;
                }
            }, new Predicate<Node>(){

                public boolean apply(Node input) {
                    return !input.isFunction();
                }
            })) {
                return false;
            }
            return !NodeUtil.isStatementBlock(this.getDefCfgNode().getParent()) || this.getDefCfgNode().getNext() == this.useCfgNode || !(pathCheck = new CheckPathsBetweenNodes(FlowSensitiveInlineVariables.this.cfg, FlowSensitiveInlineVariables.this.cfg.getDirectedGraphNode(this.getDefCfgNode()), FlowSensitiveInlineVariables.this.cfg.getDirectedGraphNode(this.useCfgNode), SIDE_EFFECT_PREDICATE, Predicates.alwaysTrue(), false)).somePathsSatisfyPredicate();
        }

        private void inlineVariable() {
            Node defParent = this.def.getParent();
            Node useParent = this.use.getParent();
            if (this.def.isAssign()) {
                Node rhs = this.def.getLastChild();
                rhs.detachFromParent();
                Preconditions.checkState((boolean)defParent.isExprResult());
                while (defParent.getParent().isLabel()) {
                    defParent = defParent.getParent();
                }
                defParent.detachFromParent();
                useParent.replaceChild(this.use, rhs);
            } else if (defParent.isVar()) {
                Node rhs = this.def.getLastChild();
                this.def.removeChild(rhs);
                useParent.replaceChild(this.use, rhs);
            } else {
                throw new IllegalStateException("No other definitions can be inlined.");
            }
            FlowSensitiveInlineVariables.this.compiler.reportCodeChange();
        }

        private void getDefinition(Node n) {
            ControlFlowGraph.AbstractCfgNodeTraversalCallback gatherCb = new ControlFlowGraph.AbstractCfgNodeTraversalCallback(){

                @Override
                public void visit(NodeTraversal t, Node n, Node parent) {
                    switch (n.getType()) {
                        case 38: {
                            if (n.getString().equals(Candidate.this.varName) && n.hasChildren()) {
                                Candidate.this.def = n;
                            }
                            return;
                        }
                        case 86: {
                            Node lhs = n.getFirstChild();
                            if (lhs.isName() && lhs.getString().equals(Candidate.this.varName)) {
                                Candidate.this.def = n;
                            }
                            return;
                        }
                    }
                }
            };
            NodeTraversal.traverse(FlowSensitiveInlineVariables.this.compiler, n, gatherCb);
        }

        private void getNumUseInUseCfgNode(final Node cfgNode) {
            this.numUsesWithinCfgNode = 0;
            ControlFlowGraph.AbstractCfgNodeTraversalCallback gatherCb = new ControlFlowGraph.AbstractCfgNodeTraversalCallback(){

                @Override
                public void visit(NodeTraversal t, Node n, Node parent) {
                    if (n.isName() && n.getString().equals(Candidate.this.varName)) {
                        if (parent.isAssign() && parent.getFirstChild() == n && this.isAssignChain(parent, cfgNode)) {
                            return;
                        }
                        Candidate.this.numUsesWithinCfgNode++;
                    }
                }

                private boolean isAssignChain(Node child, Node ancestor) {
                    for (Node n = child; n != ancestor; n = n.getParent()) {
                        if (n.isAssign()) continue;
                        return false;
                    }
                    return true;
                }
            };
            NodeTraversal.traverse(FlowSensitiveInlineVariables.this.compiler, cfgNode, gatherCb);
        }
    }

    private class GatherCandiates
    extends NodeTraversal.AbstractShallowCallback {
        private GatherCandiates() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            DiGraph.DiGraphNode graphNode = FlowSensitiveInlineVariables.this.cfg.getDirectedGraphNode(n);
            if (graphNode == null) {
                return;
            }
            final Node cfgNode = n;
            ControlFlowGraph.AbstractCfgNodeTraversalCallback gatherCb = new ControlFlowGraph.AbstractCfgNodeTraversalCallback(){

                @Override
                public void visit(NodeTraversal t, Node n, Node parent) {
                    if (n.isName()) {
                        if (parent == null) {
                            return;
                        }
                        if (NodeUtil.isAssignmentOp(parent) && parent.getFirstChild() == n || parent.isVar() || parent.isInc() || parent.isDec() || parent.isParamList() || parent.isCatch()) {
                            return;
                        }
                        String name = n.getString();
                        if (FlowSensitiveInlineVariables.this.compiler.getCodingConvention().isExported(name)) {
                            return;
                        }
                        MustBeReachingVariableDef.Definition def = FlowSensitiveInlineVariables.this.reachingDef.getDef(name, cfgNode);
                        if (def != null && !FlowSensitiveInlineVariables.this.reachingDef.dependsOnOuterScopeVars(def)) {
                            FlowSensitiveInlineVariables.this.candidates.add(new Candidate(name, def, n, cfgNode));
                        }
                    }
                }
            };
            NodeTraversal.traverse(FlowSensitiveInlineVariables.this.compiler, cfgNode, gatherCb);
        }
    }
}

