/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.TypeDeclarationsIR;
import java.util.LinkedHashMap;
import javax.annotation.Nullable;

public final class JsdocToEs6TypedConverter
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    private final AbstractCompiler compiler;

    public JsdocToEs6TypedConverter(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        JSDocInfo bestJSDocInfo = NodeUtil.getBestJSDocInfo(n);
        switch (n.getType()) {
            case 105: {
                if (bestJSDocInfo == null) break;
                this.setTypeExpression(n, bestJSDocInfo.getReturnType());
                break;
            }
            case 33: 
            case 38: {
                JSTypeExpression parameterType;
                JSDocInfo parentDocInfo;
                if (parent == null) break;
                if (parent.isVar() || parent.isAssign() || parent.isExprResult()) {
                    if (bestJSDocInfo == null) break;
                    this.setTypeExpression(n, bestJSDocInfo.getType());
                    break;
                }
                if (!parent.isParamList() || (parentDocInfo = NodeUtil.getBestJSDocInfo(parent)) == null || (parameterType = parentDocInfo.getParameterType(n.getString())) == null) break;
                Node attachTypeExpr = n;
                if (parameterType.getRoot().getType() == 305) {
                    attachTypeExpr = Node.newString(173, n.getString());
                    n.getParent().replaceChild(n, attachTypeExpr);
                    this.compiler.reportCodeChange();
                }
                this.setTypeExpression(attachTypeExpr, parameterType);
                break;
            }
        }
    }

    private void setTypeExpression(Node n, JSTypeExpression type) {
        Node.TypeDeclarationNode node = TypeDeclarationsIRFactory.convert(type);
        if (node != null) {
            n.setDeclaredTypeExpression(node);
            this.compiler.reportCodeChange();
        }
    }

    public static final class TypeDeclarationsIRFactory {
        private static final Function<Node, Node.TypeDeclarationNode> CONVERT_TYPE_NODE = new Function<Node, Node.TypeDeclarationNode>(){

            public Node.TypeDeclarationNode apply(Node node) {
                return TypeDeclarationsIRFactory.convertTypeNodeAST(node);
            }
        };

        @Nullable
        public static Node.TypeDeclarationNode convert(@Nullable JSTypeExpression typeExpr) {
            if (typeExpr == null) {
                return null;
            }
            return TypeDeclarationsIRFactory.convertTypeNodeAST(typeExpr.getRoot());
        }

        @Nullable
        public static Node.TypeDeclarationNode convertTypeNodeAST(Node n) {
            int token = n.getType();
            switch (token) {
                case 124: 
                case 302: {
                    return TypeDeclarationsIR.anyType();
                }
                case 122: {
                    return TypeDeclarationsIR.undefinedType();
                }
                case 306: {
                    return TypeDeclarationsIRFactory.convertTypeNodeAST(n.getFirstChild());
                }
                case 40: {
                    String typeName;
                    switch (typeName = n.getString()) {
                        case "boolean": {
                            return TypeDeclarationsIR.booleanType();
                        }
                        case "number": {
                            return TypeDeclarationsIR.numberType();
                        }
                        case "string": {
                            return TypeDeclarationsIR.stringType();
                        }
                        case "null": 
                        case "undefined": 
                        case "void": {
                            return null;
                        }
                    }
                    Node.TypeDeclarationNode root = TypeDeclarationsIR.namedType(typeName);
                    if (n.getChildCount() > 0 && n.getFirstChild().isBlock()) {
                        Node block = n.getFirstChild();
                        if ("Array".equals(typeName)) {
                            return TypeDeclarationsIR.arrayType(TypeDeclarationsIRFactory.convertTypeNodeAST(block.getFirstChild()));
                        }
                        return TypeDeclarationsIR.parameterizedType(root, Iterables.filter((Iterable)Iterables.transform(block.children(), CONVERT_TYPE_NODE), (Predicate)Predicates.notNull()));
                    }
                    return root;
                }
                case 304: {
                    Node child = n.getFirstChild();
                    return child == null ? TypeDeclarationsIR.anyType() : TypeDeclarationsIRFactory.convertTypeNodeAST(child);
                }
                case 309: {
                    LinkedHashMap<String, Node.TypeDeclarationNode> properties = new LinkedHashMap<String, Node.TypeDeclarationNode>();
                    for (Node field : n.getFirstChild().children()) {
                        boolean isFieldTypeDeclared = field.getType() == 310;
                        Node fieldNameNode = isFieldTypeDeclared ? field.getFirstChild() : field;
                        String fieldName = fieldNameNode.getString();
                        if (fieldName.startsWith("'") || fieldName.startsWith("\"")) {
                            fieldName = fieldName.substring(1, fieldName.length() - 1);
                        }
                        Node.TypeDeclarationNode fieldType = isFieldTypeDeclared ? TypeDeclarationsIRFactory.convertTypeNodeAST(field.getLastChild()) : null;
                        properties.put(fieldName, fieldType);
                    }
                    return TypeDeclarationsIR.recordType(properties);
                }
                case 305: {
                    return TypeDeclarationsIR.arrayType(TypeDeclarationsIRFactory.convertTypeNodeAST(n.getFirstChild()));
                }
                case 301: {
                    ImmutableList types = FluentIterable.from(n.children()).transform(CONVERT_TYPE_NODE).filter(Predicates.notNull()).toList();
                    switch (types.size()) {
                        case 0: {
                            return null;
                        }
                        case 1: {
                            return (Node.TypeDeclarationNode)types.get(0);
                        }
                    }
                    return TypeDeclarationsIR.unionType((Iterable<Node.TypeDeclarationNode>)types);
                }
                case 105: {
                    Node.TypeDeclarationNode returnType = TypeDeclarationsIR.anyType();
                    LinkedHashMap<String, Node.TypeDeclarationNode> requiredParams = new LinkedHashMap<String, Node.TypeDeclarationNode>();
                    LinkedHashMap<String, Node.TypeDeclarationNode> optionalParams = new LinkedHashMap<String, Node.TypeDeclarationNode>();
                    String restName = null;
                    Node.TypeDeclarationNode restType = null;
                    for (Node child2 : n.children()) {
                        if (child2.isParamList()) {
                            int paramIdx = 1;
                            for (Node param : child2.children()) {
                                String paramName = "p" + paramIdx++;
                                if (param.getType() == 305) {
                                    if (param.getFirstChild() != null) {
                                        restType = TypeDeclarationsIR.arrayType(TypeDeclarationsIRFactory.convertTypeNodeAST(param.getFirstChild()));
                                    }
                                    restName = paramName;
                                    continue;
                                }
                                Node.TypeDeclarationNode paramNode = TypeDeclarationsIRFactory.convertTypeNodeAST(param);
                                if (paramNode.getType() == 212) {
                                    optionalParams.put(paramName, (Node.TypeDeclarationNode)paramNode.removeFirstChild());
                                    continue;
                                }
                                requiredParams.put(paramName, TypeDeclarationsIRFactory.convertTypeNodeAST(param));
                            }
                            continue;
                        }
                        if (child2.isNew() || child2.isThis()) continue;
                        returnType = TypeDeclarationsIRFactory.convertTypeNodeAST(child2);
                    }
                    return TypeDeclarationsIR.functionType(returnType, requiredParams, optionalParams, restName, restType);
                }
                case 307: {
                    Node.TypeDeclarationNode optionalParam = TypeDeclarationsIRFactory.convertTypeNodeAST(n.getFirstChild());
                    return optionalParam == null ? null : TypeDeclarationsIR.optionalParameter(optionalParam);
                }
            }
            throw new IllegalArgumentException("Unsupported node type: " + Token.name(n.getType()) + " " + n.toStringTree());
        }
    }
}

